/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.bhv.readable.coins;

import java.util.ArrayList;
import java.util.List;
import org.dbflute.cbean.result.PagingResultBean;
import org.dbflute.cbean.result.ResultBeanBuilder;

public class VirtualUnionPagingBean<ID, RESULT> {
    protected final List<VirtualUnionPagingMeta> _metaMap = new ArrayList<VirtualUnionPagingMeta>();
    protected int _pageSize;
    protected int _pageNumber;

    public VirtualUnionPagingBean(VirtualUnionPagingIdSelector<ID> noArgLambda, VirtualUnionPagingDataMapper<ID, RESULT> oneArgLambda) {
        this.unionAll(noArgLambda, oneArgLambda);
    }

    public VirtualUnionPagingBean<ID, RESULT> unionAll(VirtualUnionPagingIdSelector<ID> noArgLambda, VirtualUnionPagingDataMapper<ID, RESULT> oneArgLambda) {
        this._metaMap.add(this.newVirtualUnionPagingMetaInfo(noArgLambda, oneArgLambda));
        return this;
    }

    protected VirtualUnionPagingMeta newVirtualUnionPagingMetaInfo(VirtualUnionPagingIdSelector<ID> idSelector, VirtualUnionPagingDataMapper<ID, RESULT> dataMapper) {
        return new VirtualUnionPagingMeta(idSelector, dataMapper);
    }

    public VirtualUnionPagingSelector<RESULT> paging(int pageSize, int pageNumber) {
        if (pageSize < 1) {
            throw new IllegalArgumentException("The pageSize should not be minus or zero: " + pageSize);
        }
        if (pageNumber < 1) {
            throw new IllegalArgumentException("The pageNumber should not be minus or zero: " + pageNumber);
        }
        this._pageSize = pageSize;
        this._pageNumber = pageNumber;
        return new VirtualUnionPagingSelector<RESULT>(){

            @Override
            public PagingResultBean<RESULT> selectPage() {
                return VirtualUnionPagingBean.this.doSelectPage();
            }
        };
    }

    protected PagingResultBean<RESULT> doSelectPage() {
        PagingResultBean<RESULT> page = this.actuallySelectPage(this._pageSize, this._pageNumber);
        if (page.getCurrentPageNumber() > 1 && page.isEmpty()) {
            return this.actuallySelectPage(this._pageSize, page.getAllPageCount());
        }
        return page;
    }

    protected PagingResultBean<RESULT> actuallySelectPage(int pageSize, int pageNumber) {
        int allRecordCount = this.prepareIdList();
        ArrayList resultList = new ArrayList();
        boolean usePaging = pageSize > 0 && pageNumber > 0;
        int limit = usePaging ? pageSize * pageNumber : -1;
        int offset = usePaging ? pageSize * (pageNumber - 1) : -1;
        int skippedCount = 0;
        boolean overOffset = false;
        int actualCount = 0;
        for (VirtualUnionPagingMeta meta : this._metaMap) {
            VirtualUnionPagingDataMapper dataMapper = meta.getDataMapper();
            List idList = meta.getIdList();
            if (idList.isEmpty()) continue;
            if (usePaging) {
                if (!overOffset) {
                    int scheduledSkippedCount = skippedCount + idList.size();
                    if (scheduledSkippedCount < offset) {
                        skippedCount += idList.size();
                        continue;
                    }
                    overOffset = true;
                    if ((idList = this.filterIdListByOffset(idList, skippedCount, offset)).isEmpty()) continue;
                }
                if ((idList = this.filterIdListByLimit(idList, actualCount, limit, offset)).isEmpty()) continue;
            }
            List mappedList = dataMapper.selectMappedList(idList);
            int mappedSize = mappedList.size();
            this.assertMappedSizeValidForIdList(idList, mappedSize);
            resultList.addAll(mappedList);
            if (!usePaging || (actualCount += mappedSize) < limit) continue;
            break;
        }
        ResultBeanBuilder builder = new ResultBeanBuilder("UNION_PAGING");
        return builder.buildPagingSimply(pageSize, pageNumber, allRecordCount, resultList);
    }

    protected int prepareIdList() {
        int count = 0;
        for (VirtualUnionPagingMeta meta : this._metaMap) {
            VirtualUnionPagingIdSelector idSelector = meta.getIdSelector();
            List idList = idSelector.selectIdList();
            meta.setIdList(idList);
            count += idList.size();
        }
        return count;
    }

    protected List<ID> filterIdListByOffset(List<ID> idList, int skippedCount, int offset) {
        return idList.subList(offset - skippedCount, idList.size());
    }

    protected List<ID> filterIdListByLimit(List<ID> idList, int actualCount, int limit, int offset) {
        int pageSize;
        int scheduledCount = actualCount + idList.size();
        if (scheduledCount > (pageSize = limit - offset)) {
            int remainderSize;
            idList = actualCount == 0 ? idList.subList(0, pageSize) : ((remainderSize = pageSize - actualCount) < idList.size() ? idList.subList(0, remainderSize) : idList);
        }
        return idList;
    }

    protected void assertMappedSizeValidForIdList(List<ID> idList, int mappedSize) {
        if (mappedSize > idList.size()) {
            String msg = "mapped list is over the ID list: " + mappedSize + ", " + idList;
            throw new IllegalStateException(msg);
        }
    }

    @FunctionalInterface
    public static interface VirtualUnionPagingDataMapper<ID, RESULT> {
        public List<RESULT> selectMappedList(List<ID> var1);
    }

    @FunctionalInterface
    public static interface VirtualUnionPagingIdSelector<ID> {
        public List<ID> selectIdList();
    }

    public class VirtualUnionPagingMeta {
        protected VirtualUnionPagingIdSelector<ID> _idSelector;
        protected VirtualUnionPagingDataMapper<ID, RESULT> _dataMapper;
        protected List<ID> _idList;

        public VirtualUnionPagingMeta(VirtualUnionPagingIdSelector<ID> idSelector, VirtualUnionPagingDataMapper<ID, RESULT> dataMapper) {
            this._idSelector = idSelector;
            this._dataMapper = dataMapper;
        }

        public VirtualUnionPagingIdSelector<ID> getIdSelector() {
            return this._idSelector;
        }

        public void setIdSelector(VirtualUnionPagingIdSelector<ID> idSelector) {
            this._idSelector = idSelector;
        }

        public VirtualUnionPagingDataMapper<ID, RESULT> getDataMapper() {
            return this._dataMapper;
        }

        public void setDataMapper(VirtualUnionPagingDataMapper<ID, RESULT> dataMapper) {
            this._dataMapper = dataMapper;
        }

        public List<ID> getIdList() {
            return this._idList;
        }

        public void setIdList(List<ID> idList) {
            this._idList = idList;
        }
    }

    public static interface VirtualUnionPagingSelector<RESULT> {
        public PagingResultBean<RESULT> selectPage();
    }
}

