/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.cbean.chelper;

import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.TimeZone;
import org.dbflute.cbean.ConditionBean;
import org.dbflute.cbean.chelper.HpQDRSetupper;
import org.dbflute.cbean.ckey.ConditionKey;
import org.dbflute.cbean.coption.ConditionOptionCall;
import org.dbflute.cbean.coption.DerivedReferrerOption;
import org.dbflute.cbean.coption.FromToOption;
import org.dbflute.cbean.coption.RangeOfOption;
import org.dbflute.cbean.scoping.SubQuery;
import org.dbflute.exception.IllegalConditionBeanOperationException;
import org.dbflute.helper.message.ExceptionMessageBuilder;
import org.dbflute.system.DBFluteSystem;
import org.dbflute.util.DfTypeUtil;

public class HpQDRParameter<CB extends ConditionBean, PARAMETER> {
    protected final String _function;
    protected final SubQuery<CB> _subQuery;
    protected final DerivedReferrerOption _option;
    protected final HpQDRSetupper<CB> _setupper;

    public HpQDRParameter(String function, SubQuery<CB> subQuery, DerivedReferrerOption option, HpQDRSetupper<CB> setupper) {
        this._function = function;
        this._subQuery = subQuery;
        this._option = option;
        this._setupper = setupper;
    }

    public void equal(PARAMETER value) {
        this.assertParameterNotNull(value);
        this._setupper.setup(this._function, this._subQuery, ConditionKey.CK_EQUAL.getOperand(), value, this._option);
    }

    public void notEqual(PARAMETER value) {
        this.assertParameterNotNull(value);
        this._setupper.setup(this._function, this._subQuery, ConditionKey.CK_NOT_EQUAL_STANDARD.getOperand(), value, this._option);
    }

    public void greaterThan(PARAMETER value) {
        this.assertParameterNotNull(value);
        this._setupper.setup(this._function, this._subQuery, ConditionKey.CK_GREATER_THAN.getOperand(), value, this._option);
    }

    public void lessThan(PARAMETER value) {
        this.assertParameterNotNull(value);
        this._setupper.setup(this._function, this._subQuery, ConditionKey.CK_LESS_THAN.getOperand(), value, this._option);
    }

    public void greaterEqual(PARAMETER value) {
        this.assertParameterNotNull(value);
        this._setupper.setup(this._function, this._subQuery, ConditionKey.CK_GREATER_EQUAL.getOperand(), value, this._option);
    }

    public void lessEqual(PARAMETER value) {
        this.assertParameterNotNull(value);
        this._setupper.setup(this._function, this._subQuery, ConditionKey.CK_LESS_EQUAL.getOperand(), value, this._option);
    }

    public void isNull() {
        this._setupper.setup(this._function, this._subQuery, ConditionKey.CK_IS_NULL.getOperand(), null, this._option);
    }

    public void isNotNull() {
        this._setupper.setup(this._function, this._subQuery, ConditionKey.CK_IS_NOT_NULL.getOperand(), null, this._option);
    }

    public void rangeOf(Number minNumber, Number maxNumber, ConditionOptionCall<RangeOfOption> opLambda) {
        this.doRangeOf(minNumber, maxNumber, this.createRangeOfOption(opLambda));
    }

    protected void doRangeOf(Number minNumber, Number maxNumber, RangeOfOption option) {
        this.assertRangeOfOption(option);
        this.assertRangeOfNotCalledUnsupported(minNumber, maxNumber, option);
        this.assertRangeOfNumberBothNullOrOneSideAllowed(minNumber, maxNumber, option);
        Number fromValue = minNumber;
        Number toValue = maxNumber;
        this.dispatchFromTo(fromValue, toValue);
    }

    protected RangeOfOption createRangeOfOption(ConditionOptionCall<RangeOfOption> opLambda) {
        this.assertRangeOfOptionCall(opLambda);
        RangeOfOption op = this.newRangeOfOption();
        opLambda.callback(op);
        return op;
    }

    protected RangeOfOption newRangeOfOption() {
        return new RangeOfOption();
    }

    public void fromTo(LocalDate fromDate, LocalDate toDate, ConditionOptionCall<FromToOption> opLambda) {
        FromToOption option = this.createFromToOption(opLambda);
        if (option.isUsePattern()) {
            this.doFromTo(this.toTimestamp(fromDate), this.toTimestamp(toDate), option);
        } else {
            this.doFromTo(this.toDate(fromDate), this.toDate(toDate), option);
        }
    }

    public void fromTo(LocalDateTime fromDate, LocalDateTime toDate, ConditionOptionCall<FromToOption> opLambda) {
        this.doFromTo(this.toTimestamp(fromDate), this.toTimestamp(toDate), this.createFromToOption(opLambda));
    }

    public void fromTo(Date fromDate, Date toDate, ConditionOptionCall<FromToOption> opLambda) {
        this.doFromTo(fromDate, toDate, this.createFromToOption(opLambda));
    }

    protected FromToOption createFromToOption(ConditionOptionCall<FromToOption> opLambda) {
        this.assertFromToOptionCall(opLambda);
        FromToOption op = this.newFromToOption();
        opLambda.callback(op);
        return op;
    }

    protected FromToOption newFromToOption() {
        return new FromToOption();
    }

    protected void doFromTo(Date fromDate, Date toDate, FromToOption option) {
        this.assertFromToOption(option);
        this.assertFromToNotCalledUnsupported(fromDate, toDate, option);
        this.assertFromToDateBothNullOrOneSideAllowed(fromDate, toDate, option);
        if (fromDate != null) {
            fromDate = option.filterFromDate(fromDate);
        }
        if (toDate != null) {
            toDate = option.xfilterToDateBetweenWay(toDate);
        }
        Date fromValue = fromDate;
        Date toValue = toDate;
        this.dispatchFromTo(fromValue, toValue);
    }

    protected void dispatchFromTo(PARAMETER fromValue, PARAMETER toValue) {
        if (fromValue != null && toValue != null) {
            this.doBetween(fromValue, toValue);
        } else if (fromValue != null) {
            this.greaterEqual(fromValue);
        } else if (toValue != null) {
            this.lessEqual(toValue);
        }
    }

    protected void doBetween(PARAMETER fromValue, PARAMETER toValue) {
        this.assertParameterFromNotNull(fromValue);
        this.assertParameterToNotNull(toValue);
        ArrayList<PARAMETER> fromToValueList = new ArrayList<PARAMETER>(2);
        fromToValueList.add(fromValue);
        fromToValueList.add(toValue);
        this._setupper.setup(this._function, this._subQuery, this.getBetweenKeyword(), fromToValueList, this._option);
    }

    protected String getBetweenKeyword() {
        return "between";
    }

    protected Date toDate(Object obj) {
        return DfTypeUtil.toDate(obj, this.getFromToConversionTimeZone());
    }

    protected Timestamp toTimestamp(Object obj) {
        return DfTypeUtil.toTimestamp(obj, this.getFromToConversionTimeZone());
    }

    protected TimeZone getFromToConversionTimeZone() {
        return this.getDBFluteSystemFinalTimeZone();
    }

    protected TimeZone getDBFluteSystemFinalTimeZone() {
        return DBFluteSystem.getFinalTimeZone();
    }

    protected void assertParameterNotNull(Object value) {
        if (value == null) {
            String msg = "The argument 'value' of parameter for DerivedReferrer should not be null.";
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertRangeOfOptionCall(ConditionOptionCall<RangeOfOption> opLambda) {
        if (opLambda == null) {
            String msg = "The argument 'opLambda' for range-of option of (Query)DerivedReferrer should not be null.";
            throw new IllegalConditionBeanOperationException(msg);
        }
    }

    protected void assertRangeOfOption(RangeOfOption option) {
        if (option == null) {
            String msg = "The argument 'option' of range-of for (Query)DerivedReferrer should not be null.";
            throw new IllegalConditionBeanOperationException(msg);
        }
    }

    protected void assertRangeOfNotCalledUnsupported(Number minNumber, Number maxNumber, RangeOfOption option) {
        if (option.isLessThan()) {
            this.throwRangeOfUnsupportedOptionException(minNumber, maxNumber, option, "lessThan");
        }
        if (option.isGreaterThan()) {
            this.throwRangeOfUnsupportedOptionException(minNumber, maxNumber, option, "greaterThan");
        }
        if (option.isOrIsNull()) {
            this.throwRangeOfUnsupportedOptionException(minNumber, maxNumber, option, "greaterThan");
        }
        if (option.hasCalculationRange()) {
            this.throwRangeOfUnsupportedOptionException(minNumber, maxNumber, option, "calculation");
        }
    }

    protected void throwRangeOfUnsupportedOptionException(Number minNumber, Number maxNumber, RangeOfOption option, String keyword) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Unsupported option of range-of option.");
        br.addItem("Advice");
        br.addElement("Cannot use the option '" + keyword + "'");
        br.addElement(" of the range-of for (Query)DerivedReferrer.");
        br.addItem("Max/Min Number");
        br.addElement(minNumber + " / " + maxNumber);
        br.addItem("RangeOfOption");
        br.addElement(option);
        String msg = br.buildExceptionMessage();
        throw new IllegalConditionBeanOperationException(msg);
    }

    protected void assertRangeOfNumberBothNullOrOneSideAllowed(Number minNumber, Number maxNumber, RangeOfOption option) {
        boolean oneSideAllowed = option.isOneSideAllowed();
        if (minNumber == null && maxNumber == null) {
            this.throwRangeOfNumberBothNullException(option);
        } else if (minNumber == null && !oneSideAllowed) {
            this.throwRangeOfMinNumberOnlyNullNotAllowedException(maxNumber, option);
        } else if (maxNumber == null && !oneSideAllowed) {
            this.throwRangeOfMaxNumberOnlyNullNotAllowedException(minNumber, option);
        }
    }

    protected void throwRangeOfNumberBothNullException(RangeOfOption option) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("The both arguments of from-to for (Query)DerivedReferrer were null.");
        br.addItem("Advice");
        br.addElement("Basically it cannot allow double null");
        br.addElement("of the range-of method, even if allowOneSide().");
        br.addItem("FromToOption");
        br.addElement(option);
        String msg = br.buildExceptionMessage();
        throw new IllegalConditionBeanOperationException(msg);
    }

    protected void throwRangeOfMinNumberOnlyNullNotAllowedException(Number maxNumber, RangeOfOption option) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("The min-number of range-of for (Query)DerivedReferrer were null.");
        br.addItem("Advice");
        br.addElement("Basically it cannot allow min-mumber to be null.");
        br.addElement("If you need to specify null, use allowOneSide() option.");
        br.addItem("maxNumber");
        br.addElement(maxNumber);
        br.addItem("RangeOfOption");
        br.addElement(option);
        String msg = br.buildExceptionMessage();
        throw new IllegalConditionBeanOperationException(msg);
    }

    protected void throwRangeOfMaxNumberOnlyNullNotAllowedException(Number minNumber, RangeOfOption option) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("The max-mumber of range-of for (Query)DerivedReferrer were null.");
        br.addItem("Advice");
        br.addElement("Basically it cannot allow max-mumber to be null.");
        br.addElement("If you need to specify null, use allowOneSide() option.");
        br.addItem("minNumber");
        br.addElement(minNumber);
        br.addItem("RangeOfOption");
        br.addElement(option);
        String msg = br.buildExceptionMessage();
        throw new IllegalConditionBeanOperationException(msg);
    }

    protected void assertFromToOptionCall(ConditionOptionCall<FromToOption> opLambda) {
        if (opLambda == null) {
            String msg = "The argument 'opLambda' for from-to option of (Query)DerivedReferrer should not be null.";
            throw new IllegalConditionBeanOperationException(msg);
        }
    }

    protected void assertFromToOption(FromToOption option) {
        if (option == null) {
            String msg = "The argument 'option' of from-to for (Query)DerivedReferrer should not be null.";
            throw new IllegalConditionBeanOperationException(msg);
        }
    }

    protected void assertFromToNotCalledUnsupported(Date fromDate, Date toDate, FromToOption option) {
        if (!option.isUsePattern() && option.isLessThan()) {
            this.throwFromToUnsupportedOptionException(fromDate, toDate, option, "lessThan");
        }
        if (!option.isUsePattern() && option.isGreaterThan()) {
            this.throwFromToUnsupportedOptionException(fromDate, toDate, option, "greaterThan");
        }
        if (option.isOrIsNull()) {
            this.throwFromToUnsupportedOptionException(fromDate, toDate, option, "osIsNull");
        }
    }

    protected void throwFromToUnsupportedOptionException(Date fromDate, Date toDate, FromToOption option, String keyword) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Unsupported option of from-to option.");
        br.addItem("Advice");
        br.addElement("Cannot use the option '" + keyword + "'");
        br.addElement(" of the from-to for (Query)DerivedReferrer.");
        br.addItem("From/To Date");
        br.addElement(fromDate + " / " + toDate);
        br.addItem("FromToOption");
        br.addElement(option);
        String msg = br.buildExceptionMessage();
        throw new IllegalConditionBeanOperationException(msg);
    }

    protected void assertFromToDateBothNullOrOneSideAllowed(Date fromDate, Date toDate, FromToOption option) {
        boolean oneSideAllowed = option.isOneSideAllowed();
        if (fromDate == null && toDate == null) {
            this.throwFromToDateBothNullException(option);
        } else if (fromDate == null && !oneSideAllowed) {
            this.throwFromToFromDateOnlyNullNotAllowedException(toDate, option);
        } else if (toDate == null && !oneSideAllowed) {
            this.throwFromToToDateOnlyNullNotAllowedException(fromDate, option);
        }
    }

    protected void throwFromToDateBothNullException(FromToOption option) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("The both arguments of from-to for (Query)DerivedReferrer were null.");
        br.addItem("Advice");
        br.addElement("Basically it cannot allow double null");
        br.addElement("of the from-to method, even if allowOneSide().");
        br.addItem("FromToOption");
        br.addElement(option);
        String msg = br.buildExceptionMessage();
        throw new IllegalConditionBeanOperationException(msg);
    }

    protected void throwFromToFromDateOnlyNullNotAllowedException(Date toDate, FromToOption option) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("The from-date of from-to for (Query)DerivedReferrer were null.");
        br.addItem("Advice");
        br.addElement("Basically it cannot allow from-date to be null.");
        br.addElement("If you need to specify null, use allowOneSide() option.");
        br.addItem("toDate");
        br.addElement(toDate);
        br.addItem("FromToOption");
        br.addElement(option);
        String msg = br.buildExceptionMessage();
        throw new IllegalConditionBeanOperationException(msg);
    }

    protected void throwFromToToDateOnlyNullNotAllowedException(Date fromDate, FromToOption option) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("The to-date of from-to for (Query)DerivedReferrer were null.");
        br.addItem("Advice");
        br.addElement("Basically it cannot allow to-date to be null.");
        br.addElement("If you need to specify null, use allowOneSide() option.");
        br.addItem("fromDate");
        br.addElement(fromDate);
        br.addItem("FromToOption");
        br.addElement(option);
        String msg = br.buildExceptionMessage();
        throw new IllegalConditionBeanOperationException(msg);
    }

    protected void assertParameterFromNotNull(Object fromValue) {
        if (fromValue == null) {
            String msg = "The argument 'fromValue' of parameter for DerivedReferrer should not be null.";
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertParameterToNotNull(Object toValue) {
        if (toValue == null) {
            String msg = "The argument 'toValue' of parameter for DerivedReferrer should not be null.";
            throw new IllegalArgumentException(msg);
        }
    }

    public static boolean isOperandIsNull(String operand) {
        return ConditionKey.CK_IS_NULL.getOperand().equals(operand);
    }
}

