/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.dbmeta.info;

import java.util.Collections;
import java.util.List;
import org.dbflute.dbmeta.DBMeta;
import org.dbflute.dbmeta.info.ColumnInfo;

public class UniqueInfo {
    protected final DBMeta _dbmeta;
    protected final List<ColumnInfo> _uniqueColumnList;
    protected final boolean _primary;

    public UniqueInfo(DBMeta dbmeta, List<ColumnInfo> uniqueColumnList, boolean primary) {
        this.assertObjectNotNull("dbmeta", dbmeta);
        this.assertObjectNotNull("uniqueColumnList", uniqueColumnList);
        this._dbmeta = dbmeta;
        this._uniqueColumnList = Collections.unmodifiableList(uniqueColumnList);
        this._primary = primary;
    }

    public boolean containsColumn(ColumnInfo columnInfo) {
        this.assertObjectNotNull("columnInfo", columnInfo);
        return this.doContainsColumn(columnInfo.getColumnDbName());
    }

    protected boolean doContainsColumn(String columnName) {
        for (ColumnInfo columnInfo : this._uniqueColumnList) {
            if (!columnInfo.getColumnDbName().equals(columnName)) continue;
            return true;
        }
        return false;
    }

    protected void assertObjectNotNull(String variableName, Object value) {
        if (variableName == null) {
            String msg = "The value should not be null: variableName=null value=" + value;
            throw new IllegalArgumentException(msg);
        }
        if (value == null) {
            String msg = "The value should not be null: variableName=" + variableName;
            throw new IllegalArgumentException(msg);
        }
    }

    public int hashCode() {
        return this._dbmeta.hashCode() + this._uniqueColumnList.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof UniqueInfo)) {
            return false;
        }
        UniqueInfo target = (UniqueInfo)obj;
        if (!this._dbmeta.equals(target.getDBMeta())) {
            return false;
        }
        return this._uniqueColumnList.equals(target.getUniqueColumnList());
    }

    public String toString() {
        return "{" + this._dbmeta.getTableDbName() + "." + this._uniqueColumnList + "}";
    }

    public DBMeta getDBMeta() {
        return this._dbmeta;
    }

    public List<ColumnInfo> getUniqueColumnList() {
        return this._uniqueColumnList;
    }

    public ColumnInfo getFirstColumn() {
        return this._uniqueColumnList.get(0);
    }

    public boolean isCompoundKey() {
        return this._uniqueColumnList.size() > 1;
    }

    public boolean isTwoOrMore() {
        return this.isCompoundKey();
    }

    public boolean isPrimary() {
        return this._primary;
    }
}

