/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.helper.beans.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Calendar;
import org.dbflute.helper.beans.DfBeanDesc;
import org.dbflute.helper.beans.DfPropertyDesc;
import org.dbflute.helper.beans.exception.DfBeanIllegalPropertyException;
import org.dbflute.helper.message.ExceptionMessageBuilder;
import org.dbflute.util.DfReflectionUtil;
import org.dbflute.util.DfTypeUtil;

public class DfPropertyDescImpl
implements DfPropertyDesc {
    protected static final Object[] EMPTY_ARGS = new Object[0];
    protected final DfBeanDesc _beanDesc;
    protected final String _propertyName;
    protected final Class<?> _propertyType;
    protected Method _readMethod;
    protected Method _writeMethod;
    protected Field _field;
    protected Constructor<?> _stringConstructor;
    protected Method _valueOfMethod;
    protected boolean _readable;
    protected boolean _writable;

    public DfPropertyDescImpl(DfBeanDesc beanDesc, String propertyName, Class<?> propertyType, Method readMethod, Method writeMethod, Field field) {
        if (propertyName == null) {
            String msg = "The argument 'propertyName' should not be null!";
            throw new IllegalArgumentException(msg);
        }
        if (propertyType == null) {
            String msg = "The argument 'propertyType' should not be null!";
            throw new IllegalArgumentException(msg);
        }
        this._beanDesc = beanDesc;
        this._propertyName = propertyName;
        this._propertyType = propertyType;
        this.setReadMethod(readMethod);
        this.setWriteMethod(writeMethod);
        this.setField(field);
        this.setupStringConstructor();
        this.setupValueOfMethod();
    }

    protected void setupStringConstructor() {
        Constructor<?>[] cons = this._propertyType.getConstructors();
        for (int i = 0; i < cons.length; ++i) {
            Constructor<?> con = cons[i];
            if (con.getParameterTypes().length != 1 || !con.getParameterTypes()[0].equals(String.class)) continue;
            this._stringConstructor = con;
            break;
        }
    }

    protected void setupValueOfMethod() {
        Method[] methods = this._propertyType.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (DfReflectionUtil.isBridgeMethod(method) || DfReflectionUtil.isSyntheticMethod(method) || !DfReflectionUtil.isStatic(method.getModifiers()) || !method.getName().equals("valueOf") || method.getParameterTypes().length != 1 || !method.getParameterTypes()[0].equals(String.class)) continue;
            this._valueOfMethod = method;
            break;
        }
    }

    @Override
    public DfBeanDesc getBeanDesc() {
        return this._beanDesc;
    }

    @Override
    public final String getPropertyName() {
        return this._propertyName;
    }

    @Override
    public final Class<?> getPropertyType() {
        return this._propertyType;
    }

    @Override
    public final Class<?> getGenericType() {
        if (this._readMethod != null) {
            return DfReflectionUtil.getGenericFirstClass(this._readMethod.getGenericReturnType());
        }
        return null;
    }

    @Override
    public final Method getReadMethod() {
        return this._readMethod;
    }

    @Override
    public final void setReadMethod(Method readMethod) {
        this._readMethod = readMethod;
        if (readMethod != null) {
            this._readable = true;
        }
    }

    @Override
    public final boolean hasReadMethod() {
        return this._readMethod != null;
    }

    @Override
    public final Method getWriteMethod() {
        return this._writeMethod;
    }

    @Override
    public final void setWriteMethod(Method writeMethod) {
        this._writeMethod = writeMethod;
        if (writeMethod != null) {
            this._writable = true;
        }
    }

    @Override
    public final boolean hasWriteMethod() {
        return this._writeMethod != null;
    }

    @Override
    public Field getField() {
        return this._field;
    }

    @Override
    public void setField(Field field) {
        this._field = field;
        if (field != null && DfReflectionUtil.isPublic(field.getModifiers())) {
            this._readable = true;
            this._writable = true;
        }
    }

    @Override
    public final Object getValue(Object target) {
        if (!this._readable) {
            this.throwPropertyNotReadableException(target);
        }
        try {
            if (this.hasReadMethod()) {
                return DfReflectionUtil.invoke(this._readMethod, target, EMPTY_ARGS);
            }
            return DfReflectionUtil.getValue(this._field, target);
        }
        catch (RuntimeException e) {
            this.throwPropertyReadFailureException(target, e);
            return null;
        }
    }

    protected void throwPropertyNotReadableException(Object target) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("The property is not readable.");
        this.setupExceptionBasicInfo(br);
        br.addItem("Target Object");
        br.addElement(target != null ? target.getClass() : null);
        br.addElement(target);
        String msg = br.buildExceptionMessage();
        throw new DfBeanIllegalPropertyException(msg);
    }

    protected void throwPropertyReadFailureException(Object target, RuntimeException e) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Failed to read the property.");
        this.setupExceptionBasicInfo(br);
        br.addItem("Target Object");
        br.addElement(target != null ? target.getClass() : null);
        br.addElement(target);
        String msg = br.buildExceptionMessage();
        throw new DfBeanIllegalPropertyException(msg, e);
    }

    @Override
    public final void setValue(Object target, Object value) {
        if (!this._writable) {
            this.throwPropertyNotWritableException(target, value);
        }
        try {
            value = this.convertIfNeed(value);
            if (this.hasWriteMethod()) {
                DfReflectionUtil.invoke(this._writeMethod, target, new Object[]{value});
            } else {
                DfReflectionUtil.setValue(this._field, target, value);
            }
        }
        catch (RuntimeException e) {
            this.throwPropertyWriteFailureException(target, value, e);
        }
    }

    protected void throwPropertyNotWritableException(Object target, Object value) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("The property is not writable.");
        this.setupExceptionBasicInfo(br);
        br.addItem("Target Object");
        br.addElement(target != null ? target.getClass() : null);
        br.addElement(target);
        br.addItem("Wrote Object");
        br.addElement(value != null ? value.getClass() : null);
        br.addElement(value);
        String msg = br.buildExceptionMessage();
        throw new DfBeanIllegalPropertyException(msg);
    }

    protected void throwPropertyWriteFailureException(Object target, Object value, RuntimeException e) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Failed to write the property.");
        this.setupExceptionBasicInfo(br);
        br.addItem("Target Object");
        br.addElement(target != null ? target.getClass() : null);
        br.addElement(target);
        br.addItem("Wrote Object");
        br.addElement(value != null ? value.getClass() : null);
        br.addElement(value);
        String msg = br.buildExceptionMessage();
        throw new DfBeanIllegalPropertyException(msg, e);
    }

    protected void setupExceptionBasicInfo(ExceptionMessageBuilder br) {
        br.addItem("Bean Class");
        br.addElement(this._beanDesc.getBeanClass());
        br.addElement("property count: " + this._beanDesc.getPropertyDescSize());
        br.addElement("property list: " + this._beanDesc.getProppertyNameList());
        br.addItem("Property");
        br.addElement(this._propertyName);
        br.addElement(this._propertyType);
        br.addElement("hash: " + Integer.toHexString(this.hashCode()));
        br.addItem("Readable?");
        br.addElement(this._readable);
        br.addElement(this._readMethod);
        br.addItem("Writable?");
        br.addElement(this._writable);
        br.addElement(this._writeMethod);
        br.addItem("Field?");
        br.addElement(this._field);
    }

    @Override
    public boolean isReadable() {
        return this._readable;
    }

    @Override
    public boolean isWritable() {
        return this._writable;
    }

    @Override
    public Object convertIfNeed(Object arg) {
        if (this._propertyType.isPrimitive()) {
            return DfTypeUtil.toWrapper(arg, this._propertyType);
        }
        if (Number.class.isAssignableFrom(this._propertyType)) {
            return DfTypeUtil.toNumber(arg, this._propertyType);
        }
        if (java.util.Date.class.isAssignableFrom(this._propertyType)) {
            return this.convertDate(arg);
        }
        if (LocalDate.class.isAssignableFrom(this._propertyType)) {
            return DfTypeUtil.toLocalDate(arg);
        }
        if (LocalDateTime.class.isAssignableFrom(this._propertyType)) {
            return DfTypeUtil.toLocalDateTime(arg);
        }
        if (LocalTime.class.isAssignableFrom(this._propertyType)) {
            return DfTypeUtil.toLocalTime(arg);
        }
        if (Boolean.class.isAssignableFrom(this._propertyType)) {
            return DfTypeUtil.toBoolean(arg);
        }
        if (arg != null && arg.getClass() != String.class && String.class == this._propertyType) {
            return arg.toString();
        }
        if (arg instanceof String && !String.class.equals(this._propertyType)) {
            return this.convertWithString(arg);
        }
        if (Calendar.class.isAssignableFrom(this._propertyType)) {
            return DfTypeUtil.toCalendar(arg);
        }
        return arg;
    }

    protected Object convertDate(Object arg) {
        if (this._propertyType == java.util.Date.class) {
            return DfTypeUtil.toDate(arg);
        }
        if (this._propertyType == Timestamp.class) {
            return DfTypeUtil.toTimestamp(arg);
        }
        if (this._propertyType == Date.class) {
            return DfTypeUtil.toDate(arg);
        }
        if (this._propertyType == Time.class) {
            return DfTypeUtil.toTime(arg);
        }
        return arg;
    }

    protected Object convertWithString(Object arg) {
        if (this._stringConstructor != null) {
            return DfReflectionUtil.newInstance(this._stringConstructor, new Object[]{arg});
        }
        if (this._valueOfMethod != null) {
            return DfReflectionUtil.invoke(this._valueOfMethod, null, new Object[]{arg});
        }
        return arg;
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("property:{");
        sb.append(this._propertyName);
        sb.append(", ").append(this._propertyType.getName());
        sb.append(", reader=").append(this._readMethod != null ? this._readMethod.getName() : null);
        sb.append(", writer=").append(this._writeMethod != null ? this._writeMethod.getName() : null);
        sb.append("}@").append(Integer.toHexString(this.hashCode()));
        return sb.toString();
    }
}

