/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.helper.process;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.dbflute.helper.process.ProcessConsoleReader;
import org.dbflute.helper.process.ProcessResult;
import org.dbflute.helper.process.exception.SystemScriptFailureException;
import org.dbflute.helper.process.exception.SystemScriptUnsupportedScriptException;
import org.dbflute.util.DfCollectionUtil;

public class SystemScript {
    public static final String WINDOWS_BATCH_EXT = ".bat";
    public static final String SHELL_SCRIPT_EXT = ".sh";
    protected static final List<String> SUPPORTED_EXT_LIST;
    protected String _consoleEncoding;
    protected Consumer<String> _consoleLiner;
    protected Map<String, String> _environmentMap;

    public static List<String> getSupportedExtList() {
        return SUPPORTED_EXT_LIST;
    }

    public SystemScript consoleEncoding(String encoding) {
        this.assertStringNotNullAndNotTrimmedEmpty("encoding", encoding);
        this._consoleEncoding = encoding;
        return this;
    }

    public SystemScript consoleLiner(Consumer<String> liner) {
        this.assertObjectNotNull("liner", liner);
        this._consoleLiner = liner;
        return this;
    }

    public SystemScript env(String key, String value) {
        this.assertStringNotNullAndNotTrimmedEmpty("key", key);
        this.assertObjectNotNull("value", value);
        if (this._environmentMap == null) {
            this._environmentMap = new LinkedHashMap<String, String>();
        }
        this._environmentMap.put(key, value);
        return this;
    }

    public ProcessResult execute(File baseDir, String scriptName, String ... args) {
        this.assertObjectNotNull("baseDir", baseDir);
        this.assertStringNotNullAndNotTrimmedEmpty("scriptName", scriptName);
        List<String> cmdList = this.prepareCommandList(scriptName, args);
        if (cmdList.isEmpty()) {
            String msg = "Unsupported script: " + scriptName;
            throw new SystemScriptUnsupportedScriptException(msg);
        }
        ProcessBuilder builder = this.prepareProcessBuilder(baseDir, cmdList);
        Process process = this.startProcess(scriptName, builder);
        return this.handleProcessResult(scriptName, process);
    }

    protected List<String> prepareCommandList(String scriptName, String ... args) {
        ArrayList<String> cmdList = new ArrayList<String>();
        if (this.isSystemWindowsOS()) {
            if (scriptName.endsWith(WINDOWS_BATCH_EXT)) {
                cmdList.add("cmd.exe");
                cmdList.add("/c");
                cmdList.add(scriptName);
            }
        } else if (scriptName.endsWith(SHELL_SCRIPT_EXT)) {
            cmdList.add("sh");
            cmdList.add(scriptName);
        }
        if (cmdList.isEmpty()) {
            return DfCollectionUtil.emptyList();
        }
        if (args != null && args.length > 0) {
            for (String arg : args) {
                cmdList.add(arg);
            }
        }
        return cmdList;
    }

    protected boolean isSystemWindowsOS() {
        String osName = System.getProperty("os.name");
        return osName != null && osName.toLowerCase().contains("windows");
    }

    protected ProcessBuilder prepareProcessBuilder(File baseDir, List<String> cmdList) {
        ProcessBuilder builder = this.createProcessBuilder(cmdList);
        if (this._environmentMap != null && !this._environmentMap.isEmpty()) {
            builder.environment().putAll(this._environmentMap);
        }
        builder.directory(baseDir).redirectErrorStream(true);
        return builder;
    }

    protected ProcessBuilder createProcessBuilder(List<String> cmdList) {
        return new ProcessBuilder(cmdList);
    }

    protected Process startProcess(String scriptName, ProcessBuilder builder) {
        Process process;
        try {
            process = builder.start();
        }
        catch (IOException e) {
            String msg = "Failed to execute the command: " + scriptName;
            throw new IllegalStateException(msg, e);
        }
        return process;
    }

    protected ProcessResult handleProcessResult(String scriptName, Process process) {
        InputStream stdin = null;
        try {
            stdin = process.getInputStream();
            ProcessConsoleReader reader = this.createProcessConsoleReader(stdin);
            reader.start();
            int exitCode = process.waitFor();
            String console = reader.read();
            return new ProcessResult(scriptName, console, exitCode);
        }
        catch (InterruptedException e) {
            String msg = "The execution was interrupted: " + scriptName;
            throw new SystemScriptFailureException(msg, e);
        }
    }

    protected ProcessConsoleReader createProcessConsoleReader(InputStream stdin) {
        return this.newProcessConsoleReader(stdin, this._consoleEncoding != null ? this._consoleEncoding : "UTF-8", this._consoleLiner);
    }

    protected ProcessConsoleReader newProcessConsoleReader(InputStream stdin, String encoding, Consumer<String> liner) {
        return new ProcessConsoleReader(stdin, encoding, liner);
    }

    protected void assertObjectNotNull(String variableName, Object value) {
        if (variableName == null) {
            String msg = "The value should not be null: variableName=null value=" + value;
            throw new IllegalArgumentException(msg);
        }
        if (value == null) {
            String msg = "The value should not be null: variableName=" + variableName;
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertStringNotNullAndNotTrimmedEmpty(String variableName, String value) {
        this.assertObjectNotNull("variableName", variableName);
        this.assertObjectNotNull(variableName, value);
        if (value.trim().length() == 0) {
            String msg = "The value should not be empty: variableName=" + variableName + " value=" + value;
            throw new IllegalArgumentException(msg);
        }
    }

    public String getConsoleEncoding() {
        return this._consoleEncoding;
    }

    @Deprecated
    public void setConsoleEncoding(String consoleEncoding) {
        this._consoleEncoding = consoleEncoding;
    }

    public Map<String, String> getEnvironmentMap() {
        return this._environmentMap;
    }

    @Deprecated
    public void setEnvironmentMap(Map<String, String> environmentMap) {
        this._environmentMap = environmentMap;
    }

    static {
        ArrayList<String> tmpList = DfCollectionUtil.newArrayList(WINDOWS_BATCH_EXT, SHELL_SCRIPT_EXT);
        SUPPORTED_EXT_LIST = Collections.unmodifiableList(tmpList);
    }
}

