/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.hook;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.dbflute.exception.AccessContextNoValueException;
import org.dbflute.exception.AccessContextNotFoundException;
import org.dbflute.helper.message.ExceptionMessageBuilder;
import org.dbflute.system.DBFluteSystem;
import org.dbflute.util.DfTypeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessContext {
    private static final Logger _log = LoggerFactory.getLogger(AccessContext.class);
    protected static final ThreadLocal<AccessContext> _defaultThreadLocal = new ThreadLocal();
    protected static final AccessContextHolder _defaultHolder;
    protected static AccessContextHolder _holder;
    protected static boolean _locked;
    protected LocalDate _accessLocalDate;
    protected AccessLocalDateProvider _accessLocalDateProvider;
    protected LocalDateTime _accessLocalDateTime;
    protected AccessLocalDateTimeProvider _accessLocalDateTimeProvider;
    protected Date _accessDate;
    protected AccessDateProvider _accessDateProvider;
    protected Timestamp _accessTimestamp;
    protected AccessTimestampProvider _accessTimestampProvider;
    protected String _accessUser;
    protected AccessUserProvider _accessUserProvider;
    protected String _accessProcess;
    protected AccessProcessProvider _accessProcessProvider;
    protected String _accessModule;
    protected AccessModuleProvider _accessModuleProvider;
    protected Map<String, Object> _accessValueMap;

    public static AccessContext getAccessContextOnThread() {
        return AccessContext.getActiveHolder().provide();
    }

    public static void setAccessContextOnThread(AccessContext accessContext) {
        if (accessContext == null) {
            String msg = "The argument 'accessContext' should not be null.";
            throw new IllegalArgumentException(msg);
        }
        AccessContext.getActiveHolder().save(accessContext);
    }

    public static boolean isExistAccessContextOnThread() {
        return AccessContext.getActiveHolder().provide() != null;
    }

    public static void clearAccessContextOnThread() {
        AccessContext.getActiveHolder().save(null);
    }

    protected static AccessContextHolder getActiveHolder() {
        return _holder;
    }

    public static void useSurrogateHolder(AccessContextHolder holder) {
        AccessContext.assertNotLocked();
        if (_log.isInfoEnabled()) {
            _log.info("...Setting surrogate holder for access context: " + holder);
        }
        _holder = holder != null ? holder : _defaultHolder;
        _locked = true;
    }

    public static boolean isLocked() {
        return _locked;
    }

    public static void lock() {
        if (_log.isInfoEnabled()) {
            _log.info("...Locking the static world of the access context!");
        }
        _locked = true;
    }

    public static void unlock() {
        if (_log.isInfoEnabled()) {
            _log.info("...Unlocking the static world of the access context!");
        }
        _locked = false;
    }

    protected static void assertNotLocked() {
        if (!AccessContext.isLocked()) {
            return;
        }
        String msg = "The access context is locked! Don't access at this timing!";
        throw new IllegalStateException(msg);
    }

    public static LocalDate getAccessLocalDateOnThread() {
        if (AccessContext.isExistAccessContextOnThread()) {
            LocalDate provided;
            AccessContext context = AccessContext.getAccessContextOnThread();
            LocalDate accessLocalDate = context.getAccessLocalDate();
            if (accessLocalDate != null) {
                return accessLocalDate;
            }
            AccessLocalDateProvider provider = context.getAccessLocalDateProvider();
            if (provider != null && (provided = provider.provideLocalDate()) != null) {
                return provided;
            }
        }
        return null;
    }

    public static LocalDateTime getAccessLocalDateTimeOnThread() {
        if (AccessContext.isExistAccessContextOnThread()) {
            LocalDateTime provided;
            AccessContext context = AccessContext.getAccessContextOnThread();
            LocalDateTime accessLocalDateTime = context.getAccessLocalDateTime();
            if (accessLocalDateTime != null) {
                return accessLocalDateTime;
            }
            AccessLocalDateTimeProvider provider = context.getAccessLocalDateTimeProvider();
            if (provider != null && (provided = provider.provideLocalDateTime()) != null) {
                return provided;
            }
        }
        return null;
    }

    public static Date getAccessDateOnThread() {
        if (AccessContext.isExistAccessContextOnThread()) {
            Date provided;
            AccessContext context = AccessContext.getAccessContextOnThread();
            Date accessDate = context.getAccessDate();
            if (accessDate != null) {
                return accessDate;
            }
            AccessDateProvider provider = context.getAccessDateProvider();
            if (provider != null && (provided = provider.provideDate()) != null) {
                return provided;
            }
        }
        return DBFluteSystem.currentDate();
    }

    public static Timestamp getAccessTimestampOnThread() {
        if (AccessContext.isExistAccessContextOnThread()) {
            Timestamp provided;
            AccessContext context = AccessContext.getAccessContextOnThread();
            Timestamp accessTimestamp = context.getAccessTimestamp();
            if (accessTimestamp != null) {
                return accessTimestamp;
            }
            AccessTimestampProvider provider = context.getAccessTimestampProvider();
            if (provider != null && (provided = provider.provideTimestamp()) != null) {
                return provided;
            }
        }
        return DBFluteSystem.currentTimestamp();
    }

    public static String getAccessUserOnThread() {
        if (AccessContext.isExistAccessContextOnThread()) {
            String user;
            AccessContext context = AccessContext.getAccessContextOnThread();
            String accessUser = context.getAccessUser();
            if (accessUser != null) {
                return accessUser;
            }
            AccessUserProvider provider = context.getAccessUserProvider();
            if (provider != null && (user = provider.provideUser()) != null) {
                return user;
            }
        }
        String methodName = "getAccessUserOnThread()";
        if (AccessContext.isExistAccessContextOnThread()) {
            AccessContext.throwAccessContextNoValueException("getAccessUserOnThread()", "AccessUser", "user");
        } else {
            AccessContext.throwAccessContextNotFoundException("getAccessUserOnThread()");
        }
        return null;
    }

    public static String getAccessProcessOnThread() {
        if (AccessContext.isExistAccessContextOnThread()) {
            String provided;
            AccessContext context = AccessContext.getAccessContextOnThread();
            String accessProcess = context.getAccessProcess();
            if (accessProcess != null) {
                return accessProcess;
            }
            AccessProcessProvider provider = context.getAccessProcessProvider();
            if (provider != null && (provided = provider.provideProcess()) != null) {
                return provided;
            }
        }
        String methodName = "getAccessProcessOnThread()";
        if (AccessContext.isExistAccessContextOnThread()) {
            AccessContext.throwAccessContextNoValueException("getAccessProcessOnThread()", "AccessProcess", "process");
        } else {
            AccessContext.throwAccessContextNotFoundException("getAccessProcessOnThread()");
        }
        return null;
    }

    public static String getAccessModuleOnThread() {
        if (AccessContext.isExistAccessContextOnThread()) {
            String provided;
            AccessContext context = AccessContext.getAccessContextOnThread();
            String accessModule = context.getAccessModule();
            if (accessModule != null) {
                return accessModule;
            }
            AccessModuleProvider provider = context.getAccessModuleProvider();
            if (provider != null && (provided = provider.provideModule()) != null) {
                return provided;
            }
        }
        String methodName = "getAccessModuleOnThread()";
        if (AccessContext.isExistAccessContextOnThread()) {
            AccessContext.throwAccessContextNoValueException("getAccessModuleOnThread()", "AccessModule", "module");
        } else {
            AccessContext.throwAccessContextNotFoundException("getAccessModuleOnThread()");
        }
        return null;
    }

    public static Object getAccessValueOnThread(String key) {
        Object value;
        AccessContext context;
        Map<String, Object> accessValueMap;
        if (AccessContext.isExistAccessContextOnThread() && (accessValueMap = (context = AccessContext.getAccessContextOnThread()).getAccessValueMap()) != null && (value = accessValueMap.get(key)) != null) {
            return value;
        }
        String methodName = "getAccessValueOnThread(\"" + key + "\")";
        if (AccessContext.isExistAccessContextOnThread()) {
            AccessContext.throwAccessContextNoValueException(methodName, "AccessValue", "value");
        } else {
            AccessContext.throwAccessContextNotFoundException(methodName);
        }
        return null;
    }

    protected static void throwAccessContextNotFoundException(String methodName) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("The access context was not found on thread.");
        br.addItem("Advice");
        br.addElement("Set up the value before DB access (using common column auto set-up)");
        br.addElement("You should set it up at your application's interceptor or filter.");
        br.addElement("For example:");
        br.addElement("  try {");
        br.addElement("      AccessContext context = new AccessContext();");
        br.addElement("      context.setAccessLocalDateTime(accessLocalDateTime);");
        br.addElement("      context.setAccessUser(accessUser);");
        br.addElement("      context.setAccessProcess(accessProcess);");
        br.addElement("      AccessContext.setAccessContextOnThread(context);");
        br.addElement("      return invocation.proceed();");
        br.addElement("  } finally {");
        br.addElement("      AccessContext.clearAccessContextOnThread();");
        br.addElement("  }");
        String msg = br.buildExceptionMessage();
        throw new AccessContextNotFoundException(msg);
    }

    protected static void throwAccessContextNoValueException(String methodName, String capPropName, String aliasName) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Failed to get the access " + aliasName + " in access context on thread.");
        br.addItem("Advice");
        br.addElement("Set up the value before DB access (using common column auto set-up)");
        br.addElement("You should set it up at your application's interceptor or filter.");
        br.addElement("For example:");
        br.addElement("  try {");
        br.addElement("      AccessContext context = new AccessContext();");
        br.addElement("      context.setAccessLocalDateTime(accessLocalDateTime);");
        br.addElement("      context.setAccessUser(accessUser);");
        br.addElement("      context.setAccessProcess(accessProcess);");
        br.addElement("      AccessContext.setAccessContextOnThread(context);");
        br.addElement("      return invocation.proceed();");
        br.addElement("  } finally {");
        br.addElement("      AccessContext.clearAccessContextOnThread();");
        br.addElement("  }");
        String msg = br.buildExceptionMessage();
        throw new AccessContextNoValueException(msg);
    }

    protected static String ln() {
        return DBFluteSystem.ln();
    }

    public String toString() {
        String disp;
        StringBuilder sb = new StringBuilder();
        sb.append(DfTypeUtil.toClassTitle(this)).append(":{");
        boolean firstDone = false;
        String delimiter = ", ";
        if (this._accessLocalDate != null) {
            sb.append(firstDone ? ", " : "").append("localDate=").append(this._accessLocalDate);
            firstDone = true;
        }
        if (this._accessLocalDateProvider != null) {
            sb.append(firstDone ? ", " : "").append("localDateProvider=").append(this._accessLocalDateProvider);
            firstDone = true;
        }
        if (this._accessLocalDateTime != null) {
            sb.append(firstDone ? ", " : "").append("localDateTime=").append(this._accessLocalDateTime);
            firstDone = true;
        }
        if (this._accessLocalDateTimeProvider != null) {
            sb.append(firstDone ? ", " : "").append("localDateTimeProvider=").append(this._accessLocalDateTimeProvider);
            firstDone = true;
        }
        if (this._accessDate != null) {
            disp = new SimpleDateFormat("yyyy/MM/dd").format(this._accessDate);
            sb.append(firstDone ? ", " : "").append("date=").append(disp);
            firstDone = true;
        }
        if (this._accessDateProvider != null) {
            sb.append(firstDone ? ", " : "").append("dateProvider=").append(this._accessDateProvider);
            firstDone = true;
        }
        if (this._accessTimestamp != null) {
            disp = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS").format(this._accessTimestamp);
            sb.append(firstDone ? ", " : "").append("timestamp=").append(disp);
            firstDone = true;
        }
        if (this._accessTimestampProvider != null) {
            sb.append(firstDone ? ", " : "").append("timestampProvider=").append(this._accessTimestampProvider);
            firstDone = true;
        }
        if (this._accessUser != null) {
            sb.append(firstDone ? ", " : "").append("user=").append(this._accessUser);
            firstDone = true;
        }
        if (this._accessUserProvider != null) {
            sb.append(firstDone ? ", " : "").append("userProvider=").append(this._accessUserProvider);
            firstDone = true;
        }
        if (this._accessProcess != null) {
            sb.append(firstDone ? ", " : "").append("process=").append(this._accessProcess);
            firstDone = true;
        }
        if (this._accessProcessProvider != null) {
            sb.append(firstDone ? ", " : "").append("processProvider=").append(this._accessProcessProvider);
            firstDone = true;
        }
        if (this._accessModule != null) {
            sb.append(firstDone ? ", " : "").append("module=").append(this._accessModule);
            firstDone = true;
        }
        if (this._accessModuleProvider != null) {
            sb.append(firstDone ? ", " : "").append("moduleProvider=").append(this._accessModuleProvider);
            firstDone = true;
        }
        if (this._accessValueMap != null) {
            sb.append(firstDone ? ", " : "").append("valueMap=").append(this._accessValueMap);
            firstDone = true;
        }
        sb.append("}");
        return sb.toString();
    }

    public LocalDate getAccessLocalDate() {
        return this._accessLocalDate;
    }

    public void setAccessLocalDate(LocalDate accessLocalDate) {
        this._accessLocalDate = accessLocalDate;
    }

    public AccessLocalDateProvider getAccessLocalDateProvider() {
        return this._accessLocalDateProvider;
    }

    public void setAccessLocalDateProvider(AccessLocalDateProvider accessLocalDateProvider) {
        this._accessLocalDateProvider = accessLocalDateProvider;
    }

    public LocalDateTime getAccessLocalDateTime() {
        return this._accessLocalDateTime;
    }

    public void setAccessLocalDateTime(LocalDateTime accessLocalDateTime) {
        this._accessLocalDateTime = accessLocalDateTime;
    }

    public AccessLocalDateTimeProvider getAccessLocalDateTimeProvider() {
        return this._accessLocalDateTimeProvider;
    }

    public void setAccessLocalDateTimeProvider(AccessLocalDateTimeProvider accessLocalDateTimeProvider) {
        this._accessLocalDateTimeProvider = accessLocalDateTimeProvider;
    }

    public Date getAccessDate() {
        return this._accessDate;
    }

    public void setAccessDate(Date accessDate) {
        this._accessDate = accessDate;
    }

    public AccessDateProvider getAccessDateProvider() {
        return this._accessDateProvider;
    }

    public void setAccessDateProvider(AccessDateProvider accessDateProvider) {
        this._accessDateProvider = accessDateProvider;
    }

    public Timestamp getAccessTimestamp() {
        return this._accessTimestamp;
    }

    public void setAccessTimestamp(Timestamp accessTimestamp) {
        this._accessTimestamp = accessTimestamp;
    }

    public AccessTimestampProvider getAccessTimestampProvider() {
        return this._accessTimestampProvider;
    }

    public void setAccessTimestampProvider(AccessTimestampProvider accessTimestampProvider) {
        this._accessTimestampProvider = accessTimestampProvider;
    }

    public String getAccessUser() {
        return this._accessUser;
    }

    public void setAccessUser(String accessUser) {
        this._accessUser = accessUser;
    }

    public AccessUserProvider getAccessUserProvider() {
        return this._accessUserProvider;
    }

    public void setAccessUserProvider(AccessUserProvider accessUserProvider) {
        this._accessUserProvider = accessUserProvider;
    }

    public String getAccessProcess() {
        return this._accessProcess;
    }

    public void setAccessProcess(String accessProcess) {
        this._accessProcess = accessProcess;
    }

    public AccessProcessProvider getAccessProcessProvider() {
        return this._accessProcessProvider;
    }

    public void setAccessProcessProvider(AccessProcessProvider accessProcessProvider) {
        this._accessProcessProvider = accessProcessProvider;
    }

    public String getAccessModule() {
        return this._accessModule;
    }

    public void setAccessModule(String accessModule) {
        this._accessModule = accessModule;
    }

    public AccessModuleProvider getAccessModuleProvider() {
        return this._accessModuleProvider;
    }

    public void setAccessModuleProvider(AccessModuleProvider accessModuleProvider) {
        this._accessModuleProvider = accessModuleProvider;
    }

    public Map<String, Object> getAccessValueMap() {
        return this._accessValueMap;
    }

    public void registerAccessValue(String key, Object value) {
        if (this._accessValueMap == null) {
            this._accessValueMap = new HashMap<String, Object>();
        }
        this._accessValueMap.put(key, value);
    }

    static {
        _holder = _defaultHolder = new AccessContextHolder(){

            @Override
            public AccessContext provide() {
                return _defaultThreadLocal.get();
            }

            @Override
            public void save(AccessContext context) {
                _defaultThreadLocal.set(context);
            }
        };
        _locked = true;
    }

    public static interface AccessModuleProvider {
        public String provideModule();
    }

    public static interface AccessProcessProvider {
        public String provideProcess();
    }

    public static interface AccessUserProvider {
        public String provideUser();
    }

    public static interface AccessTimestampProvider {
        public Timestamp provideTimestamp();
    }

    public static interface AccessDateProvider {
        public Date provideDate();
    }

    public static interface AccessLocalDateTimeProvider {
        public LocalDateTime provideLocalDateTime();
    }

    public static interface AccessLocalDateProvider {
        public LocalDate provideLocalDate();
    }

    public static interface AccessContextHolder {
        public AccessContext provide();

        public void save(AccessContext var1);
    }
}

