/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.infra.dfprop;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;

public class DfPublicProperties {
    public static final String PUBLIC_PROP_URL = "http://dbflute.org/meta/public.properties";
    public static final String VERSION_VARIABLE = "$$version$$";
    public static final String DBFLUTE_LATEST_RELEASE_VERSION = "dbflute.latest.release.version";
    public static final String DBFLUTE_LATEST_SNAPSHOT_VERSION = "dbflute.latest.snapshot.version";
    public static final String DBFLUTE_ENGINE_DOWNLOAD_URL = "dbflute.engine.download.url";
    public static final String INTRO_LATEST_VERSION = "intro.latest.version";
    public static final String INTRO_DOWNLOAD_URL = "intro.download.url";
    protected Properties _publicProp;
    protected String _specifiedUrl;

    public void load() {
        String siteUrl = this.getPublicPropertiesUrl();
        InputStream ins = null;
        try {
            URL url = new URL(siteUrl);
            ins = url.openStream();
            Properties prop = new Properties();
            prop.load(ins);
            this._publicProp = prop;
        }
        catch (IOException e) {
            String msg = "The url threw the IO exception: url=" + siteUrl;
            throw new IllegalStateException(msg, e);
        }
        finally {
            if (ins != null) {
                try {
                    ins.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public String getPublicPropertiesUrl() {
        return this._specifiedUrl != null ? this._specifiedUrl : PUBLIC_PROP_URL;
    }

    public String getDBFluteLatestReleaseVersion() {
        return this.getProperty(DBFLUTE_LATEST_RELEASE_VERSION);
    }

    public String getDBFluteLatestSnapshotVersion() {
        return this.getProperty(DBFLUTE_LATEST_SNAPSHOT_VERSION);
    }

    public String getDBFluteDownloadUrl(String downloadVersion) {
        return this.buildDownloadUrl(DBFLUTE_ENGINE_DOWNLOAD_URL, downloadVersion);
    }

    public String getIntroLatestVersion() {
        return this.getProperty(INTRO_LATEST_VERSION);
    }

    public String getIntroDownloadUrl(String downloadVersion) {
        return this.buildDownloadUrl(INTRO_DOWNLOAD_URL, downloadVersion);
    }

    protected String buildDownloadUrl(String urlKey, String downloadVersion) {
        String downloadUrl = this.getProperty(urlKey);
        if (downloadUrl == null) {
            String msg = "Not found the download URL property: key=" + urlKey + ", map=" + this._publicProp;
            throw new IllegalStateException(msg);
        }
        return this.replace(downloadUrl, VERSION_VARIABLE, downloadVersion);
    }

    protected String getProperty(String key) {
        if (this._publicProp == null) {
            String msg = "Not loaded public properties: " + this.getPublicPropertiesUrl();
            throw new IllegalStateException(msg);
        }
        return this._publicProp.getProperty(key);
    }

    protected String replace(String str, String fromStr, String toStr) {
        if (str == null) {
            throw new IllegalArgumentException("The argument 'str' should not be null.");
        }
        if (fromStr == null) {
            throw new IllegalArgumentException("The argument 'fromStr' should not be null.");
        }
        if (toStr == null) {
            throw new IllegalArgumentException("The argument 'toStr' should not be null.");
        }
        StringBuilder sb = null;
        int pos = 0;
        int pos2 = 0;
        while (true) {
            pos = str.indexOf(fromStr, pos2);
            if (pos2 == 0 && pos < 0) {
                return str;
            }
            if (sb == null) {
                sb = new StringBuilder();
            }
            if (pos == 0) {
                sb.append(toStr);
                pos2 = fromStr.length();
                continue;
            }
            if (pos <= 0) break;
            sb.append(str.substring(pos2, pos));
            sb.append(toStr);
            pos2 = pos + fromStr.length();
        }
        sb.append(str.substring(pos2));
        return sb.toString();
    }

    public DfPublicProperties specifyUrl(String url) {
        this._specifiedUrl = url;
        return this;
    }

    public String toString() {
        return "publicProp:{" + this._publicProp + "}";
    }
}

