/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.optional;

import java.util.stream.Stream;
import org.dbflute.exception.EntityAlreadyDeletedException;
import org.dbflute.exception.NonSetupSelectRelationAccessException;
import org.dbflute.helper.function.IndependentProcessor;
import org.dbflute.helper.message.ExceptionMessageBuilder;
import org.dbflute.optional.BaseOptional;
import org.dbflute.optional.OptionalThing;
import org.dbflute.optional.OptionalThingConsumer;
import org.dbflute.optional.OptionalThingExceptionThrower;
import org.dbflute.optional.OptionalThingFunction;
import org.dbflute.optional.OptionalThingIfPresentAfter;
import org.dbflute.optional.OptionalThingPredicate;
import org.dbflute.optional.OptionalThingSupplier;
import org.dbflute.optional.SerializableOptionalThingExceptionThrower;

public class OptionalEntity<ENTITY>
extends BaseOptional<ENTITY> {
    private static final long serialVersionUID = 1L;
    protected static final OptionalEntity<Object> EMPTY_INSTANCE = new OptionalEntity<Object>(null, (OptionalThingExceptionThrower)new SerializableOptionalThingExceptionThrower(){
        private static final long serialVersionUID = 1L;

        @Override
        public void throwNotFoundException() {
            String msg = "The empty optional so the value is null.";
            throw new EntityAlreadyDeletedException(msg);
        }
    });
    protected static final OptionalThingExceptionThrower NOWAY_THROWER = new SerializableOptionalThingExceptionThrower(){
        private static final long serialVersionUID = 1L;

        @Override
        public void throwNotFoundException() {
            throw new EntityAlreadyDeletedException("no way");
        }
    };

    public OptionalEntity(ENTITY entity, OptionalThingExceptionThrower thrower) {
        super(entity, thrower);
    }

    public static <EMPTY> OptionalEntity<EMPTY> empty() {
        return EMPTY_INSTANCE;
    }

    public static <ENTITY> OptionalEntity<ENTITY> of(ENTITY entity) {
        if (entity == null) {
            String msg = "The argument 'entity' should not be null.";
            throw new IllegalArgumentException(msg);
        }
        return new OptionalEntity<ENTITY>(entity, NOWAY_THROWER);
    }

    public static <ENTITY> OptionalEntity<ENTITY> ofNullable(ENTITY entity, OptionalThingExceptionThrower noArgLambda) {
        if (entity != null) {
            return OptionalEntity.of(entity);
        }
        return new OptionalEntity<ENTITY>(entity, noArgLambda);
    }

    public static <EMPTY> OptionalEntity<EMPTY> relationEmpty(final Object entity, final String relation) {
        if (entity == null) {
            String msg = "The argument 'entity' should not be null.";
            throw new IllegalArgumentException(msg);
        }
        if (relation == null) {
            String msg = "The argument 'relation' should not be null.";
            throw new IllegalArgumentException(msg);
        }
        return new OptionalEntity<Object>(null, new OptionalThingExceptionThrower(){

            @Override
            public void throwNotFoundException() {
                OptionalEntity.throwNonSetupSelectRelationAccessException(entity, relation);
            }
        });
    }

    protected static void throwNonSetupSelectRelationAccessException(Object entity, String relation) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Non-setupSelect relation was accessed.");
        br.addItem("Advice");
        br.addElement("Confirm your access to the relation.");
        br.addElement("Call setupSelect or fix your access.");
        br.addElement("For example:");
        br.addElement("  (x):");
        br.addElement("    memberBhv.selectList(cb -> {");
        br.addElement("        cb.setupSelect_MemberStatus();");
        br.addElement("    }).forEach(member -> {");
        br.addElement("        ... = member.getMemberSecurityAsOne().alwaysPresent(...); // *NG");
        br.addElement("    });");
        br.addElement("  (o): (fix access mistake)");
        br.addElement("    List<Member> memberList = memberBhv.selectList(cb -> {");
        br.addElement("        cb.setupSelect_MemberStatus();");
        br.addElement("    }).forEach(member -> {");
        br.addElement("        ... = member.getMemberStatus().alwaysPresent(...); // OK");
        br.addElement("    });");
        br.addElement("  (o): (fix setupSelect mistake)");
        br.addElement("    List<Member> memberList = memberBhv.selectList(cb -> {");
        br.addElement("        cb.setupSelect_MemberSecurityAsOne(); // OK");
        br.addElement("    }).forEach(member -> {");
        br.addElement("        ... = member.getMemberSecurityAsOne().alwaysPresent(...);");
        br.addElement("    });");
        br.addItem("Your Relation");
        br.addElement(entity.getClass().getSimpleName() + "." + relation);
        String msg = br.buildExceptionMessage();
        throw new NonSetupSelectRelationAccessException(msg);
    }

    @Override
    public OptionalThingIfPresentAfter ifPresent(OptionalThingConsumer<? super ENTITY> entityLambda) {
        this.assertEntityLambdaNotNull(entityLambda);
        return this.callbackIfPresent(entityLambda);
    }

    @Override
    public void ifPresentOrElse(OptionalThingConsumer<? super ENTITY> entityLambda, IndependentProcessor noArgLambda) {
        this.assertEntityLambdaNotNull(entityLambda);
        this.assertNoArgLambdaNotNull(noArgLambda);
        this.callbackIfPresentOrElse(entityLambda, noArgLambda);
    }

    @Override
    public boolean isPresent() {
        return this.determinePresent();
    }

    @Override
    public boolean isEmpty() {
        return this.determineEmpty();
    }

    @Override
    public ENTITY get() {
        return (ENTITY)this.directlyGet();
    }

    @Override
    public OptionalThing<ENTITY> or(OptionalThingSupplier<? extends OptionalThing<? extends ENTITY>> noArgLambda) {
        this.assertNoArgLambdaNotNull(noArgLambda);
        return this.callbackOr(noArgLambda);
    }

    @Override
    public ENTITY orElse(ENTITY other) {
        return this.directlyGetOrElse(other);
    }

    @Override
    public ENTITY orElseGet(OptionalThingSupplier<? extends ENTITY> noArgLambda) {
        this.assertNoArgLambdaNotNull(noArgLambda);
        return this.callbackGetOrElseGet(noArgLambda);
    }

    @Override
    public ENTITY orElseThrow() {
        return (ENTITY)this.directlyGet();
    }

    @Override
    public <CAUSE extends Throwable> ENTITY orElseThrow(OptionalThingSupplier<? extends CAUSE> noArgLambda) throws CAUSE {
        this.assertNoArgLambdaNotNull(noArgLambda);
        return (ENTITY)this.callbackGetOrElseThrow(noArgLambda);
    }

    @Override
    public <CAUSE extends Throwable, TRANSLATED extends Throwable> ENTITY orElseTranslatingThrow(OptionalThingFunction<CAUSE, TRANSLATED> causeLambda) throws TRANSLATED {
        this.assertCauseLambdaNotNull(causeLambda);
        return (ENTITY)this.callbackGetOrElseTranslatingThrow(causeLambda);
    }

    @Override
    public OptionalEntity<ENTITY> filter(OptionalThingPredicate<? super ENTITY> entityLambda) {
        this.assertEntityLambdaNotNull(entityLambda);
        return (OptionalEntity)this.callbackFilter(entityLambda);
    }

    @Override
    protected <ARG> OptionalEntity<ARG> createOptionalFilteredObject(ARG obj) {
        return new OptionalEntity<ARG>(obj, this._thrower);
    }

    @Override
    public <RESULT> OptionalEntity<RESULT> map(OptionalThingFunction<? super ENTITY, ? extends RESULT> entityLambda) {
        this.assertEntityLambdaNotNull(entityLambda);
        return (OptionalEntity)this.callbackMapping(entityLambda);
    }

    @Override
    protected <ARG> OptionalEntity<ARG> createOptionalMappedObject(ARG obj) {
        return new OptionalEntity<ARG>(obj, this._thrower);
    }

    @Override
    public <RESULT> OptionalThing<RESULT> flatMap(OptionalThingFunction<? super ENTITY, OptionalThing<RESULT>> entityLambda) {
        this.assertEntityLambdaNotNull(entityLambda);
        return this.callbackFlatMapping(entityLambda);
    }

    @Override
    protected <ARG> OptionalEntity<ARG> createOptionalFlatMappedObject(ARG obj) {
        return new OptionalEntity<ARG>(obj, this._thrower);
    }

    @Override
    public Stream<ENTITY> stream() {
        return this.convertToStream();
    }

    @Override
    public void alwaysPresent(OptionalThingConsumer<? super ENTITY> entityLambda) {
        this.assertEntityLambdaNotNull(entityLambda);
        this.callbackAlwaysPresent(entityLambda);
    }

    protected void assertEntityLambdaNotNull(Object entityLambda) {
        if (entityLambda == null) {
            throw new IllegalArgumentException("The argument 'entityLambda' should not be null.");
        }
    }
}

