/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.optional;

import java.util.stream.Stream;
import org.dbflute.helper.function.IndependentProcessor;
import org.dbflute.optional.BaseOptional;
import org.dbflute.optional.OptionalThing;
import org.dbflute.optional.OptionalThingConsumer;
import org.dbflute.optional.OptionalThingExceptionThrower;
import org.dbflute.optional.OptionalThingFunction;
import org.dbflute.optional.OptionalThingIfPresentAfter;
import org.dbflute.optional.OptionalThingPredicate;
import org.dbflute.optional.OptionalThingSupplier;

public class OptionalObject<OBJ>
extends BaseOptional<OBJ> {
    private static final long serialVersionUID = 1L;
    protected static final OptionalObject<Object> EMPTY_INSTANCE = new OptionalObject<Object>(null, () -> {
        String msg = "The empty optional so the value is null.";
        throw new IllegalStateException(msg);
    });
    protected static final OptionalThingExceptionThrower NOWAY_THROWER = () -> {
        throw new IllegalStateException("no way");
    };

    public OptionalObject(OBJ thing, OptionalThingExceptionThrower thrower) {
        super(thing, thrower);
    }

    public static <EMPTY> OptionalObject<EMPTY> empty() {
        return EMPTY_INSTANCE;
    }

    public static <OBJ> OptionalObject<OBJ> of(OBJ object) {
        if (object == null) {
            String msg = "The argument 'object' should not be null.";
            throw new IllegalArgumentException(msg);
        }
        return new OptionalObject<OBJ>(object, NOWAY_THROWER);
    }

    public static <OBJ> OptionalObject<OBJ> ofNullable(OBJ object, OptionalThingExceptionThrower noArgLambda) {
        if (object != null) {
            return OptionalObject.of(object);
        }
        return new OptionalObject<OBJ>(object, noArgLambda);
    }

    @Override
    public OptionalThingIfPresentAfter ifPresent(OptionalThingConsumer<? super OBJ> oneArgLambda) {
        this.assertOneArgLambdaNotNull(oneArgLambda);
        return this.callbackIfPresent(oneArgLambda);
    }

    @Override
    public void ifPresentOrElse(OptionalThingConsumer<? super OBJ> oneArgLambda, IndependentProcessor noArgLambda) {
        this.assertOneArgLambdaNotNull(oneArgLambda);
        this.assertNoArgLambdaNotNull(noArgLambda);
        this.callbackIfPresentOrElse(oneArgLambda, noArgLambda);
    }

    @Override
    public boolean isPresent() {
        return this.determinePresent();
    }

    @Override
    public boolean isEmpty() {
        return this.determineEmpty();
    }

    @Override
    public OBJ get() {
        return this.directlyGet();
    }

    @Override
    public OptionalThing<OBJ> or(OptionalThingSupplier<? extends OptionalThing<? extends OBJ>> noArgLambda) {
        this.assertNoArgLambdaNotNull(noArgLambda);
        return this.callbackOr(noArgLambda);
    }

    @Override
    public OBJ orElse(OBJ other) {
        return this.directlyGetOrElse(other);
    }

    @Override
    public OBJ orElseGet(OptionalThingSupplier<? extends OBJ> noArgLambda) {
        this.assertNoArgLambdaNotNull(noArgLambda);
        return this.callbackGetOrElseGet(noArgLambda);
    }

    @Override
    public OBJ orElseThrow() {
        return this.directlyGet();
    }

    @Override
    public <CAUSE extends Throwable> OBJ orElseThrow(OptionalThingSupplier<? extends CAUSE> noArgLambda) throws CAUSE {
        this.assertNoArgLambdaNotNull(noArgLambda);
        return this.callbackGetOrElseThrow(noArgLambda);
    }

    @Override
    public <CAUSE extends Throwable, TRANSLATED extends Throwable> OBJ orElseTranslatingThrow(OptionalThingFunction<CAUSE, TRANSLATED> causeLambda) throws TRANSLATED {
        this.assertCauseLambdaNotNull(causeLambda);
        return this.callbackGetOrElseTranslatingThrow(causeLambda);
    }

    @Override
    public OptionalObject<OBJ> filter(OptionalThingPredicate<? super OBJ> oneArgLambda) {
        this.assertOneArgLambdaNotNull(oneArgLambda);
        return (OptionalObject)this.callbackFilter(oneArgLambda);
    }

    @Override
    protected <ARG> OptionalObject<ARG> createOptionalFilteredObject(ARG obj) {
        return new OptionalObject<ARG>(obj, this._thrower);
    }

    @Override
    public <RESULT> OptionalThing<RESULT> map(OptionalThingFunction<? super OBJ, ? extends RESULT> oneArgLambda) {
        this.assertOneArgLambdaNotNull(oneArgLambda);
        return this.callbackMapping(oneArgLambda);
    }

    @Override
    protected <ARG> OptionalObject<ARG> createOptionalMappedObject(ARG obj) {
        return new OptionalObject<ARG>(obj, this._thrower);
    }

    @Override
    public <RESULT> OptionalThing<RESULT> flatMap(OptionalThingFunction<? super OBJ, OptionalThing<RESULT>> oneArgLambda) {
        this.assertOneArgLambdaNotNull(oneArgLambda);
        return this.callbackFlatMapping(oneArgLambda);
    }

    @Override
    protected <ARG> OptionalObject<ARG> createOptionalFlatMappedObject(ARG obj) {
        return new OptionalObject<ARG>(obj, this._thrower);
    }

    @Override
    public Stream<OBJ> stream() {
        return this.convertToStream();
    }

    @Override
    public void alwaysPresent(OptionalThingConsumer<? super OBJ> oneArgLambda) {
        this.assertOneArgLambdaNotNull(oneArgLambda);
        this.callbackAlwaysPresent(oneArgLambda);
    }
}

