/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.optional;

import java.util.stream.Stream;
import org.dbflute.helper.function.IndependentProcessor;
import org.dbflute.optional.BaseOptional;
import org.dbflute.optional.OptionalThing;
import org.dbflute.optional.OptionalThingConsumer;
import org.dbflute.optional.OptionalThingExceptionThrower;
import org.dbflute.optional.OptionalThingFunction;
import org.dbflute.optional.OptionalThingIfPresentAfter;
import org.dbflute.optional.OptionalThingPredicate;
import org.dbflute.optional.OptionalThingSupplier;

public class OptionalScalar<SCALAR>
extends BaseOptional<SCALAR> {
    private static final long serialVersionUID = 1L;
    protected static final OptionalScalar<Object> EMPTY_INSTANCE = new OptionalScalar<Object>(null, () -> {
        String msg = "The empty optional so the value is null.";
        throw new IllegalStateException(msg);
    });
    protected static final OptionalThingExceptionThrower NOWAY_THROWER = () -> {
        throw new IllegalStateException("no way");
    };

    public OptionalScalar(SCALAR thing, OptionalThingExceptionThrower thrower) {
        super(thing, thrower);
    }

    public static <EMPTY> OptionalScalar<EMPTY> empty() {
        return EMPTY_INSTANCE;
    }

    public static <OBJ> OptionalScalar<OBJ> of(OBJ object) {
        if (object == null) {
            String msg = "The argument 'object' should not be null.";
            throw new IllegalArgumentException(msg);
        }
        return new OptionalScalar<OBJ>(object, NOWAY_THROWER);
    }

    public static <OBJ> OptionalScalar<OBJ> ofNullable(OBJ object, OptionalThingExceptionThrower noArgLambda) {
        if (object != null) {
            return OptionalScalar.of(object);
        }
        return new OptionalScalar<OBJ>(object, noArgLambda);
    }

    @Override
    public OptionalThingIfPresentAfter ifPresent(OptionalThingConsumer<? super SCALAR> oneArgLambda) {
        this.assertOneArgLambdaNotNull(oneArgLambda);
        return this.callbackIfPresent(oneArgLambda);
    }

    @Override
    public void ifPresentOrElse(OptionalThingConsumer<? super SCALAR> oneArgLambda, IndependentProcessor noArgLambda) {
        this.assertOneArgLambdaNotNull(oneArgLambda);
        this.assertNoArgLambdaNotNull(noArgLambda);
        this.callbackIfPresentOrElse(oneArgLambda, noArgLambda);
    }

    @Override
    public boolean isPresent() {
        return this.determinePresent();
    }

    @Override
    public boolean isEmpty() {
        return this.determineEmpty();
    }

    @Override
    public SCALAR get() {
        return (SCALAR)this.directlyGet();
    }

    @Override
    public OptionalThing<SCALAR> or(OptionalThingSupplier<? extends OptionalThing<? extends SCALAR>> noArgLambda) {
        this.assertNoArgLambdaNotNull(noArgLambda);
        return this.callbackOr(noArgLambda);
    }

    @Override
    public SCALAR orElse(SCALAR other) {
        return this.directlyGetOrElse(other);
    }

    @Override
    public SCALAR orElseGet(OptionalThingSupplier<? extends SCALAR> noArgLambda) {
        this.assertNoArgLambdaNotNull(noArgLambda);
        return this.callbackGetOrElseGet(noArgLambda);
    }

    @Override
    public SCALAR orElseThrow() {
        return (SCALAR)this.directlyGet();
    }

    @Override
    public <CAUSE extends Throwable> SCALAR orElseThrow(OptionalThingSupplier<? extends CAUSE> noArgLambda) throws CAUSE {
        this.assertNoArgLambdaNotNull(noArgLambda);
        return (SCALAR)this.callbackGetOrElseThrow(noArgLambda);
    }

    @Override
    public <CAUSE extends Throwable, TRANSLATED extends Throwable> SCALAR orElseTranslatingThrow(OptionalThingFunction<CAUSE, TRANSLATED> causeLambda) throws TRANSLATED {
        this.assertCauseLambdaNotNull(causeLambda);
        return (SCALAR)this.callbackGetOrElseTranslatingThrow(causeLambda);
    }

    @Override
    public OptionalScalar<SCALAR> filter(OptionalThingPredicate<? super SCALAR> oneArgLambda) {
        this.assertOneArgLambdaNotNull(oneArgLambda);
        return (OptionalScalar)this.callbackFilter(oneArgLambda);
    }

    @Override
    protected <ARG> OptionalScalar<ARG> createOptionalFilteredObject(ARG obj) {
        return new OptionalScalar<ARG>(obj, this._thrower);
    }

    @Override
    public <RESULT> OptionalThing<RESULT> map(OptionalThingFunction<? super SCALAR, ? extends RESULT> oneArgLambda) {
        this.assertOneArgLambdaNotNull(oneArgLambda);
        return this.callbackMapping(oneArgLambda);
    }

    @Override
    protected <ARG> OptionalScalar<ARG> createOptionalMappedObject(ARG obj) {
        return new OptionalScalar<ARG>(obj, this._thrower);
    }

    @Override
    public <RESULT> OptionalThing<RESULT> flatMap(OptionalThingFunction<? super SCALAR, OptionalThing<RESULT>> oneArgLambda) {
        this.assertOneArgLambdaNotNull(oneArgLambda);
        return this.callbackFlatMapping(oneArgLambda);
    }

    @Override
    protected <ARG> OptionalScalar<ARG> createOptionalFlatMappedObject(ARG obj) {
        return new OptionalScalar<ARG>(obj, this._thrower);
    }

    @Override
    public Stream<SCALAR> stream() {
        return this.convertToStream();
    }

    @Override
    public void alwaysPresent(OptionalThingConsumer<? super SCALAR> oneArgLambda) {
        this.assertOneArgLambdaNotNull(oneArgLambda);
        this.callbackAlwaysPresent(oneArgLambda);
    }
}

