/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.s2dao.valuetype.basic;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.TimeZone;
import org.dbflute.bhv.core.context.ResourceContext;
import org.dbflute.s2dao.valuetype.TnAbstractValueType;
import org.dbflute.s2dao.valuetype.basic.SqlDateType;
import org.dbflute.system.DBFluteSystem;
import org.dbflute.util.DfTypeUtil;

public class LocalDateAsSqlDateType
extends TnAbstractValueType {
    protected final SqlDateType _sqlDateType = new SqlDateType();

    public LocalDateAsSqlDateType() {
        super(91);
    }

    @Override
    public Object getValue(ResultSet rs, int index) throws SQLException {
        return this.toLocalDate(this._sqlDateType.getValue(rs, index));
    }

    @Override
    public Object getValue(ResultSet rs, String columnName) throws SQLException {
        return this.toLocalDate(this._sqlDateType.getValue(rs, columnName));
    }

    @Override
    public Object getValue(CallableStatement cs, int index) throws SQLException {
        return this.toLocalDate(this._sqlDateType.getValue(cs, index));
    }

    @Override
    public Object getValue(CallableStatement cs, String parameterName) throws SQLException {
        return this.toLocalDate(this._sqlDateType.getValue(cs, parameterName));
    }

    @Override
    public void bindValue(Connection conn, PreparedStatement ps, int index, Object value) throws SQLException {
        this._sqlDateType.bindValue(conn, ps, index, (Object)this.toSqlDate(value));
    }

    @Override
    public void bindValue(Connection conn, CallableStatement cs, String parameterName, Object value) throws SQLException {
        this._sqlDateType.bindValue(conn, cs, parameterName, (Object)this.toSqlDate(value));
    }

    protected LocalDate toLocalDate(Object date) {
        return DfTypeUtil.toLocalDate(date, this.getTimeZone());
    }

    protected Date toSqlDate(Object date) {
        return DfTypeUtil.toSqlDate(date, this.getTimeZone());
    }

    protected TimeZone getTimeZone() {
        TimeZone provided;
        if (ResourceContext.isExistResourceContextOnThread() && (provided = ResourceContext.provideMappingDateTimeZone()) != null) {
            return provided;
        }
        return DBFluteSystem.getFinalTimeZone();
    }
}

