/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.bhv.writable;

import org.dbflute.bhv.writable.WritableOption;
import org.dbflute.cbean.ConditionBean;
import org.dbflute.cbean.coption.StatementConfigCall;
import org.dbflute.dbmeta.info.UniqueInfo;
import org.dbflute.exception.IllegalConditionBeanOperationException;
import org.dbflute.jdbc.StatementConfig;
import org.dbflute.util.DfTypeUtil;

public class DeleteOption<CB extends ConditionBean>
implements WritableOption<CB> {
    protected UniqueInfo _uniqueByUniqueInfo;
    protected boolean _nonQueryDeleteAllowed;
    protected boolean _queryDeleteForcedDirectAllowed;
    protected Integer _batchLoggingDeleteLimit;
    protected StatementConfig _deleteStatementConfig;

    public void uniqueBy(UniqueInfo uniqueInfo) {
        if (uniqueInfo == null) {
            String msg = "The argument 'uniqueInfo' should not be null.";
            throw new IllegalArgumentException(msg);
        }
        if (uniqueInfo.isPrimary()) {
            String msg = "The unique info should be natural unique (not primary): " + uniqueInfo;
            throw new IllegalArgumentException(msg);
        }
        this._uniqueByUniqueInfo = uniqueInfo;
    }

    public boolean hasUniqueByUniqueInfo() {
        return this._uniqueByUniqueInfo != null;
    }

    public UniqueInfo getUniqueByUniqueInfo() {
        return this._uniqueByUniqueInfo;
    }

    public DeleteOption<CB> allowNonQueryDelete() {
        this._nonQueryDeleteAllowed = true;
        return this;
    }

    public boolean isNonQueryDeleteAllowed() {
        return this._nonQueryDeleteAllowed;
    }

    public DeleteOption<CB> allowQueryDeleteForcedDirect() {
        this._queryDeleteForcedDirectAllowed = true;
        return this;
    }

    public boolean isQueryDeleteForcedDirectAllowed() {
        return this._queryDeleteForcedDirectAllowed;
    }

    public void limitBatchDeleteLogging(Integer batchDeleteLoggingLimit) {
        this._batchLoggingDeleteLimit = batchDeleteLoggingLimit;
    }

    public Integer getBatchLoggingDeleteLimit() {
        return this._batchLoggingDeleteLimit;
    }

    public void configure(StatementConfigCall<StatementConfig> confLambda) {
        this.assertStatementConfigNotDuplicated(confLambda);
        this._deleteStatementConfig = this.createStatementConfig(confLambda);
    }

    protected void assertStatementConfigNotDuplicated(StatementConfigCall<StatementConfig> configCall) {
        if (this._deleteStatementConfig != null) {
            String msg = "Already registered the configuration: existing=" + this._deleteStatementConfig + ", new=" + configCall;
            throw new IllegalConditionBeanOperationException(msg);
        }
    }

    protected StatementConfig createStatementConfig(StatementConfigCall<StatementConfig> configCall) {
        if (configCall == null) {
            throw new IllegalArgumentException("The argument 'confLambda' should not be null.");
        }
        StatementConfig config = this.newStatementConfig();
        configCall.callback(config);
        return config;
    }

    protected StatementConfig newStatementConfig() {
        return new StatementConfig();
    }

    public StatementConfig getDeleteStatementConfig() {
        return this._deleteStatementConfig;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this._nonQueryDeleteAllowed) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("NonQueryDeleteAllowed");
        }
        if (sb.length() == 0) {
            sb.append("default");
        }
        return DfTypeUtil.toClassTitle(this) + ":{" + sb.toString() + "}";
    }
}

