/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.cbean.garnish.datefitting;

import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;
import java.util.Date;
import org.dbflute.dbmeta.info.ColumnInfo;
import org.dbflute.util.DfTypeUtil;

public class DateConditionAdjuster {
    public Object truncatePrecisionIfHasTime(ColumnInfo columnInfo, Object value) {
        Integer datetimePrecision;
        if (value == null) {
            throw new IllegalArgumentException("The argument 'value' should not be null.");
        }
        if (columnInfo.isObjectNativeTypeDate() && ((datetimePrecision = columnInfo.getDatetimePrecision()) == null || datetimePrecision == 0)) {
            if (value instanceof LocalDateTime) {
                return ((LocalDateTime)value).truncatedTo(ChronoUnit.SECONDS);
            }
            if (value instanceof LocalTime) {
                return ((LocalTime)value).truncatedTo(ChronoUnit.SECONDS);
            }
            if (value instanceof Date && !(value instanceof java.sql.Date)) {
                Calendar cal = DfTypeUtil.toCalendar(value);
                DfTypeUtil.clearCalendarMillisecond(cal);
                return DfTypeUtil.toDate(cal);
            }
        }
        return value;
    }
}

