/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.cbean.paging.numberlink.group;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.dbflute.cbean.paging.numberlink.PageNumberLink;
import org.dbflute.cbean.paging.numberlink.PageNumberLinkSetupper;
import org.dbflute.cbean.paging.numberlink.group.PageGroupOption;

public class PageGroupBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected int _currentPageNumber;
    protected int _allPageCount;
    protected PageGroupOption _pageGroupOption;
    protected List<Integer> _cachedPageNumberList;

    public <LINK extends PageNumberLink> List<LINK> buildPageNumberLinkList(PageNumberLinkSetupper<LINK> manyArgLambda) {
        List<Integer> pageNumberList = this.createPageNumberList();
        ArrayList<LINK> pageNumberLinkList = new ArrayList<LINK>();
        for (Integer pageNumber : pageNumberList) {
            pageNumberLinkList.add(manyArgLambda.setup(pageNumber, pageNumber.equals(this._currentPageNumber)));
        }
        return pageNumberLinkList;
    }

    public List<Integer> createPageNumberList() {
        this.assertPageGroupValid();
        if (this._cachedPageNumberList != null) {
            return this._cachedPageNumberList;
        }
        int pageGroupSize = this._pageGroupOption.getPageGroupSize();
        int allPageCount = this._allPageCount;
        int currentPageGroupStartPageNumber = this.calculateStartPageNumber();
        if (currentPageGroupStartPageNumber <= 0) {
            String msg = "currentPageGroupStartPageNumber should be greater than 0. {> 0} But:";
            msg = msg + " currentPageGroupStartPageNumber=" + currentPageGroupStartPageNumber;
            throw new IllegalStateException(msg);
        }
        int nextPageGroupStartPageNumber = currentPageGroupStartPageNumber + pageGroupSize;
        ArrayList<Integer> resultList = new ArrayList<Integer>();
        for (int i = currentPageGroupStartPageNumber; i < nextPageGroupStartPageNumber && i <= allPageCount; ++i) {
            resultList.add(i);
        }
        this._cachedPageNumberList = resultList;
        return this._cachedPageNumberList;
    }

    protected int calculateStartPageNumber() {
        int currentPageGroupStartPageNumber;
        this.assertPageGroupValid();
        int pageGroupSize = this._pageGroupOption.getPageGroupSize();
        int currentPageNumber = this._currentPageNumber;
        int currentPageGroupNumber = currentPageNumber / pageGroupSize;
        if (currentPageNumber % pageGroupSize == 0) {
            --currentPageGroupNumber;
        }
        if (currentPageNumber < (currentPageGroupStartPageNumber = pageGroupSize * currentPageGroupNumber + 1)) {
            String msg = "currentPageNumber should be greater equal currentPageGroupStartPageNumber. But:";
            msg = msg + " currentPageNumber=" + currentPageNumber;
            msg = msg + " currentPageGroupStartPageNumber=" + currentPageGroupStartPageNumber;
            throw new IllegalStateException(msg);
        }
        return currentPageGroupStartPageNumber;
    }

    public boolean existsPreviousGroup() {
        this.assertPageGroupValid();
        return this._currentPageNumber > this._pageGroupOption.getPageGroupSize();
    }

    public boolean existsNextGroup() {
        this.assertPageGroupValid();
        int currentStartPageNumber = this.calculateStartPageNumber();
        if (currentStartPageNumber <= 0) {
            String msg = "currentStartPageNumber should be greater than 0. {> 0} But:";
            msg = msg + " currentStartPageNumber=" + currentStartPageNumber;
            throw new IllegalStateException(msg);
        }
        int nextStartPageNumber = currentStartPageNumber + this._pageGroupOption.getPageGroupSize();
        return nextStartPageNumber <= this._allPageCount;
    }

    public boolean isExistPrePageGroup() {
        return this.existsPreviousGroup();
    }

    public boolean isExistNextPageGroup() {
        return this.existsNextGroup();
    }

    protected int[] convertListToIntArray(List<Integer> ls) {
        int[] resultArray = new int[ls.size()];
        int arrayIndex = 0;
        int[] nArray = resultArray;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int pageNumber;
            resultArray[arrayIndex] = pageNumber = nArray[i];
            ++arrayIndex;
        }
        return resultArray;
    }

    protected void assertPageGroupValid() {
        if (this._pageGroupOption == null) {
            String msg = "The pageGroupOption should not be null. Please call setPageGroupOption().";
            throw new IllegalStateException(msg);
        }
        if (this._pageGroupOption.getPageGroupSize() == 0) {
            String msg = "The pageGroupSize should be greater than 1. But the value is zero.";
            msg = msg + " pageGroupSize=" + this._pageGroupOption.getPageGroupSize();
            throw new IllegalStateException(msg);
        }
        if (this._pageGroupOption.getPageGroupSize() == 1) {
            String msg = "The pageGroupSize should be greater than 1. But the value is one.";
            msg = msg + " pageGroupSize=" + this._pageGroupOption.getPageGroupSize();
            throw new IllegalStateException(msg);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("currentPageNumber=").append(this._currentPageNumber);
        sb.append(", allPageCount=").append(this._allPageCount);
        sb.append(", pageGroupOption=").append(this._pageGroupOption);
        sb.append("}");
        return sb.toString();
    }

    public void setCurrentPageNumber(int currentPageNumber) {
        this._currentPageNumber = currentPageNumber;
    }

    public void setAllPageCount(int allPageCount) {
        this._allPageCount = allPageCount;
    }

    public PageGroupOption getPageGroupOption() {
        return this._pageGroupOption;
    }

    public void setPageGroupOption(PageGroupOption pageGroupOption) {
        this._pageGroupOption = pageGroupOption;
    }

    public int getPreviousGroupNearestPageNumber() {
        if (!this.existsPreviousGroup()) {
            String msg = "The previous page range should exist when you use previousGroupNearestPageNumber:";
            msg = msg + " currentPageNumber=" + this._currentPageNumber + " allPageCount=" + this._allPageCount;
            msg = msg + " pageGroupOption=" + this._pageGroupOption;
            throw new IllegalStateException(msg);
        }
        return this.createPageNumberList().get(0) - 1;
    }

    public int getNextGroupNearestPageNumber() {
        if (!this.existsNextGroup()) {
            String msg = "The next page range should exist when you use nextGroupNearestPageNumber:";
            msg = msg + " currentPageNumber=" + this._currentPageNumber + " allPageCount=" + this._allPageCount;
            msg = msg + " pageGroupOption=" + this._pageGroupOption;
            throw new IllegalStateException(msg);
        }
        List<Integer> ls = this.createPageNumberList();
        return ls.get(ls.size() - 1) + 1;
    }

    public int getPreGroupNearestPageNumber() {
        return this.getPreviousGroupNearestPageNumber();
    }
}

