/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.dbway;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dbflute.dbway.DBWay;
import org.dbflute.dbway.OnQueryStringConnector;
import org.dbflute.optional.OptionalThing;

public class WayOfMySQL
implements DBWay,
Serializable {
    private static final long serialVersionUID = 1L;
    protected static final OnQueryStringConnector ORIGINAL_STRING_CONNECTOR = new OnQueryStringConnector(){

        @Override
        public String connect(Object ... elements) {
            StringBuilder sb = new StringBuilder();
            sb.append("concat(");
            int index = 0;
            for (Object element : elements) {
                if (index > 0) {
                    sb.append(", ");
                }
                sb.append(element);
                ++index;
            }
            sb.append(")");
            return sb.toString();
        }
    };

    @Override
    public String buildSequenceNextValSql(String sequenceName) {
        return null;
    }

    @Override
    public String getIdentitySelectSql() {
        return "SELECT LAST_INSERT_ID()";
    }

    @Override
    public boolean isBlockCommentSupported() {
        return true;
    }

    @Override
    public boolean isLineCommentSupported() {
        return true;
    }

    @Override
    public boolean isScrollableCursorSupported() {
        return true;
    }

    @Override
    public List<String> getOriginalWildCardList() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public OnQueryStringConnector getStringConnector() {
        return ORIGINAL_STRING_CONNECTOR;
    }

    @Override
    public boolean isUniqueConstraintException(String sqlState, Integer errorCode) {
        return errorCode != null && errorCode == 1062;
    }

    public static enum FullTextSearchModifier {
        InBooleanMode("in boolean mode"),
        InNaturalLanguageMode("in natural language mode"),
        InNaturalLanguageModeWithQueryExpansion("in natural language mode with query expansion"),
        WithQueryExpansion("with query expansion");

        private static final Map<String, FullTextSearchModifier> _codeValueMap;
        private String _code;

        private FullTextSearchModifier(String code) {
            this._code = code;
        }

        public String code() {
            return this._code;
        }

        public static OptionalThing<FullTextSearchModifier> of(Object code) {
            if (code == null) {
                return OptionalThing.ofNullable(null, () -> {
                    throw new IllegalArgumentException("The argument 'code' should not be null.");
                });
            }
            if (code instanceof FullTextSearchModifier) {
                return OptionalThing.of((FullTextSearchModifier)((Object)code));
            }
            if (code instanceof OptionalThing) {
                return FullTextSearchModifier.of(((OptionalThing)code).orElse(null));
            }
            FullTextSearchModifier modifier = _codeValueMap.get(code.toString().toLowerCase());
            return OptionalThing.ofNullable(modifier, () -> {
                throw new IllegalStateException("Not found the modifier by the code: " + code);
            });
        }

        @Deprecated
        public static FullTextSearchModifier codeOf(Object code) {
            return FullTextSearchModifier.of(code).orElse(null);
        }

        static {
            _codeValueMap = new HashMap<String, FullTextSearchModifier>();
            for (FullTextSearchModifier value : FullTextSearchModifier.values()) {
                _codeValueMap.put(value.code().toLowerCase(), value);
            }
        }
    }
}

