/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.helper.thread;

import java.util.concurrent.CountDownLatch;
import org.dbflute.helper.thread.exception.CountDownRaceExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CountDownRaceLatch {
    private static final Logger _log = LoggerFactory.getLogger(CountDownRaceLatch.class);
    protected final int _runnerCount;
    protected volatile CountDownLatch _ourLatch;

    public CountDownRaceLatch(int runnerCount) {
        this._runnerCount = runnerCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void await() {
        boolean last;
        CountDownLatch latch;
        CountDownRaceLatch countDownRaceLatch = this;
        synchronized (countDownRaceLatch) {
            latch = this.prepareLatch();
            boolean bl = last = this.actuallyGetCount(latch) == 1L;
            if (last) {
                if (_log.isDebugEnabled()) {
                    _log.debug("...Restarting count down race");
                }
                this.clearLatch();
            }
            this.actuallyCountDown(latch);
        }
        if (!last && this.isWaitingLatch()) {
            if (_log.isDebugEnabled()) {
                _log.debug("...Awaiting all runners coming here");
            }
            this.actuallyAwait(latch);
        }
    }

    protected CountDownLatch prepareLatch() {
        if (this._ourLatch == null) {
            this._ourLatch = new CountDownLatch(this._runnerCount);
        }
        return this._ourLatch;
    }

    protected void clearLatch() {
        this._ourLatch = null;
    }

    protected boolean isWaitingLatch() {
        return this._ourLatch != null;
    }

    protected long actuallyGetCount(CountDownLatch latch) {
        return latch.getCount();
    }

    protected void actuallyCountDown(CountDownLatch latch) {
        latch.countDown();
    }

    protected void actuallyAwait(CountDownLatch latch) {
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            String msg = "Failed to await by your latch: latch=" + latch;
            throw new CountDownRaceExecutionException(msg, e);
        }
    }

    public synchronized void reset() {
        if (this._ourLatch == null) {
            return;
        }
        long count = this._ourLatch.getCount();
        if (count > 0L) {
            if (_log.isDebugEnabled()) {
                _log.debug("...Resetting your latch: count=" + count);
            }
            int i = 0;
            while ((long)i < count) {
                this._ourLatch.countDown();
                ++i;
            }
        }
        this._ourLatch = null;
    }
}

