/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.infra.diffmap;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Predicate;
import org.dbflute.exception.DfPropFileReadFailureException;
import org.dbflute.exception.DfPropFileWriteFailureException;
import org.dbflute.helper.dfmap.DfMapFile;
import org.dbflute.helper.dfmap.DfMapStyle;
import org.dbflute.helper.filesystem.FileHierarchyTracer;
import org.dbflute.helper.filesystem.FileHierarchyTracingHandler;
import org.dbflute.helper.message.ExceptionMessageBuilder;
import org.dbflute.util.Srl;

public class DfDiffMapFile {
    public Map<String, Object> collectDiffMap(String pieceDirPath, Predicate<File> pieceDeterminer, String monolithicMapPath) {
        if (pieceDirPath == null || pieceDirPath.trim().isEmpty()) {
            throw new IllegalArgumentException("The argument 'pieceDirPath' should not be null or empty.");
        }
        if (pieceDeterminer == null) {
            throw new IllegalArgumentException("The argument 'pieceDeterminer' should not be null.");
        }
        if (monolithicMapPath == null || monolithicMapPath.trim().isEmpty()) {
            throw new IllegalArgumentException("The argument 'monolithicMapPath' should not be null or empty.");
        }
        TreeMap<String, Object> sortedMap = new TreeMap<String, Object>((key1, key2) -> -key1.compareTo((String)key2));
        File pieceDir = new File(pieceDirPath);
        if (pieceDir.exists()) {
            this.pickupPiece(pieceDir, pieceDeterminer, sortedMap);
        }
        this.pickupMonolithic(monolithicMapPath, sortedMap);
        return this.convertToStyleMap(sortedMap);
    }

    protected void pickupPiece(File pieceDir, final Predicate<File> pieceDeterminer, SortedMap<String, Object> sortedMap) {
        final ArrayList pieceFileList = new ArrayList();
        FileHierarchyTracer tracer = new FileHierarchyTracer();
        tracer.trace(pieceDir, new FileHierarchyTracingHandler(){

            @Override
            public boolean isTargetFileOrDir(File currentFile) {
                if (pieceDeterminer.test(currentFile)) {
                    return true;
                }
                return currentFile.isDirectory() && Srl.isNumberHarfAll(currentFile.getName());
            }

            @Override
            public void handleFile(File currentFile) throws IOException {
                pieceFileList.add(currentFile);
            }
        });
        for (File pieceFile : pieceFileList) {
            try {
                Map<String, Object> readMap = this.readMap(new FileInputStream(pieceFile));
                sortedMap.putAll(readMap);
            }
            catch (FileNotFoundException e) {
                throw new DfPropFileReadFailureException("Not found the piece file: " + pieceFile, e);
            }
        }
    }

    protected void pickupMonolithic(String monolithicMapPath, SortedMap<String, Object> sortedMap) {
        File monolithicMapFile = new File(monolithicMapPath);
        if (monolithicMapFile.exists()) {
            try {
                Map<String, Object> readMap = this.readMap(new FileInputStream(monolithicMapFile));
                sortedMap.putAll(readMap);
            }
            catch (FileNotFoundException e) {
                throw new DfPropFileReadFailureException("Not found the monolithic map file: " + monolithicMapPath, e);
            }
        }
    }

    protected Map<String, Object> convertToStyleMap(SortedMap<String, Object> sortedMap) {
        Map<String, Object> resultMap = new DfMapStyle().newStringObjectMap();
        resultMap.putAll(sortedMap);
        return resultMap;
    }

    public Map<String, Object> readMap(InputStream ins) {
        DfMapFile mapFile = this.createMapFile();
        try {
            return mapFile.readMap(ins);
        }
        catch (Exception e) {
            this.throwDfPropFileReadFailureException(ins, e);
            return null;
        }
    }

    protected void throwDfPropFileReadFailureException(InputStream ins, Exception e) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Failed to read the diff-map file.");
        br.addItem("Advice");
        br.addElement("Make sure the map-string is correct in the file.");
        br.addElement("For exapmle, the number of start and end braces are the same.");
        br.addItem("DBFlute Property");
        br.addElement(ins);
        String msg = br.buildExceptionMessage();
        throw new DfPropFileReadFailureException(msg, e);
    }

    public void writeMap(OutputStream ous, Map<String, Object> map) {
        DfMapFile mapFile = this.createMapFile();
        try {
            mapFile.writeMap(ous, map);
        }
        catch (Exception e) {
            this.throwDfPropFileWriteFailureException(ous, e);
        }
    }

    protected void throwDfPropFileWriteFailureException(OutputStream ous, Exception e) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Failed to write the diff-map file.");
        br.addItem("DBFlute Property");
        br.addElement(ous);
        String msg = br.buildExceptionMessage();
        throw new DfPropFileWriteFailureException(msg, e);
    }

    protected DfMapFile createMapFile() {
        return new DfMapFile();
    }
}

