/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.cbean.ckey;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.dbflute.cbean.ConditionBean;
import org.dbflute.cbean.chelper.HpCalcSpecification;
import org.dbflute.cbean.cipher.ColumnFunctionCipher;
import org.dbflute.cbean.cipher.GearedCipherManager;
import org.dbflute.cbean.ckey.ConditionKeyEqual;
import org.dbflute.cbean.ckey.ConditionKeyGreaterEqual;
import org.dbflute.cbean.ckey.ConditionKeyGreaterEqualOrIsNull;
import org.dbflute.cbean.ckey.ConditionKeyGreaterThan;
import org.dbflute.cbean.ckey.ConditionKeyGreaterThanOrIsNull;
import org.dbflute.cbean.ckey.ConditionKeyInScope;
import org.dbflute.cbean.ckey.ConditionKeyIsNotNull;
import org.dbflute.cbean.ckey.ConditionKeyIsNull;
import org.dbflute.cbean.ckey.ConditionKeyIsNullOrEmpty;
import org.dbflute.cbean.ckey.ConditionKeyLessEqual;
import org.dbflute.cbean.ckey.ConditionKeyLessEqualOrIsNull;
import org.dbflute.cbean.ckey.ConditionKeyLessThan;
import org.dbflute.cbean.ckey.ConditionKeyLessThanOrIsNull;
import org.dbflute.cbean.ckey.ConditionKeyLikeSearch;
import org.dbflute.cbean.ckey.ConditionKeyNotEqualStandard;
import org.dbflute.cbean.ckey.ConditionKeyNotEqualTradition;
import org.dbflute.cbean.ckey.ConditionKeyNotInScope;
import org.dbflute.cbean.ckey.ConditionKeyNotLikeSearch;
import org.dbflute.cbean.ckey.ConditionKeyPrepareResult;
import org.dbflute.cbean.coption.ConditionOption;
import org.dbflute.cbean.coption.RangeOfOption;
import org.dbflute.cbean.cvalue.ConditionValue;
import org.dbflute.cbean.dream.SpecifiedColumn;
import org.dbflute.cbean.sqlclause.query.QueryClause;
import org.dbflute.cbean.sqlclause.query.QueryClauseArranger;
import org.dbflute.cbean.sqlclause.query.StringQueryClause;
import org.dbflute.dbmeta.info.ColumnInfo;
import org.dbflute.dbmeta.name.ColumnRealName;
import org.dbflute.dbmeta.name.ColumnSqlName;
import org.dbflute.dbway.topic.ExtensionOperand;
import org.dbflute.dbway.topic.OnQueryStringConnector;
import org.dbflute.exception.IllegalConditionBeanOperationException;

public abstract class ConditionKey
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final ConditionKey CK_EQUAL = new ConditionKeyEqual();
    public static final ConditionKey CK_NOT_EQUAL_STANDARD = new ConditionKeyNotEqualStandard();
    public static final ConditionKey CK_NOT_EQUAL_TRADITION = new ConditionKeyNotEqualTradition();
    public static final ConditionKey CK_GREATER_THAN = new ConditionKeyGreaterThan();
    public static final ConditionKey CK_GREATER_THAN_OR_IS_NULL = new ConditionKeyGreaterThanOrIsNull();
    public static final ConditionKey CK_LESS_THAN = new ConditionKeyLessThan();
    public static final ConditionKey CK_LESS_THAN_OR_IS_NULL = new ConditionKeyLessThanOrIsNull();
    public static final ConditionKey CK_GREATER_EQUAL = new ConditionKeyGreaterEqual();
    public static final ConditionKey CK_GREATER_EQUAL_OR_IS_NULL = new ConditionKeyGreaterEqualOrIsNull();
    public static final ConditionKey CK_LESS_EQUAL = new ConditionKeyLessEqual();
    public static final ConditionKey CK_LESS_EQUAL_OR_IS_NULL = new ConditionKeyLessEqualOrIsNull();
    public static final ConditionKey CK_IN_SCOPE = new ConditionKeyInScope();
    public static final ConditionKey CK_NOT_IN_SCOPE = new ConditionKeyNotInScope();
    public static final ConditionKey CK_LIKE_SEARCH = new ConditionKeyLikeSearch();
    public static final ConditionKey CK_NOT_LIKE_SEARCH = new ConditionKeyNotLikeSearch();
    public static final ConditionKey CK_IS_NULL = new ConditionKeyIsNull();
    public static final ConditionKey CK_IS_NULL_OR_EMPTY = new ConditionKeyIsNullOrEmpty();
    public static final ConditionKey CK_IS_NOT_NULL = new ConditionKeyIsNotNull();
    protected static final Object DUMMY_OBJECT = new Object();
    protected static final ConditionKeyPrepareResult RESULT_NEW_QUERY = ConditionKeyPrepareResult.NEW_QUERY;
    protected static final ConditionKeyPrepareResult RESULT_INVALID_QUERY = ConditionKeyPrepareResult.INVALID_QUERY;
    protected static final ConditionKeyPrepareResult RESULT_OVERRIDING_QUERY = ConditionKeyPrepareResult.OVERRIDING_QUERY;
    protected static final ConditionKeyPrepareResult RESULT_DUPLICATE_QUERY = ConditionKeyPrepareResult.DUPLICATE_QUERY;
    protected String _conditionKey;
    protected String _operand;

    public ConditionKeyPrepareResult prepareQuery(final ConditionValue.QueryModeProvider provider, final ConditionValue cvalue, final Object value) {
        return cvalue.process(new ConditionValue.CallbackProcessor<ConditionKeyPrepareResult>(){

            @Override
            public ConditionKeyPrepareResult process() {
                return ConditionKey.this.doPrepareQuery(cvalue, value);
            }

            @Override
            public ConditionValue.QueryModeProvider getProvider() {
                return provider;
            }
        });
    }

    protected abstract ConditionKeyPrepareResult doPrepareQuery(ConditionValue var1, Object var2);

    protected ConditionKeyPrepareResult chooseResultAlreadyExists(boolean sameAsPrevious) {
        return sameAsPrevious ? RESULT_DUPLICATE_QUERY : RESULT_OVERRIDING_QUERY;
    }

    protected ConditionKeyPrepareResult chooseResultNonValue(ConditionValue cvalue) {
        return this.needsOverrideValue(cvalue) ? RESULT_DUPLICATE_QUERY : RESULT_NEW_QUERY;
    }

    protected ConditionKeyPrepareResult chooseResultNonFixedQuery(Object value) {
        return this.isInvalidNonFixedQuery(value) ? RESULT_INVALID_QUERY : RESULT_NEW_QUERY;
    }

    protected boolean isInvalidNonFixedQuery(Object value) {
        return value == null;
    }

    protected ConditionKeyPrepareResult chooseResultListQuery(Object value) {
        return this.isInvalidListQuery(value) ? RESULT_INVALID_QUERY : RESULT_NEW_QUERY;
    }

    protected boolean isInvalidListQuery(Object value) {
        return value == null || !(value instanceof List) || ((List)value).isEmpty();
    }

    protected abstract boolean needsOverrideValue(ConditionValue var1);

    public void addWhereClause(final ConditionValue.QueryModeProvider provider, final List<QueryClause> conditionList, final ColumnRealName columnRealName, final ConditionValue cvalue, final ColumnFunctionCipher cipher, final ConditionOption option) {
        cvalue.process(new ConditionValue.CallbackProcessor<Void>(){

            @Override
            public Void process() {
                ConditionKey.this.doAddWhereClause(conditionList, columnRealName, cvalue, cipher, option);
                return null;
            }

            @Override
            public ConditionValue.QueryModeProvider getProvider() {
                return provider;
            }
        });
    }

    protected abstract void doAddWhereClause(List<QueryClause> var1, ColumnRealName var2, ConditionValue var3, ColumnFunctionCipher var4, ConditionOption var5);

    public void setupConditionValue(final ConditionValue.QueryModeProvider provider, final ConditionValue cvalue, final Object value, final String location, final ConditionOption option) {
        cvalue.process(new ConditionValue.CallbackProcessor<Void>(){

            @Override
            public Void process() {
                ConditionKey.this.doSetupConditionValue(cvalue, value, location, option);
                return null;
            }

            @Override
            public ConditionValue.QueryModeProvider getProvider() {
                return provider;
            }
        });
    }

    protected abstract void doSetupConditionValue(ConditionValue var1, Object var2, String var3, ConditionOption var4);

    protected QueryClause buildBindClause(ColumnRealName columnRealName, String location, ColumnFunctionCipher cipher, ConditionOption option) {
        return new StringQueryClause(this.doBuildBindClause(columnRealName, location, cipher, option));
    }

    protected QueryClause buildBindClauseOrIsNull(ColumnRealName columnRealName, String location, ColumnFunctionCipher cipher, ConditionOption option) {
        String mainQuery = this.doBuildBindClause(columnRealName, location, cipher, option);
        String clause = "(" + mainQuery + " or " + columnRealName + " is null)";
        return new StringQueryClause(clause);
    }

    protected String doBuildBindClause(ColumnRealName columnRealName, String location, ColumnFunctionCipher cipher, ConditionOption option) {
        BindClauseResult result = this.resolveBindClause(columnRealName, location, cipher, option);
        return result.toBindClause();
    }

    protected QueryClause buildClauseWithoutValue(ColumnRealName columnRealName) {
        String clause = columnRealName + " " + this.getOperand();
        return new StringQueryClause(clause);
    }

    protected BindClauseResult resolveBindClause(ColumnRealName columnRealName, String location, ColumnFunctionCipher cipher, ConditionOption option) {
        ColumnRealName columnExp;
        String bindExp;
        String basicBindExp = this.buildBindVariableExp(location, option);
        if (cipher != null) {
            String decryptExp;
            String plainColumnExp = columnRealName.toString();
            boolean nonInvertible = plainColumnExp.equals(decryptExp = cipher.decrypt(plainColumnExp));
            if (this.isBindEncryptAllowed(columnRealName, option, nonInvertible)) {
                bindExp = cipher.encrypt(basicBindExp);
                columnExp = columnRealName;
            } else {
                bindExp = basicBindExp;
                columnExp = this.toColumnRealName(decryptExp);
            }
        } else {
            bindExp = basicBindExp;
            columnExp = columnRealName;
        }
        ColumnRealName resolvedColumn = this.resolveOptionalColumn(columnExp, option);
        return this.createBindClauseResult(resolvedColumn, bindExp, option);
    }

    protected boolean isBindEncryptAllowed(ColumnRealName columnRealName, ConditionOption option, boolean nonInvertible) {
        if (this.isOutOfBindEncryptConditionKey()) {
            return false;
        }
        if (nonInvertible) {
            return true;
        }
        boolean possible = this.isPossibleBindEncryptConditionKey();
        return possible && !this.hasColumnCollaboration(columnRealName, option);
    }

    protected String buildBindVariableExp(String location, ConditionOption option) {
        return "/*pmb." + location + "*/" + this.getBindVariableDummyValue();
    }

    protected String getBindVariableDummyValue() {
        return null;
    }

    protected boolean isOutOfBindEncryptConditionKey() {
        return false;
    }

    protected boolean isPossibleBindEncryptConditionKey() {
        return false;
    }

    protected ColumnRealName toColumnRealName(String columnSqlName) {
        return ColumnRealName.create(null, new ColumnSqlName(columnSqlName));
    }

    protected BindClauseResult createBindClauseResult(ColumnRealName columnExp, String bindExp, ConditionOption option) {
        String operand = this.resolveOperand(option);
        String rearOption = this.resolveRearOption(option);
        BindClauseResult result = new BindClauseResult(columnExp, operand, bindExp, rearOption);
        result.setArranger(this.resolveWhereClauseArranger(option));
        return result;
    }

    protected String resolveOperand(ConditionOption option) {
        String operand = this.extractExtOperand(option);
        return operand != null ? operand : this.getOperand();
    }

    protected String extractExtOperand(ConditionOption option) {
        ExtensionOperand extOperand = option != null ? option.getExtensionOperand() : null;
        return extOperand != null ? extOperand.operand() : null;
    }

    protected String resolveRearOption(ConditionOption option) {
        return option != null ? option.getRearOption() : "";
    }

    protected QueryClauseArranger resolveWhereClauseArranger(ConditionOption option) {
        return option != null ? option.getWhereClauseArranger() : null;
    }

    protected ColumnRealName resolveOptionalColumn(ColumnRealName columnExp, ConditionOption option) {
        return this.resolveCalculationColumn(this.resolveCompoundColumn(columnExp, option), option);
    }

    protected boolean hasColumnCollaboration(ColumnRealName columnRealName, ConditionOption option) {
        return this.hasCalculationColumn(columnRealName, option) || this.hasCompoundColumn(columnRealName, option);
    }

    protected boolean hasCalculationColumn(ColumnRealName columnRealName, ConditionOption option) {
        return option != null && option instanceof RangeOfOption && ((RangeOfOption)option).hasCalculationRange();
    }

    protected ColumnRealName resolveCalculationColumn(ColumnRealName columnRealName, ConditionOption option) {
        RangeOfOption rangeOfOption;
        if (option == null) {
            return columnRealName;
        }
        if (option instanceof RangeOfOption && (rangeOfOption = (RangeOfOption)option).hasCalculationRange()) {
            HpCalcSpecification<ConditionBean> calculationRange = rangeOfOption.getCalculationRange();
            String calculated = calculationRange.buildStatementToSpecifidName(columnRealName.toString());
            return this.toColumnRealName(calculated);
        }
        return columnRealName;
    }

    protected boolean hasCompoundColumn(ColumnRealName columnRealName, ConditionOption option) {
        return option != null && !option.hasCompoundColumn();
    }

    protected ColumnRealName resolveCompoundColumn(ColumnRealName baseRealName, ConditionOption option) {
        if (option == null || !option.hasCompoundColumn()) {
            return baseRealName;
        }
        if (!option.hasStringConnector()) {
            String msg = "The option should have string connector when compound column is specified: " + option;
            throw new IllegalConditionBeanOperationException(msg);
        }
        List<SpecifiedColumn> compoundColumnList = option.getCompoundColumnList();
        ArrayList<ColumnRealName> realNameList = new ArrayList<ColumnRealName>();
        realNameList.add(this.doResolveCompoundColumnOption(option, baseRealName));
        for (SpecifiedColumn specifiedColumn : compoundColumnList) {
            realNameList.add(this.doResolveCompoundColumnOption(option, this.doResolveCompoundColumnCipher(option, specifiedColumn)));
        }
        OnQueryStringConnector stringConnector = option.getStringConnector();
        String connected = stringConnector.connect(realNameList.toArray());
        return ColumnRealName.create(null, new ColumnSqlName(connected));
    }

    protected ColumnRealName doResolveCompoundColumnOption(ConditionOption option, ColumnRealName columnRealName) {
        if (option.isNullCompoundedAsEmpty()) {
            return this.toColumnRealName("coalesce(" + columnRealName + ",'')");
        }
        return columnRealName;
    }

    protected ColumnRealName doResolveCompoundColumnCipher(ConditionOption option, SpecifiedColumn specifiedColumn) {
        GearedCipherManager cipherManager = option.getGearedCipherManager();
        ColumnRealName specifiedName = specifiedColumn.toColumnRealName();
        if (cipherManager != null && !specifiedColumn.isDerived()) {
            ColumnInfo columnInfo = specifiedColumn.getColumnInfo();
            ColumnFunctionCipher cipher = cipherManager.findColumnFunctionCipher(columnInfo);
            if (cipher != null) {
                return this.toColumnRealName(cipher.decrypt(specifiedName.toString()));
            }
            return specifiedName;
        }
        return specifiedName;
    }

    public abstract boolean isNullaleKey();

    public String toString() {
        return "ConditionKey:{" + this.getConditionKey() + " " + this.getOperand() + "}";
    }

    public String getConditionKey() {
        return this._conditionKey;
    }

    public String getOperand() {
        return this._operand;
    }

    public static class BindClauseResult {
        protected final ColumnRealName _columnExp;
        protected final String _operand;
        protected final String _bindExp;
        protected final String _rearOption;
        protected QueryClauseArranger _arranger;

        public BindClauseResult(ColumnRealName columnExp, String operand, String bindExp, String rearOption) {
            this._columnExp = columnExp;
            this._operand = operand;
            this._bindExp = bindExp;
            this._rearOption = rearOption;
        }

        public String toBindClause() {
            String clause = this._arranger != null ? this._arranger.arrange(this._columnExp, this._operand, this._bindExp, this._rearOption) : this._columnExp + " " + this._operand + " " + this._bindExp + this._rearOption;
            return clause;
        }

        public ColumnRealName getColumnExp() {
            return this._columnExp;
        }

        public String getOperand() {
            return this._operand;
        }

        public String getBindExp() {
            return this._bindExp;
        }

        public String getRearOption() {
            return this._rearOption;
        }

        public QueryClauseArranger getArranger() {
            return this._arranger;
        }

        public void setArranger(QueryClauseArranger arranger) {
            this._arranger = arranger;
        }
    }
}

