/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.cbean.coption;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.dbflute.cbean.cipher.GearedCipherManager;
import org.dbflute.cbean.coption.SimpleStringOption;
import org.dbflute.cbean.dream.SpecifiedColumn;
import org.dbflute.cbean.sqlclause.query.QueryClauseArranger;
import org.dbflute.dbway.topic.ExtensionOperand;
import org.dbflute.dbway.topic.OnQueryStringConnector;
import org.dbflute.twowaysql.node.FilteringBindOption;
import org.dbflute.util.DfCollectionUtil;
import org.dbflute.util.DfTypeUtil;

public class LikeSearchOption
extends SimpleStringOption
implements FilteringBindOption {
    protected static final String LIKE_PREFIX = "prefix";
    protected static final String LIKE_SUFFIX = "suffix";
    protected static final String LIKE_CONTAIN = "contain";
    protected String _like;
    protected String _escape;
    protected boolean _asOrSplit;
    protected List<SpecifiedColumn> _compoundColumnList;
    protected List<Integer> _compoundColumnSizeList;
    protected boolean _nullCompoundedAsEmpty;
    protected OnQueryStringConnector _stringConnector;
    protected List<String> _originalWildCardList;
    protected ExtensionOperand _extensionOperand;
    protected QueryClauseArranger _whereClauseArranger;
    protected GearedCipherManager _cipherManager;

    @Override
    public String getRearOption() {
        if (this._escape == null || this._escape.trim().length() == 0) {
            return "";
        }
        return " escape '" + this._escape + "'";
    }

    public LikeSearchOption likePrefix() {
        this._like = LIKE_PREFIX;
        this.doLikeAutoEscape();
        return this;
    }

    public LikeSearchOption likeSuffix() {
        this._like = LIKE_SUFFIX;
        this.doLikeAutoEscape();
        return this;
    }

    public LikeSearchOption likeContain() {
        this._like = LIKE_CONTAIN;
        this.doLikeAutoEscape();
        return this;
    }

    protected void doLikeAutoEscape() {
        this.escape();
    }

    public boolean isLikePrefix() {
        return LIKE_PREFIX.equals(this._like);
    }

    public boolean isLikeSuffix() {
        return LIKE_SUFFIX.equals(this._like);
    }

    public boolean isLikeContain() {
        return LIKE_CONTAIN.equals(this._like);
    }

    public LikeSearchOption escape() {
        return this.escapeByPipeLine();
    }

    public LikeSearchOption escapeByPipeLine() {
        this._escape = "|";
        return this;
    }

    public LikeSearchOption escapeByAtMark() {
        this._escape = "@";
        return this;
    }

    public LikeSearchOption escapeBySlash() {
        this._escape = "/";
        return this;
    }

    public LikeSearchOption escapeByBackSlash() {
        this._escape = "\\";
        return this;
    }

    public LikeSearchOption notEscape() {
        this._escape = null;
        return this;
    }

    public LikeSearchOption splitByBlank() {
        this.assertSplitByPrecondition();
        return (LikeSearchOption)this.doSplitByBlank();
    }

    public LikeSearchOption splitBySpace() {
        this.assertSplitByPrecondition();
        return (LikeSearchOption)this.doSplitBySpace();
    }

    public LikeSearchOption splitBySpaceContainsDoubleByte() {
        this.assertSplitByPrecondition();
        return (LikeSearchOption)this.doSplitBySpaceContainsDoubleByte();
    }

    public LikeSearchOption splitByPipeLine() {
        this.assertSplitByPrecondition();
        return (LikeSearchOption)this.doSplitByPipeLine();
    }

    public LikeSearchOption splitByVarious(List<String> delimiterList) {
        this.assertSplitByPrecondition();
        return (LikeSearchOption)this.doSplitByVarious(delimiterList);
    }

    protected void assertSplitByPrecondition() {
        if (this.hasCompoundColumn()) {
            String msg = "The Split of LikeSearch is unsupported with CompoundColumn.";
            throw new IllegalStateException(msg);
        }
    }

    public LikeSearchOption asOrSplit() {
        this._asOrSplit = true;
        return this;
    }

    public boolean isAsOrSplit() {
        return this._asOrSplit;
    }

    public LikeSearchOption cutSplit(int splitLimitCount) {
        this.doCutSplit(splitLimitCount);
        return this;
    }

    public LikeSearchOption addCompoundColumn(SpecifiedColumn compoundColumn) {
        this.assertCompoundColumnPrecondition(compoundColumn);
        this.assertCompoundColumnSpecifiedColumn(compoundColumn);
        if (this._compoundColumnList == null) {
            this._compoundColumnList = new ArrayList<SpecifiedColumn>();
        }
        this._compoundColumnList.add(compoundColumn);
        return this;
    }

    protected void assertCompoundColumnPrecondition(SpecifiedColumn compoundColumn) {
        if (this.isSplit()) {
            String msg = "The CompoundColumn of LikeSearch is unsupported with Split: " + compoundColumn;
            throw new IllegalStateException(msg);
        }
    }

    protected void assertCompoundColumnSpecifiedColumn(SpecifiedColumn compoundColumn) {
        if (compoundColumn == null) {
            String msg = "The argument 'compoundColumn' should not be null.";
            throw new IllegalArgumentException(msg);
        }
        if (!compoundColumn.getColumnInfo().isObjectNativeTypeString()) {
            String msg = "The type of the compound column should be String: " + compoundColumn;
            throw new IllegalArgumentException(msg);
        }
    }

    @Override
    public boolean hasCompoundColumn() {
        return this._compoundColumnList != null && !this._compoundColumnList.isEmpty();
    }

    @Override
    public List<SpecifiedColumn> getCompoundColumnList() {
        return this._compoundColumnList != null ? Collections.unmodifiableList(this._compoundColumnList) : DfCollectionUtil.emptyList();
    }

    public LikeSearchOption compoundsNullAsEmpty() {
        this._nullCompoundedAsEmpty = true;
        return this;
    }

    @Override
    public boolean isNullCompoundedAsEmpty() {
        return this._nullCompoundedAsEmpty;
    }

    public void clearCompoundColumn() {
        if (this._compoundColumnList != null) {
            this._compoundColumnList.clear();
        }
        if (this._compoundColumnSizeList != null) {
            this._compoundColumnSizeList.clear();
        }
    }

    public LikeSearchOption optimizeCompoundColumnByFixedSize(Integer ... sizes) {
        if (!this.hasCompoundColumn()) {
            String msg = "The CompoundColumnOptimization needs CompoundColumn.";
            throw new IllegalStateException(msg);
        }
        if (sizes.length > this._compoundColumnList.size() + 1) {
            String msg = "The length of argument 'sizes' should be less or equal count of compound columns + 1.";
            msg = msg + " sizes.length=" + sizes.length;
            msg = msg + " compoundColumnList.size()=" + this._compoundColumnList.size();
            throw new IllegalArgumentException(msg);
        }
        this._compoundColumnSizeList = Arrays.asList(sizes);
        return this;
    }

    public boolean canOptimizeCompoundColumnLikePrefix() {
        return this.hasCompoundColumn() && this.hasCompoundColumnOptimization() && this.isLikePrefix();
    }

    public boolean hasCompoundColumnOptimization() {
        return this._compoundColumnSizeList != null && !this._compoundColumnSizeList.isEmpty();
    }

    public List<Integer> getCompoundColumnSizeList() {
        return this._compoundColumnSizeList != null ? Collections.unmodifiableList(this._compoundColumnSizeList) : DfCollectionUtil.emptyList();
    }

    @Override
    public LikeSearchOption acceptStringConnector(OnQueryStringConnector stringConnector) {
        this._stringConnector = stringConnector;
        return this;
    }

    @Override
    public boolean hasStringConnector() {
        return this._stringConnector != null;
    }

    @Override
    public OnQueryStringConnector getStringConnector() {
        return this._stringConnector;
    }

    public LikeSearchOption acceptOriginalWildCardList(List<String> originalWildCardList) {
        this._originalWildCardList = originalWildCardList;
        return this;
    }

    public List<String> getOriginalWildCardList() {
        return this._originalWildCardList != null ? Collections.unmodifiableList(this._originalWildCardList) : DfCollectionUtil.emptyList();
    }

    public LikeSearchOption acceptExtensionOperand(ExtensionOperand extensionOperand) {
        this._extensionOperand = extensionOperand;
        return this;
    }

    @Override
    public ExtensionOperand getExtensionOperand() {
        return this._extensionOperand;
    }

    public LikeSearchOption acceptWhereClauseArranger(QueryClauseArranger whereClauseArranger) {
        this._whereClauseArranger = whereClauseArranger;
        return this;
    }

    @Override
    public QueryClauseArranger getWhereClauseArranger() {
        return this._whereClauseArranger;
    }

    public LikeSearchOption acceptGearedCipherManager(GearedCipherManager cipherManager) {
        this._cipherManager = cipherManager;
        return this;
    }

    @Override
    public GearedCipherManager getGearedCipherManager() {
        return this._cipherManager;
    }

    @Override
    public String generateRealValue(String value) {
        value = super.generateRealValue(value);
        if (this._escape != null && this._escape.trim().length() != 0) {
            String tmp = this.replace(value, this._escape, this._escape + this._escape);
            tmp = this.filterEscape(tmp, "%");
            tmp = this.filterEscape(tmp, "_");
            if (this._originalWildCardList != null) {
                for (String wildCard : this._originalWildCardList) {
                    tmp = this.filterEscape(tmp, wildCard);
                }
            }
            value = tmp;
        }
        String wildCard = "%";
        if (this._like == null || this._like.trim().length() == 0) {
            return value;
        }
        if (this._like.equals(LIKE_PREFIX)) {
            return value + "%";
        }
        if (this._like.equals(LIKE_SUFFIX)) {
            return "%" + value;
        }
        if (this._like.equals(LIKE_CONTAIN)) {
            return "%" + value + "%";
        }
        String msg = "The like was wrong string: " + this._like;
        throw new IllegalStateException(msg);
    }

    protected String filterEscape(String target, String wildCard) {
        return this.replace(target, wildCard, this._escape + wildCard);
    }

    @Override
    public LikeSearchOption createDeepCopy() {
        LikeSearchOption copy = (LikeSearchOption)super.createDeepCopy();
        copy._like = this._like;
        copy._escape = this._escape;
        copy._asOrSplit = this._asOrSplit;
        if (this._compoundColumnList != null) {
            copy._compoundColumnList = new ArrayList<SpecifiedColumn>(this._compoundColumnList);
        }
        if (this._compoundColumnSizeList != null) {
            copy._compoundColumnSizeList = new ArrayList<Integer>(this._compoundColumnSizeList);
        }
        copy._stringConnector = this._stringConnector;
        copy._originalWildCardList = this._originalWildCardList != null ? new ArrayList<String>(this._originalWildCardList) : null;
        copy._extensionOperand = this._extensionOperand;
        copy._whereClauseArranger = this._whereClauseArranger;
        copy._cipherManager = this._cipherManager;
        return copy;
    }

    @Override
    protected LikeSearchOption newDeepCopyInstance() {
        return new LikeSearchOption();
    }

    public String toString() {
        String title = DfTypeUtil.toClassTitle(this);
        String split = this.isSplit() ? (this._asOrSplit ? "true(or)" : "true(and)") : "false";
        return title + ":{like=" + this._like + ", escape=" + this._escape + ", split=" + split + "}";
    }
}

