/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.cbean.garnish;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.dbflute.cbean.ConditionBean;
import org.dbflute.cbean.garnish.logger.SpecifyColumnRequiredWLog;
import org.dbflute.cbean.sqlclause.SqlClause;
import org.dbflute.cbean.sqlclause.select.SelectedRelationColumn;
import org.dbflute.exception.RequiredSpecifyColumnNotFoundException;

public class SpecifyColumnRequiredChecker {
    protected boolean _warningOnly;

    public SpecifyColumnRequiredChecker warningOnly() {
        this._warningOnly = true;
        return this;
    }

    public void checkSpecifyColumnRequiredIfNeeds(ConditionBean cb, Consumer<Set<String>> thrower) {
        SqlClause sqlClause = cb.getSqlClause();
        LinkedHashSet<String> nonSpecifiedAliasSet = new LinkedHashSet<String>();
        this.doCheckBasePointTable(cb, sqlClause, nonSpecifiedAliasSet);
        this.doCheckRelationTable(sqlClause, nonSpecifiedAliasSet);
        if (!nonSpecifiedAliasSet.isEmpty()) {
            this.handleNonSpecified(thrower, nonSpecifiedAliasSet);
        }
    }

    protected void doCheckBasePointTable(ConditionBean cb, SqlClause sqlClause, Set<String> nonSpecifiedAliasSet) {
        String basePointAliasName = sqlClause.getBasePointAliasName();
        if (!sqlClause.hasSpecifiedSelectColumn(basePointAliasName)) {
            nonSpecifiedAliasSet.add(cb.asDBMeta().getTableDispName() + " (" + basePointAliasName + ")");
        }
    }

    protected void doCheckRelationTable(SqlClause sqlClause, Set<String> nonSpecifiedAliasSet) {
        for (Map.Entry<String, Map<String, SelectedRelationColumn>> entry : sqlClause.getSelectedRelationColumnMap().entrySet()) {
            String dispName;
            String tableAliasName = entry.getKey();
            if (sqlClause.hasSpecifiedSelectColumn(tableAliasName)) continue;
            Collection<SelectedRelationColumn> values = entry.getValue().values();
            if (!values.isEmpty()) {
                SelectedRelationColumn firstColumn = values.iterator().next();
                dispName = sqlClause.translateSelectedRelationPathToPropName(firstColumn.getRelationNoSuffix());
            } else {
                dispName = "*no name";
            }
            nonSpecifiedAliasSet.add(dispName + " (" + tableAliasName + ")");
        }
    }

    protected void handleNonSpecified(Consumer<Set<String>> thrower, Set<String> nonSpecifiedAliasSet) {
        try {
            this.evaluateThrower(thrower, nonSpecifiedAliasSet);
        }
        catch (RequiredSpecifyColumnNotFoundException e) {
            if (this._warningOnly) {
                this.warnNonSpecified(e);
            }
            throw e;
        }
    }

    protected void evaluateThrower(Consumer<Set<String>> thrower, Set<String> nonSpecifiedAliasSet) {
        thrower.accept(nonSpecifiedAliasSet);
    }

    protected void warnNonSpecified(RequiredSpecifyColumnNotFoundException e) {
        SpecifyColumnRequiredWLog.log("*Found the violation of SpecifyColumnRequired", e);
    }
}

