/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.cbean.garnish.invoking;

import java.lang.reflect.Method;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.dbflute.cbean.ConditionQuery;
import org.dbflute.cbean.coption.ConditionOption;
import org.dbflute.cbean.coption.FromToOption;
import org.dbflute.cbean.coption.LikeSearchOption;
import org.dbflute.cbean.coption.RangeOfOption;
import org.dbflute.cbean.cvalue.ConditionValue;
import org.dbflute.dbmeta.DBMeta;
import org.dbflute.dbmeta.DBMetaProvider;
import org.dbflute.dbmeta.info.ColumnInfo;
import org.dbflute.exception.ConditionInvokingFailureException;
import org.dbflute.exception.IllegalConditionBeanOperationException;
import org.dbflute.helper.beans.DfBeanDesc;
import org.dbflute.helper.beans.factory.DfBeanDescFactory;
import org.dbflute.helper.message.ExceptionMessageBuilder;
import org.dbflute.util.DfCollectionUtil;
import org.dbflute.util.DfReflectionUtil;
import org.dbflute.util.DfTypeUtil;
import org.dbflute.util.Srl;

public class InvokingQueryAgent {
    protected final ConditionQuery _rootQuery;
    protected final DBMetaProvider _dbmetaProvider;

    public InvokingQueryAgent(ConditionQuery rootQuery, DBMetaProvider dbmetaProvider) {
        this._rootQuery = rootQuery;
        this._dbmetaProvider = dbmetaProvider;
    }

    public ConditionValue invokeValue(DBMeta dbmeta, String columnFlexibleName) {
        this.assertStringNotNullAndNotTrimmedEmpty("columnFlexibleName", columnFlexibleName);
        String columnCapPropName = Srl.initCap(dbmeta.findColumnInfo(columnFlexibleName).getPropertyName());
        String methodName = "xdfget" + columnCapPropName;
        Method method = this.searchSimpleCQMethod(this._rootQuery, methodName, null);
        if (method == null) {
            this.throwConditionInvokingGetMethodNotFoundException(columnFlexibleName, methodName);
            return null;
        }
        try {
            return (ConditionValue)this.xhelpInvokingCQMethod(this._rootQuery, method, null);
        }
        catch (DfReflectionUtil.ReflectionFailureException e) {
            this.throwConditionInvokingGetReflectionFailureException(columnFlexibleName, methodName, e);
            return null;
        }
    }

    protected void throwConditionInvokingGetMethodNotFoundException(String columnFlexibleName, String methodName) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Not found the method for getting the condition.");
        br.addItem("columnFlexibleName");
        br.addElement(columnFlexibleName);
        br.addItem("methodName");
        br.addElement(methodName);
        String msg = br.buildExceptionMessage();
        throw new ConditionInvokingFailureException(msg);
    }

    protected void throwConditionInvokingGetReflectionFailureException(String columnFlexibleName, String methodName, DfReflectionUtil.ReflectionFailureException e) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Failed to invoke the method for getting value.");
        br.addItem("columnFlexibleName");
        br.addElement(columnFlexibleName);
        br.addItem("methodName");
        br.addElement(methodName);
        String msg = br.buildExceptionMessage();
        throw new ConditionInvokingFailureException(msg, e);
    }

    public void invokeQuery(String colName, String ckey, Object value, ConditionOption option) {
        ColumnInfo columnInfo;
        this.assertStringNotNullAndNotTrimmedEmpty("columnFlexibleName", colName);
        this.assertStringNotNullAndNotTrimmedEmpty("conditionKeyName", ckey);
        boolean noArg = Srl.equalsIgnoreCase(ckey, "IsNull", "IsNotNull", "IsNullOrEmpty", "EmptyString");
        if (!noArg && (value == null || "".equals(value))) {
            if (this._rootQuery.xgetSqlClause().isNullOrEmptyQueryChecked()) {
                String msg = "The conditionValue is required but null or empty: column=" + colName + " value=" + value;
                throw new IllegalConditionBeanOperationException(msg);
            }
            return;
        }
        PropertyNameCQContainer container = this.xhelpExtractingPropertyNameCQContainer(colName);
        String flexibleName = container.getFlexibleName();
        ConditionQuery declaringCQ = container.getConditionQuery();
        DBMeta dbmeta = this._dbmetaProvider.provideDBMetaChecked(declaringCQ.asTableDbName());
        try {
            columnInfo = dbmeta.findColumnInfo(flexibleName);
        }
        catch (RuntimeException e) {
            this.throwConditionInvokingColumnFindFailureException(colName, ckey, value, option, e);
            return;
        }
        String columnCapPropName = Srl.initCap(columnInfo.getPropertyName());
        boolean rangeOf = Srl.equalsIgnoreCase(ckey, "RangeOf");
        boolean fromTo = Srl.equalsIgnoreCase(ckey, "FromTo", "DateFromTo");
        boolean inScope = Srl.equalsIgnoreCase(ckey, "InScope");
        if (!noArg) {
            try {
                value = columnInfo.convertToObjectNativeType(value);
            }
            catch (RuntimeException e) {
                this.throwConditionInvokingValueConvertFailureException(colName, ckey, value, option, e);
            }
        }
        String methodName = this.xbuildQuerySetMethodName(ckey, columnCapPropName);
        ArrayList typeList = this.newArrayListSized(4);
        Class<?> propertyType = columnInfo.getObjectNativeType();
        if (fromTo) {
            if (LocalDate.class.isAssignableFrom(propertyType)) {
                typeList.add(propertyType);
                typeList.add(propertyType);
            } else if (LocalDateTime.class.isAssignableFrom(propertyType)) {
                typeList.add(propertyType);
                typeList.add(propertyType);
            } else {
                typeList.add(Date.class);
                typeList.add(Date.class);
            }
        } else if (rangeOf) {
            typeList.add(propertyType);
            typeList.add(propertyType);
        } else if (!noArg) {
            Class<?> instanceType = value.getClass();
            if (inScope && Collection.class.isAssignableFrom(instanceType)) {
                typeList.add(Collection.class);
            } else {
                typeList.add(instanceType);
            }
        }
        if (option != null) {
            typeList.add(option.getClass());
        }
        ArrayList filteredTypeList = this.newArrayListSized(typeList.size());
        for (Class parameterType : typeList) {
            filteredTypeList.add(this.xfilterInvokeQueryParameterType(colName, ckey, parameterType));
        }
        Class[] argTypes = filteredTypeList.toArray(new Class[filteredTypeList.size()]);
        Method method = this.searchQuerySetMethod(declaringCQ, methodName, argTypes, option);
        if (method == null) {
            this.throwConditionInvokingSetMethodNotFoundException(colName, ckey, value, option, methodName, argTypes);
        }
        try {
            ArrayList argList = this.newArrayList();
            if (fromTo || rangeOf) {
                if (!(value instanceof List)) {
                    this.throwConditionInvokingDateFromToValueInvalidException(colName, ckey, value, option, methodName, argTypes);
                }
                argList.addAll((List)value);
            } else if (!noArg) {
                argList.add(value);
            }
            if (option != null) {
                argList.add(option);
            }
            ArrayList filteredArgList = this.newArrayListSized(argList.size());
            for (Object arg : argList) {
                filteredArgList.add(this.xfilterInvokeQueryParameterValue(colName, ckey, arg));
            }
            this.xhelpInvokingCQMethod(declaringCQ, method, filteredArgList.toArray());
        }
        catch (DfReflectionUtil.ReflectionFailureException e) {
            this.throwConditionInvokingSetReflectionFailureException(colName, ckey, value, option, methodName, argTypes, e);
        }
    }

    protected String xbuildQuerySetMethodName(String ckey, String columnCapPropName) {
        return "set" + columnCapPropName + "_" + Srl.initCap(ckey);
    }

    protected Class<?> xfilterInvokeQueryParameterType(String colName, String ckey, Class<?> parameterType) {
        return parameterType;
    }

    protected Method searchQuerySetMethod(ConditionQuery declaringCQ, String methodName, Class<?>[] argTypes, ConditionOption option) {
        Method found = this.findCQPublicMethod(declaringCQ, methodName, argTypes);
        if (found != null) {
            return found;
        }
        if (option != null) {
            Class<?>[] retryArgType = null;
            if (this.isLastArgConditionOptionExtended(LikeSearchOption.class, argTypes)) {
                retryArgType = this.deriveRetryArgType(argTypes, LikeSearchOption.class);
            } else if (this.isLastArgConditionOptionExtended(RangeOfOption.class, argTypes)) {
                retryArgType = this.deriveRetryArgType(argTypes, RangeOfOption.class);
            } else if (this.isLastArgConditionOptionExtended(FromToOption.class, argTypes)) {
                retryArgType = this.deriveRetryArgType(argTypes, FromToOption.class);
            }
            if (retryArgType != null && (found = this.findCQWholeMethod(declaringCQ, methodName, retryArgType)) != null) {
                return found;
            }
        }
        return this.findCQWholeMethod(declaringCQ, methodName, argTypes);
    }

    protected boolean isLastArgConditionOptionExtended(Class<?> pureOptionType, Class<?>[] argTypes) {
        if (argTypes.length == 0) {
            return false;
        }
        Class<?> lastType = argTypes[argTypes.length - 1];
        return pureOptionType.isAssignableFrom(lastType) && !pureOptionType.equals(lastType);
    }

    protected Class<?>[] deriveRetryArgType(Class<?>[] argTypes, Class<?> pureOptionType) {
        Class[] retryArgTypes = new Class[argTypes.length];
        int index = 0;
        for (Class<?> argType : argTypes) {
            retryArgTypes[index] = index == argTypes.length - 1 ? pureOptionType : argType;
            ++index;
        }
        return retryArgTypes;
    }

    protected Object xfilterInvokeQueryParameterValue(String colName, String ckey, Object parameterValue) {
        return parameterValue;
    }

    protected void throwConditionInvokingColumnFindFailureException(String columnFlexibleName, String conditionKeyName, Object conditionValue, ConditionOption conditionOption, RuntimeException cause) {
        String notice = "Failed to find the column in the table.";
        this.doThrowConditionInvokingFailureException("Failed to find the column in the table.", columnFlexibleName, conditionKeyName, conditionValue, conditionOption, null, null, cause);
    }

    protected void throwConditionInvokingValueConvertFailureException(String columnFlexibleName, String conditionKeyName, Object conditionValue, ConditionOption conditionOption, RuntimeException cause) {
        String notice = "Failed to convert the value to property type.";
        this.doThrowConditionInvokingFailureException("Failed to convert the value to property type.", columnFlexibleName, conditionKeyName, conditionValue, conditionOption, null, null, cause);
    }

    protected void throwConditionInvokingSetMethodNotFoundException(String columnFlexibleName, String conditionKeyName, Object conditionValue, ConditionOption conditionOption, String methodName, Class<?>[] argTypes) {
        String notice = "Not found the method for setting the condition.";
        this.doThrowConditionInvokingFailureException("Not found the method for setting the condition.", columnFlexibleName, conditionKeyName, conditionValue, conditionOption, methodName, argTypes, null);
    }

    protected void throwConditionInvokingDateFromToValueInvalidException(String columnFlexibleName, String conditionKeyName, Object conditionValue, ConditionOption conditionOption, String methodName, Class<?>[] argTypes) {
        String notice = "The conditionValue should be List that has 2 elements, fromDate and toDate.";
        this.doThrowConditionInvokingFailureException("The conditionValue should be List that has 2 elements, fromDate and toDate.", columnFlexibleName, conditionKeyName, conditionValue, conditionOption, methodName, argTypes, null);
    }

    protected void throwConditionInvokingSetReflectionFailureException(String columnFlexibleName, String conditionKeyName, Object conditionValue, ConditionOption conditionOption, String methodName, Class<?>[] argTypes, DfReflectionUtil.ReflectionFailureException cause) {
        String notice = "Failed to invoke the method for setting the condition.";
        this.doThrowConditionInvokingFailureException("Failed to invoke the method for setting the condition.", columnFlexibleName, conditionKeyName, conditionValue, conditionOption, methodName, argTypes, cause);
    }

    protected void doThrowConditionInvokingFailureException(String notice, String columnFlexibleName, String conditionKeyName, Object conditionValue, ConditionOption conditionOption, String methodName, Class<?>[] argTypes, RuntimeException cause) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice(notice);
        br.addItem("Table");
        br.addElement(this._rootQuery.asTableDbName());
        br.addItem("columnFlexibleName");
        br.addElement(columnFlexibleName);
        br.addItem("conditionKeyName");
        br.addElement(conditionKeyName);
        br.addItem("conditionValue");
        br.addElement(conditionValue);
        br.addElement(conditionValue != null ? conditionValue.getClass() : null);
        br.addItem("conditionOption");
        br.addElement(conditionOption);
        if (methodName != null) {
            StringBuilder sb = new StringBuilder();
            if (argTypes != null) {
                int index = 0;
                for (Class<?> argType : argTypes) {
                    if (index > 0) {
                        sb.append(", ");
                    }
                    sb.append(DfTypeUtil.toClassTitle(argType));
                    ++index;
                }
            }
            br.addItem("Method");
            br.addElement(methodName + "(" + sb.toString() + ")");
        }
        String msg = br.buildExceptionMessage();
        if (cause != null) {
            throw new ConditionInvokingFailureException(msg, cause);
        }
        throw new ConditionInvokingFailureException(msg);
    }

    public void invokeOrderBy(String columnFlexibleName, boolean isAsc) {
        this.assertStringNotNullAndNotTrimmedEmpty("columnFlexibleName", columnFlexibleName);
        PropertyNameCQContainer container = this.xhelpExtractingPropertyNameCQContainer(columnFlexibleName);
        String flexibleName = container.getFlexibleName();
        ConditionQuery cq = container.getConditionQuery();
        String ascDesc = isAsc ? "Asc" : "Desc";
        DBMeta dbmeta = this._dbmetaProvider.provideDBMetaChecked(cq.asTableDbName());
        String columnCapPropName = Srl.initCap(dbmeta.findColumnInfo(flexibleName).getPropertyName());
        String methodName = "addOrderBy_" + columnCapPropName + "_" + ascDesc;
        Method method = this.searchSimpleCQMethod(cq, methodName, null);
        if (method == null) {
            this.throwConditionInvokingOrderMethodNotFoundException(columnFlexibleName, isAsc, methodName);
        }
        try {
            this.xhelpInvokingCQMethod(cq, method, null);
        }
        catch (DfReflectionUtil.ReflectionFailureException e) {
            this.throwConditionInvokingOrderReflectionFailureException(columnFlexibleName, isAsc, methodName, e);
        }
    }

    protected void throwConditionInvokingOrderMethodNotFoundException(String columnFlexibleName, boolean isAsc, String methodName) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Not found the method for adding the order-by condition.");
        br.addItem("Table");
        br.addElement(this._rootQuery.asTableDbName());
        br.addItem("columnFlexibleName");
        br.addElement(columnFlexibleName);
        br.addItem("isAsc");
        br.addElement(isAsc);
        br.addItem("Method");
        br.addElement(methodName);
        String msg = br.buildExceptionMessage();
        throw new ConditionInvokingFailureException(msg);
    }

    protected void throwConditionInvokingOrderReflectionFailureException(String columnFlexibleName, boolean isAsc, String methodName, DfReflectionUtil.ReflectionFailureException cause) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Failed to invoke the method for setting the order-by condition.");
        br.addItem("Table");
        br.addElement(this._rootQuery.asTableDbName());
        br.addItem("columnFlexibleName");
        br.addElement(columnFlexibleName);
        br.addItem("isAsc");
        br.addElement(isAsc);
        br.addItem("Method");
        br.addElement(methodName);
        String msg = br.buildExceptionMessage();
        throw new ConditionInvokingFailureException(msg, cause);
    }

    public ConditionQuery invokeForeignCQ(String foreignPropertyName) {
        this.assertStringNotNullAndNotTrimmedEmpty("foreignPropertyName", foreignPropertyName);
        List<String> traceList = Srl.splitList(foreignPropertyName, ".");
        ConditionQuery foreignCQ = this._rootQuery;
        for (String trace : traceList) {
            foreignCQ = this.doInvokeForeignCQ(foreignCQ, trace);
        }
        return foreignCQ;
    }

    protected ConditionQuery doInvokeForeignCQ(ConditionQuery foreignCQ, String foreignPropertyName) {
        this.assertStringNotNullAndNotTrimmedEmpty("foreignPropertyName", foreignPropertyName);
        String methodName = "query" + Srl.initCap(foreignPropertyName);
        Method method = this.searchSimpleCQMethod(foreignCQ, methodName, null);
        if (method == null) {
            this.throwConditionInvokingForeignQueryMethodNotFoundException(foreignCQ, foreignPropertyName, methodName);
            return null;
        }
        try {
            return (ConditionQuery)this.xhelpInvokingCQMethod(foreignCQ, method, null);
        }
        catch (DfReflectionUtil.ReflectionFailureException e) {
            this.throwConditionInvokingForeignQueryReflectionFailureException(foreignCQ, foreignPropertyName, methodName, e);
            return null;
        }
    }

    protected void throwConditionInvokingForeignQueryMethodNotFoundException(ConditionQuery foreignCQ, String foreignPropertyName, String methodName) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Not found the method for getting a foreign condition query.");
        br.addItem("Table");
        br.addElement(this._rootQuery.asTableDbName());
        br.addItem("foreignPropertyName");
        br.addElement(foreignPropertyName);
        br.addItem("Method");
        br.addElement(methodName);
        String msg = br.buildExceptionMessage();
        throw new ConditionInvokingFailureException(msg);
    }

    protected void throwConditionInvokingForeignQueryReflectionFailureException(ConditionQuery foreignCQ, String foreignPropertyName, String methodName, DfReflectionUtil.ReflectionFailureException cause) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Failed to invoke the method for setting a condition(query).");
        br.addItem("Table");
        br.addElement(this._rootQuery.asTableDbName());
        br.addItem("foreignPropertyName");
        br.addElement(foreignPropertyName);
        br.addItem("Method");
        br.addElement(methodName);
        String msg = br.buildExceptionMessage();
        throw new ConditionInvokingFailureException(msg, cause);
    }

    public boolean invokeHasForeignCQ(String foreignPropertyName) {
        this.assertStringNotNullAndNotTrimmedEmpty("foreignPropertyName", foreignPropertyName);
        List<String> traceList = Srl.splitList(foreignPropertyName, ".");
        ConditionQuery foreignCQ = this._rootQuery;
        int splitLength = traceList.size();
        int index = 0;
        for (String traceName : traceList) {
            if (!this.doInvokeHasForeignCQ(foreignCQ, traceName)) {
                return false;
            }
            if (index + 1 < splitLength) {
                foreignCQ = foreignCQ.invokeForeignCQ(traceName);
            }
            ++index;
        }
        return true;
    }

    protected boolean doInvokeHasForeignCQ(ConditionQuery foreignCQ, String foreignPropertyName) {
        this.assertStringNotNullAndNotTrimmedEmpty("foreignPropertyName", foreignPropertyName);
        String methodName = "hasConditionQuery" + Srl.initCap(foreignPropertyName);
        Method method = this.searchSimpleCQMethod(foreignCQ, methodName, null);
        if (method == null) {
            ExceptionMessageBuilder br = new ExceptionMessageBuilder();
            br.addNotice("Not found the method for determining a foreign condition query.");
            br.addItem("Table");
            br.addElement(this._rootQuery.asTableDbName());
            br.addItem("foreignPropertyName");
            br.addElement(foreignPropertyName);
            br.addItem("methodName");
            br.addElement(methodName);
            br.addItem("ConditionQuery");
            br.addElement(DfTypeUtil.toClassTitle(foreignCQ));
            String msg = br.buildExceptionMessage();
            throw new ConditionInvokingFailureException(msg);
        }
        try {
            return (Boolean)this.xhelpInvokingCQMethod(foreignCQ, method, null);
        }
        catch (DfReflectionUtil.ReflectionFailureException e) {
            String msg = "Failed to invoke the method for determining a condition(query):";
            msg = msg + " foreignPropertyName=" + foreignPropertyName;
            msg = msg + " methodName=" + methodName + " table=" + this._rootQuery.asTableDbName();
            throw new ConditionInvokingFailureException(msg, e);
        }
    }

    protected PropertyNameCQContainer xhelpExtractingPropertyNameCQContainer(String chainedColumnName) {
        String[] strings = chainedColumnName.split("\\.");
        int length = strings.length;
        String propertyName = null;
        ConditionQuery cq = this._rootQuery;
        int index = 0;
        for (String element : strings) {
            if (length == index + 1) {
                propertyName = element;
                break;
            }
            cq = cq.invokeForeignCQ(element);
            ++index;
        }
        return new PropertyNameCQContainer(propertyName, cq);
    }

    protected Method searchSimpleCQMethod(ConditionQuery declaringCQ, String methodName, Class<?>[] argTypes) {
        Method found = this.findCQPublicMethod(declaringCQ, methodName, argTypes);
        if (found != null) {
            return found;
        }
        return this.findCQWholeMethod(declaringCQ, methodName, argTypes);
    }

    protected Method findCQPublicMethod(ConditionQuery declaringCQ, String methodName, Class<?>[] argTypes) {
        Class<?> cqType = declaringCQ.getClass();
        DfBeanDesc beanDesc = DfBeanDescFactory.getBeanDesc(cqType);
        return beanDesc.getMethodNoException(methodName, argTypes);
    }

    protected Method findCQWholeMethod(ConditionQuery declaringCQ, String methodName, Class<?>[] argTypes) {
        return DfReflectionUtil.getWholeMethod(declaringCQ.getClass(), methodName, argTypes);
    }

    protected Object xhelpInvokingCQMethod(ConditionQuery cq, Method method, Object[] args) {
        return DfReflectionUtil.invokeForcedly(method, cq, args);
    }

    protected <ELEMENT> ArrayList<ELEMENT> newArrayList() {
        return DfCollectionUtil.newArrayList();
    }

    protected <ELEMENT> ArrayList<ELEMENT> newArrayListSized(int size) {
        return DfCollectionUtil.newArrayListSized(size);
    }

    protected void assertObjectNotNull(String variableName, Object value) {
        if (variableName == null) {
            String msg = "The value should not be null: variableName=null value=" + value;
            throw new IllegalArgumentException(msg);
        }
        if (value == null) {
            String msg = "The value should not be null: variableName=" + variableName;
            throw new IllegalArgumentException(msg);
        }
    }

    protected void assertStringNotNullAndNotTrimmedEmpty(String variableName, String value) {
        this.assertObjectNotNull("variableName", variableName);
        this.assertObjectNotNull("value", value);
        if (value.trim().length() == 0) {
            String msg = "The value should not be empty: variableName=" + variableName + " value=" + value;
            throw new IllegalArgumentException(msg);
        }
    }

    protected static class PropertyNameCQContainer {
        protected String _flexibleName;
        protected ConditionQuery _cq;

        public PropertyNameCQContainer(String flexibleName, ConditionQuery cq) {
            this._flexibleName = flexibleName;
            this._cq = cq;
        }

        public String getFlexibleName() {
            return this._flexibleName;
        }

        public ConditionQuery getConditionQuery() {
            return this._cq;
        }
    }
}

