/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.cbean.sqlclause.query;

import java.util.function.BiFunction;
import org.dbflute.cbean.ConditionBean;
import org.dbflute.cbean.chelper.HpCalcSpecification;
import org.dbflute.cbean.sqlclause.SqlClause;
import org.dbflute.cbean.sqlclause.join.InnerJoinNoWaySpeaker;
import org.dbflute.cbean.sqlclause.query.QueryClause;
import org.dbflute.cbean.sqlclause.query.QueryUsedAliasInfo;
import org.dbflute.cbean.sqlclause.subquery.SubQueryIndentProcessor;
import org.dbflute.dbmeta.info.ColumnInfo;
import org.dbflute.exception.ColumnQueryCalculationUnsupportedColumnTypeException;
import org.dbflute.system.DBFluteSystem;

public class ColumnQueryClauseCreator {
    public <CB extends ConditionBean> QueryClause createColumnQueryClause(final String leftColumn, final String operand, final String rightColumn, final HpCalcSpecification<CB> rightCalcSp, final BiFunction<ColumnInfo, String, String> decryptor) {
        return new QueryClause(){

            @Override
            public String toString() {
                String leftExp = this.resolveColumnExp(rightCalcSp.getLeftCalcSp(), leftColumn);
                String rightExp = this.resolveColumnExp(rightCalcSp, rightColumn);
                return ColumnQueryClauseCreator.this.buildColumnQueryClause(leftExp, operand, rightExp);
            }

            protected String resolveColumnExp(HpCalcSpecification<CB> calcSp, String columnExp) {
                String resolvedExp;
                if (calcSp != null) {
                    String statement = calcSp.buildStatementToSpecifidName(columnExp);
                    if (statement != null) {
                        this.assertCalculationColumnType(calcSp);
                        resolvedExp = statement;
                    } else {
                        ColumnInfo columnInfo = calcSp.getSpecifiedColumnInfo();
                        resolvedExp = columnInfo != null ? (String)decryptor.apply(columnInfo, columnExp) : columnExp;
                    }
                } else {
                    resolvedExp = columnExp;
                }
                return resolvedExp;
            }

            protected void assertCalculationColumnType(HpCalcSpecification<CB> calcSp) {
                if (calcSp.hasConvert()) {
                    return;
                }
                ColumnInfo columnInfo = calcSp.getResolvedSpecifiedColumnInfo();
                if (columnInfo != null && !columnInfo.isObjectNativeTypeNumber()) {
                    String msg = "Not number column specified: " + columnInfo;
                    throw new ColumnQueryCalculationUnsupportedColumnTypeException(msg);
                }
            }
        };
    }

    protected String buildColumnQueryClause(String leftExp, String operand, String rightExp) {
        StringBuilder sb = new StringBuilder();
        if (this.hasSubQueryEndOnLastLine(leftExp)) {
            if (this.hasSubQueryEndOnLastLine(rightExp)) {
                sb.append(this.reflectToSubQueryEndOnLastLine(leftExp, " " + operand + " "));
                sb.append(this.ln()).append("       ").append(rightExp);
            } else {
                sb.append(this.reflectToSubQueryEndOnLastLine(leftExp, " " + operand + " " + rightExp));
            }
        } else {
            sb.append(leftExp).append(" ").append(operand).append(" ").append(rightExp);
        }
        return sb.toString();
    }

    protected boolean hasSubQueryEndOnLastLine(String columnExp) {
        return SubQueryIndentProcessor.hasSubQueryEndOnLastLine(columnExp);
    }

    protected String reflectToSubQueryEndOnLastLine(String columnExp, String inserted) {
        return SubQueryIndentProcessor.moveSubQueryEndToRear(columnExp + inserted);
    }

    public <CB extends ConditionBean> void registerColumnQueryClause(SqlClause sqlClause, QueryClause queryClause, HpCalcSpecification<CB> leftCalcSp, HpCalcSpecification<CB> rightCalcSp) {
        QueryUsedAliasInfo leftInfo = this.createColumnQueryAliasInfo(leftCalcSp);
        QueryUsedAliasInfo rightInfo = this.createColumnQueryAliasInfo(rightCalcSp);
        sqlClause.registerWhereClause(queryClause, leftInfo, rightInfo);
    }

    protected <CB extends ConditionBean> QueryUsedAliasInfo createColumnQueryAliasInfo(final HpCalcSpecification<CB> calcSp) {
        String usedAliasName = calcSp.getResolvedSpecifiedTableAliasName();
        return new QueryUsedAliasInfo(usedAliasName, new InnerJoinNoWaySpeaker(){

            @Override
            public boolean isNoWayInner() {
                return calcSp.mayNullRevived();
            }
        });
    }

    protected String ln() {
        return DBFluteSystem.ln();
    }
}

