/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.cbean.sqlclause.subquery;

import java.util.List;
import org.dbflute.cbean.cipher.GearedCipherManager;
import org.dbflute.cbean.sqlclause.SqlClause;
import org.dbflute.cbean.sqlclause.subquery.AbstractSubQuery;
import org.dbflute.cbean.sqlclause.subquery.SubQueryPath;
import org.dbflute.dbmeta.DBMeta;
import org.dbflute.dbmeta.name.ColumnRealName;
import org.dbflute.dbmeta.name.ColumnRealNameProvider;
import org.dbflute.dbmeta.name.ColumnSqlName;
import org.dbflute.dbmeta.name.ColumnSqlNameProvider;
import org.dbflute.util.Srl;

public class InScopeRelation
extends AbstractSubQuery {
    protected boolean _suppressLocalAliasName;

    public InScopeRelation(SubQueryPath subQueryPath, ColumnRealNameProvider localRealNameProvider, ColumnSqlNameProvider subQuerySqlNameProvider, int subQueryLevel, SqlClause subQuerySqlClause, String subQueryIdentity, DBMeta subQueryDBMeta, GearedCipherManager cipherManager, boolean suppressLocalAliasName) {
        super(subQueryPath, localRealNameProvider, subQuerySqlNameProvider, subQueryLevel, subQuerySqlClause, subQueryIdentity, subQueryDBMeta, cipherManager);
        this._suppressLocalAliasName = suppressLocalAliasName;
    }

    public String buildInScopeRelation(String localColumnDbName, String relatedColumnDbName, String correlatedFixedCondition, String inScopeOption) {
        inScopeOption = inScopeOption != null ? inScopeOption + " " : "";
        String localQueryColumnExp = this.prepareLocalQueryColumnExp(localColumnDbName, relatedColumnDbName);
        String subQueryClause = this.prepareSubQueryClause(localColumnDbName, relatedColumnDbName, correlatedFixedCondition);
        String beginMark = this.resolveSubQueryBeginMark(this._subQueryIdentity) + this.ln();
        String endMark = this.resolveSubQueryEndMark(this._subQueryIdentity);
        String endIndent = "       ";
        return localQueryColumnExp + " " + inScopeOption + "in (" + beginMark + subQueryClause + this.ln() + "       " + ")" + endMark;
    }

    protected String prepareLocalQueryColumnExp(String localColumnDbName, String relatedColumnDbName) {
        String localQueryColumnExp;
        if (this.isSinglePrimaryKey(localColumnDbName, relatedColumnDbName)) {
            localQueryColumnExp = this.deriveLocalQueryColumnExp(localColumnDbName);
        } else {
            List<String> localColumnSplit = Srl.splitListTrimmed(localColumnDbName, ",");
            localQueryColumnExp = this.deriveLocalQueryColumnExp(localColumnSplit);
        }
        return localQueryColumnExp;
    }

    protected String deriveLocalQueryColumnExp(String localColumnDbName) {
        ColumnRealName columnRealName = this.deriveLocalColumnRealName(localColumnDbName);
        return columnRealName.toString();
    }

    protected String deriveLocalQueryColumnExp(List<String> localColumnDbNameList) {
        ColumnRealName[] localColumnRealNames = new ColumnRealName[localColumnDbNameList.size()];
        for (int i = 0; i < localColumnDbNameList.size(); ++i) {
            String localColumnDbName = localColumnDbNameList.get(i);
            localColumnRealNames[i] = this.deriveLocalColumnRealName(localColumnDbName);
        }
        return this.generateCompoundColumnInExp(localColumnRealNames, true);
    }

    protected ColumnRealName deriveLocalColumnRealName(String localColumnDbName) {
        ColumnRealName localRealName = this._localRealNameProvider.provide(localColumnDbName);
        ColumnRealName derivedRealName = this._suppressLocalAliasName ? ColumnRealName.create(null, localRealName.getColumnSqlName()) : localRealName;
        return derivedRealName;
    }

    protected String prepareSubQueryClause(String localColumnDbName, String relatedColumnDbName, String correlatedFixedCondition) {
        String subQueryClause;
        if (this.isSinglePrimaryKey(localColumnDbName, relatedColumnDbName)) {
            ColumnSqlName relatedColumnSqlName = this._subQuerySqlNameProvider.provide(relatedColumnDbName);
            subQueryClause = this.deriveSubQueryClause(relatedColumnSqlName, correlatedFixedCondition);
        } else {
            List<String> relatedColumnSplit = Srl.splitListTrimmed(relatedColumnDbName, ",");
            ColumnSqlName[] relatedColumnSqlNames = new ColumnSqlName[relatedColumnSplit.size()];
            for (int i = 0; i < relatedColumnSplit.size(); ++i) {
                relatedColumnSqlNames[i] = this._subQuerySqlNameProvider.provide(relatedColumnSplit.get(i));
            }
            subQueryClause = this.deriveSubQueryClause(relatedColumnSqlNames, correlatedFixedCondition);
        }
        return subQueryClause;
    }

    protected String deriveSubQueryClause(ColumnSqlName relatedColumnSqlName, String correlatedFixedCondition) {
        String tableAliasName = this.getSubQueryLocalAliasName();
        String selectClause = "select " + ColumnRealName.create(tableAliasName, relatedColumnSqlName);
        String fromWhereClause = this.buildPlainFromWhereClause(selectClause, tableAliasName, correlatedFixedCondition);
        String subQueryClause = selectClause + " " + fromWhereClause;
        return this.resolveSubQueryLevelVariable(subQueryClause);
    }

    protected String deriveSubQueryClause(ColumnSqlName[] relatedColumnSqlNames, String correlatedFixedCondition) {
        String tableAliasName = this.getSubQueryLocalAliasName();
        ColumnRealName[] relatedColumnRealNames = new ColumnRealName[relatedColumnSqlNames.length];
        for (int i = 0; i < relatedColumnSqlNames.length; ++i) {
            relatedColumnRealNames[i] = ColumnRealName.create(tableAliasName, relatedColumnSqlNames[i]);
        }
        String selectClause = "select " + this.generateCompoundColumnInExp(relatedColumnRealNames, false);
        String fromWhereClause = this.buildPlainFromWhereClause(selectClause, tableAliasName, correlatedFixedCondition);
        String subQueryClause = selectClause + " " + fromWhereClause;
        return this.resolveSubQueryLevelVariable(subQueryClause);
    }

    protected String generateCompoundColumnInExp(ColumnRealName[] columnRealNames, boolean useParentheses) {
        StringBuilder sb = new StringBuilder();
        if (useParentheses) {
            sb.append("(");
        }
        int index = 0;
        for (ColumnRealName columnRealName : columnRealNames) {
            if (index >= 1) {
                sb.append(", ");
            }
            sb.append(columnRealName);
            ++index;
        }
        if (useParentheses) {
            sb.append(")");
        }
        return sb.toString();
    }
}

