/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.infra.doc.decomment;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.dbflute.helper.HandyDate;
import org.dbflute.helper.dfmap.DfMapFile;
import org.dbflute.helper.message.ExceptionMessageBuilder;
import org.dbflute.infra.doc.decomment.DfDecoMapMapping;
import org.dbflute.infra.doc.decomment.DfDecoMapPickup;
import org.dbflute.infra.doc.decomment.DfDecoMapPiece;
import org.dbflute.infra.doc.decomment.DfDecoMapPieceTargetType;
import org.dbflute.infra.doc.decomment.exception.DfDecoMapFileReadFailureException;
import org.dbflute.infra.doc.decomment.exception.DfDecoMapFileWriteFailureException;
import org.dbflute.infra.doc.decomment.parts.DfDecoMapColumnPart;
import org.dbflute.infra.doc.decomment.parts.DfDecoMapMappingPart;
import org.dbflute.infra.doc.decomment.parts.DfDecoMapPropertyPart;
import org.dbflute.infra.doc.decomment.parts.DfDecoMapTablePart;
import org.dbflute.optional.OptionalThing;
import org.dbflute.util.DfStringUtil;
import org.dbflute.util.DfTypeUtil;

public class DfDecoMapFile {
    private static final String BASE_DECOMMENT_DIR_PATH = "/schema/decomment/";
    private static final String BASE_PICKUP_DIR_PATH = "/schema/decomment/piece/";
    private static final String BASE_PIECE_FILE_PATH = "/schema/decomment/pickup/decomment-pickup.dfmap";
    private static final Map<String, String> REPLACE_CHAR_MAP;
    private final Supplier<LocalDateTime> currentDatetimeSupplier;

    public DfDecoMapFile(Supplier<LocalDateTime> currentDatetimeSupplier) {
        this.currentDatetimeSupplier = currentDatetimeSupplier;
    }

    public List<DfDecoMapPiece> readPieceList(String clientDirPath) {
        this.assertClientDirPath(clientDirPath);
        String pieceDirPath = this.buildPieceDirPath(clientDirPath);
        if (Files.notExists(Paths.get(pieceDirPath, new String[0]), new LinkOption[0])) {
            return Collections.emptyList();
        }
        try {
            return Files.list(Paths.get(pieceDirPath, new String[0])).filter(path -> path.toString().endsWith(".dfmap")).filter(path -> path.toString().contains("-piece-")).map(path -> this.doReadPiece((Path)path)).collect(Collectors.toList());
        }
        catch (IOException e) {
            this.throwDecoMapReadFailureException(pieceDirPath, e);
            return Collections.emptyList();
        }
    }

    private DfDecoMapPiece doReadPiece(Path path) {
        DfMapFile mapFile = this.createDfMapFile();
        try {
            Map<String, Object> map = mapFile.readMap(Files.newInputStream(path, new OpenOption[0]));
            return this.mappingToDecoMapPiece(map);
        }
        catch (IOException | RuntimeException e) {
            this.throwDecoMapReadFailureException(path.toString(), e);
            return null;
        }
    }

    private DfDecoMapPiece mappingToDecoMapPiece(Map<String, Object> map) {
        String formatVersion = (String)map.get("formatVersion");
        String tableName = (String)map.get("tableName");
        String columnName = (String)map.get("columnName");
        DfDecoMapPieceTargetType targetType = DfDecoMapPieceTargetType.of(map.get("targetType")).get();
        String decomment = (String)map.get("decomment");
        String databaseComment = (String)map.get("databaseComment");
        Long commentVersion = Long.valueOf(map.get("commentVersion").toString());
        List authorList = (List)map.get("authorList");
        String pieceCode = (String)map.get("pieceCode");
        LocalDateTime pieceDatetime = new HandyDate((String)map.get("pieceDatetime")).getLocalDateTime();
        String pieceOwner = (String)map.get("pieceOwner");
        String pieceGitBranch = (String)map.get("pieceGitBranch");
        List previousPieceList = (List)map.get("previousPieceList");
        return new DfDecoMapPiece(formatVersion, tableName, columnName, targetType, decomment, databaseComment, commentVersion, authorList, pieceCode, pieceDatetime, pieceOwner, pieceGitBranch, previousPieceList);
    }

    public OptionalThing<DfDecoMapPickup> readPickup(String clientDirPath) {
        this.assertClientDirPath(clientDirPath);
        String filePath = this.buildPickupFilePath(clientDirPath);
        if (Files.notExists(Paths.get(filePath, new String[0]), new LinkOption[0])) {
            return OptionalThing.empty();
        }
        return OptionalThing.ofNullable(this.doReadPickup(Paths.get(filePath, new String[0])), () -> {});
    }

    private DfDecoMapPickup doReadPickup(Path path) {
        DfMapFile mapFile = this.createDfMapFile();
        try {
            Map<String, Object> map = mapFile.readMap(Files.newInputStream(path, new OpenOption[0]));
            return this.mappingToDecoMapPickup(map);
        }
        catch (IOException | RuntimeException e) {
            this.throwDecoMapReadFailureException(path.toString(), e);
            return null;
        }
    }

    private DfDecoMapPickup mappingToDecoMapPickup(Map<String, Object> map) {
        String formatVersion = (String)map.getOrDefault("formatVersion", "1.1");
        LocalDateTime pickupDatetime = DfTypeUtil.toLocalDateTime(map.get("pickupDatetime"));
        Map decoMap = map.getOrDefault("decoMap", Collections.emptyMap());
        if (decoMap.isEmpty()) {
            return new DfDecoMapPickup(formatVersion, Collections.emptyList(), pickupDatetime);
        }
        List tableMapList = decoMap.getOrDefault("tableList", Collections.emptyList());
        List<DfDecoMapTablePart> tableList = tableMapList.stream().map(tablePartMap -> new DfDecoMapTablePart((Map<String, Object>)tablePartMap)).collect(Collectors.toList());
        return new DfDecoMapPickup(formatVersion, tableList, pickupDatetime);
    }

    public List<DfDecoMapMapping> readMappingList(String clientDirPath) {
        this.assertClientDirPath(clientDirPath);
        String pieceDirPath = this.buildPieceDirPath(clientDirPath);
        if (Files.notExists(Paths.get(pieceDirPath, new String[0]), new LinkOption[0])) {
            return Collections.emptyList();
        }
        try {
            return Files.list(Paths.get(pieceDirPath, new String[0])).filter(path -> path.toString().endsWith(".dfmap")).filter(path -> path.toString().contains("-mapping-")).map(path -> this.doReadMapping((Path)path)).collect(Collectors.toList());
        }
        catch (IOException e) {
            this.throwDecoMapReadFailureException(pieceDirPath, e);
            return Collections.emptyList();
        }
    }

    private DfDecoMapMapping doReadMapping(Path path) {
        DfMapFile mapFile = this.createDfMapFile();
        try {
            Map<String, Object> map = mapFile.readMap(Files.newInputStream(path, new OpenOption[0]));
            return this.mappingToDecoMapMapping(map);
        }
        catch (IOException | RuntimeException e) {
            this.throwDecoMapReadFailureException(path.toString(), e);
            return null;
        }
    }

    private DfDecoMapMapping mappingToDecoMapMapping(Map<String, Object> map) {
        String formatVersion = (String)map.get("formatVersion");
        String oldTableName = (String)map.get("oldTableName");
        String oldColumnName = (String)map.get("oldColumnName");
        String newTableName = (String)map.get("newTableName");
        String newColumnName = (String)map.get("newColumnName");
        DfDecoMapPieceTargetType targetType = DfDecoMapPieceTargetType.of(map.get("targetType")).get();
        List authorList = (List)map.get("authorList");
        String mappingCode = (String)map.get("mappingCode");
        LocalDateTime mappingDatetime = new HandyDate((String)map.get("mappingDatetime")).getLocalDateTime();
        String mappingOwner = (String)map.get("mappingOwner");
        List previousMappingList = (List)map.get("previousMappingList");
        return new DfDecoMapMapping(formatVersion, oldTableName, oldColumnName, newTableName, newColumnName, targetType, authorList, mappingCode, mappingOwner, mappingDatetime, previousMappingList);
    }

    protected void throwDecoMapReadFailureException(String path, Exception cause) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Failed to read the deco-map file or directory.");
        br.addItem("path");
        br.addElement(path);
        String msg = br.buildExceptionMessage();
        throw new DfDecoMapFileReadFailureException(msg, cause);
    }

    public void writePiece(String clientDirPath, DfDecoMapPiece decoMapPiece) {
        this.assertClientDirPath(clientDirPath);
        String pieceMapPath = this.buildPieceDirPath(clientDirPath) + this.buildPieceFileName(decoMapPiece);
        this.doWritePiece(pieceMapPath, decoMapPiece);
    }

    protected String buildPieceFileName(DfDecoMapPiece decoMapPiece) {
        String tableName = decoMapPiece.getTableName();
        String columnName = decoMapPiece.getColumnName();
        String owner = decoMapPiece.getPieceOwner();
        String pieceCode = decoMapPiece.getPieceCode();
        if (decoMapPiece.getTargetType() == DfDecoMapPieceTargetType.Table) {
            return "decomment-piece-" + tableName + "-" + this.getCurrentDateStr() + "-" + this.filterOwner(owner) + "-" + pieceCode + ".dfmap";
        }
        if (decoMapPiece.getTargetType() == DfDecoMapPieceTargetType.Column) {
            return "decomment-piece-" + tableName + "-" + columnName + "-" + this.getCurrentDateStr() + "-" + this.filterOwner(owner) + "-" + pieceCode + ".dfmap";
        }
        this.throwIllegalTargetTypeException(decoMapPiece);
        return null;
    }

    protected String filterOwner(String owner) {
        return DfStringUtil.replaceBy(owner, REPLACE_CHAR_MAP);
    }

    protected String getCurrentDateStr() {
        return DateTimeFormatter.ofPattern("yyyyMMdd-HHmmss-SSS").format(this.getCurrentLocalDateTime());
    }

    private void doWritePiece(String pieceFilePath, DfDecoMapPiece decoMapPiece) {
        File pieceMapFile = new File(pieceFilePath);
        if (pieceMapFile.exists()) {
            pieceMapFile.delete();
        }
        this.createPieceMapFile(pieceMapFile);
        Map<String, Object> decoMap = decoMapPiece.convertToMap();
        DfMapFile mapFile = this.createDfMapFile();
        this.createDfMapFile(pieceFilePath, pieceMapFile, decoMap, mapFile);
    }

    protected void createPieceMapFile(File pieceMapFile) {
        try {
            Files.createDirectories(Paths.get(pieceMapFile.getParentFile().getAbsolutePath(), new String[0]), new FileAttribute[0]);
            Files.createFile(Paths.get(pieceMapFile.getAbsolutePath(), new String[0]), new FileAttribute[0]);
        }
        catch (IOException e) {
            this.throwDecoMapWriteFailureException(pieceMapFile.getPath(), e);
        }
    }

    public void writePickup(String clientDirPath, DfDecoMapPickup decoMapPickup) {
        this.assertClientDirPath(clientDirPath);
        this.doWritePickup(this.buildPickupFilePath(clientDirPath), decoMapPickup);
    }

    protected void doWritePickup(String pickupFilePath, DfDecoMapPickup decoMapPickup) {
        File pickupMapFile = new File(pickupFilePath);
        if (pickupMapFile.exists()) {
            pickupMapFile.delete();
        }
        this.createPickupMapFile(pickupMapFile);
        Map<String, Object> decoMap = decoMapPickup.convertToMap();
        DfMapFile mapFile = this.createDfMapFile();
        this.createDfMapFile(pickupFilePath, pickupMapFile, decoMap, mapFile);
    }

    protected void createPickupMapFile(File pickupMapFile) {
        try {
            Files.createDirectories(Paths.get(pickupMapFile.getParentFile().getAbsolutePath(), new String[0]), new FileAttribute[0]);
            Files.createFile(Paths.get(pickupMapFile.getAbsolutePath(), new String[0]), new FileAttribute[0]);
        }
        catch (IOException e) {
            this.throwDecoMapWriteFailureException(pickupMapFile.getPath(), e);
        }
    }

    public void writeMapping(String clientDirPath, DfDecoMapMapping decoMapMapping) {
        this.assertClientDirPath(clientDirPath);
        String mappingFilePath = this.buildPieceDirPath(clientDirPath) + this.buildMappingFileName(decoMapMapping);
        this.doWriteMapping(mappingFilePath, decoMapMapping);
    }

    protected String buildMappingFileName(DfDecoMapMapping decoMapMapping) {
        String oldTableName = decoMapMapping.getOldTableName();
        String oldColumnName = decoMapMapping.getOldColumnName();
        String newTableName = decoMapMapping.getNewTableName();
        String newColumnName = decoMapMapping.getNewColumnName();
        String owner = decoMapMapping.getMappingOwner();
        String mappingCode = decoMapMapping.getMappingCode();
        if (decoMapMapping.getTargetType() == DfDecoMapPieceTargetType.Table) {
            return "decomment-mapping-" + oldTableName + "-" + newTableName + "-" + this.getCurrentDateStr() + "-" + this.filterOwner(owner) + "-" + mappingCode + ".dfmap";
        }
        if (decoMapMapping.getTargetType() == DfDecoMapPieceTargetType.Column) {
            return "decomment-mapping-" + oldTableName + "-" + oldColumnName + "-" + newTableName + "-" + newColumnName + "-" + this.getCurrentDateStr() + "-" + this.filterOwner(owner) + "-" + mappingCode + ".dfmap";
        }
        this.throwIllegalTargetTypeException(decoMapMapping);
        return null;
    }

    protected void doWriteMapping(String mappingFilePath, DfDecoMapMapping decoMapMapping) {
        File mappingMapFile = new File(mappingFilePath);
        if (mappingMapFile.exists()) {
            mappingMapFile.delete();
        }
        this.createMappingMapFile(mappingMapFile);
        Map<String, Object> decoMap = decoMapMapping.convertToMap();
        DfMapFile mapFile = this.createDfMapFile();
        this.createDfMapFile(mappingFilePath, mappingMapFile, decoMap, mapFile);
    }

    protected void createMappingMapFile(File mappingMapFile) {
        try {
            Files.createDirectories(Paths.get(mappingMapFile.getParentFile().getAbsolutePath(), new String[0]), new FileAttribute[0]);
            Files.createFile(Paths.get(mappingMapFile.getAbsolutePath(), new String[0]), new FileAttribute[0]);
        }
        catch (IOException e) {
            this.throwDecoMapWriteFailureException(mappingMapFile.getPath(), e);
        }
    }

    private void createDfMapFile(String mappingFilePath, File mappingMapFile, Map<String, Object> decoMap, DfMapFile mapFile) {
        try (FileOutputStream ous = new FileOutputStream(mappingMapFile);){
            try {
                mapFile.writeMap(ous, decoMap);
            }
            catch (IOException e) {
                this.throwDecoMapWriteFailureException(mappingFilePath, decoMap, e);
            }
        }
        catch (IOException e) {
            this.throwDecoMapResourceReleaseFailureException(mappingFilePath, decoMap, e);
        }
    }

    protected void throwDecoMapWriteFailureException(String path, Exception cause) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Failed to create the deco-map file.");
        br.addItem("Path");
        br.addElement(path);
        String msg = br.buildExceptionMessage();
        throw new DfDecoMapFileWriteFailureException(msg, cause);
    }

    protected void throwDecoMapWriteFailureException(String path, Map<String, Object> decoMap, Exception cause) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Failed to write the deco-map file.");
        br.addItem("Path");
        br.addElement(path);
        br.addItem("DecoMap");
        br.addElement(decoMap);
        String msg = br.buildExceptionMessage();
        throw new DfDecoMapFileWriteFailureException(msg, cause);
    }

    protected void throwDecoMapResourceReleaseFailureException(String path, Map<String, Object> decoMap, Exception cause) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Maybe... fail to execute \"outputStream.close()\".");
        br.addItem("Path");
        br.addElement(path);
        br.addItem("DecoMap");
        br.addElement(decoMap);
        String msg = br.buildExceptionMessage();
        throw new DfDecoMapFileWriteFailureException(msg, cause);
    }

    protected void throwIllegalTargetTypeException(DfDecoMapPiece decoMapPiece) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Deco map piece target type is illegal");
        br.addItem("Target type");
        br.addElement(decoMapPiece.getTargetType());
        br.addItem("DecoMapPiece");
        br.addElement(decoMapPiece);
        String msg = br.buildExceptionMessage();
        throw new IllegalArgumentException(msg);
    }

    protected void throwIllegalTargetTypeException(DfDecoMapMapping decoMapMapping) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Deco map mapping target type is illegal");
        br.addItem("Target type");
        br.addElement(decoMapMapping.getTargetType());
        br.addItem("DecoMapPiece");
        br.addElement(decoMapMapping);
        String msg = br.buildExceptionMessage();
        throw new IllegalArgumentException(msg);
    }

    public DfDecoMapPickup merge(OptionalThing<DfDecoMapPickup> optPickup, List<DfDecoMapPiece> outputPieceList, List<DfDecoMapMapping> outputMappingList) {
        List<DfDecoMapMapping> allMappingList = this.extractAllMappingList(optPickup, outputMappingList);
        List<DfDecoMapMapping> filteredMappingPartList = this.filterMergedMapping(allMappingList);
        Map<String, List<DfDecoMapMappingPart>> mappingPartListMap = this.groupingByOldStatusAndMergeSameNewStatus(filteredMappingPartList);
        List<DfDecoMapTablePart> allTablePartList = this.extractAllTableList(optPickup, outputPieceList);
        Stream<DfDecoMapTablePart> correctNameTableStream = this.defineMappingToCorrectName(allTablePartList.stream(), mappingPartListMap);
        Stream<DfDecoMapTablePart> mergedTableStream = this.defineSameNameMerging(correctNameTableStream);
        Stream<DfDecoMapTablePart> filteredTableStream = this.defineFilteringMergedProperty(mergedTableStream, allTablePartList);
        List<DfDecoMapTablePart> tableList = filteredTableStream.collect(Collectors.toList());
        return new DfDecoMapPickup(tableList, this.getCurrentLocalDateTime());
    }

    private List<DfDecoMapMapping> extractAllMappingList(OptionalThing<DfDecoMapPickup> optPickup, List<DfDecoMapMapping> outputMappingList) {
        Stream<DfDecoMapMapping> pickupMappingStream = this.defineExtractingMappingInPickup(optPickup);
        Stream pieceMappingStream = outputMappingList.stream();
        return Stream.concat(pickupMappingStream, pieceMappingStream).collect(Collectors.toList());
    }

    private Stream<DfDecoMapMapping> defineExtractingMappingInPickup(OptionalThing<DfDecoMapPickup> optPickup) {
        return optPickup.map(pickup -> {
            Stream tableMappingStream = pickup.getTableList().stream().flatMap(table -> table.getMappingList().stream().map(mapping -> new DfDecoMapMapping(table.getTableName(), null, DfDecoMapPieceTargetType.Table, (DfDecoMapMappingPart)mapping)));
            Stream columnMappingStream = pickup.getTableList().stream().flatMap(table -> table.getColumnList().stream().flatMap(column -> column.getMappingList().stream().map(mapping -> new DfDecoMapMapping(table.getTableName(), column.getColumnName(), DfDecoMapPieceTargetType.Column, (DfDecoMapMappingPart)mapping))));
            return Stream.concat(tableMappingStream, columnMappingStream);
        }).orElse(Stream.empty());
    }

    private List<DfDecoMapMapping> filterMergedMapping(List<DfDecoMapMapping> allMappingList) {
        Set mappingCodeSet = allMappingList.stream().flatMap(mapping -> mapping.getPreviousMappingList().stream()).collect(Collectors.toSet());
        return allMappingList.stream().filter(mapping -> !mappingCodeSet.contains(mapping.getMappingCode())).collect(Collectors.toList());
    }

    private Map<String, List<DfDecoMapMappingPart>> groupingByOldStatusAndMergeSameNewStatus(List<DfDecoMapMapping> mappingList) {
        Map<String, List<DfDecoMapMapping>> mappingListByOldStatusHash = mappingList.stream().collect(Collectors.groupingBy(mapping -> this.generateOldStateHash((DfDecoMapMapping)mapping)));
        return mappingListByOldStatusHash.entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> ((List)entry.getValue()).stream().collect(Collectors.toMap(mapping -> this.generateNewStateHash((DfDecoMapMapping)mapping), mapping -> mapping, (m1, m2) -> this.mergeMapping((DfDecoMapMapping)m1, (DfDecoMapMapping)m2))).values().stream().map(mapping -> new DfDecoMapMappingPart((DfDecoMapMapping)mapping)).collect(Collectors.toList()), (l1, l2) -> Stream.concat(l1.stream(), l2.stream()).collect(Collectors.toList())));
    }

    private DfDecoMapMapping mergeMapping(DfDecoMapMapping m1, DfDecoMapMapping m2) {
        Set authorSet = Stream.concat(m1.getAuthorList().stream(), m2.getAuthorList().stream()).collect(Collectors.toSet());
        Set previousMappingSet = Stream.concat(m1.getPreviousMappingList().stream(), m2.getPreviousMappingList().stream()).collect(Collectors.toSet());
        previousMappingSet.add(m2.mappingCode);
        return new DfDecoMapMapping("1.1", m1.getOldTableName(), m1.getOldColumnName(), m1.getNewTableName(), m1.getNewColumnName(), m1.getTargetType(), new ArrayList<String>(authorSet), m1.getMappingCode(), m1.getMappingOwner(), m1.getMappingDatetime(), new ArrayList<String>(previousMappingSet));
    }

    private List<DfDecoMapTablePart> extractAllTableList(OptionalThing<DfDecoMapPickup> optPickup, List<DfDecoMapPiece> outputPieceList) {
        Stream<DfDecoMapTablePart> pickupTableStream = this.defineConvertPickupToTable(optPickup);
        Stream<DfDecoMapTablePart> pieceTableStream = this.defineConvertPieceListToTable(outputPieceList);
        return Stream.concat(pickupTableStream, pieceTableStream).collect(Collectors.toList());
    }

    private Stream<DfDecoMapTablePart> defineConvertPickupToTable(OptionalThing<DfDecoMapPickup> pickupOpt) {
        return pickupOpt.map(pickup -> pickup.getTableList().stream()).orElse(Stream.empty());
    }

    private Stream<DfDecoMapTablePart> defineConvertPieceListToTable(List<DfDecoMapPiece> pieceList) {
        return pieceList.stream().map(piece -> this.convertPieceToTablePart((DfDecoMapPiece)piece));
    }

    private DfDecoMapTablePart convertPieceToTablePart(DfDecoMapPiece piece) {
        DfDecoMapPropertyPart property = this.convertToProperty(piece);
        String tableName = piece.getTableName();
        List<DfDecoMapPropertyPart> tablePropertyList = piece.isTargetTypeTable() ? Collections.singletonList(property) : Collections.emptyList();
        List<DfDecoMapColumnPart> columnList = piece.isTargetTypeColumn() ? Collections.singletonList(this.convertPieceToColumnPart(piece, property)) : Collections.emptyList();
        return new DfDecoMapTablePart(tableName, Collections.emptyList(), tablePropertyList, columnList);
    }

    private DfDecoMapPropertyPart convertToProperty(DfDecoMapPiece piece) {
        DfDecoMapPropertyPart property = new DfDecoMapPropertyPart(piece.getDecomment(), piece.getDatabaseComment(), piece.getCommentVersion(), piece.getAuthorList(), piece.getPieceCode(), piece.getPieceDatetime(), piece.getPieceOwner(), piece.getPieceGitBranch(), piece.getPreviousPieceList());
        return property;
    }

    private DfDecoMapColumnPart convertPieceToColumnPart(DfDecoMapPiece piece, DfDecoMapPropertyPart property) {
        String columnName = piece.getColumnName();
        List<DfDecoMapPropertyPart> columnPropertyList = Collections.singletonList(property);
        return new DfDecoMapColumnPart(columnName, Collections.emptyList(), columnPropertyList);
    }

    private Stream<DfDecoMapTablePart> defineMappingToCorrectName(Stream<DfDecoMapTablePart> tableStream, Map<String, List<DfDecoMapMappingPart>> mappingPartListMap) {
        return tableStream.map(table -> this.mappingToTableIfNameChanged((DfDecoMapTablePart)table, mappingPartListMap));
    }

    private DfDecoMapTablePart mappingToTableIfNameChanged(DfDecoMapTablePart tablePart, Map<String, List<DfDecoMapMappingPart>> mappingPartListMap) {
        DfDecoMapTablePart part;
        List<DfDecoMapMappingPart> mappingPartList = mappingPartListMap.getOrDefault(this.generateTableStateHash(tablePart), Collections.emptyList());
        if (mappingPartList.size() == 1) {
            DfDecoMapMappingPart mappingPart = (DfDecoMapMappingPart)mappingPartList.get(0);
            part = new DfDecoMapTablePart(mappingPart.getNewTableName(), Collections.emptyList(), tablePart.getPropertyList(), tablePart.getColumnList());
        } else {
            part = new DfDecoMapTablePart(tablePart.getTableName(), mappingPartList, tablePart.getPropertyList(), tablePart.getColumnList());
        }
        List<DfDecoMapColumnPart> columnPartList = part.getColumnList().stream().map(columnPart -> this.mappingToColumnIfNameChanged(part, (DfDecoMapColumnPart)columnPart, mappingPartListMap)).collect(Collectors.toList());
        return new DfDecoMapTablePart(part.getTableName(), part.getMappingList(), part.getPropertyList(), columnPartList);
    }

    private DfDecoMapColumnPart mappingToColumnIfNameChanged(DfDecoMapTablePart tablePart, DfDecoMapColumnPart columnPart, Map<String, List<DfDecoMapMappingPart>> mappingPartListMap) {
        List<DfDecoMapMappingPart> mappingPartList = mappingPartListMap.getOrDefault(this.generateColumnStateHash(tablePart, columnPart), Collections.emptyList());
        if (mappingPartList.size() == 1) {
            DfDecoMapMappingPart mappingPart = (DfDecoMapMappingPart)mappingPartList.get(0);
            return new DfDecoMapColumnPart(mappingPart.getNewColumnName(), Collections.emptyList(), columnPart.getPropertyList());
        }
        return new DfDecoMapColumnPart(columnPart.getColumnName(), mappingPartList, columnPart.getPropertyList());
    }

    private Stream<DfDecoMapTablePart> defineSameNameMerging(Stream<DfDecoMapTablePart> tableStream) {
        Map groupedTableMap = tableStream.collect(Collectors.groupingBy(table -> table.getTableName(), () -> new LinkedHashMap(), Collectors.toList()));
        return groupedTableMap.entrySet().stream().map(tableEntry -> {
            String tableName = (String)tableEntry.getKey();
            List sameTableNameList = (List)tableEntry.getValue();
            List<DfDecoMapPropertyPart> tablePropertyList = ((List)tableEntry.getValue()).stream().flatMap(table -> table.getPropertyList().stream()).collect(Collectors.toList());
            List<DfDecoMapMappingPart> tableMappingPartList = ((List)tableEntry.getValue()).stream().flatMap(table -> table.getMappingList().stream()).collect(Collectors.toList());
            Map groupedColumnMap = sameTableNameList.stream().flatMap(table -> table.getColumnList().stream()).collect(Collectors.groupingBy(column -> column.getColumnName(), () -> new LinkedHashMap(), Collectors.toList()));
            List<DfDecoMapColumnPart> columnList = groupedColumnMap.entrySet().stream().map(columnEntry -> {
                String columnName = (String)columnEntry.getKey();
                List<DfDecoMapMappingPart> columnMappingPartList = ((List)columnEntry.getValue()).stream().flatMap(column -> column.getMappingList().stream()).collect(Collectors.toList());
                List<DfDecoMapPropertyPart> columnPropertyList = ((List)columnEntry.getValue()).stream().flatMap(column -> column.getPropertyList().stream()).collect(Collectors.toList());
                return new DfDecoMapColumnPart(columnName, columnMappingPartList, columnPropertyList);
            }).collect(Collectors.toList());
            return new DfDecoMapTablePart(tableName, tableMappingPartList, tablePropertyList, columnList);
        });
    }

    private Stream<DfDecoMapTablePart> defineFilteringMergedProperty(Stream<DfDecoMapTablePart> tableStream, List<DfDecoMapTablePart> allTablePartList) {
        Set<String> pieceCodeSet = this.extractAllMergedPieceCode(allTablePartList);
        return tableStream.map(table -> {
            String tableName = table.getTableName();
            List<DfDecoMapMappingPart> tableMappingPartList = table.getMappingList();
            List<DfDecoMapPropertyPart> tablePropertyList = table.getPropertyList().stream().filter(property -> !pieceCodeSet.contains(property.getPieceCode())).collect(Collectors.toList());
            List<DfDecoMapColumnPart> columnList = table.getColumnList().stream().map(column -> {
                String columnName = column.getColumnName();
                List<DfDecoMapMappingPart> columnMappingPartList = column.getMappingList();
                List<DfDecoMapPropertyPart> columnPropertyList = column.getPropertyList().stream().filter(property -> !pieceCodeSet.contains(property.getPieceCode())).collect(Collectors.toList());
                return new DfDecoMapColumnPart(columnName, columnMappingPartList, columnPropertyList);
            }).collect(Collectors.toList());
            return new DfDecoMapTablePart(tableName, tableMappingPartList, tablePropertyList, columnList);
        });
    }

    private Set<String> extractAllMergedPieceCode(List<DfDecoMapTablePart> tableList) {
        return tableList.stream().flatMap(table -> {
            Stream previousTablePieceStream = table.getPropertyList().stream().flatMap(property -> property.getPreviousPieceList().stream());
            Stream previousColumnPieceStream = table.getColumnList().stream().flatMap(column -> column.getPropertyList().stream()).flatMap(property -> property.getPreviousPieceList().stream());
            return Stream.concat(previousTablePieceStream, previousColumnPieceStream);
        }).collect(Collectors.toSet());
    }

    private String generateOldStateHash(DfDecoMapMapping mapping) {
        return this.generateStateHash(mapping.getOldTableName(), mapping.getOldColumnName(), mapping.getTargetType());
    }

    private String generateNewStateHash(DfDecoMapMapping mapping) {
        return this.generateStateHash(mapping.getNewTableName(), mapping.getNewColumnName(), mapping.getTargetType());
    }

    private String generateTableStateHash(DfDecoMapTablePart tablePart) {
        return this.generateStateHash(tablePart.getTableName(), null, DfDecoMapPieceTargetType.Table);
    }

    private String generateColumnStateHash(DfDecoMapTablePart tablePart, DfDecoMapColumnPart columnPart) {
        return this.generateStateHash(tablePart.getTableName(), columnPart.getColumnName(), DfDecoMapPieceTargetType.Column);
    }

    private String generateStateHash(String tableName, String columnName, DfDecoMapPieceTargetType type) {
        StringBuilder sb = new StringBuilder();
        sb.append(tableName);
        sb.append(":").append(DfStringUtil.isEmpty(columnName) ? "" : columnName);
        sb.append(":").append(type);
        return Integer.toHexString(sb.toString().hashCode());
    }

    public void deletePiece(String clientPath) {
        String pieceDirPath = this.buildPieceDirPath(clientPath);
        this.doDeletePiece(pieceDirPath);
    }

    private void doDeletePiece(String piecePath) {
        File pieceDir = new File(piecePath);
        if (pieceDir.isDirectory()) {
            for (File pieceFile : pieceDir.listFiles()) {
                if (pieceFile.isFile()) {
                    pieceFile.delete();
                    continue;
                }
                this.doDeletePiece(pieceFile.getAbsolutePath());
            }
        }
    }

    protected DfMapFile createDfMapFile() {
        return new DfMapFile();
    }

    protected String buildPieceDirPath(String clientDirPath) {
        return clientDirPath + BASE_PICKUP_DIR_PATH;
    }

    protected String buildPickupFilePath(String clientDirPath) {
        return clientDirPath + BASE_PIECE_FILE_PATH;
    }

    protected void assertClientDirPath(String clientDirPath) {
        if (clientDirPath == null || clientDirPath.trim().length() == 0) {
            String msg = "The argument 'clientDirPath' should not be null or empty: " + clientDirPath;
            throw new IllegalArgumentException(msg);
        }
    }

    protected LocalDateTime getCurrentLocalDateTime() {
        return this.currentDatetimeSupplier.get();
    }

    static {
        List<String> notAvailableCharList = Arrays.asList("/", "\\", "<", ">", "*", "?", "\"", "|", ":", ";", "\u0000", " ");
        String replaceChar = "_";
        REPLACE_CHAR_MAP = notAvailableCharList.stream().collect(Collectors.toMap(ch -> ch, ch -> "_"));
    }
}

