/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.infra.doc.decomment;

import java.time.LocalDateTime;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.dbflute.helper.dfmap.DfMapStyle;
import org.dbflute.infra.doc.decomment.parts.DfDecoMapTablePart;

public class DfDecoMapPickup {
    public static final String DEFAULT_FORMAT_VERSION = "1.1";
    public static final String DECO_MAP_KEY_DECOMAP = "decoMap";
    public static final String DECO_MAP_KEY_TABLE_LIST = "tableList";
    protected final String formatVersion;
    protected final LocalDateTime pickupDatetime;
    protected final List<DfDecoMapTablePart> tableList;

    public DfDecoMapPickup(String formatVersion, List<DfDecoMapTablePart> tableList, LocalDateTime pickupDatetime) {
        this.formatVersion = formatVersion;
        this.pickupDatetime = pickupDatetime;
        this.tableList = tableList;
    }

    public DfDecoMapPickup(List<DfDecoMapTablePart> tableList, LocalDateTime pickupDatetime) {
        this.formatVersion = DEFAULT_FORMAT_VERSION;
        this.pickupDatetime = pickupDatetime;
        this.tableList = tableList;
    }

    public Map<String, Object> convertToMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("formatVersion", this.formatVersion);
        map.put("pickupDatetime", this.pickupDatetime);
        map.put(DECO_MAP_KEY_DECOMAP, this.prepareDecoMap());
        return map;
    }

    private Map<String, List<Map<String, Object>>> prepareDecoMap() {
        LinkedHashMap<String, List<Map<String, Object>>> decoMap = new LinkedHashMap<String, List<Map<String, Object>>>();
        List convertedTableList = this.tableList.stream().map(DfDecoMapTablePart::convertPickupMap).collect(Collectors.toList());
        decoMap.put(DECO_MAP_KEY_TABLE_LIST, convertedTableList);
        return decoMap;
    }

    public String toString() {
        return new DfMapStyle().toMapString(this.convertToMap());
    }

    public String getFormatVersion() {
        return this.formatVersion;
    }

    public LocalDateTime getPickupDatetime() {
        return this.pickupDatetime;
    }

    public List<DfDecoMapTablePart> getTableList() {
        return Collections.unmodifiableList(this.tableList);
    }
}

