/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.infra.doc.decomment;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.dbflute.exception.ClassificationNotFoundException;
import org.dbflute.jdbc.Classification;
import org.dbflute.jdbc.ClassificationCodeType;
import org.dbflute.jdbc.ClassificationMeta;
import org.dbflute.jdbc.ClassificationUndefinedHandlingType;
import org.dbflute.optional.OptionalThing;
import org.dbflute.util.DfTypeUtil;

public enum DfDecoMapPieceTargetType implements Classification
{
    Column("COLUMN", "Column", DfTypeUtil.emptyStrings()),
    Table("TABLE", "Table", DfTypeUtil.emptyStrings());

    private static final Map<String, DfDecoMapPieceTargetType> _codeClsMap;
    private static final Map<String, DfDecoMapPieceTargetType> _nameClsMap;
    private String _code;
    private String _alias;
    private Set<String> _sisterSet;

    private DfDecoMapPieceTargetType(String code, String alias, String[] sisters) {
        this._code = code;
        this._alias = alias;
        this._sisterSet = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList(sisters)));
    }

    @Override
    public String code() {
        return this._code;
    }

    @Override
    public String alias() {
        return this._alias;
    }

    @Override
    public Set<String> sisterSet() {
        return this._sisterSet;
    }

    @Override
    public Map<String, Object> subItemMap() {
        return Collections.emptyMap();
    }

    @Override
    public ClassificationMeta meta() {
        return new ClassificationMeta(){

            @Override
            public String classificationName() {
                return DfDecoMapPieceTargetType.class.getSimpleName();
            }

            @Override
            public OptionalThing<? extends Classification> of(Object code) {
                return DfDecoMapPieceTargetType.of(code);
            }

            @Override
            public OptionalThing<? extends Classification> byName(String name) {
                return DfDecoMapPieceTargetType.byName(name);
            }

            @Override
            public Classification codeOf(Object code) {
                return DfDecoMapPieceTargetType.of(code).orElse(null);
            }

            @Override
            public Classification nameOf(String name) {
                return DfDecoMapPieceTargetType.byName(name).orElse(null);
            }

            @Override
            public List<Classification> listAll() {
                return DfDecoMapPieceTargetType.listAll().stream().map(el -> el).collect(Collectors.toList());
            }

            @Override
            public List<Classification> listByGroup(String groupName) {
                DfDecoMapPieceTargetType.listByGroup(groupName);
                return Collections.emptyList();
            }

            @Override
            public List<Classification> groupOf(String groupName) {
                return Collections.emptyList();
            }

            @Override
            public ClassificationCodeType codeType() {
                return ClassificationCodeType.String;
            }

            @Override
            public ClassificationUndefinedHandlingType undefinedHandlingType() {
                return ClassificationUndefinedHandlingType.EXCEPTION;
            }
        };
    }

    @Override
    public boolean inGroup(String groupName) {
        return false;
    }

    public static OptionalThing<DfDecoMapPieceTargetType> of(Object code) {
        if (code == null) {
            return OptionalThing.ofNullable(null, () -> {
                throw new ClassificationNotFoundException("null code specified");
            });
        }
        if (code instanceof DfDecoMapPieceTargetType) {
            return OptionalThing.of((DfDecoMapPieceTargetType)code);
        }
        if (code instanceof OptionalThing) {
            return DfDecoMapPieceTargetType.of(((OptionalThing)code).orElse(null));
        }
        return OptionalThing.ofNullable(_codeClsMap.get(code.toString().toLowerCase()), () -> {
            throw new ClassificationNotFoundException("Unknown classification code: " + code);
        });
    }

    public static OptionalThing<DfDecoMapPieceTargetType> byName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("The argument 'name' should not be null.");
        }
        return OptionalThing.ofNullable(_nameClsMap.get(name.toLowerCase()), () -> {
            throw new ClassificationNotFoundException("Unknown classification name: " + name);
        });
    }

    public static DfDecoMapPieceTargetType codeOf(Object code) {
        if (code == null) {
            return null;
        }
        if (code instanceof DfDecoMapPieceTargetType) {
            return (DfDecoMapPieceTargetType)code;
        }
        return _codeClsMap.get(code.toString().toLowerCase());
    }

    public static DfDecoMapPieceTargetType nameOf(String name) {
        if (name == null) {
            return null;
        }
        try {
            return DfDecoMapPieceTargetType.valueOf(name);
        }
        catch (RuntimeException ignored) {
            return null;
        }
    }

    public static List<DfDecoMapPieceTargetType> listAll() {
        return new ArrayList<DfDecoMapPieceTargetType>(Arrays.asList(DfDecoMapPieceTargetType.values()));
    }

    public static List<DfDecoMapPieceTargetType> listByGroup(String groupName) {
        if (groupName == null) {
            throw new IllegalArgumentException("The argument 'groupName' should not be null.");
        }
        throw new ClassificationNotFoundException("Unknown classification group: DfDecoMapPieceTargetType." + groupName);
    }

    public static List<DfDecoMapPieceTargetType> listOf(Collection<String> codeList) {
        if (codeList == null) {
            throw new IllegalArgumentException("The argument 'codeList' should not be null.");
        }
        ArrayList<DfDecoMapPieceTargetType> clsList = new ArrayList<DfDecoMapPieceTargetType>(codeList.size());
        for (String code : codeList) {
            clsList.add(DfDecoMapPieceTargetType.of(code).get());
        }
        return clsList;
    }

    public static List<DfDecoMapPieceTargetType> groupOf(String groupName) {
        return new ArrayList<DfDecoMapPieceTargetType>(4);
    }

    public String toString() {
        return this.code();
    }

    static {
        _codeClsMap = new HashMap<String, DfDecoMapPieceTargetType>();
        _nameClsMap = new HashMap<String, DfDecoMapPieceTargetType>();
        for (DfDecoMapPieceTargetType value : DfDecoMapPieceTargetType.values()) {
            _codeClsMap.put(value.code().toLowerCase(), value);
            for (String sister : value.sisterSet()) {
                _codeClsMap.put(sister.toLowerCase(), value);
            }
        }
    }
}

