/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.infra.doc.decomment.parts;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.dbflute.infra.doc.decomment.parts.DfDecoMapColumnPart;
import org.dbflute.infra.doc.decomment.parts.DfDecoMapMappingPart;
import org.dbflute.infra.doc.decomment.parts.DfDecoMapPropertyPart;

public class DfDecoMapTablePart {
    protected final String tableName;
    protected final List<DfDecoMapMappingPart> mappingList;
    protected final List<DfDecoMapPropertyPart> propertyList;
    protected final List<DfDecoMapColumnPart> columnList;

    public DfDecoMapTablePart(String tableName, List<DfDecoMapMappingPart> mappingList, List<DfDecoMapPropertyPart> propertyList, List<DfDecoMapColumnPart> columnList) {
        this.tableName = tableName;
        this.mappingList = mappingList;
        this.propertyList = propertyList;
        this.columnList = columnList;
    }

    public DfDecoMapTablePart(Map<String, Object> tablePartMap) {
        this.tableName = (String)tablePartMap.get("tableName");
        List mappingMapList = tablePartMap.getOrDefault("mappingList", Collections.emptyList());
        this.mappingList = mappingMapList.stream().map(DfDecoMapMappingPart::new).collect(Collectors.toList());
        List propertyMapList = (List)tablePartMap.get("propertyList");
        this.propertyList = propertyMapList.stream().map(DfDecoMapPropertyPart::new).collect(Collectors.toList());
        List columnMapList = (List)tablePartMap.get("columnList");
        this.columnList = columnMapList.stream().map(DfDecoMapColumnPart::new).collect(Collectors.toList());
    }

    public Map<String, Object> convertPickupMap() {
        List mappingMapList = this.mappingList.stream().map(DfDecoMapMappingPart::convertToMap).collect(Collectors.toList());
        List columnMapList = this.columnList.stream().map(DfDecoMapColumnPart::convertToMap).collect(Collectors.toList());
        List propertyMapList = this.propertyList.stream().map(DfDecoMapPropertyPart::convertToMap).collect(Collectors.toList());
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("tableName", this.tableName);
        map.put("mappingList", mappingMapList);
        map.put("propertyList", propertyMapList);
        map.put("columnList", columnMapList);
        return map;
    }

    public String toString() {
        return "tablePart:{" + this.tableName + ", mappings=" + this.toSizeExp(this.mappingList) + ", properties=" + this.toSizeExp(this.propertyList) + ", columns=" + this.toSizeExp(this.columnList) + "}";
    }

    protected String toSizeExp(List<?> list) {
        return list != null ? String.valueOf(list.size()) : "null";
    }

    public String getTableName() {
        return this.tableName;
    }

    public List<DfDecoMapMappingPart> getMappingList() {
        return this.mappingList;
    }

    public List<DfDecoMapPropertyPart> getPropertyList() {
        return Collections.unmodifiableList(this.propertyList);
    }

    public List<DfDecoMapColumnPart> getColumnList() {
        return this.columnList;
    }
}

