/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.jdbc;

import java.util.HashMap;
import java.util.Map;
import org.dbflute.optional.OptionalThing;

public enum ClassificationUndefinedHandlingType {
    EXCEPTION("EXCEPTION", true, false),
    LOGGING("LOGGING", true, true),
    ALLOWED("ALLOWED", false, true);

    private static final Map<String, ClassificationUndefinedHandlingType> _codeValueMap;
    private final String _code;
    private final boolean _checked;
    private final boolean _continued;

    private ClassificationUndefinedHandlingType(String code, boolean checked, boolean continued) {
        this._code = code;
        this._checked = checked;
        this._continued = continued;
    }

    public static OptionalThing<ClassificationUndefinedHandlingType> of(Object code) {
        if (code == null) {
            return OptionalThing.ofNullable(null, () -> {
                throw new IllegalArgumentException("The argument 'code' should not be null.");
            });
        }
        if (code instanceof ClassificationUndefinedHandlingType) {
            return OptionalThing.of((ClassificationUndefinedHandlingType)((Object)code));
        }
        if (code instanceof OptionalThing) {
            return ClassificationUndefinedHandlingType.of(((OptionalThing)code).orElse(null));
        }
        ClassificationUndefinedHandlingType type = _codeValueMap.get(code.toString().toLowerCase());
        return OptionalThing.ofNullable(type, () -> {
            throw new IllegalStateException("Not found the type by the code: " + code);
        });
    }

    @Deprecated
    public static ClassificationUndefinedHandlingType codeOf(Object code) {
        return ClassificationUndefinedHandlingType.of(code).orElse(null);
    }

    public String code() {
        return this._code;
    }

    public boolean isChecked() {
        return this._checked;
    }

    public boolean isCheckedAbort() {
        return this._checked && !this._continued;
    }

    public boolean isCheckedContinue() {
        return this._checked && this._continued;
    }

    public boolean isContinued() {
        return this._continued;
    }

    static {
        _codeValueMap = new HashMap<String, ClassificationUndefinedHandlingType>();
        for (ClassificationUndefinedHandlingType value : ClassificationUndefinedHandlingType.values()) {
            _codeValueMap.put(value.code().toLowerCase(), value);
        }
    }
}

