/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.jdbc;

import java.util.HashMap;
import java.util.Map;
import org.dbflute.optional.OptionalThing;

public enum ShortCharHandlingMode {
    RFILL("R"),
    LFILL("L"),
    EXCEPTION("E"),
    NONE("N");

    private static final Map<String, ShortCharHandlingMode> _codeValueMap;
    protected final String _code;

    private ShortCharHandlingMode(String code) {
        this._code = code;
    }

    public static OptionalThing<ShortCharHandlingMode> of(Object code) {
        if (code == null) {
            return OptionalThing.ofNullable(null, () -> {
                throw new IllegalArgumentException("The argument 'code' should not be null.");
            });
        }
        if (code instanceof ShortCharHandlingMode) {
            return OptionalThing.of((ShortCharHandlingMode)((Object)code));
        }
        if (code instanceof OptionalThing) {
            return ShortCharHandlingMode.of(((OptionalThing)code).orElse(null));
        }
        ShortCharHandlingMode type = _codeValueMap.get(code.toString().toLowerCase());
        return OptionalThing.ofNullable(type, () -> {
            throw new IllegalStateException("Not found the type by the code: " + code);
        });
    }

    @Deprecated
    public static ShortCharHandlingMode codeOf(Object code) {
        return ShortCharHandlingMode.of(code).orElse(null);
    }

    public String code() {
        return this._code;
    }

    static {
        _codeValueMap = new HashMap<String, ShortCharHandlingMode>();
        for (ShortCharHandlingMode value : ShortCharHandlingMode.values()) {
            _codeValueMap.put(value.code().toLowerCase(), value);
        }
    }
}

