/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.mail;

import java.util.Map;
import org.dbflute.mail.Postcard;
import org.dbflute.mail.send.SMailDeliveryDepartment;
import org.dbflute.mail.send.SMailPostalMotorbike;
import org.dbflute.mail.send.SMailPostie;
import org.dbflute.mail.send.SMailReceptionist;
import org.dbflute.mail.send.SMailTextProofreader;
import org.dbflute.mail.send.embedded.proofreader.SMailBodyMetaProofreader;
import org.dbflute.util.DfTypeUtil;

public class PostOffice {
    public static final String LOGGING_TITLE_SYSINFO = "sysInfo";
    public static final String LOGGING_TITLE_APPINFO = "appInfo";
    protected final SMailDeliveryDepartment deliveryDepartment;

    public PostOffice(SMailDeliveryDepartment deliveryDepartment) {
        if (deliveryDepartment == null) {
            throw new IllegalArgumentException("The argument 'deliveryDepartment' should not be null.");
        }
        this.deliveryDepartment = deliveryDepartment;
    }

    public void deliver(Postcard postcard) {
        postcard.officeCheck();
        SMailReceptionist receptionist = this.fetchReceptionist(postcard);
        receptionist.accept(postcard);
        this.proofreadIfNeeds(postcard);
        SMailPostalMotorbike motorbike = this.fetchMotorbike(postcard);
        SMailPostie postie = this.fetchPostie(postcard, motorbike);
        postie.deliver(postcard);
    }

    protected void proofreadIfNeeds(Postcard postcard) {
        if (this.needsProofreading(postcard)) {
            SMailTextProofreader proofreader = this.fetchProofreader(postcard);
            postcard.proofreadPlain((reading, varMap) -> proofreader.proofread((String)reading, (Map<String, Object>)varMap));
            if (postcard.hasHtmlBody()) {
                postcard.proofreadHtml((reading, varMap) -> proofreader.proofread((String)reading, (Map<String, Object>)varMap));
            }
        }
        if (this.needsSubjectHeader(postcard)) {
            this.proofreadSubjectHeader(postcard);
        }
    }

    protected boolean needsProofreading(Postcard postcard) {
        return !postcard.isWholeFixedTextUsed() && postcard.hasTemplateVariable();
    }

    protected boolean needsSubjectHeader(Postcard postcard) {
        return !postcard.isForcedlyDirect();
    }

    protected void proofreadSubjectHeader(Postcard postcard) {
        SMailBodyMetaProofreader proofreader = this.newMailSubjectHeaderProofreader(postcard);
        postcard.proofreadPlain((plainText, variableMap) -> proofreader.proofread((String)plainText, (Map<String, Object>)variableMap));
    }

    protected SMailBodyMetaProofreader newMailSubjectHeaderProofreader(Postcard postcard) {
        return new SMailBodyMetaProofreader(postcard);
    }

    protected SMailReceptionist fetchReceptionist(Postcard postcard) {
        return this.deliveryDepartment.getPersonnel().selectReceptionist(postcard);
    }

    protected SMailTextProofreader fetchProofreader(Postcard postcard) {
        return this.deliveryDepartment.getPersonnel().selectProofreader(postcard);
    }

    protected SMailPostalMotorbike fetchMotorbike(Postcard postcard) {
        return this.deliveryDepartment.getParkingLot().findMotorbike(postcard);
    }

    protected SMailPostie fetchPostie(Postcard postcard, SMailPostalMotorbike motorbike) {
        return this.deliveryDepartment.getPersonnel().selectPostie(postcard, motorbike);
    }

    public void workingDispose() {
        this.deliveryDepartment.workingDispose();
    }

    public String toString() {
        return DfTypeUtil.toClassTitle((Object)this) + ":{" + this.deliveryDepartment + "}@" + Integer.toHexString(this.hashCode());
    }

    public SMailDeliveryDepartment getDeliveryDepartment() {
        return this.deliveryDepartment;
    }
}

