/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.mail.send;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.dbflute.mail.DeliveryCategory;
import org.dbflute.mail.Postcard;
import org.dbflute.mail.send.SMailPostalMotorbike;
import org.dbflute.mail.send.exception.SMailIllegalStateException;
import org.dbflute.util.DfTypeUtil;

public class SMailPostalParkingLot {
    protected static final DeliveryCategory MAIN_CATEGORY = new DeliveryCategory("main");
    protected final Map<DeliveryCategory, SMailPostalMotorbike> motorbikeMap = new ConcurrentHashMap<DeliveryCategory, SMailPostalMotorbike>();

    public SMailPostalMotorbike findMotorbike(Postcard postcard) {
        DeliveryCategory category = (DeliveryCategory)postcard.getDeliveryCategory().orElse((Object)MAIN_CATEGORY);
        postcard.officeManagedLogging("sysInfo", "category", category.getCategory());
        SMailPostalMotorbike motorbike = this.motorbikeMap.get(category);
        if (motorbike == null) {
            String msg = "Not found the motorbike (session) by the category: " + category + ", " + this.motorbikeMap;
            throw new SMailIllegalStateException(msg);
        }
        return motorbike;
    }

    public void registerMotorbike(DeliveryCategory category, SMailPostalMotorbike motorbike) {
        this.motorbikeMap.put(category, motorbike);
    }

    public void registerMotorbikeAsMain(SMailPostalMotorbike motorbike) {
        this.registerMotorbike(MAIN_CATEGORY, motorbike);
    }

    public String toString() {
        return DfTypeUtil.toClassTitle((Object)this) + ":{" + this.motorbikeMap + "}@" + Integer.toHexString(this.hashCode());
    }
}

