/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.mail.send.embedded.postie;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.NoSuchProviderException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import javax.mail.internet.MimeUtility;
import javax.mail.util.ByteArrayDataSource;
import org.dbflute.helper.message.ExceptionMessageBuilder;
import org.dbflute.mail.CardView;
import org.dbflute.mail.Postcard;
import org.dbflute.mail.send.SMailAddress;
import org.dbflute.mail.send.SMailPostalMotorbike;
import org.dbflute.mail.send.SMailPostie;
import org.dbflute.mail.send.embedded.postie.SMailPostingMessage;
import org.dbflute.mail.send.exception.SMailIllegalStateException;
import org.dbflute.mail.send.exception.SMailMessageSettingFailureException;
import org.dbflute.mail.send.exception.SMailTransportFailureException;
import org.dbflute.mail.send.hook.SMailCallbackContext;
import org.dbflute.mail.send.hook.SMailPreparedMessageHook;
import org.dbflute.mail.send.supplement.async.SMailAsyncStrategy;
import org.dbflute.mail.send.supplement.async.SMailAsyncStrategyNone;
import org.dbflute.mail.send.supplement.attachment.SMailAttachment;
import org.dbflute.mail.send.supplement.filter.SMailAddressFilter;
import org.dbflute.mail.send.supplement.filter.SMailAddressFilterNone;
import org.dbflute.mail.send.supplement.filter.SMailBodyTextFilter;
import org.dbflute.mail.send.supplement.filter.SMailBodyTextFilterNone;
import org.dbflute.mail.send.supplement.filter.SMailCancelFilter;
import org.dbflute.mail.send.supplement.filter.SMailCancelFilterNone;
import org.dbflute.mail.send.supplement.filter.SMailSubjectFilter;
import org.dbflute.mail.send.supplement.filter.SMailSubjectFilterNone;
import org.dbflute.mail.send.supplement.header.SMailMailHeaderStrategy;
import org.dbflute.mail.send.supplement.header.SMailMailHeaderStrategyNone;
import org.dbflute.mail.send.supplement.inetaddr.SMailInternetAddressCreator;
import org.dbflute.mail.send.supplement.inetaddr.SMailNormalInternetAddressCreator;
import org.dbflute.mail.send.supplement.label.SMailLabelStrategy;
import org.dbflute.mail.send.supplement.label.SMailLabelStrategyNone;
import org.dbflute.mail.send.supplement.logging.SMailLoggingStrategy;
import org.dbflute.mail.send.supplement.logging.SMailTypicalLoggingStrategy;
import org.dbflute.mail.send.supplement.retry.SMailRetryStrategy;
import org.dbflute.mail.send.supplement.retry.SMailRetryStrategyNone;
import org.dbflute.optional.OptionalThing;
import org.dbflute.system.DBFluteSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SMailHonestPostie
implements SMailPostie {
    private static final Logger logger = LoggerFactory.getLogger(SMailHonestPostie.class);
    private static final SMailCancelFilter noneCancelFilter = new SMailCancelFilterNone();
    private static final SMailAddressFilter noneAddressFilter = new SMailAddressFilterNone();
    private static final SMailSubjectFilter noneSubjectFilter = new SMailSubjectFilterNone();
    private static final SMailBodyTextFilter noneBodyTextFilter = new SMailBodyTextFilterNone();
    private static final SMailAsyncStrategy noneAsyncStrategy = new SMailAsyncStrategyNone();
    private static final SMailRetryStrategy noneRetryStrategy = new SMailRetryStrategyNone();
    private static final SMailLabelStrategy noneLabelStrategy = new SMailLabelStrategyNone();
    private static final SMailLoggingStrategy typicalLoggingStrategy = new SMailTypicalLoggingStrategy();
    private static final SMailMailHeaderStrategy noneMailHeaderStrategy = new SMailMailHeaderStrategyNone();
    private static final SMailInternetAddressCreator normalInternetAddressCreator = new SMailNormalInternetAddressCreator();
    protected final SMailPostalMotorbike motorbike;
    protected SMailCancelFilter cancelFilter = noneCancelFilter;
    protected SMailAddressFilter addressFilter = noneAddressFilter;
    protected SMailSubjectFilter subjectFilter = noneSubjectFilter;
    protected SMailBodyTextFilter bodyTextFilter = noneBodyTextFilter;
    protected SMailAsyncStrategy asyncStrategy = noneAsyncStrategy;
    protected SMailRetryStrategy retryStrategy = noneRetryStrategy;
    protected SMailLabelStrategy labelStrategy = noneLabelStrategy;
    protected SMailLoggingStrategy loggingStrategy = typicalLoggingStrategy;
    protected SMailMailHeaderStrategy mailHeaderStrategy = noneMailHeaderStrategy;
    protected SMailInternetAddressCreator internetAddressCreator = normalInternetAddressCreator;
    protected boolean training;
    protected OptionalThing<String> textTransferEncoding = OptionalThing.empty();

    public SMailHonestPostie(SMailPostalMotorbike motorbike) {
        this.assertArgumentNotNull("motorbike", motorbike);
        this.motorbike = motorbike;
    }

    public SMailHonestPostie withCancelFilter(SMailCancelFilter cancelFilter) {
        this.assertArgumentNotNull("cancelFilter", cancelFilter);
        this.cancelFilter = cancelFilter;
        return this;
    }

    public SMailHonestPostie withAddressFilter(SMailAddressFilter addressFilter) {
        this.assertArgumentNotNull("addressFilter", addressFilter);
        this.addressFilter = addressFilter;
        return this;
    }

    public SMailHonestPostie withSubjectFilter(SMailSubjectFilter subjectFilter) {
        this.assertArgumentNotNull("subjectFilter", subjectFilter);
        this.subjectFilter = subjectFilter;
        return this;
    }

    public SMailHonestPostie withBodyTextFilter(SMailBodyTextFilter bodyTextFilter) {
        this.assertArgumentNotNull("bodyTextFilter", bodyTextFilter);
        this.bodyTextFilter = bodyTextFilter;
        return this;
    }

    public SMailHonestPostie withAsyncStrategy(SMailAsyncStrategy asyncStrategy) {
        this.assertArgumentNotNull("asyncStrategy", asyncStrategy);
        this.asyncStrategy = asyncStrategy;
        return this;
    }

    public SMailHonestPostie withRetryStrategy(SMailRetryStrategy retryStrategy) {
        this.assertArgumentNotNull("retryStrategy", retryStrategy);
        this.retryStrategy = retryStrategy;
        return this;
    }

    public SMailHonestPostie withLabelStrategy(SMailLabelStrategy labelStrategy) {
        this.assertArgumentNotNull("labelStrategy", labelStrategy);
        this.labelStrategy = labelStrategy;
        return this;
    }

    public SMailHonestPostie withLoggingStrategy(SMailLoggingStrategy loggingStrategy) {
        this.assertArgumentNotNull("loggingStrategy", loggingStrategy);
        this.loggingStrategy = loggingStrategy;
        return this;
    }

    public SMailHonestPostie withMailHeaderStrategy(SMailMailHeaderStrategy mailHeaderStrategy) {
        this.assertArgumentNotNull("mailHeaderStrategy", mailHeaderStrategy);
        this.mailHeaderStrategy = mailHeaderStrategy;
        return this;
    }

    public SMailHonestPostie withInternetAddressCreator(SMailInternetAddressCreator internetAddressCreator) {
        this.assertArgumentNotNull("internetAddressCreator", internetAddressCreator);
        this.internetAddressCreator = internetAddressCreator;
        return this;
    }

    public SMailHonestPostie asTraining() {
        this.training = true;
        return this;
    }

    @Override
    public void deliver(Postcard postcard) {
        SMailPostingMessage message = this.createMailMessage(postcard);
        if (this.isCancel(postcard)) {
            return;
        }
        this.prepareAddress(postcard, message);
        this.prepareSubject(postcard, message);
        this.prepareBody(postcard, message);
        this.prepareAsync(postcard);
        this.prepareRetry(postcard);
        this.disclosePostingState(postcard, message);
        this.hookPreparedMessage(postcard, message);
        if (postcard.isDryrun()) {
            logger.debug("*dryrun: postcard={}", (Object)postcard);
            return;
        }
        this.send(postcard, message);
    }

    protected SMailPostingMessage createMailMessage(CardView view) {
        MimeMessage mimeMessage = this.createMimeMessage(view, this.extractNativeSession(view, this.motorbike));
        Map<String, Object> pushedLoggingMap = view.getPushedLoggingMap();
        Map<String, Map<String, Object>> officeManagedLoggingMap = view.getOfficeManagedLoggingMap();
        return new SMailPostingMessage(mimeMessage, this.motorbike, this.training, pushedLoggingMap, officeManagedLoggingMap);
    }

    protected Session extractNativeSession(CardView view, SMailPostalMotorbike motorbike) {
        return motorbike.getNativeSession();
    }

    protected MimeMessage createMimeMessage(CardView view, Session session) {
        return new MimeMessage(session);
    }

    protected boolean isCancel(CardView view) {
        return this.cancelFilter.isCancel(view);
    }

    protected void prepareAddress(CardView view, SMailPostingMessage message) {
        OptionalThing<Address> opt;
        SMailAddress from = (SMailAddress)view.getFrom().orElseThrow(() -> new SMailIllegalStateException("Not found the from address in the postcard: " + view));
        Address filteredFrom = this.addressFilter.filterFrom(view, this.toInternetAddress(view, from));
        message.setFrom(this.verifyFilteredFromAddress(view, filteredFrom));
        boolean existsToAddress = false;
        for (SMailAddress to : view.getToList()) {
            opt = this.addressFilter.filterTo(view, this.toInternetAddress(view, to));
            this.verifyFilteredOptionalAddress(view, opt).ifPresent(address -> message.addTo((Address)address));
            if (!opt.isPresent()) continue;
            existsToAddress = true;
        }
        this.verifyFilteredToAddressExists(view, existsToAddress);
        for (SMailAddress cc : view.getCcList()) {
            opt = this.addressFilter.filterCc(view, this.toInternetAddress(view, cc));
            this.verifyFilteredOptionalAddress(view, opt).ifPresent(address -> message.addCc((Address)address));
        }
        for (SMailAddress bcc : view.getBccList()) {
            opt = this.addressFilter.filterBcc(view, this.toInternetAddress(view, bcc));
            this.verifyFilteredOptionalAddress(view, opt).ifPresent(address -> message.addBcc((Address)address));
        }
        List<SMailAddress> replyToList = view.getReplyToList();
        if (!replyToList.isEmpty()) {
            ArrayList<Address> filteredList = new ArrayList<Address>(replyToList.size());
            for (SMailAddress replyTo : replyToList) {
                OptionalThing<Address> opt2 = this.addressFilter.filterReplyTo(view, this.toInternetAddress(view, replyTo));
                this.verifyFilteredOptionalAddress(view, opt2).ifPresent(address -> filteredList.add((Address)address));
            }
            message.setReplyTo(filteredList);
        }
    }

    protected Address toInternetAddress(CardView view, SMailAddress address) {
        return this.createAddress(view, address);
    }

    protected Address createAddress(CardView view, SMailAddress address) {
        InternetAddress internetAddress;
        try {
            internetAddress = this.createInternetAddress(view, address.getAddress(), this.isStrictAddress());
        }
        catch (AddressException e) {
            throw new IllegalStateException("Failed to create internet address: " + address, e);
        }
        address.getPersonal().ifPresent(personal -> {
            String encoding = this.getPersonalEncoding();
            try {
                Locale locale = (Locale)view.getReceiverLocale().orElseGet(() -> this.getDefaultReceiverLocale());
                String resolved = this.labelStrategy.resolveLabel(view, locale, (String)personal);
                internetAddress.setPersonal(resolved, encoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException("Unknown encoding for personal: encoding=" + encoding + " personal=" + personal, e);
            }
        });
        return internetAddress;
    }

    protected boolean isStrictAddress() {
        return true;
    }

    protected InternetAddress createInternetAddress(CardView view, String address, boolean strict) throws AddressException {
        return this.internetAddressCreator.create(view, address, strict);
    }

    protected String getPersonalEncoding() {
        return this.getBasicEncoding();
    }

    protected Locale getDefaultReceiverLocale() {
        return DBFluteSystem.getFinalLocale();
    }

    protected Address verifyFilteredFromAddress(CardView view, Address filteredFrom) {
        if (filteredFrom == null) {
            String msg = "The filtered from-address should not be null: postcard=" + view;
            throw new SMailIllegalStateException(msg);
        }
        return filteredFrom;
    }

    protected OptionalThing<Address> verifyFilteredOptionalAddress(CardView view, OptionalThing<Address> opt) {
        if (opt == null) {
            String msg = "The filtered optional should not be null: postcard=" + view;
            throw new SMailIllegalStateException(msg);
        }
        return opt;
    }

    protected void verifyFilteredToAddressExists(CardView view, boolean existsToAddress) {
        if (!existsToAddress) {
            String msg = "Empty to-address by filtering: specifiedToAddress=" + view.getToList();
            throw new SMailIllegalStateException(msg);
        }
    }

    protected void prepareSubject(CardView view, SMailPostingMessage message) {
        message.setSubject(this.getSubject(view), this.getSubjectEncoding());
    }

    protected String getSubject(CardView view) {
        return this.subjectFilter.filterSubject(view, (String)view.getSubject().get());
    }

    protected String getSubjectEncoding() {
        return this.getBasicEncoding();
    }

    protected void prepareBody(CardView view, SMailPostingMessage message) {
        String plainText = this.toCompletePlainText(view);
        OptionalThing<String> optHtmlText = this.toCompleteHtmlText(view);
        message.savePlainTextForDisplay(plainText);
        message.saveHtmlTextForDisplay(optHtmlText);
        Map<String, SMailAttachment> attachmentMap = view.getAttachmentMap();
        MimeMessage nativeMessage = message.getMimeMessage();
        if (attachmentMap.isEmpty()) {
            this.setupTextPart(view, (MimePart)nativeMessage, plainText, TextType.PLAIN);
            optHtmlText.ifPresent(htmlText -> this.setupTextPart(view, (MimePart)nativeMessage, (String)htmlText, TextType.HTML));
        } else {
            if (optHtmlText.isPresent()) {
                throw new SMailIllegalStateException("Unsupported HTML mail with attachment for now: postcard=" + view);
            }
            try {
                MimeMultipart multipart = this.createTextWithAttachmentMultipart(view, message, plainText, attachmentMap);
                nativeMessage.setContent((Multipart)multipart);
            }
            catch (MessagingException e) {
                String msg = "Failed to set attachment multipart content: postcard=" + view;
                throw new SMailIllegalStateException(msg, e);
            }
        }
    }

    protected String toCompletePlainText(CardView view) {
        return (String)view.toCompletePlainText().map(plainText -> this.bodyTextFilter.filterBody(view, (String)plainText, false)).get();
    }

    protected OptionalThing<String> toCompleteHtmlText(CardView view) {
        return view.toCompleteHtmlText().map(htmlText -> this.bodyTextFilter.filterBody(view, (String)htmlText, true));
    }

    protected MimeMultipart createTextWithAttachmentMultipart(CardView view, SMailPostingMessage message, String plain, Map<String, SMailAttachment> attachmentMap) throws MessagingException {
        MimeMultipart multipart = this.newMimeMultipart();
        multipart.setSubType("mixed");
        multipart.addBodyPart((BodyPart)this.setupTextPart(view, (MimePart)this.newMimeBodyPart(), plain, TextType.PLAIN));
        for (Map.Entry<String, SMailAttachment> entry : attachmentMap.entrySet()) {
            SMailAttachment attachment = entry.getValue();
            multipart.addBodyPart((BodyPart)this.setupAttachmentPart(view, message, attachment));
        }
        return multipart;
    }

    protected MimeMultipart newMimeMultipart() {
        return new MimeMultipart();
    }

    protected MimeBodyPart newMimeBodyPart() {
        return new MimeBodyPart();
    }

    protected MimePart setupTextPart(CardView view, MimePart part, String text, TextType textType) {
        this.assertArgumentNotNull("view", view);
        this.assertArgumentNotNull("part", part);
        this.assertArgumentNotNull("text", text);
        this.assertArgumentNotNull("textType", (Object)textType);
        String textEncoding = this.getTextEncoding(view);
        ByteBuffer buffer = this.prepareTextByteBuffer(view, text, textEncoding);
        ByteArrayDataSource source = this.prepareTextDataSource(view, buffer);
        try {
            part.setDataHandler(this.createDataHandler((DataSource)source));
            if (!this.isSuppressTextTransferEncoding(view)) {
                part.setHeader("Content-Transfer-Encoding", this.getTextTransferEncoding(view));
            }
            part.setHeader("Content-Type", this.buildTextContentType(view, textType, textEncoding));
        }
        catch (MessagingException e) {
            throw new SMailMessageSettingFailureException("Failed to set headers: postcard=" + view, e);
        }
        return part;
    }

    protected String getTextEncoding(CardView view) {
        return (String)this.mailHeaderStrategy.getTextEncoding(view).orElseGet(() -> this.getBasicEncoding());
    }

    protected ByteBuffer prepareTextByteBuffer(CardView view, String text, String encoding) {
        ByteBuffer buffer;
        try {
            buffer = ByteBuffer.wrap(text.getBytes(encoding));
        }
        catch (UnsupportedEncodingException e) {
            throw new SMailMessageSettingFailureException("Unknown encoding: " + encoding, e);
        }
        return buffer;
    }

    protected ByteArrayDataSource prepareTextDataSource(CardView view, ByteBuffer buffer) {
        return new ByteArrayDataSource(buffer.array(), this.getTextMimeType(view));
    }

    protected String getTextMimeType(CardView view) {
        return (String)this.mailHeaderStrategy.getTextMimeType(view).orElseGet(() -> "application/octet-stream");
    }

    protected boolean isSuppressTextTransferEncoding(CardView view) {
        return this.mailHeaderStrategy.isSuppressTextTransferEncoding();
    }

    protected String getTextTransferEncoding(CardView view) {
        return (String)this.mailHeaderStrategy.getTextTransferEncoding(view).orElseGet(() -> "base64");
    }

    protected String buildTextContentType(CardView view, TextType textType, String encoding) {
        return "text/" + textType.code() + "; charset=\"" + encoding + "\"";
    }

    protected MimePart setupAttachmentPart(CardView view, SMailPostingMessage message, SMailAttachment attachment) {
        this.assertArgumentNotNull("view", view);
        this.assertArgumentNotNull("message", message);
        this.assertArgumentNotNull("attachment", attachment);
        MimeBodyPart part = this.newMimeBodyPart();
        OptionalThing<String> textEncoding = this.getAttachmentTextEncoding(view, attachment);
        DataSource source = this.prepareAttachmentDataSource(view, message, attachment, textEncoding);
        String contentType = this.buildAttachmentContentType(view, attachment, textEncoding);
        String contentDisposition = this.buildAttachmentContentDisposition(view, attachment, textEncoding);
        try {
            part.setDataHandler(this.createDataHandler(source));
            if (!this.isSuppressAttachmentTransferEncoding(view)) {
                part.setHeader("Content-Transfer-Encoding", this.getAttachmentTransferEncoding(view));
            }
            part.setHeader("Content-Type", contentType);
            part.setHeader("Content-Disposition", contentDisposition);
        }
        catch (MessagingException e) {
            String msg = "Failed to set headers: " + attachment;
            throw new SMailMessageSettingFailureException(msg, e);
        }
        return part;
    }

    protected OptionalThing<String> getAttachmentTextEncoding(CardView view, SMailAttachment attachment) {
        return attachment.getTextEncoding();
    }

    protected DataSource prepareAttachmentDataSource(CardView view, SMailPostingMessage message, SMailAttachment attachment, OptionalThing<String> textEncoding) {
        byte[] attachedBytes = this.readAttachedBytes(view, attachment);
        message.saveAttachmentForDisplay(attachment, attachedBytes, textEncoding);
        return new ByteArrayDataSource(attachedBytes, this.getAttachmentMimeType(view));
    }

    protected byte[] readAttachedBytes(CardView view, SMailAttachment attachment) {
        InputStream ins = attachment.getReourceStream();
        ByteArrayOutputStream ous = null;
        try {
            int length;
            ous = new ByteArrayOutputStream();
            byte[] buffer = new byte[8192];
            while ((length = ins.read(buffer)) > 0) {
                ous.write(buffer, 0, length);
            }
            byte[] byArray = ous.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            String msg = "Failed to read the attached stream as bytes: " + attachment;
            throw new SMailIllegalStateException(msg, e);
        }
        finally {
            if (ous != null) {
                try {
                    ous.close();
                }
                catch (IOException iOException) {}
            }
            try {
                ins.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected String getAttachmentMimeType(CardView view) {
        return (String)this.mailHeaderStrategy.getAttachmentMimeType(view).orElseGet(() -> "application/octet-stream");
    }

    protected String buildAttachmentContentType(CardView view, SMailAttachment attachment, OptionalThing<String> textEncoding) {
        String encodedFilename = this.getEncodedFilename(view, attachment.getFilenameOnHeader());
        StringBuilder sb = new StringBuilder();
        String contentType = attachment.getContentType();
        sb.append(contentType);
        if (contentType.equals("text/plain")) {
            sb.append("; charset=").append((String)textEncoding.get());
        }
        sb.append("; name=\"").append(encodedFilename).append("\"");
        return sb.toString();
    }

    protected String buildAttachmentContentDisposition(CardView view, SMailAttachment attachment, OptionalThing<String> textEncoding) {
        String encodedFilename = this.getEncodedFilename(view, attachment.getFilenameOnHeader());
        StringBuilder sb = new StringBuilder();
        sb.append("attachment; filename=\"").append(encodedFilename).append("\"");
        return sb.toString();
    }

    protected String getEncodedFilename(CardView view, String filename) {
        String encodedFilename;
        String filenameEncoding = this.getAttachmentFilenameEncoding(view);
        try {
            encodedFilename = MimeUtility.encodeText((String)filename, (String)filenameEncoding, (String)"B");
        }
        catch (UnsupportedEncodingException e) {
            throw new SMailMessageSettingFailureException("Unknown encoding: " + filenameEncoding, e);
        }
        return encodedFilename;
    }

    protected String getAttachmentFilenameEncoding(CardView view) {
        return this.getBasicEncoding();
    }

    protected boolean isSuppressAttachmentTransferEncoding(CardView view) {
        return this.mailHeaderStrategy.isSuppressAttachmentTransferEncoding();
    }

    protected String getAttachmentTransferEncoding(CardView view) {
        return (String)this.mailHeaderStrategy.getAttachmentTransferEncoding(view).orElseGet(() -> "base64");
    }

    protected void prepareAsync(Postcard postcard) {
        if (this.asyncStrategy.alwaysAsync(postcard) && !postcard.isAsync()) {
            logger.debug("...Calling async() automatically by strategy: {}", (Object)this.asyncStrategy);
            postcard.async();
        }
    }

    protected void prepareRetry(Postcard postcard) {
        this.retryStrategy.retry(postcard, (retryCount, intervalMillis) -> {
            if (postcard.getRetryCount() == 0) {
                logger.debug("...Calling retry({}, {}) automatically by strategy: {}", new Object[]{retryCount, intervalMillis, this.asyncStrategy});
                postcard.retry(retryCount, intervalMillis);
            }
        });
    }

    protected void disclosePostingState(Postcard postcard, SMailPostingMessage message) {
        postcard.officeDisclosePostingState(message);
    }

    protected void hookPreparedMessage(Postcard postcard, SMailPostingMessage message) {
        if (SMailCallbackContext.isExistPreparedMessageHookOnThread()) {
            SMailCallbackContext context = SMailCallbackContext.getCallbackContextOnThread();
            SMailPreparedMessageHook hook = context.getPreparedMessageHook();
            hook.hookPreparedMessage(postcard, message);
        }
    }

    protected void send(Postcard postcard, SMailPostingMessage message) {
        if (this.needsAsync(postcard)) {
            this.asyncStrategy.async(postcard, () -> this.doSend(postcard, message));
        } else {
            this.doSend(postcard, message);
        }
    }

    protected boolean needsAsync(Postcard postcard) {
        return postcard.isAsync() && !postcard.isDefinitelySync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSend(Postcard postcard, SMailPostingMessage message) {
        block6: {
            this.logMailBefore(postcard, message);
            RuntimeException cause = null;
            try {
                this.retryableSend(postcard, message);
            }
            catch (RuntimeException e) {
                cause = e;
                if (postcard.isSuppressSendFailure()) {
                    this.logSuppressedCause(postcard, message, e);
                    break block6;
                }
                throw e;
            }
            finally {
                this.logMailFinally(postcard, message, cause);
            }
        }
    }

    protected void logMailBefore(Postcard postcard, SMailPostingMessage message) {
        this.loggingStrategy.logMailBefore(postcard, message);
    }

    protected void logSuppressedCause(Postcard postcard, SMailPostingMessage message, RuntimeException e) {
        this.loggingStrategy.logSuppressedCause(postcard, message, e);
    }

    protected void logMailFinally(Postcard postcard, SMailPostingMessage message, RuntimeException cause) {
        this.loggingStrategy.logMailFinally(postcard, message, (OptionalThing<Exception>)OptionalThing.ofNullable((Object)cause, () -> {
            throw new IllegalStateException("Not found the exception for the mail finally: " + postcard);
        }));
    }

    protected void retryableSend(Postcard postcard, SMailPostingMessage message) {
        int retryCount = this.getRetryCount(postcard);
        long intervalMillis = this.getIntervalMillis(postcard);
        int challengeCount = 0;
        Throwable firstCause = null;
        while (true) {
            if (challengeCount > retryCount) {
                if (firstCause == null) break;
                this.handleSendFailure(postcard, message, (Exception)firstCause);
                break;
            }
            try {
                if (challengeCount > 0) {
                    this.waitBeforeRetrySending(intervalMillis);
                }
                this.stagingSend(postcard, message);
                if (challengeCount <= 0) break;
                this.logRetrySuccess(postcard, message, challengeCount, (Exception)firstCause);
            }
            catch (RuntimeException | MessagingException e) {
                if (firstCause == null) {
                    firstCause = e;
                }
                ++challengeCount;
                continue;
            }
            break;
        }
    }

    protected int getRetryCount(Postcard postcard) {
        return postcard.getRetryCount();
    }

    protected long getIntervalMillis(Postcard postcard) {
        return postcard.getIntervalMillis();
    }

    protected void waitBeforeRetrySending(long intervalMillis) {
        if (intervalMillis > 0L) {
            try {
                Thread.sleep(intervalMillis);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    protected void logRetrySuccess(Postcard postcard, SMailPostingMessage message, int challengeCount, Exception firstCause) {
        this.loggingStrategy.logRetrySuccess(postcard, message, challengeCount, firstCause);
    }

    protected void handleSendFailure(Postcard postcard, SMailPostingMessage message, Exception e) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Failed to send the mail message.");
        br.addItem("Postcard");
        br.addElement((Object)postcard);
        br.addItem("Posting Message");
        br.addElement((Object)Integer.hashCode(message.hashCode()));
        br.addElement((Object)message);
        String msg = br.buildExceptionMessage();
        throw new SMailTransportFailureException(msg, e);
    }

    protected void stagingSend(Postcard postcard, SMailPostingMessage message) throws MessagingException {
        if (!this.training) {
            this.actuallySend(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void actuallySend(SMailPostingMessage message) throws MessagingException {
        Transport transport = this.prepareTransport();
        try {
            MimeMessage mimeMessage = message.getMimeMessage();
            transport.connect();
            transport.sendMessage((Message)mimeMessage, mimeMessage.getAllRecipients());
            message.acceptSentTransport(transport);
        }
        finally {
            this.closeTransport(transport);
        }
    }

    protected Transport prepareTransport() throws NoSuchProviderException {
        return this.motorbike.getNativeSession().getTransport();
    }

    protected void closeTransport(Transport transport) {
        try {
            transport.close();
        }
        catch (MessagingException continued) {
            logger.warn("Failed to close the transport: " + transport, (Throwable)continued);
        }
    }

    protected String getBasicEncoding() {
        return "UTF-8";
    }

    protected DataHandler createDataHandler(DataSource source) {
        return new DataHandler(source);
    }

    protected void assertArgumentNotNull(String variableName, Object value) {
        if (variableName == null) {
            throw new IllegalArgumentException("The variableName should not be null.");
        }
        if (value == null) {
            throw new IllegalArgumentException("The argument '" + variableName + "' should not be null.");
        }
    }

    public boolean isTraining() {
        return this.training;
    }

    protected static enum TextType {
        PLAIN("plain"),
        HTML("html");

        private final String code;

        private TextType(String code) {
            this.code = code;
        }

        public String code() {
            return this.code;
        }
    }
}

