/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.mail.send.embedded.postie;

import com.sun.mail.smtp.SMTPTransport;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Transport;
import javax.mail.internet.MimeMessage;
import org.dbflute.helper.filesystem.FileTextIO;
import org.dbflute.mail.send.SMailPostalMotorbike;
import org.dbflute.mail.send.exception.SMailIllegalStateException;
import org.dbflute.mail.send.exception.SMailMessageSettingFailureException;
import org.dbflute.mail.send.supplement.SMailPostingDiscloser;
import org.dbflute.mail.send.supplement.attachment.SMailAttachment;
import org.dbflute.mail.send.supplement.attachment.SMailReadAttachedData;
import org.dbflute.optional.OptionalThing;
import org.dbflute.util.Srl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SMailPostingMessage
implements SMailPostingDiscloser {
    private static final Logger logger = LoggerFactory.getLogger(SMailPostingMessage.class);
    protected static final String LF = "\n";
    protected final MimeMessage message;
    protected final SMailPostalMotorbike motorbike;
    protected final boolean training;
    protected final Map<String, Object> pushedLoggingMap;
    protected final Map<String, Map<String, Object>> officeManagedLoggingMap;
    protected String subject;
    protected Address from;
    protected List<Address> toList;
    protected List<Address> ccList;
    protected List<Address> bccList;
    protected List<Address> replyToList;
    protected String plainText;
    protected OptionalThing<String> optHtmlText = OptionalThing.empty();
    protected Map<String, SMailReadAttachedData> attachmentMap;
    protected Integer lastReturnCode;
    protected String lastServerResponse;

    public SMailPostingMessage(MimeMessage message, SMailPostalMotorbike motorbike, boolean training, Map<String, Object> pushedLoggingMap, Map<String, Map<String, Object>> officeManagedLoggingMap) {
        this.assertArgumentNotNull("message", message);
        this.assertArgumentNotNull("motorbike", motorbike);
        this.assertArgumentNotNull("pushedLoggingMap", pushedLoggingMap);
        this.assertArgumentNotNull("officeManagedLoggingMap", officeManagedLoggingMap);
        this.message = message;
        this.motorbike = motorbike;
        this.training = training;
        this.pushedLoggingMap = pushedLoggingMap;
        this.officeManagedLoggingMap = officeManagedLoggingMap;
    }

    public void setFrom(Address address) {
        this.assertArgumentNotNull("address", address);
        this.from = address;
        try {
            this.message.setFrom(address);
        }
        catch (MessagingException e) {
            String msg = this.buildAddressSettingFailureMessage("from", address);
            throw new SMailMessageSettingFailureException(msg, e);
        }
    }

    public void addTo(Address address) {
        this.assertArgumentNotNull("address", address);
        this.saveTo(address);
        try {
            this.message.addRecipient(Message.RecipientType.TO, address);
        }
        catch (MessagingException e) {
            String msg = this.buildAddressSettingFailureMessage("to", address);
            throw new SMailMessageSettingFailureException(msg, e);
        }
    }

    protected void saveTo(Address address) {
        if (this.toList == null) {
            this.toList = new ArrayList<Address>(2);
        }
        this.toList.add(address);
    }

    public void addCc(Address address) {
        this.assertArgumentNotNull("address", address);
        this.saveCc(address);
        try {
            this.message.addRecipient(Message.RecipientType.CC, address);
        }
        catch (MessagingException e) {
            String msg = this.buildAddressSettingFailureMessage("cc", address);
            throw new SMailMessageSettingFailureException(msg, e);
        }
    }

    protected void saveCc(Address address) {
        if (this.ccList == null) {
            this.ccList = new ArrayList<Address>(2);
        }
        this.ccList.add(address);
    }

    public void addBcc(Address address) {
        this.assertArgumentNotNull("address", address);
        this.saveBcc(address);
        try {
            this.message.addRecipient(Message.RecipientType.BCC, address);
        }
        catch (MessagingException e) {
            String msg = this.buildAddressSettingFailureMessage("bcc", address);
            throw new SMailMessageSettingFailureException(msg, e);
        }
    }

    protected void saveBcc(Address address) {
        if (this.bccList == null) {
            this.bccList = new ArrayList<Address>(2);
        }
        this.bccList.add(address);
    }

    public void setReplyTo(List<Address> addressList) {
        this.assertArgumentNotNull("addressList", addressList);
        this.saveReplyTo(addressList);
        try {
            this.message.setReplyTo(addressList.toArray(new Address[addressList.size()]));
        }
        catch (MessagingException e) {
            String msg = this.buildAddressSettingFailureMessage("reply-to", addressList);
            throw new SMailMessageSettingFailureException(msg, e);
        }
    }

    protected void saveReplyTo(List<Address> addressList) {
        this.replyToList = addressList;
    }

    public void setSubject(String subject, String encoding) {
        this.assertArgumentNotNull("encoding", encoding);
        this.saveSubject(subject);
        try {
            this.message.setSubject(subject, encoding);
        }
        catch (MessagingException e) {
            String msg = "Failed to set subject: " + subject + " message=" + this.message;
            throw new SMailMessageSettingFailureException(msg, e);
        }
    }

    protected void saveSubject(String subject) {
        this.assertArgumentNotNull("subject", subject);
        this.subject = subject;
    }

    public void savePlainTextForDisplay(String plainText) {
        this.assertArgumentNotNull("plainText", plainText);
        this.plainText = plainText;
    }

    public void saveHtmlTextForDisplay(OptionalThing<String> optHtmlText) {
        this.assertArgumentNotNull("optHtmlText", optHtmlText);
        this.optHtmlText = optHtmlText;
    }

    public void saveAttachmentForDisplay(SMailAttachment attachment, byte[] attachedBytes, OptionalThing<String> textEncoding) {
        this.assertArgumentNotNull("attachment", attachment);
        this.assertArgumentNotNull("attachedBytes", attachedBytes);
        this.assertArgumentNotNull("textEncoding", textEncoding);
        if (this.attachmentMap == null) {
            this.attachmentMap = new LinkedHashMap<String, SMailReadAttachedData>(2);
        }
        String filenameOnHeader = attachment.getFilenameOnHeader();
        String contentType = attachment.getContentType();
        SMailReadAttachedData attachedData = this.newMailReadAttachedData(filenameOnHeader, contentType, attachedBytes, textEncoding);
        this.attachmentMap.put(filenameOnHeader, attachedData);
    }

    protected SMailReadAttachedData newMailReadAttachedData(String filenameOnHeader, String contentType, byte[] attachedBytes, OptionalThing<String> textEncoding) {
        return new SMailReadAttachedData(filenameOnHeader, contentType, attachedBytes, textEncoding);
    }

    protected String buildAddressSettingFailureMessage(String title, Address address) {
        return "Failed to set '" + title + "' address: " + address + " message=" + this.message;
    }

    protected String buildAddressSettingFailureMessage(String title, List<Address> addressList) {
        return "Failed to set '" + title + "' addresses: " + addressList + " message=" + this.message;
    }

    public void acceptSentTransport(Transport transport) {
        if (transport instanceof SMTPTransport) {
            SMTPTransport smtp = (SMTPTransport)transport;
            this.lastReturnCode = smtp.getLastReturnCode();
            this.lastServerResponse = smtp.getLastServerResponse();
        }
    }

    @Override
    public String toDisplay() {
        StringBuilder sb = new StringBuilder();
        sb.append("/= = = = = = = = = = = = = = = = = = = = = = = = = = Mail Message");
        sb.append(LF).append("subject: " + this.subject);
        sb.append(LF).append("   from: " + this.from);
        if (this.toList != null && !this.toList.isEmpty()) {
            sb.append(LF).append("     to: " + (this.toList.size() == 1 ? this.toList.get(0) : this.toList));
        }
        if (this.ccList != null && !this.ccList.isEmpty()) {
            sb.append(LF).append("     cc: " + (this.ccList.size() == 1 ? this.ccList.get(0) : this.ccList));
        }
        if (this.bccList != null && !this.bccList.isEmpty()) {
            sb.append(LF).append("    bcc: " + (this.bccList.size() == 1 ? this.bccList.get(0) : this.bccList));
        }
        if (this.replyToList != null && !this.replyToList.isEmpty()) {
            sb.append(LF).append("  reply: " + (this.replyToList.size() == 1 ? this.replyToList.get(0) : this.replyToList));
        }
        this.motorbike.getReturnPath().ifPresent(returnPath -> sb.append(LF).append(" return: " + returnPath));
        if (this.officeManagedLoggingMap != null && !this.officeManagedLoggingMap.isEmpty()) {
            this.officeManagedLoggingMap.forEach((title, valueMap) -> sb.append(LF).append(Srl.lfill((String)title, (int)7, (Character)Character.valueOf(' '))).append(": ").append(valueMap));
        }
        if (this.pushedLoggingMap != null && !this.pushedLoggingMap.isEmpty()) {
            sb.append(LF).append(Srl.lfill((String)"appInfo", (int)7, (Character)Character.valueOf(' '))).append(": ").append(this.pushedLoggingMap);
        }
        sb.append(LF).append(">>>");
        sb.append(LF).append(this.plainText);
        this.optHtmlText.ifPresent(htmlText -> {
            sb.append(LF).append(" - - - - - - - - - - (HTML)");
            sb.append(LF).append((String)htmlText);
        });
        if (this.attachmentMap != null && !this.attachmentMap.isEmpty()) {
            sb.append(LF).append(" - - - - - - - - - - (Attachment)");
            this.attachmentMap.forEach((filenameOnHeader, attachedData) -> this.buildAttachmentDisplay(sb, (String)filenameOnHeader, (SMailReadAttachedData)attachedData));
        }
        sb.append(LF).append("= = = = = = = = = =/");
        return sb.toString();
    }

    protected void buildAttachmentDisplay(StringBuilder sb, String filenameOnHeader, SMailReadAttachedData attachedData) {
        String contentType = attachedData.getContentType();
        sb.append(LF).append("*").append(filenameOnHeader).append(" (").append(contentType).append(")");
        if ("text/plain".equals(contentType)) {
            String attachedText;
            String textEncoding = (String)attachedData.getTextEncoding().get();
            try {
                attachedText = new String(attachedData.getAttachedBytes(), textEncoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new SMailIllegalStateException("Unknown encoding: " + textEncoding);
            }
            sb.append(":").append(LF).append(attachedText);
        }
    }

    @Override
    public String toHash() {
        return Integer.toHexString(this.hashCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void makeEmlFile(String path) {
        this.assertArgumentNotNull("path", path);
        ByteArrayOutputStream ous = null;
        try {
            ous = new ByteArrayOutputStream();
            this.message.writeTo((OutputStream)ous);
            String eml = ous.toString();
            new FileTextIO().encodeAsUTF8().write(path, eml);
        }
        catch (IOException | MessagingException e) {
            logger.info("Failed to make EML file to the path: " + path + " subject=" + this.subject, e);
        }
        finally {
            if (ous != null) {
                try {
                    ous.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected void assertArgumentNotNull(String variableName, Object value) {
        if (variableName == null) {
            throw new IllegalArgumentException("The variableName should not be null.");
        }
        if (value == null) {
            throw new IllegalArgumentException("The argument '" + variableName + "' should not be null.");
        }
    }

    public String toString() {
        return "message:{" + this.message + ", " + this.subject + "}";
    }

    @Override
    public MimeMessage getMimeMessage() {
        return this.message;
    }

    @Override
    public boolean isTraining() {
        return this.training;
    }

    @Override
    public Map<String, Object> getPushedLoggingMap() {
        return this.pushedLoggingMap != null ? Collections.unmodifiableMap(this.pushedLoggingMap) : Collections.emptyMap();
    }

    @Override
    public Map<String, Map<String, Object>> getOfficeManagedLoggingMap() {
        return this.officeManagedLoggingMap != null ? Collections.unmodifiableMap(this.officeManagedLoggingMap) : Collections.emptyMap();
    }

    @Override
    public OptionalThing<String> getSavedSubject() {
        return OptionalThing.ofNullable((Object)this.subject, () -> {
            throw new SMailIllegalStateException("Not found the subject: " + this.toString());
        });
    }

    @Override
    public OptionalThing<Address> getSavedFrom() {
        return OptionalThing.ofNullable((Object)this.from, () -> {
            throw new SMailIllegalStateException("Not found the from address: " + this.toString());
        });
    }

    @Override
    public List<Address> getSavedToList() {
        return this.toList != null ? Collections.unmodifiableList(this.toList) : Collections.emptyList();
    }

    @Override
    public List<Address> getSavedCcList() {
        return this.ccList != null ? Collections.unmodifiableList(this.ccList) : Collections.emptyList();
    }

    @Override
    public List<Address> getSavedBccList() {
        return this.bccList != null ? Collections.unmodifiableList(this.bccList) : Collections.emptyList();
    }

    @Override
    public List<Address> getSavedReplyToList() {
        return this.replyToList != null ? Collections.unmodifiableList(this.replyToList) : Collections.emptyList();
    }

    @Override
    public OptionalThing<String> getSavedReturnPath() {
        return this.motorbike.getReturnPath();
    }

    @Override
    public OptionalThing<String> getSavedPlainText() {
        return OptionalThing.ofNullable((Object)this.plainText, () -> {
            throw new SMailIllegalStateException("Not found the plain text: " + this.toString());
        });
    }

    @Override
    public OptionalThing<String> getSavedHtmlText() {
        return this.optHtmlText;
    }

    @Override
    public Map<String, SMailReadAttachedData> getSavedAttachmentMap() {
        return this.attachmentMap != null ? Collections.unmodifiableMap(this.attachmentMap) : Collections.emptyMap();
    }

    @Override
    public OptionalThing<Integer> getLastReturnCode() {
        return OptionalThing.ofNullable((Object)this.lastReturnCode, () -> {
            throw new SMailIllegalStateException("Not found the last return code: " + this.toString());
        });
    }

    @Override
    public OptionalThing<String> getLastServerResponse() {
        return OptionalThing.ofNullable((Object)this.lastServerResponse, () -> {
            throw new SMailIllegalStateException("Not found the last server response: " + this.toString());
        });
    }
}

