/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.mail.send.embedded.proofreader;

import java.util.Map;
import org.dbflute.helper.message.ExceptionMessageBuilder;
import org.dbflute.mail.Postcard;
import org.dbflute.mail.send.SMailTextProofreader;
import org.dbflute.mail.send.exception.SMailIllegalStateException;
import org.dbflute.mail.send.exception.SMailSubjectDuplicateException;
import org.dbflute.mail.send.exception.SMailSubjectNotFoundException;
import org.dbflute.util.Srl;

public class SMailBodyMetaProofreader
implements SMailTextProofreader {
    protected static final String META_DELIMITER = ">>>";
    protected static final String COMMENT_BEGIN = "/*";
    protected static final String COMMENT_END = "*/";
    protected static final String SUBJECT_LABEL = "subject:";
    protected static final String LF = "\n";
    protected static final String CRLF = "\r\n";
    protected final Postcard postcard;

    public SMailBodyMetaProofreader(Postcard postcard) {
        this.postcard = postcard;
    }

    @Override
    public String proofread(String templateText, Map<String, Object> variableMap) {
        return this.doProofreader(this.removeUTF8BomIfNeeds(templateText));
    }

    protected String doProofreader(String templateText) {
        String delimiter = META_DELIMITER;
        if (templateText.startsWith(COMMENT_BEGIN) && templateText.contains(META_DELIMITER)) {
            if (this.postcard.getSubject().isPresent()) {
                this.throwMailSubjectDuplicateException(templateText);
            }
            String subject = this.extractSubject(templateText, META_DELIMITER);
            this.postcard.setSubject(subject);
            return this.extractRealText(templateText, META_DELIMITER);
        }
        if (this.postcard.getSubject() == null) {
            this.throwMailSubjectNotFoundException(templateText);
        }
        return templateText;
    }

    protected String extractSubject(String templateText, String delimiter) {
        String meta = Srl.substringFirstFront((String)templateText, (String[])new String[]{delimiter});
        String commentRear = Srl.substringFirstRear((String)meta, (String[])new String[]{COMMENT_END});
        if (commentRear == null) {
            throw new SMailIllegalStateException("Body meta should have header comment: " + meta);
        }
        return Srl.substringFirstFront((String)Srl.substringFirstRear((String)commentRear, (String[])new String[]{SUBJECT_LABEL}), (String[])new String[]{LF}).trim();
    }

    protected String extractRealText(String templateText, String delimiter) {
        String delimRear = Srl.substringFirstRear((String)templateText, (String[])new String[]{delimiter});
        String realText = delimRear.startsWith(LF) ? delimRear.substring(LF.length()) : (delimRear.startsWith(CRLF) ? delimRear.substring(CRLF.length()) : delimRear);
        return realText;
    }

    protected String removeUTF8BomIfNeeds(String plainText) {
        return plainText.charAt(0) == '\ufeff' ? plainText.substring(1) : plainText;
    }

    protected void throwMailSubjectDuplicateException(String templateText) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Duplicate subject specified by postcard and defined in body file.");
        br.addItem("Advice");
        br.addElement((Object)"If subject in body file exists,");
        br.addElement((Object)"you don't need to specify it by postcard.");
        br.addItem("Postcard");
        br.addElement((Object)this.postcard);
        br.addItem("Template Text");
        br.addElement((Object)templateText);
        String msg = br.buildExceptionMessage();
        throw new SMailSubjectDuplicateException(msg);
    }

    protected void throwMailSubjectNotFoundException(String templateText) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Not found the subject for the postcard.");
        br.addItem("Advice");
        br.addElement((Object)"Specify subject by postcard or define it in body file.");
        br.addElement((Object)"For example, subject on body meta like this:");
        br.addElement((Object)"  comment: ...(one liner)");
        br.addElement((Object)"  subject: ...(mail subject)");
        br.addElement((Object)"  >>>");
        br.addElement((Object)"  ...(mail body)");
        br.addItem("Postcard");
        br.addElement((Object)this.postcard);
        br.addItem("Template Text");
        br.addElement((Object)templateText);
        String msg = br.buildExceptionMessage();
        throw new SMailSubjectNotFoundException(msg);
    }

    @Override
    public void workingDispose() {
    }

    public String toString() {
        return "proofreader:{body_meta}";
    }
}

