/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.mail.send.supplement.attachment;

import java.io.InputStream;
import org.dbflute.optional.OptionalThing;

public class SMailAttachment {
    protected final String filenameOnHeader;
    protected final String contentType;
    protected final InputStream reourceStream;
    protected final String textEncoding;

    public SMailAttachment(String filenameOnHeader, String contentType, InputStream resourceStream, String textEncoding) {
        this.assertArgumentNotNull("filenameOnHeader", filenameOnHeader);
        this.assertArgumentNotNull("contentType", contentType);
        this.assertArgumentNotNull("reourceStream", resourceStream);
        this.filenameOnHeader = filenameOnHeader;
        this.contentType = contentType;
        this.reourceStream = resourceStream;
        this.textEncoding = textEncoding;
    }

    protected void assertArgumentNotNull(String variableName, Object value) {
        if (variableName == null) {
            throw new IllegalArgumentException("The variableName should not be null.");
        }
        if (value == null) {
            throw new IllegalArgumentException("The argument '" + variableName + "' should not be null.");
        }
    }

    public String toString() {
        return "attachment:{" + this.filenameOnHeader + ", " + this.contentType + ", " + this.reourceStream + ", " + this.textEncoding + "}";
    }

    public String getFilenameOnHeader() {
        return this.filenameOnHeader;
    }

    public String getContentType() {
        return this.contentType;
    }

    public InputStream getReourceStream() {
        return this.reourceStream;
    }

    public OptionalThing<String> getTextEncoding() {
        return OptionalThing.ofNullable((Object)this.textEncoding, () -> {
            throw new IllegalStateException("Not found text encoding: filenameOnHeader=" + this.filenameOnHeader);
        });
    }
}

