/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.mail;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiFunction;
import org.dbflute.helper.message.ExceptionMessageBuilder;
import org.dbflute.mail.CardView;
import org.dbflute.mail.DeliveryCategory;
import org.dbflute.mail.send.SMailAddress;
import org.dbflute.mail.send.exception.SMailFromAddressNotFoundException;
import org.dbflute.mail.send.exception.SMailIllegalStateException;
import org.dbflute.mail.send.exception.SMailPostcardIllegalStateException;
import org.dbflute.mail.send.supplement.SMailPostingDiscloser;
import org.dbflute.mail.send.supplement.attachment.SMailAttachment;
import org.dbflute.optional.OptionalThing;
import org.dbflute.util.DfCollectionUtil;
import org.dbflute.util.DfTypeUtil;

public class Postcard
implements CardView {
    protected DeliveryCategory deliveryCategory;
    protected Locale receiverLocale;
    protected String subject;
    protected SMailAddress from;
    protected List<SMailAddress> toList;
    protected List<SMailAddress> ccList;
    protected List<SMailAddress> bccList;
    protected List<SMailAddress> replyToList;
    protected Map<String, SMailAttachment> attachmentMap;
    protected String bodyFile;
    protected boolean alsoHtmlFile;
    protected boolean fromFilesystem;
    protected String plainBody;
    protected String htmlBody;
    protected Map<String, Object> templateVariableMap;
    protected boolean wholeFixedTextUsed;
    protected boolean forcedlyDirect;
    protected boolean async;
    protected boolean definitelySync;
    protected int retryCount;
    protected long intervalMillis;
    protected boolean suppressSendFailure;
    protected boolean dryrun;
    protected Map<String, Object> pushedLoggingMap;
    protected Map<String, Object> pushedUlteriorMap;
    protected String proofreadingPlain;
    protected String proofreadingHtml;
    protected Map<String, Map<String, Object>> officeManagedLoggingMap;
    protected SMailPostingDiscloser officePostingDiscloser;
    protected Object messageAuthor;
    protected Class<?> messageTheme;

    public Postcard asDeliveryCategory(DeliveryCategory category) {
        this.assertArgumentNotNull("category", category);
        this.deliveryCategory = category;
        return this;
    }

    public void asReceiverLocale(Locale receiverLocale) {
        this.assertArgumentNotNull("receiverLocale", receiverLocale);
        this.receiverLocale = receiverLocale;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setFrom(SMailAddress address) {
        this.assertArgumentNotNull("address", address);
        this.from = address;
    }

    public void addTo(SMailAddress address) {
        this.assertArgumentNotNull("address", address);
        if (this.toList == null) {
            this.toList = new ArrayList<SMailAddress>(2);
        }
        this.toList.add(address);
    }

    public void addCc(SMailAddress address) {
        this.assertArgumentNotNull("address", address);
        if (this.ccList == null) {
            this.ccList = new ArrayList<SMailAddress>(2);
        }
        this.ccList.add(address);
    }

    public void addBcc(SMailAddress address) {
        this.assertArgumentNotNull("address", address);
        if (this.bccList == null) {
            this.bccList = new ArrayList<SMailAddress>(2);
        }
        this.bccList.add(address);
    }

    public void addReplyTo(SMailAddress address) {
        this.assertArgumentNotNull("address", address);
        if (this.replyToList == null) {
            this.replyToList = new ArrayList<SMailAddress>(2);
        }
        this.replyToList.add(address);
    }

    public void attachPlainText(String filenameOnHeader, InputStream resourceStream, String textEncoding) {
        this.assertArgumentNotNull("filenameOnHeader", filenameOnHeader);
        this.assertArgumentNotNull("resourceStream", resourceStream);
        this.assertArgumentNotNull("textEncoding", textEncoding);
        this.doAttach(filenameOnHeader, "text/plain", resourceStream, textEncoding);
    }

    public void attachVarious(String filenameOnHeader, String contentType, InputStream resourceStream) {
        this.assertArgumentNotNull("filenameOnHeader", filenameOnHeader);
        this.assertArgumentNotNull("contentType", contentType);
        this.assertArgumentNotNull("resourceStream", resourceStream);
        this.doAttach(filenameOnHeader, contentType, resourceStream, null);
    }

    protected void doAttach(String filenameOnHeader, String contentType, InputStream resourceStream, String textEncoding) {
        if (this.attachmentMap == null) {
            this.attachmentMap = new LinkedHashMap<String, SMailAttachment>(4);
        }
        if (this.attachmentMap.containsKey(filenameOnHeader)) {
            String msg = "Already exists the attachment file: " + filenameOnHeader + ", " + contentType + ", existing=" + this.attachmentMap;
            throw new SMailIllegalStateException(msg);
        }
        SMailAttachment attachment = this.createAttachment(filenameOnHeader, contentType, resourceStream, textEncoding);
        this.attachmentMap.put(filenameOnHeader, attachment);
    }

    protected SMailAttachment createAttachment(String filenameOnHeader, String contentType, InputStream resourceStream, String textEncoding) {
        return new SMailAttachment(filenameOnHeader, contentType, resourceStream, textEncoding);
    }

    public BodyFileOption useBodyFile(String bodyFile) {
        this.assertArgumentNotNull("bodyFile", bodyFile);
        this.bodyFile = bodyFile;
        return new BodyFileOption();
    }

    protected void clearBodyFile() {
        this.bodyFile = null;
        this.alsoHtmlFile = false;
        this.fromFilesystem = false;
    }

    public DirectBodyOption useDirectBody(String plainBody) {
        this.assertArgumentNotNull("plainBody", plainBody);
        this.plainBody = plainBody;
        return new DirectBodyOption();
    }

    public OverridingBodyFileOption overrideBodyFile(String subject, String plainBody) {
        this.assertArgumentNotNull("subject", subject);
        this.assertArgumentNotNull("plainBody", plainBody);
        if (this.bodyFile == null) {
            throw new IllegalStateException("No body file so mistake?: specified-subject=" + subject);
        }
        this.clearBodyFile();
        this.setSubject(subject);
        DirectBodyOption option = this.useDirectBody(plainBody);
        return new OverridingBodyFileOption(option);
    }

    public Postcard async() {
        this.async = true;
        return this;
    }

    public Postcard definitelySync() {
        this.definitelySync = true;
        return this;
    }

    public Postcard retry(int retryCount, long intervalMillis) {
        if (retryCount <= 0) {
            throw new IllegalArgumentException("The arguyment 'retryCount' should be positive integer: " + retryCount);
        }
        if (intervalMillis <= 0L) {
            throw new IllegalArgumentException("The arguyment 'intervalMillis' should be positive long: " + intervalMillis);
        }
        this.retryCount = retryCount;
        this.intervalMillis = intervalMillis;
        return this;
    }

    public Postcard suppressSendFailure() {
        this.suppressSendFailure = true;
        return this;
    }

    public void dryrun() {
        this.dryrun = true;
    }

    public void pushLogging(String key, Object value) {
        this.assertArgumentNotNull("key", key);
        this.assertArgumentNotNull("value", value);
        if (this.pushedLoggingMap == null) {
            this.pushedLoggingMap = new LinkedHashMap<String, Object>(4);
        }
        this.pushedLoggingMap.put(key, value);
    }

    public void pushUlterior(String key, Object value) {
        this.assertArgumentNotNull("key", key);
        this.assertArgumentNotNull("value", value);
        if (this.pushedUlteriorMap == null) {
            this.pushedUlteriorMap = new LinkedHashMap<String, Object>(4);
        }
        this.pushedUlteriorMap.put(key, value);
    }

    public void officeCheck() {
        if (this.toList == null || this.toList.isEmpty()) {
            this.throwMailToAddressNotFoundException();
        }
        if (this.bodyFile == null && this.plainBody == null) {
            String msg = "Not found body file or plain body: bodyFile=" + this.bodyFile + " plainBody=" + this.plainBody;
            throw new SMailPostcardIllegalStateException(msg);
        }
        if (!this.forcedlyDirect && this.bodyFile != null && this.plainBody != null) {
            String msg = "Set either body file or plain body: bodyFile=" + this.bodyFile + " plainBody=" + this.plainBody;
            throw new SMailPostcardIllegalStateException(msg);
        }
        if (this.plainBody == null && this.htmlBody != null) {
            String msg = "Cannot set html body only (without plain body): htmlBody=" + this.htmlBody;
            throw new SMailPostcardIllegalStateException(msg);
        }
        if (!this.forcedlyDirect && !this.wholeFixedTextUsed && this.templateVariableMap == null) {
            String msg = "Not found template variable map:";
            msg = msg + " wholeFixedTextUsed=" + this.wholeFixedTextUsed + " variableMap=" + this.templateVariableMap;
            throw new SMailPostcardIllegalStateException(msg);
        }
        if (!this.forcedlyDirect && this.wholeFixedTextUsed && this.templateVariableMap != null) {
            String msg = "Unneeded template variable map:";
            msg = msg + " wholeFixedTextUsed=" + this.wholeFixedTextUsed + " variableMap=" + this.templateVariableMap;
            throw new SMailPostcardIllegalStateException(msg);
        }
    }

    protected void throwMailFromAddressNotFoundException() {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Not found the 'from' address in the postcard.");
        br.addItem("Advice");
        br.addElement((Object)"Specify your 'from' address.");
        br.addItem("Postcard");
        br.addElement((Object)this.toString());
        String msg = br.buildExceptionMessage();
        throw new SMailFromAddressNotFoundException(msg);
    }

    protected void throwMailToAddressNotFoundException() {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Not found the 'to' address in the postcard.");
        br.addItem("Advice");
        br.addElement((Object)"Specify your 'to' address.");
        br.addItem("Postcard");
        br.addElement((Object)this.toString());
        String msg = br.buildExceptionMessage();
        throw new SMailFromAddressNotFoundException(msg);
    }

    public void officePlusHtml() {
        this.alsoHtmlFile = true;
    }

    public boolean needsMainProofreading() {
        return !this.isWholeFixedTextUsed() && this.hasTemplateVariable();
    }

    public void proofreadPlain(BiFunction<String, Map<String, Object>, String> proofreader) {
        this.proofreadingPlain = proofreader.apply((String)this.getProofreadingOrOriginalPlain().get(), this.getTemplaetVariableMap());
    }

    public void proofreadHtml(BiFunction<String, Map<String, Object>, String> proofreader) {
        this.proofreadingHtml = proofreader.apply((String)this.getProofreadingOrOriginalHtml().get(), this.getTemplaetVariableMap());
    }

    @Override
    public OptionalThing<String> toCompletePlainText() {
        return this.getProofreadingOrOriginalPlain();
    }

    @Override
    public OptionalThing<String> toCompleteHtmlText() {
        return this.getProofreadingOrOriginalHtml();
    }

    protected OptionalThing<String> getProofreadingOrOriginalPlain() {
        return OptionalThing.ofNullable((Object)(this.proofreadingPlain != null ? this.proofreadingPlain : this.plainBody), () -> {
            throw new SMailIllegalStateException("Not found the plain text: " + this.toString());
        });
    }

    protected OptionalThing<String> getProofreadingOrOriginalHtml() {
        return OptionalThing.ofNullable((Object)(this.proofreadingHtml != null ? this.proofreadingHtml : this.htmlBody), () -> {
            throw new SMailIllegalStateException("Not found the HTML text: " + this.toString());
        });
    }

    public void officeManagedLogging(String title, String key, Object value) {
        Map<String, Object> valueMap;
        this.assertArgumentNotNull("title", title);
        this.assertArgumentNotNull("key", key);
        this.assertArgumentNotNull("value", value);
        if (this.officeManagedLoggingMap == null) {
            this.officeManagedLoggingMap = new LinkedHashMap<String, Map<String, Object>>(4);
        }
        if ((valueMap = this.officeManagedLoggingMap.get(title)) == null) {
            valueMap = new LinkedHashMap<String, Object>(4);
            this.officeManagedLoggingMap.put(title, valueMap);
        }
        valueMap.put(key, value);
    }

    public void officeDisclosePostingState(SMailPostingDiscloser postingDiscloser) {
        this.assertArgumentNotNull("postingDiscloser", postingDiscloser);
        this.officePostingDiscloser = postingDiscloser;
    }

    public void writeMessageAuthor(Object messageAuthor) {
        this.assertArgumentNotNull("messageAuthor", messageAuthor);
        this.messageAuthor = messageAuthor;
        String exp = this.buildMessageAuthorLoggingExp(messageAuthor);
        this.officeManagedLogging("sysInfo", "author", exp);
    }

    protected String buildMessageAuthorLoggingExp(Object messageAuthor) {
        String exp = messageAuthor instanceof Class ? ((Class)messageAuthor).getSimpleName() : (messageAuthor.getClass().getName().startsWith("java.") ? messageAuthor.toString() : messageAuthor.getClass().getSimpleName());
        return exp;
    }

    public void writeMessageTheme(Class<?> messageTheme) {
        this.assertArgumentNotNull("messageTheme", messageTheme);
        this.messageTheme = messageTheme;
        this.officeManagedLogging("sysInfo", "theme", messageTheme.getSimpleName());
    }

    protected void assertArgumentNotNull(String variableName, Object value) {
        if (variableName == null) {
            throw new IllegalArgumentException("The variableName should not be null.");
        }
        if (value == null) {
            throw new IllegalArgumentException("The argument '" + variableName + "' should not be null.");
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(DfTypeUtil.toClassTitle((Object)this));
        sb.append(":{");
        sb.append("from=").append(this.from);
        sb.append(", to=").append(this.toList);
        if (this.subject != null) {
            sb.append(", subject=").append(this.subject);
        }
        if (this.bodyFile != null) {
            sb.append(", bodyFile=").append(this.bodyFile);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public OptionalThing<DeliveryCategory> getDeliveryCategory() {
        return OptionalThing.ofNullable((Object)this.deliveryCategory, () -> {
            throw new SMailIllegalStateException("Not found the delivery category: " + this.toString());
        });
    }

    @Override
    public OptionalThing<Locale> getReceiverLocale() {
        return OptionalThing.ofNullable((Object)this.receiverLocale, () -> {
            throw new SMailIllegalStateException("Not found the receiver locale: " + this.toString());
        });
    }

    @Override
    public OptionalThing<String> getSubject() {
        return OptionalThing.ofNullable((Object)this.subject, () -> {
            throw new SMailIllegalStateException("Not found the subject: " + this.toString());
        });
    }

    @Override
    public OptionalThing<SMailAddress> getFrom() {
        return OptionalThing.ofNullable((Object)this.from, () -> {
            throw new SMailIllegalStateException("Not found the from address: " + this.toString());
        });
    }

    @Override
    public List<SMailAddress> getToList() {
        return this.toList != null ? Collections.unmodifiableList(this.toList) : DfCollectionUtil.emptyList();
    }

    @Override
    public List<SMailAddress> getCcList() {
        return this.ccList != null ? Collections.unmodifiableList(this.ccList) : DfCollectionUtil.emptyList();
    }

    @Override
    public List<SMailAddress> getBccList() {
        return this.bccList != null ? Collections.unmodifiableList(this.bccList) : DfCollectionUtil.emptyList();
    }

    @Override
    public List<SMailAddress> getReplyToList() {
        return this.replyToList != null ? Collections.unmodifiableList(this.replyToList) : DfCollectionUtil.emptyList();
    }

    @Override
    public Map<String, SMailAttachment> getAttachmentMap() {
        return this.attachmentMap != null ? Collections.unmodifiableMap(this.attachmentMap) : DfCollectionUtil.emptyMap();
    }

    @Override
    public boolean hasBodyFile() {
        return this.bodyFile != null;
    }

    @Override
    public OptionalThing<String> getBodyFile() {
        return OptionalThing.ofNullable((Object)this.bodyFile, () -> {
            throw new SMailIllegalStateException("Not found the body file: " + this.toString());
        });
    }

    @Override
    public boolean isAlsoHtmlFile() {
        return this.alsoHtmlFile;
    }

    @Override
    public boolean isFromFilesystem() {
        return this.fromFilesystem;
    }

    @Override
    public boolean hasTemplateVariable() {
        return this.templateVariableMap != null;
    }

    @Override
    public Map<String, Object> getTemplaetVariableMap() {
        return this.templateVariableMap != null ? Collections.unmodifiableMap(this.templateVariableMap) : Collections.emptyMap();
    }

    @Override
    public boolean isWholeFixedTextUsed() {
        return this.wholeFixedTextUsed;
    }

    @Override
    public boolean isForcedlyDirect() {
        return this.forcedlyDirect;
    }

    @Override
    public OptionalThing<String> getPlainBody() {
        return OptionalThing.ofNullable((Object)this.plainBody, () -> {
            throw new SMailIllegalStateException("Not found the plain body: " + this.toString());
        });
    }

    @Override
    public boolean hasHtmlBody() {
        return this.htmlBody != null;
    }

    @Override
    public OptionalThing<String> getHtmlBody() {
        return OptionalThing.ofNullable((Object)this.htmlBody, () -> {
            throw new SMailIllegalStateException("Not found the html body: " + this.toString());
        });
    }

    @Override
    public boolean isAsync() {
        return this.async;
    }

    public boolean isDefinitelySync() {
        return this.definitelySync;
    }

    @Override
    public int getRetryCount() {
        return this.retryCount;
    }

    @Override
    public long getIntervalMillis() {
        return this.intervalMillis;
    }

    @Override
    public boolean isSuppressSendFailure() {
        return this.suppressSendFailure;
    }

    @Override
    public boolean isDryrun() {
        return this.dryrun;
    }

    @Override
    public boolean hasPushedLogging() {
        return this.pushedLoggingMap != null;
    }

    @Override
    public Map<String, Object> getPushedLoggingMap() {
        return this.pushedLoggingMap != null ? Collections.unmodifiableMap(this.pushedLoggingMap) : Collections.emptyMap();
    }

    @Override
    public boolean hasPushedUlterior() {
        return this.pushedUlteriorMap != null;
    }

    @Override
    public Map<String, Object> getPushedUlteriorMap() {
        return this.pushedUlteriorMap != null ? Collections.unmodifiableMap(this.pushedUlteriorMap) : Collections.emptyMap();
    }

    @Override
    public boolean hasOfficeManagedLogging() {
        return this.officeManagedLoggingMap != null;
    }

    @Override
    public Map<String, Map<String, Object>> getOfficeManagedLoggingMap() {
        return this.officeManagedLoggingMap != null ? Collections.unmodifiableMap(this.officeManagedLoggingMap) : Collections.emptyMap();
    }

    @Override
    public boolean hasOfficePostingDiscloser() {
        return this.officePostingDiscloser != null;
    }

    @Override
    public OptionalThing<SMailPostingDiscloser> getOfficePostingDiscloser() {
        return OptionalThing.ofNullable((Object)this.officePostingDiscloser, () -> {
            throw new IllegalStateException("Not found the office posting discloser: " + this.toString());
        });
    }

    @Override
    public OptionalThing<Object> getMessageAuthor() {
        return OptionalThing.ofNullable((Object)this.messageAuthor, () -> {
            throw new IllegalStateException("Not found the message author: " + this.toString());
        });
    }

    @Override
    public OptionalThing<Class<?>> getMessageTheme() {
        return OptionalThing.ofNullable(this.messageTheme, () -> {
            throw new IllegalStateException("Not found the message theme: " + this.toString());
        });
    }

    public class OverridingBodyFileOption {
        protected final DirectBodyOption directBodyOption;

        public OverridingBodyFileOption(DirectBodyOption directBodyOption) {
            this.directBodyOption = directBodyOption;
        }

        public OverridingBodyFileOption alsoHtmlBody(String htmlBody) {
            Postcard.this.assertArgumentNotNull("htmlBody", htmlBody);
            this.directBodyOption.alsoDirectHtml(htmlBody);
            return this;
        }
    }

    public class WholeFixedTextOption {
        public WholeFixedTextOption forcedlyDirect(String subject) {
            Postcard.this.assertArgumentNotNull("subject", subject);
            Postcard.this.subject = subject;
            Postcard.this.forcedlyDirect = true;
            Postcard.this.officeManagedLogging("sysInfo", "forcedlyDirect", true);
            return this;
        }
    }

    public class DirectBodyOption {
        public DirectBodyOption alsoDirectHtml(String directHtml) {
            Postcard.this.assertArgumentNotNull("directHtml", directHtml);
            Postcard.this.htmlBody = directHtml;
            return this;
        }

        public void useTemplateText(Map<String, Object> variableMap) {
            Postcard.this.assertArgumentNotNull("variableMap", variableMap);
            Postcard.this.templateVariableMap = variableMap;
        }

        public WholeFixedTextOption useWholeFixedText() {
            Postcard.this.wholeFixedTextUsed = true;
            return new WholeFixedTextOption();
        }
    }

    public class BodyFileOption {
        public BodyFileOption alsoHtmlFile() {
            Postcard.this.alsoHtmlFile = true;
            return this;
        }

        public BodyFileOption fromFilesystem() {
            Postcard.this.fromFilesystem = true;
            return this;
        }

        public void useTemplateText(Map<String, Object> variableMap) {
            Postcard.this.assertArgumentNotNull("variableMap", variableMap);
            Postcard.this.templateVariableMap = variableMap;
        }

        public void useWholeFixedText() {
            Postcard.this.wholeFixedTextUsed = true;
        }
    }
}

