/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.mail.send;

import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import org.dbflute.mail.send.exception.SMailIllegalStateException;
import org.dbflute.optional.OptionalThing;
import org.dbflute.util.Srl;

public class SMailPostalMotorbike {
    protected static final String MAIL_SMTP_HOST = "mail.smtp.host";
    protected static final String MAIL_SMTP_PORT = "mail.smtp.port";
    protected static final String MAIL_SMTP_FROM = "mail.smtp.from";
    protected static final String MAIL_SMTP_AUTH = "mail.smtp.auth";
    protected static final String MAIL_TRANSPORT_PROTOCOL = "mail.transport.protocol";
    protected final Session session;
    protected final boolean hasAuth;
    protected MotorbikeSecurityType securityType = MotorbikeSecurityType.NONE;

    public SMailPostalMotorbike() {
        this.session = this.createSession();
        this.hasAuth = false;
    }

    public SMailPostalMotorbike(String userName, String password) {
        this.assertArgumentNotNull("userName", userName);
        this.assertArgumentNotNull("password", password);
        this.session = this.createSession(this.createAuthenticator(userName, password));
        this.hasAuth = true;
    }

    protected Authenticator createAuthenticator(final String userName, final String password) {
        return new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(userName, password);
            }
        };
    }

    protected Session createSession() {
        return Session.getInstance((Properties)this.createSessionProperties());
    }

    protected Session createSession(Authenticator auth) {
        return Session.getInstance((Properties)this.createSessionProperties(), (Authenticator)auth);
    }

    protected Properties createSessionProperties() {
        return new Properties();
    }

    public SMailPostalMotorbike useSsl() {
        if (!this.hasAuth) {
            throw new IllegalStateException("Not found the authenticator for SSL: session=" + this.session);
        }
        if (MotorbikeSecurityType.STARTTLS.equals((Object)this.securityType)) {
            throw new IllegalStateException("Cannot use SSL with STARTTLS: session=" + this.session);
        }
        this.securityType = MotorbikeSecurityType.SSL;
        this.registerTransportProtocol("smtps");
        this.registerSmtpAuth();
        return this;
    }

    public SMailPostalMotorbike useStarttls() {
        if (!this.hasAuth) {
            throw new IllegalStateException("Not found the authenticator for STARTTLS: session=" + this.session);
        }
        if (MotorbikeSecurityType.SSL.equals((Object)this.securityType)) {
            throw new IllegalStateException("Cannot use STARTTLS with SSL: session=" + this.session);
        }
        this.securityType = MotorbikeSecurityType.STARTTLS;
        this.registerSmtpAuth();
        Properties props = this.session.getProperties();
        props.setProperty("mail.smtp.starttls.enable", "true");
        props.setProperty("mail.smtp.starttls.required", "true");
        return this;
    }

    protected void registerSmtpAuth() {
        this.session.getProperties().setProperty(this.resolveProtocolKey(MAIL_SMTP_AUTH), "true");
    }

    public void registerConnectionInfo(String host, int port) {
        this.assertArgumentNotNull("passhostword", host);
        Properties props = this.session.getProperties();
        props.setProperty(this.resolveProtocolKey(MAIL_SMTP_HOST), host);
        props.setProperty(this.resolveProtocolKey(MAIL_SMTP_PORT), String.valueOf(port));
    }

    public void registerProxy(String proxyHost, String proxyPort) {
        this.assertArgumentNotNull("proxyHost", proxyHost);
        this.assertArgumentNotNull("proxyPort", proxyPort);
        Properties props = this.session.getProperties();
        props.setProperty("proxySet", "true");
        props.setProperty("socksProxyHost", proxyHost);
        props.setProperty("socksProxyPort", proxyPort);
        props.setProperty("mail.smtp.socks.host", proxyHost);
        props.setProperty("mail.smtp.socks.port", proxyPort);
    }

    public void registerStarttls() {
        this.useStarttls();
    }

    public void registerReturnPath(String address) {
        this.assertArgumentNotNull("address", address);
        this.session.getProperties().setProperty(this.resolveProtocolKey(MAIL_SMTP_FROM), address);
    }

    public void registerTransportProtocol(String protocol) {
        this.assertArgumentNotNull("protocol", protocol);
        this.session.getProperties().setProperty(MAIL_TRANSPORT_PROTOCOL, protocol);
    }

    protected String resolveProtocolKey(String key) {
        return MotorbikeSecurityType.SSL.equals((Object)this.securityType) ? Srl.replace((String)key, (String)".smtp.", (String)".smtps.") : key;
    }

    public void setProperty(String key, String value) {
        this.assertArgumentNotNull("key", key);
        this.assertArgumentNotNull("value", value);
        this.session.getProperties().setProperty(key, value);
    }

    protected void assertArgumentNotNull(String variableName, Object value) {
        if (variableName == null) {
            throw new IllegalArgumentException("The variableName should not be null.");
        }
        if (value == null) {
            throw new IllegalArgumentException("The argument '" + variableName + "' should not be null.");
        }
    }

    public String toString() {
        return "motorbike:{session=" + this.session + (this.hasAuth ? ", auth(" + (Object)((Object)this.securityType) + ")" : "") + "}";
    }

    public Session getNativeSession() {
        return this.session;
    }

    public OptionalThing<String> getReturnPath() {
        return OptionalThing.ofNullable((Object)this.session.getProperty(MAIL_SMTP_FROM), () -> {
            throw new SMailIllegalStateException("Not found the return path (mail.smtp.from): " + this.session.getProperties());
        });
    }

    protected static enum MotorbikeSecurityType {
        NONE,
        SSL,
        STARTTLS;

    }
}

