/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.mail.send.embedded.proofreader;

import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.List;
import java.util.Map;
import org.dbflute.mail.send.SMailTextProofreader;
import org.dbflute.twowaysql.SqlAnalyzer;
import org.dbflute.twowaysql.context.CommandContext;
import org.dbflute.twowaysql.context.CommandContextCreator;
import org.dbflute.twowaysql.factory.NodeAdviceFactory;
import org.dbflute.twowaysql.node.BoundValue;
import org.dbflute.twowaysql.node.EmbeddedVariableNode;
import org.dbflute.twowaysql.node.Node;
import org.dbflute.twowaysql.pmbean.SimpleMapPmb;
import org.dbflute.util.Srl;

public class SMailPmCommentProofreader
implements SMailTextProofreader {
    protected static final String IF_PREFIX = "/*IF ";
    protected static final String FOR_PREFIX = "/*FOR ";
    protected static final String END_COMMENT = "/*END*/";
    protected static final String CLOSE_MARK = "*/";
    protected static final String LF = "\n";
    protected static final String CRLF = "\r\n";

    @Override
    public String proofread(String templateText, Map<String, Object> variableMap) {
        SimpleMapPmb pmb = new SimpleMapPmb();
        variableMap.forEach((key, value) -> pmb.addParameter(key, value));
        return this.evaluate(templateText, pmb);
    }

    protected String evaluate(String templateText, Object pmb) {
        Node node = this.analyze(this.filterTemplateText(templateText, pmb));
        CommandContext ctx = this.prepareContext(pmb);
        node.accept(ctx);
        return ctx.getSql();
    }

    protected String filterTemplateText(String templateText, Object pmb) {
        String replaced = Srl.replace((String)templateText, (String)CRLF, (String)LF);
        List lineList = Srl.splitList((String)replaced, (String)LF);
        StringBuilder sb = new StringBuilder(templateText.length());
        boolean nextNoLine = false;
        int lineNumber = 0;
        for (String line : lineList) {
            String realLine;
            ++lineNumber;
            if (nextNoLine) {
                sb.append(line);
                nextNoLine = false;
                continue;
            }
            if (this.isIfEndCommentLine(line) || this.isForEndCommentLine(line)) {
                this.appendLfLine(sb, lineNumber, Srl.substringLastFront((String)line, (String[])new String[]{END_COMMENT}));
                sb.append(LF).append(END_COMMENT);
                nextNoLine = true;
                continue;
            }
            if (this.isOnlyIfCommentLine(line) || this.isOnlyForCommentLine(line) || this.isOnlyEndCommentLine(line)) {
                nextNoLine = true;
                realLine = Srl.ltrim((String)line);
            } else {
                realLine = line;
            }
            this.appendLfLine(sb, lineNumber, realLine);
        }
        return sb.toString();
    }

    protected boolean isOnlyIfCommentLine(String line) {
        String trimmed = line.trim();
        return trimmed.startsWith(IF_PREFIX) && trimmed.endsWith(CLOSE_MARK) && Srl.count((String)line, (String)CLOSE_MARK) == 1;
    }

    protected boolean isOnlyForCommentLine(String line) {
        String trimmed = line.trim();
        return trimmed.startsWith(FOR_PREFIX) && trimmed.endsWith(CLOSE_MARK) && Srl.count((String)line, (String)CLOSE_MARK) == 1;
    }

    protected boolean isOnlyEndCommentLine(String line) {
        return line.trim().equals(END_COMMENT);
    }

    protected boolean isIfEndCommentLine(String line) {
        return line.startsWith(IF_PREFIX) && line.endsWith(END_COMMENT) && Srl.count((String)line, (String)CLOSE_MARK) > 1;
    }

    protected boolean isForEndCommentLine(String line) {
        return line.startsWith(FOR_PREFIX) && line.endsWith(END_COMMENT) && Srl.count((String)line, (String)CLOSE_MARK) > 1;
    }

    protected void appendLfLine(StringBuilder sb, int lineNumber, String line) {
        sb.append(lineNumber > 1 ? LF : "").append(line);
    }

    protected Node analyze(String templateText) {
        return this.createMailikeSqlAnalyzer(templateText).analyze();
    }

    protected SqlAnalyzer createMailikeSqlAnalyzer(String templateText) {
        SqlAnalyzer analyzer = new SqlAnalyzer(templateText, true){

            protected String filterAtFirst(String sql) {
                return sql;
            }

            protected EmbeddedVariableNode newEmbeddedVariableNode(String expr, String testValue, String specifiedSql, boolean blockNullParameter, NodeAdviceFactory adviceFactory, boolean replaceOnly, boolean terminalDot, boolean overlookNativeBinding) {
                return SMailPmCommentProofreader.this.createMailikeEmbeddedVariableNode(expr, testValue, specifiedSql, blockNullParameter, adviceFactory, replaceOnly, terminalDot, overlookNativeBinding);
            }
        }.overlookNativeBinding().switchBindingToReplaceOnlyEmbedded();
        return analyzer;
    }

    protected EmbeddedVariableNode createMailikeEmbeddedVariableNode(String expr, String testValue, String specifiedSql, boolean blockNullParameter, NodeAdviceFactory adviceFactory, boolean replaceOnly, boolean terminalDot, boolean overlookNativeBinding) {
        return new EmbeddedVariableNode(expr, testValue, specifiedSql, blockNullParameter, adviceFactory, replaceOnly, terminalDot, overlookNativeBinding){

            protected void setupBoundValue(BoundValue boundValue) {
                super.setupBoundValue(boundValue);
                SMailPmCommentProofreader.this.setupOrElseValueIfNeeds(boundValue, this._optionDef);
                SMailPmCommentProofreader.this.setupFormatAsValueIfNeeds(boundValue, this._optionDef);
            }

            protected boolean processDynamicBinding(CommandContext ctx, Object firstValue, Class<?> firstType, String embeddedString) {
                return SMailPmCommentProofreader.this.isDynamicBindingEnabled();
            }
        };
    }

    protected boolean isDynamicBindingEnabled() {
        return false;
    }

    protected void setupOrElseValueIfNeeds(BoundValue boundValue, String optionDef) {
        if (Srl.is_Null_or_TrimmedEmpty((String)optionDef)) {
            return;
        }
        Object targetValue = boundValue.getTargetValue();
        if (targetValue != null) {
            return;
        }
        List optionList = Srl.splitListTrimmed((String)optionDef, (String)"|");
        String orElseBegin = "orElse(";
        String orElseEnd = ")";
        optionList.stream().filter(op -> op.startsWith("orElse(") && op.endsWith(")")).findFirst().ifPresent(op -> {
            Srl.ScopeInfo scope = Srl.extractScopeWide((String)op, (String)"orElse(", (String)")");
            String content = scope.getContent().trim();
            if (!Srl.isQuotedSingle((String)content)) {
                this.throwMailOrElseValueNotQuotedException(optionDef);
            }
            boundValue.setTargetValue((Object)Srl.unquoteSingle((String)content));
        });
    }

    protected void throwMailOrElseValueNotQuotedException(String optionDef) {
        String msg = "The orElse() value for mail should be single-quoted e.g. orElse('sea') but: " + optionDef;
        throw new IllegalStateException(msg);
    }

    protected void setupFormatAsValueIfNeeds(BoundValue boundValue, String optionDef) {
        if (Srl.is_Null_or_TrimmedEmpty((String)optionDef)) {
            return;
        }
        Object targetValue = boundValue.getTargetValue();
        if (targetValue == null) {
            return;
        }
        if (targetValue instanceof TemporalAccessor) {
            TemporalAccessor temporal = (TemporalAccessor)targetValue;
            List optionList = Srl.splitListTrimmed((String)optionDef, (String)"|");
            String formatAsBegin = "formatAs(";
            String formatAsEnd = ")";
            optionList.stream().filter(op -> op.startsWith("formatAs(") && op.endsWith(")")).findFirst().ifPresent(op -> {
                Srl.ScopeInfo scope = Srl.extractScopeWide((String)op, (String)"formatAs(", (String)")");
                String content = scope.getContent().trim();
                if (!Srl.isQuotedSingle((String)content)) {
                    this.throwMailFormatAsValueNotQuotedException(optionDef);
                }
                String datePattern = Srl.unquoteSingle((String)content);
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern(datePattern);
                boundValue.setTargetValue((Object)formatter.format(temporal));
            });
        }
    }

    protected void throwMailFormatAsValueNotQuotedException(String optionDef) {
        String msg = "The formatAs() value for mail should be single-quoted e.g. formatAs('sea') but: " + optionDef;
        throw new IllegalStateException(msg);
    }

    protected CommandContext prepareContext(Object pmb) {
        Object filteredPmb = this.filterPmb(pmb);
        String[] argNames = new String[]{"pmb"};
        Class[] argTypes = new Class[]{filteredPmb.getClass()};
        CommandContextCreator creator = SMailPmCommentProofreader.newCommandContextCreator(argNames, argTypes);
        return creator.createCommandContext(new Object[]{filteredPmb});
    }

    protected static CommandContextCreator newCommandContextCreator(String[] argNames, Class<?>[] argTypes) {
        return new CommandContextCreator(argNames, (Class[])argTypes);
    }

    protected Object filterPmb(Object pmb) {
        if (pmb instanceof Map) {
            Map variableMap = (Map)pmb;
            SimpleMapPmb mapPmb = new SimpleMapPmb();
            variableMap.forEach((key, value) -> mapPmb.addParameter(key, value));
            return mapPmb;
        }
        return pmb;
    }

    @Override
    public void workingDispose() {
    }

    public String toString() {
        return "proofreader:{pmcomment}";
    }
}

