/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.mail.send.embedded.receptionist;

import java.io.File;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.dbflute.Entity;
import org.dbflute.helper.filesystem.FileTextIO;
import org.dbflute.helper.message.ExceptionMessageBuilder;
import org.dbflute.mail.Postcard;
import org.dbflute.mail.send.SMailAddress;
import org.dbflute.mail.send.SMailReceptionist;
import org.dbflute.mail.send.embedded.receptionist.SMailConventionSecurity;
import org.dbflute.mail.send.embedded.receptionist.SMailDynamicDataResource;
import org.dbflute.mail.send.embedded.receptionist.SMailDynamicPropAcceptor;
import org.dbflute.mail.send.embedded.receptionist.SMailDynamicPropResource;
import org.dbflute.mail.send.embedded.receptionist.SMailDynamicTextAssist;
import org.dbflute.mail.send.embedded.receptionist.SMailDynamicTextResource;
import org.dbflute.mail.send.embedded.receptionist.SMailReceiverLocaleAssist;
import org.dbflute.mail.send.exception.SMailFromAddressNotFoundException;
import org.dbflute.mail.send.exception.SMailIllegalStateException;
import org.dbflute.optional.OptionalThing;
import org.dbflute.util.DfCollectionUtil;
import org.dbflute.util.DfResourceUtil;
import org.dbflute.util.DfTypeUtil;
import org.dbflute.util.Srl;

public class SMailConventionReceptionist
implements SMailReceptionist {
    public static final String META_DELIMITER = ">>>";
    public static final String COMMENT_BEGIN = "/*";
    public static final String COMMENT_END = "*/";
    public static final String TITLE_BEGIN = "[";
    public static final String TITLE_END = "]";
    public static final String SUBJECT_LABEL = "subject:";
    public static final String OPTION_LABEL = "option:";
    public static final String PLUS_HTML_OPTION = "+html";
    public static final String PROPDEF_PREFIX = "-- !!";
    public static final Set<String> optionSet = Collections.unmodifiableSet(DfCollectionUtil.newLinkedHashSet((Object[])new String[]{"+html"}));
    public static final List<String> allowedPrefixList = Arrays.asList("option:", "-- !!");
    protected static final String LF = "\n";
    protected static final String CR = "\r";
    protected static final String CRLF = "\r\n";
    protected String classpathBasePath;
    protected SMailDynamicTextAssist dynamicTextAssist;
    protected SMailReceiverLocaleAssist receiverLocaleAssist;
    protected final Map<String, String> textCacheMap = new ConcurrentHashMap<String, String>();
    protected final FileTextIO textIO = this.createFileTextIO();
    protected final SMailConventionSecurity security = this.createConventionSecurity();

    protected FileTextIO createFileTextIO() {
        return new FileTextIO().encodeAsUTF8().removeUTF8Bom().replaceCrLfToLf();
    }

    protected SMailConventionSecurity createConventionSecurity() {
        return new SMailConventionSecurity();
    }

    public SMailConventionReceptionist asClasspathBase(String classpathBasePath) {
        this.classpathBasePath = classpathBasePath;
        return this;
    }

    public SMailConventionReceptionist asDynamicText(SMailDynamicTextAssist dynamicTextAssist) {
        this.dynamicTextAssist = dynamicTextAssist;
        return this;
    }

    public SMailConventionReceptionist asReceiverLocale(SMailReceiverLocaleAssist receiverLocaleAssist) {
        this.receiverLocaleAssist = receiverLocaleAssist;
        return this;
    }

    @Override
    public void accept(Postcard postcard) {
        this.readyPostcardFirst(postcard);
        this.checkPostcardFirst(postcard);
        if (postcard.isForcedlyDirect()) {
            this.assertPlainBodyExistsForDirectBody(postcard);
            postcard.getBodyFile().ifPresent(bodyFile -> this.officeManagedLogging(postcard, (String)bodyFile, this.prepareReceiverLocale(postcard)));
            return;
        }
        postcard.getBodyFile().ifPresent(bodyFile -> {
            if (postcard.getHtmlBody().isPresent()) {
                String msg = "Cannot use direct HTML body when body file is specified: " + postcard;
                throw new SMailIllegalStateException(msg);
            }
            boolean filesystem = postcard.isFromFilesystem();
            OptionalThing<Locale> receiverLocale = this.prepareReceiverLocale(postcard);
            OptionalThing<Object> dynamicData = this.prepareDynamicData(postcard, (String)bodyFile, filesystem, receiverLocale);
            dynamicData.ifPresent(data -> this.acceptDynamicProperty(postcard, (String)bodyFile, filesystem, receiverLocale, data));
            this.officeManagedLogging(postcard, (String)bodyFile, receiverLocale);
            String plainText = this.readText(postcard, (String)bodyFile, false, filesystem, receiverLocale, dynamicData);
            this.analyzeBodyMeta(postcard, (String)bodyFile, plainText);
            Postcard.DirectBodyOption option = postcard.useDirectBody(plainText);
            if (postcard.isAlsoHtmlFile()) {
                String htmlFilePath = this.deriveHtmlFilePath((String)bodyFile);
                String readHtml = this.readText(postcard, htmlFilePath, true, filesystem, receiverLocale, dynamicData);
                this.verifyMailHtmlTemplateTextFormat(htmlFilePath, readHtml);
                option.alsoDirectHtml(readHtml);
            }
        }).orElse(() -> this.assertPlainBodyExistsForDirectBody(postcard));
        if (!postcard.getFrom().isPresent()) {
            this.throwMailFromAddressNotFoundException(postcard);
        }
    }

    protected void readyPostcardFirst(Postcard postcard) {
    }

    protected void checkPostcardFirst(Postcard postcard) {
        Map<String, Object> variableMap = postcard.getTemplaetVariableMap();
        variableMap.forEach((key, value) -> this.stopDirectlyEntityVariable(postcard, (String)key, value));
    }

    protected void stopDirectlyEntityVariable(Postcard postcard, String key, Object value) {
        Collection coll;
        if (value instanceof Entity) {
            this.throwDirectlyEntityVariableNotAllowedException(postcard, key, value);
        } else if (value instanceof Collection && !(coll = (Collection)value).isEmpty()) {
            Object first;
            Object e = first = coll instanceof List ? ((List)coll).get(0) : coll.iterator().next();
            if (first instanceof Entity) {
                this.throwDirectlyEntityVariableNotAllowedException(postcard, key, value);
            }
        }
    }

    protected void throwDirectlyEntityVariableNotAllowedException(Postcard postcard, String key, Object value) {
        this.security.throwDirectlyEntityVariableNotAllowedException(postcard, key, value);
    }

    protected OptionalThing<Locale> prepareReceiverLocale(Postcard postcard) {
        OptionalThing<Locale> receiverLocale = postcard.getReceiverLocale();
        if (receiverLocale.isPresent()) {
            return receiverLocale;
        }
        if (this.receiverLocaleAssist != null) {
            OptionalThing<Locale> assistedLocale = this.receiverLocaleAssist.assist(postcard);
            if (assistedLocale == null) {
                String msg = "Cannot return null as optional type: receiverLocaleAssist=" + this.receiverLocaleAssist + ", " + postcard;
                throw new SMailIllegalStateException(msg);
            }
            assistedLocale.ifPresent(locale -> postcard.asReceiverLocale((Locale)locale));
            return assistedLocale;
        }
        return OptionalThing.ofNullable(null, () -> {
            throw new SMailIllegalStateException("Not found the locale: " + postcard);
        });
    }

    protected OptionalThing<Object> prepareDynamicData(Postcard postcard, String bodyFile, boolean filesystem, OptionalThing<Locale> receiverLocale) {
        if (this.dynamicTextAssist == null) {
            return OptionalThing.empty();
        }
        SMailDynamicDataResource resource = new SMailDynamicDataResource(postcard, bodyFile, filesystem, receiverLocale);
        OptionalThing<? extends Object> dynamicData = this.dynamicTextAssist.prepareDynamicData(resource);
        if (dynamicData == null) {
            String msg = "Cannot return null as optional type: dynamicTextAssist=" + this.dynamicTextAssist + ", " + postcard;
            throw new SMailIllegalStateException(msg);
        }
        return dynamicData;
    }

    protected void acceptDynamicProperty(final Postcard postcard, String bodyFile, boolean filesystem, OptionalThing<Locale> receiverLocale, Object dynamicData) {
        if (this.dynamicTextAssist == null) {
            return;
        }
        SMailDynamicPropResource resource = new SMailDynamicPropResource(postcard, bodyFile, filesystem, receiverLocale, dynamicData);
        this.dynamicTextAssist.accept(resource, new SMailDynamicPropAcceptor(){

            @Override
            public void acceptFrom(String address, String personal) {
                postcard.setFrom(new SMailAddress(address, personal));
            }
        });
    }

    protected void officeManagedLogging(Postcard postcard, String bodyFile, OptionalThing<Locale> receiverLocale) {
        String systemTitle = "sysInfo";
        postcard.officeManagedLogging("sysInfo", "dfmail", bodyFile);
        postcard.officeManagedLogging("sysInfo", "locale", receiverLocale.map(lo -> lo.toString()).orElse((Object)"none"));
    }

    protected void assertPlainBodyExistsForDirectBody(Postcard postcard) {
        if (!postcard.getPlainBody().isPresent()) {
            String msg = "Not found both the body file path and the direct body: " + postcard;
            throw new SMailIllegalStateException(msg);
        }
    }

    protected void throwMailFromAddressNotFoundException(Postcard postcard) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Not found the 'from' address in the postcard.");
        br.addItem("Advice");
        br.addElement((Object)"Specify your 'from' address.");
        br.addItem("Postcard");
        br.addElement((Object)postcard);
        String msg = br.buildExceptionMessage();
        throw new SMailFromAddressNotFoundException(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String readText(Postcard postcard, String path, boolean html, boolean filesystem, OptionalThing<Locale> receiverLocale, OptionalThing<Object> dynamicData) {
        OptionalThing<String> assisted;
        if (dynamicData.isPresent() && (assisted = this.assistDynamicText(postcard, path, html, filesystem, receiverLocale, dynamicData.get())).isPresent()) {
            return (String)assisted.get();
        }
        String cacheKey = this.generateCacheKey(path, filesystem, receiverLocale);
        String cached = this.textCacheMap.get(cacheKey);
        if (cached != null) {
            return cached;
        }
        SMailConventionReceptionist sMailConventionReceptionist = this;
        synchronized (sMailConventionReceptionist) {
            String retried = this.textCacheMap.get(cacheKey);
            if (retried != null) {
                return retried;
            }
            String read = this.doReadText(postcard, path, filesystem, receiverLocale);
            if (read == null) {
                String msg = "Not found the text from the path: " + path + ", filesystem=" + filesystem;
                throw new SMailIllegalStateException(msg);
            }
            this.textCacheMap.put(cacheKey, read);
            return this.textCacheMap.get(cacheKey);
        }
    }

    protected OptionalThing<String> assistDynamicText(Postcard postcard, String templatePath, boolean html, boolean filesystem, OptionalThing<Locale> receiverLocale, Object dynamicData) {
        if (this.dynamicTextAssist == null) {
            return OptionalThing.empty();
        }
        SMailDynamicTextResource resource = new SMailDynamicTextResource(postcard, templatePath, html, filesystem, receiverLocale, dynamicData);
        OptionalThing<String> assisted = this.dynamicTextAssist.assist(resource);
        if (assisted == null) {
            String msg = "Cannot return null as optional type: dynamicTextAssist=" + this.dynamicTextAssist + ", " + postcard;
            throw new SMailIllegalStateException(msg);
        }
        return assisted;
    }

    protected String generateCacheKey(String path, boolean filesystem, OptionalThing<Locale> receiverLocale) {
        return path + ":" + filesystem + ":" + receiverLocale;
    }

    protected String doReadText(Postcard postcard, String path, boolean filesystem, OptionalThing<Locale> receiverLocale) {
        String read;
        if (filesystem) {
            String realPath = (String)receiverLocale.map(locale -> (String)this.deriveLocaleFilePath(path, (Locale)locale).filter(localeFilePath -> new File((String)localeFilePath).exists()).orElse((Object)path)).orElse((Object)path);
            read = this.textIO.read(realPath);
        } else {
            InputStream ins = (InputStream)receiverLocale.map(locale -> (InputStream)this.findLocaleFileResourceStream(path, (Locale)locale).orElseGet(() -> this.findMainFileResourceStream(postcard, path))).orElseGet(() -> this.findMainFileResourceStream(postcard, path));
            read = this.textIO.read(ins);
        }
        return read;
    }

    protected OptionalThing<InputStream> findLocaleFileResourceStream(String path, Locale locale) {
        return (OptionalThing)this.deriveLocaleFilePath(path, locale).map(localeFilePath -> {
            String localeRealPath = this.adjustClasspathBasePath((String)localeFilePath);
            return OptionalThing.ofNullable((Object)DfResourceUtil.getResourceStream((String)localeRealPath), () -> {
                throw new SMailIllegalStateException("Not found the resource stream for the locale file: " + path + ", " + locale);
            });
        }).orElseGet(() -> OptionalThing.ofNullable(null, () -> {
            throw new SMailIllegalStateException("Not found the language from the locale: " + locale);
        }));
    }

    protected InputStream findMainFileResourceStream(Postcard postcard, String path) {
        String realPath = this.adjustClasspathBasePath(path);
        InputStream ins = DfResourceUtil.getResourceStream((String)realPath);
        if (ins == null) {
            this.throwMailTemplateFromClasspathNotFoundException(postcard, path, realPath);
        }
        return ins;
    }

    protected String adjustClasspathBasePath(String path) {
        return (this.classpathBasePath != null ? this.classpathBasePath + "/" : "") + path;
    }

    protected OptionalThing<String> deriveLocaleFilePath(String path, Locale locale) {
        String front = Srl.substringLastFront((String)path, (String[])new String[]{"."});
        String rear = Srl.substringLastRear((String)path, (String[])new String[]{"."});
        String lang = locale.getLanguage();
        if (lang != null && !lang.isEmpty()) {
            return OptionalThing.of((Object)(front + "." + lang.toLowerCase() + "." + rear));
        }
        return OptionalThing.ofNullable(null, () -> {
            throw new SMailIllegalStateException("Not found the language from the locale: " + locale);
        });
    }

    protected void throwMailTemplateFromClasspathNotFoundException(Postcard postcard, String path, String realPath) {
        this.security.throwMailTemplateFromClasspathNotFoundException(postcard, path, realPath);
    }

    protected void analyzeBodyMeta(Postcard postcard, String bodyFile, String plainText) {
        String meta;
        Srl.ScopeInfo optionScope;
        String delimiter = META_DELIMITER;
        if (plainText.contains(META_DELIMITER)) {
            this.verifyFormat(bodyFile, plainText, META_DELIMITER);
        }
        if ((optionScope = Srl.extractScopeFirst((String)(meta = Srl.replace((String)Srl.substringFirstFront((String)plainText, (String[])new String[]{META_DELIMITER}), (String)CRLF, (String)LF)), (String)OPTION_LABEL, (String)LF)) != null && optionScope.getContent().contains(PLUS_HTML_OPTION)) {
            postcard.officePlusHtml();
        }
    }

    @Override
    public synchronized void workingDispose() {
        this.textCacheMap.clear();
    }

    protected void verifyFormat(String bodyFile, String plainText, String delimiter) {
        String rearMeta;
        List splitList;
        String desc;
        String headerComment;
        Srl.ScopeInfo titleScope;
        String rearFirstStr;
        String meta = Srl.substringFirstFront((String)plainText, (String[])new String[]{delimiter});
        if (!meta.endsWith(LF)) {
            this.throwBodyMetaNoIndependentDelimiterException(bodyFile, plainText);
        }
        int rearIndex = plainText.indexOf(delimiter) + delimiter.length();
        if (plainText.length() > rearIndex && !Srl.equalsPlain((String)(rearFirstStr = plainText.substring(rearIndex, rearIndex + 1)), (String[])new String[]{LF, CR})) {
            this.throwBodyMetaNoIndependentDelimiterException(bodyFile, plainText);
        }
        if (!meta.startsWith(COMMENT_BEGIN)) {
            this.throwBodyMetaNotStartWithHeaderCommentException(bodyFile, plainText, meta);
        }
        if (!meta.contains(COMMENT_END)) {
            this.throwBodyMetaHeaderCommentEndMarkNotFoundException(bodyFile, plainText, meta);
        }
        if ((titleScope = Srl.extractScopeFirst((String)(headerComment = Srl.extractScopeFirst((String)plainText, (String)COMMENT_BEGIN, (String)COMMENT_END).getContent()), (String)TITLE_BEGIN, (String)TITLE_END)) == null) {
            this.throwBodyMetaTitleCommentNotFoundException(bodyFile, plainText);
        }
        if ((desc = Srl.substringFirstRear((String)headerComment, (String[])new String[]{TITLE_END})).isEmpty()) {
            this.throwBodyMetaDescriptionCommentNotFoundException(bodyFile, plainText);
        }
        if (!((String)(splitList = Srl.splitList((String)(rearMeta = Srl.substringFirstRear((String)meta, (String[])new String[]{COMMENT_END})), (String)LF)).get(0)).trim().isEmpty()) {
            this.throwBodyMetaHeaderCommentEndMarkNoIndependentException(bodyFile, plainText);
        }
        if (!((String)splitList.get(1)).startsWith(SUBJECT_LABEL)) {
            this.throwBodyMetaSubjectNotFoundException(bodyFile, plainText);
        }
        int nextIndex = 2;
        if (splitList.size() > 2) {
            List nextList = splitList.subList(2, splitList.size());
            int nextSize = nextList.size();
            int index = 0;
            for (String line : nextList) {
                if (index == nextSize - 1 && line.isEmpty()) break;
                if (!allowedPrefixList.stream().anyMatch(prefix -> line.startsWith((String)prefix))) {
                    this.throwBodyMetaUnknownLineException(bodyFile, plainText, line);
                }
                if (line.startsWith(OPTION_LABEL)) {
                    String options = Srl.substringFirstRear((String)line, (String[])new String[]{OPTION_LABEL});
                    List optionList = Srl.splitListTrimmed((String)options, (String)".");
                    for (String option : optionList) {
                        if (optionSet.contains(option)) continue;
                        this.throwBodyMetaUnknownOptionException(bodyFile, plainText, option);
                    }
                }
                ++index;
            }
        }
    }

    protected void throwBodyMetaNoIndependentDelimiterException(String bodyFile, String plainText) {
        this.security.throwBodyMetaNoIndependentDelimiterException(bodyFile, plainText);
    }

    protected void throwBodyMetaNotStartWithHeaderCommentException(String bodyFile, String plainText, String meta) {
        this.security.throwBodyMetaNotStartWithHeaderCommentException(bodyFile, plainText, meta);
    }

    protected void throwBodyMetaHeaderCommentEndMarkNotFoundException(String bodyFile, String plainText, String meta) {
        this.security.throwBodyMetaHeaderCommentEndMarkNotFoundException(bodyFile, plainText, meta);
    }

    protected void throwBodyMetaTitleCommentNotFoundException(String bodyFile, String plainText) {
        this.security.throwBodyMetaTitleCommentNotFoundException(bodyFile, plainText);
    }

    protected void throwBodyMetaDescriptionCommentNotFoundException(String bodyFile, String plainText) {
        this.security.throwBodyMetaDescriptionCommentNotFoundException(bodyFile, plainText);
    }

    protected void throwBodyMetaHeaderCommentEndMarkNoIndependentException(String bodyFile, String plainText) {
        this.security.throwBodyMetaHeaderCommentEndMarkNoIndependentException(bodyFile, plainText);
    }

    protected void throwBodyMetaSubjectNotFoundException(String bodyFile, String plainText) {
        this.security.throwBodyMetaSubjectNotFoundException(bodyFile, plainText);
    }

    protected void throwBodyMetaUnknownLineException(String bodyFile, String plainText, String line) {
        this.security.throwBodyMetaUnknownLineException(bodyFile, plainText, line);
    }

    protected void throwBodyMetaUnknownOptionException(String bodyFile, String fileText, String option) {
        this.security.throwBodyMetaUnknownOptionException(bodyFile, fileText, option, optionSet);
    }

    protected String deriveHtmlFilePath(String bodyFile) {
        String dirBase = bodyFile.contains("/") ? Srl.substringLastFront((String)bodyFile, (String[])new String[]{"/"}) + "/" : "";
        String pureFileName = Srl.substringLastRear((String)bodyFile, (String[])new String[]{"/"});
        String front = Srl.substringFirstFront((String)pureFileName, (String[])new String[]{"."});
        String rear = Srl.substringFirstRear((String)pureFileName, (String[])new String[]{"."});
        return dirBase + front + "_html." + rear;
    }

    protected void verifyMailHtmlTemplateTextFormat(String htmlFilePath, String readHtml) {
        if (readHtml.contains(META_DELIMITER)) {
            this.throwMailHtmlTemplateTextCannotContainHeaderDelimiterException(htmlFilePath, readHtml);
        }
    }

    protected void throwMailHtmlTemplateTextCannotContainHeaderDelimiterException(String htmlFilePath, String readHtml) {
        this.security.throwMailHtmlTemplateTextCannotContainHeaderDelimiterException(htmlFilePath, readHtml);
    }

    public String toString() {
        String title = DfTypeUtil.toClassTitle((Object)this);
        return title + ":{" + this.textCacheMap.keySet() + "}@" + Integer.toHexString(this.hashCode());
    }
}

