/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.mail.send.embedded.receptionist;

import java.util.Collection;
import java.util.Set;
import org.dbflute.helper.message.ExceptionMessageBuilder;
import org.dbflute.mail.Postcard;
import org.dbflute.mail.send.exception.SMailBodyMetaParseFailureException;
import org.dbflute.mail.send.exception.SMailDirectlyEntityVariableNotAllowedException;
import org.dbflute.mail.send.exception.SMailTemplateNotFoundException;

public class SMailConventionSecurity {
    public void throwDirectlyEntityVariableNotAllowedException(Postcard postcard, String key, Object value) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Registered the entity directly as mail variable.");
        br.addItem("Advice");
        br.addElement((Object)"Not allowed to register register entity directly as mail variable.");
        br.addElement((Object)"Convert your entity data to mail bean for mail variable.");
        br.addElement((Object)"For example:");
        br.addElement((Object)"  (x):");
        br.addElement((Object)"    Member member = ...");
        br.addElement((Object)"    postcard.setMember(member); // *Bad");
        br.addElement((Object)"  (o):");
        br.addElement((Object)"    Member member = ...");
        br.addElement((Object)"    MemberBean bean = mappingToBean(member);");
        br.addElement((Object)"    postcard.setMember(bean); // Good");
        br.addItem("Postcard");
        br.addElement((Object)postcard);
        br.addItem("Registered");
        br.addElement((Object)("key: " + key));
        if (value instanceof Collection) {
            ((Collection)value).forEach(element -> br.addElement(element));
        } else {
            br.addElement(value);
        }
        String msg = br.buildExceptionMessage();
        throw new SMailDirectlyEntityVariableNotAllowedException(msg);
    }

    public void throwMailTemplateFromClasspathNotFoundException(Postcard postcard, String path, String realPath) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Not found the mail template file from classpath");
        br.addItem("Advice");
        br.addElement((Object)"Confirm the location and file path of mail template.");
        br.addElement((Object)"And the file should be in valid classpath.");
        br.addElement((Object)"");
        br.addElement((Object)"While, The searching mail template process needs");
        br.addElement((Object)"context class-loader of current thread.");
        br.addElement((Object)"If the class-loader is null, MailFlute cannot search it.");
        br.addItem("Postcard");
        br.addElement((Object)postcard);
        br.addItem("Mail Template");
        br.addElement((Object)("plain path : " + path));
        br.addElement((Object)("real path  : " + realPath));
        br.addItem("Context ClassLoader");
        br.addElement((Object)Thread.currentThread().getContextClassLoader());
        String msg = br.buildExceptionMessage();
        throw new SMailTemplateNotFoundException(msg);
    }

    public void throwBodyMetaNoIndependentDelimiterException(String bodyFile, String plainText) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("No independent delimter of mail body meta.");
        br.addItem("Advice");
        br.addElement((Object)"The delimter of mail body meta should be independent in line.");
        br.addElement((Object)"For example:");
        br.addElement((Object)"  (x)");
        br.addElement((Object)"    /*");
        br.addElement((Object)"     [...your mail's title]");
        br.addElement((Object)"     ...your mail's description");
        br.addElement((Object)"    */ subject: ... >>>   // *NG");
        br.addElement((Object)"    ...your mail body");
        br.addElement((Object)"  (x)");
        br.addElement((Object)"    /*");
        br.addElement((Object)"     [...your mail's title]");
        br.addElement((Object)"     ...your mail's description");
        br.addElement((Object)"    */");
        br.addElement((Object)"    subject: ...");
        br.addElement((Object)"    >>> ...your mail body // *NG");
        br.addElement((Object)"  (o)");
        br.addElement((Object)"    /*");
        br.addElement((Object)"     [...your mail's title]");
        br.addElement((Object)"     ...your mail's description");
        br.addElement((Object)"    */");
        br.addElement((Object)"    subject: ...");
        br.addElement((Object)"    >>>                   // OK");
        br.addElement((Object)"    ...your mail body");
        this.setupBodyFileInfo(br, bodyFile, plainText);
        String msg = br.buildExceptionMessage();
        throw new SMailBodyMetaParseFailureException(msg);
    }

    public void throwBodyMetaNotStartWithHeaderCommentException(String bodyFile, String plainText, String meta) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Not start with the header comment in the mail body meta.");
        br.addItem("Advice");
        br.addElement((Object)"The mail body meta should start with '/*' and should contain '*/'.");
        br.addElement((Object)"It means header comment of template file is required.");
        br.addElement((Object)"For example:");
        br.addElement((Object)"  (x)");
        br.addElement((Object)"    subject: ...              // *NG");
        br.addElement((Object)"    >>>");
        br.addElement((Object)"    ...your mail body");
        br.addElement((Object)"");
        br.addElement((Object)"  (o)");
        br.addElement((Object)"    /*                        // OK");
        br.addElement((Object)"     [...your mail's title]");
        br.addElement((Object)"     ...your mail's description");
        br.addElement((Object)"    */");
        br.addElement((Object)"    subject: ...");
        br.addElement((Object)"    >>>");
        br.addElement((Object)"    ...your mail body");
        br.addElement((Object)"");
        br.addElement((Object)"And example:");
        br.addElement((Object)"  /*");
        br.addElement((Object)"   [New Member's Registration]");
        br.addElement((Object)"   The memebr will be formalized after click.");
        br.addElement((Object)"   And the ...");
        br.addElement((Object)"  */");
        br.addElement((Object)"  subject: Welcome to your sign up, /*pmb.memberName*/");
        br.addElement((Object)"  >>>");
        br.addElement((Object)"  Hello, sea");
        br.addElement((Object)"  ...");
        this.setupBodyFileInfo(br, bodyFile, plainText);
        br.addItem("Body Meta");
        br.addElement((Object)meta);
        String msg = br.buildExceptionMessage();
        throw new SMailBodyMetaParseFailureException(msg);
    }

    public void throwBodyMetaHeaderCommentEndMarkNotFoundException(String bodyFile, String plainText, String meta) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Not found the header comment end mark in the mail body meta.");
        br.addItem("Advice");
        br.addElement((Object)"The mail body meta should start with '/*' and should contain '*/'.");
        br.addElement((Object)"For example:");
        br.addElement((Object)"  (x):");
        br.addElement((Object)"    /*");
        br.addElement((Object)"     [...your mail's title]");
        br.addElement((Object)"     ...your mail's description");
        br.addElement((Object)"    subject: ...");
        br.addElement((Object)"    >>>");
        br.addElement((Object)"    ...             // *NG: not found");
        br.addElement((Object)"  (x):");
        br.addElement((Object)"    /*");
        br.addElement((Object)"     [...your mail's title]");
        br.addElement((Object)"     ...your mail's description");
        br.addElement((Object)"    >>>");
        br.addElement((Object)"    */              // *NG: after delimiter");
        br.addElement((Object)"    subject: ...");
        br.addElement((Object)"    ...");
        br.addElement((Object)"  (o):");
        br.addElement((Object)"    /*");
        br.addElement((Object)"     [...your mail's title]");
        br.addElement((Object)"     ...your mail's description");
        br.addElement((Object)"    */              // OK");
        br.addElement((Object)"    subject: ...");
        br.addElement((Object)"    >>>");
        br.addElement((Object)"    ...");
        this.setupBodyFileInfo(br, bodyFile, plainText);
        br.addItem("Body Meta");
        br.addElement((Object)meta);
        String msg = br.buildExceptionMessage();
        throw new SMailBodyMetaParseFailureException(msg);
    }

    public void throwBodyMetaTitleCommentNotFoundException(String bodyFile, String plainText) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Not found the title in the header comment of mail body meta.");
        br.addItem("Advice");
        br.addElement((Object)"The mail body meta should contain TITLE in the header comment.");
        br.addElement((Object)"For example:");
        br.addElement((Object)"  (x):");
        br.addElement((Object)"    /*");
        br.addElement((Object)"     ...your mail's description     // *NG");
        br.addElement((Object)"    */");
        br.addElement((Object)"    subject: ...");
        br.addElement((Object)"    >>>");
        br.addElement((Object)"    ...");
        br.addElement((Object)"  (o):");
        br.addElement((Object)"    /*");
        br.addElement((Object)"     [...your mail's title]         // OK");
        br.addElement((Object)"     ...your mail's description");
        br.addElement((Object)"    */");
        br.addElement((Object)"    subject: ...");
        br.addElement((Object)"    >>>");
        br.addElement((Object)"    ...");
        this.setupBodyFileInfo(br, bodyFile, plainText);
        String msg = br.buildExceptionMessage();
        throw new SMailBodyMetaParseFailureException(msg);
    }

    public void throwBodyMetaDescriptionCommentNotFoundException(String bodyFile, String plainText) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Not found the description in the header comment of mail body meta.");
        br.addItem("Advice");
        br.addElement((Object)"The mail body meta should contain DESCRIPTION");
        br.addElement((Object)"in the header comment like this:");
        br.addElement((Object)"For example:");
        br.addElement((Object)"  (x):");
        br.addElement((Object)"    /*");
        br.addElement((Object)"     [...your mail's title]");
        br.addElement((Object)"    */                              // *NG");
        br.addElement((Object)"    subject: ...");
        br.addElement((Object)"    >>>");
        br.addElement((Object)"    ...");
        br.addElement((Object)"  (o):");
        br.addElement((Object)"    /*");
        br.addElement((Object)"     [...your mail's title]");
        br.addElement((Object)"     ...your mail's description     // OK");
        br.addElement((Object)"    */");
        br.addElement((Object)"    subject: ...");
        br.addElement((Object)"    >>>");
        br.addElement((Object)"    ...");
        this.setupBodyFileInfo(br, bodyFile, plainText);
        String msg = br.buildExceptionMessage();
        throw new SMailBodyMetaParseFailureException(msg);
    }

    public void throwBodyMetaHeaderCommentEndMarkNoIndependentException(String bodyFile, String plainText) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("No independent the header comment end mark in the mail body meta.");
        br.addItem("Advice");
        br.addElement((Object)"For example:");
        br.addElement((Object)"  (x):");
        br.addElement((Object)"    /*");
        br.addElement((Object)"     [...your mail's title]");
        br.addElement((Object)"     ...your mail's description");
        br.addElement((Object)"    */ subject: ...        // *NG");
        br.addElement((Object)"    >>>");
        br.addElement((Object)"    ...your mail body");
        br.addElement((Object)"  (o):");
        br.addElement((Object)"    /*");
        br.addElement((Object)"     [...your mail's title]");
        br.addElement((Object)"     ...your mail's description");
        br.addElement((Object)"    */");
        br.addElement((Object)"    subject: ...           // OK");
        br.addElement((Object)"    >>>");
        br.addElement((Object)"    ...your mail body");
        this.setupBodyFileInfo(br, bodyFile, plainText);
        String msg = br.buildExceptionMessage();
        throw new SMailBodyMetaParseFailureException(msg);
    }

    public void throwBodyMetaSubjectNotFoundException(String bodyFile, String plainText) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Not found the subject in the mail body meta.");
        br.addItem("Advice");
        br.addElement((Object)"The mail body meta should have subject.");
        br.addElement((Object)"And should be defined immediately after header comment.");
        br.addElement((Object)"For example:");
        br.addElement((Object)"  (x):");
        br.addElement((Object)"    /*");
        br.addElement((Object)"     [...your mail's title]");
        br.addElement((Object)"     ...your mail's description");
        br.addElement((Object)"    */");
        br.addElement((Object)"    >>>                    // *NG");
        br.addElement((Object)"    ...your mail body");
        br.addElement((Object)"  (x):");
        br.addElement((Object)"    /*");
        br.addElement((Object)"     [...your mail's title]");
        br.addElement((Object)"     ...your mail's description");
        br.addElement((Object)"    */");
        br.addElement((Object)"    option: ...");
        br.addElement((Object)"    subject: ...           // *NG");
        br.addElement((Object)"    >>>");
        br.addElement((Object)"    ...your mail body");
        br.addElement((Object)"  (o):");
        br.addElement((Object)"    /*");
        br.addElement((Object)"     [...your mail's title]");
        br.addElement((Object)"     ...your mail's description");
        br.addElement((Object)"    */");
        br.addElement((Object)"    subject: ...           // OK");
        br.addElement((Object)"    >>>");
        br.addElement((Object)"    ...your mail body");
        this.setupBodyFileInfo(br, bodyFile, plainText);
        String msg = br.buildExceptionMessage();
        throw new SMailBodyMetaParseFailureException(msg);
    }

    public void throwBodyMetaUnknownLineException(String bodyFile, String plainText, String line) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Unknown line in the template meta.");
        br.addItem("Advice");
        br.addElement((Object)"The mail body meta should start with option:");
        br.addElement((Object)"or fixed style, e.g. '-- !!...!!'");
        br.addElement((Object)"For example:");
        br.addElement((Object)"  (x):");
        br.addElement((Object)"    /*");
        br.addElement((Object)"     [...your mail's title]");
        br.addElement((Object)"     ...your mail's description");
        br.addElement((Object)"    */");
        br.addElement((Object)"    subject: ...");
        br.addElement((Object)"    maihama     // *NG: unknown meta definition");
        br.addElement((Object)"    >>>");
        br.addElement((Object)"    ...");
        br.addElement((Object)"  (x):");
        br.addElement((Object)"    /*");
        br.addElement((Object)"     [...your mail's title]");
        br.addElement((Object)"     ...your mail's description");
        br.addElement((Object)"    */");
        br.addElement((Object)"    subject: ...");
        br.addElement((Object)"                // *NG: empty line not allowed");
        br.addElement((Object)"    >>>");
        br.addElement((Object)"    ...");
        br.addElement((Object)"  (o):");
        br.addElement((Object)"    /*");
        br.addElement((Object)"     [...your mail's title]");
        br.addElement((Object)"     ...your mail's description");
        br.addElement((Object)"    */");
        br.addElement((Object)"    subject: ...");
        br.addElement((Object)"    >>>");
        br.addElement((Object)"    ...");
        br.addElement((Object)"  (o):");
        br.addElement((Object)"    /*");
        br.addElement((Object)"     [...your mail's title]");
        br.addElement((Object)"     ...your mail's description");
        br.addElement((Object)"    */");
        br.addElement((Object)"    subject: ...");
        br.addElement((Object)"    -- !!String memberName!!");
        br.addElement((Object)"    >>>");
        br.addElement((Object)"    ...");
        this.setupBodyFileInfo(br, bodyFile, plainText);
        br.addItem("Unknown Line");
        br.addElement((Object)line);
        String msg = br.buildExceptionMessage();
        throw new IllegalStateException(msg);
    }

    public void throwBodyMetaUnknownOptionException(String bodyFile, String fileText, String option, Set<String> optionSet) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Unknown option for MailFlute body meta.");
        br.addItem("Advice");
        br.addElement((Object)"You can specify the following option:");
        br.addElement(optionSet);
        br.addElement((Object)"For example:");
        br.addElement((Object)"  (x):");
        br.addElement((Object)"    /*");
        br.addElement((Object)"     [...your mail's title]");
        br.addElement((Object)"     ...your mail's description");
        br.addElement((Object)"    */");
        br.addElement((Object)"    subject: ...");
        br.addElement((Object)"    option: maihama      // *NG: unknown option");
        br.addElement((Object)"    >>>");
        br.addElement((Object)"    ...");
        br.addElement((Object)"  (o):");
        br.addElement((Object)"    /*");
        br.addElement((Object)"     [...your mail's title]");
        br.addElement((Object)"     ...your mail's description");
        br.addElement((Object)"    */");
        br.addElement((Object)"    subject: ...");
        br.addElement((Object)"    option: genAsIs      // OK");
        br.addElement((Object)"    >>>");
        br.addElement((Object)"    ...");
        br.addItem("Body File");
        br.addElement((Object)bodyFile);
        br.addItem("File Text");
        br.addElement((Object)fileText);
        br.addItem("Unknown Option");
        br.addElement((Object)option);
        String msg = br.buildExceptionMessage();
        throw new SMailBodyMetaParseFailureException(msg);
    }

    protected void setupBodyFileInfo(ExceptionMessageBuilder br, String bodyFile, String plainText) {
        br.addItem("Body File");
        br.addElement((Object)bodyFile);
        br.addItem("Plain Text");
        br.addElement((Object)plainText);
    }

    public void throwMailHtmlTemplateTextCannotContainHeaderDelimiterException(String htmlFilePath, String readHtml) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("HTML template cannot contain meta delimiter '>>>'.");
        br.addItem("Advice");
        br.addElement((Object)"Body meta delimiter '>>>' can be used by plain text template.");
        br.addElement((Object)"HTML template has only its body.");
        br.addElement((Object)"For example:");
        br.addElement((Object)"  (x):");
        br.addElement((Object)"    /*");
        br.addElement((Object)"     ...");
        br.addElement((Object)"    */");
        br.addElement((Object)"    >>>        // *NG");
        br.addElement((Object)"    <html>");
        br.addElement((Object)"    ...");
        br.addElement((Object)"  (o):");
        br.addElement((Object)"    <html>     // OK");
        br.addElement((Object)"    ...");
        br.addItem("HTML Template");
        br.addElement((Object)htmlFilePath);
        br.addItem("Read HTML");
        br.addElement((Object)readHtml);
        String msg = br.buildExceptionMessage();
        throw new SMailBodyMetaParseFailureException(msg);
    }
}

