/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.mail.send.hook;

import org.dbflute.mail.CardView;
import org.dbflute.mail.send.hook.SMailPreparedMessageHook;
import org.dbflute.mail.send.supplement.SMailPostingDiscloser;
import org.dbflute.util.DfTypeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SMailCallbackContext {
    private static final Logger _log = LoggerFactory.getLogger(SMailCallbackContext.class);
    protected static final ThreadLocal<SMailCallbackContext> _defaultThreadLocal = new ThreadLocal();
    protected static final SMailCallbackContextHolder _defaultHolder;
    protected static SMailCallbackContextHolder _holder;
    protected static boolean _locked;
    protected SMailPreparedMessageHook _preparedMessageHook;

    public static SMailCallbackContext getCallbackContextOnThread() {
        return SMailCallbackContext.getActiveHolder().provide();
    }

    public static void setCallbackContextOnThread(SMailCallbackContext callbackContext) {
        if (callbackContext == null) {
            String msg = "The argument 'callbackContext' must not be null.";
            throw new IllegalArgumentException(msg);
        }
        SMailCallbackContext.getActiveHolder().save(callbackContext);
    }

    public static boolean isExistCallbackContextOnThread() {
        return SMailCallbackContext.getActiveHolder().provide() != null;
    }

    public static void clearCallbackContextOnThread() {
        SMailCallbackContext.getActiveHolder().save(null);
    }

    protected static SMailCallbackContextHolder getActiveHolder() {
        return _holder;
    }

    public static void useSurrogateHolder(SMailCallbackContextHolder holder) {
        SMailCallbackContext.assertNotLocked();
        if (_log.isInfoEnabled()) {
            _log.info("...Setting surrogate holder for callback context: " + holder);
        }
        _holder = holder != null ? holder : _defaultHolder;
        _locked = true;
    }

    public static boolean isLocked() {
        return _locked;
    }

    public static void lock() {
        if (_log.isInfoEnabled()) {
            _log.info("...Locking the static world of the callback context!");
        }
        _locked = true;
    }

    public static void unlock() {
        if (_log.isInfoEnabled()) {
            _log.info("...Unlocking the static world of the callback context!");
        }
        _locked = false;
    }

    protected static void assertNotLocked() {
        if (!SMailCallbackContext.isLocked()) {
            return;
        }
        String msg = "The callback context is locked! Don't access at this timing!";
        throw new IllegalStateException(msg);
    }

    public static void setPreparedMessageHookOnThread(SMailPreparedMessageHook preparedMessageHook) {
        SMailCallbackContext context = SMailCallbackContext.getOrCreateContext();
        context.setPreparedMessageHook(preparedMessageHook);
    }

    public static boolean isExistPreparedMessageHookOnThread() {
        return SMailCallbackContext.isExistCallbackContextOnThread() && SMailCallbackContext.getCallbackContextOnThread().getPreparedMessageHook() != null;
    }

    public static void clearPreparedMessageHookOnThread() {
        if (SMailCallbackContext.isExistCallbackContextOnThread()) {
            SMailCallbackContext context = SMailCallbackContext.getCallbackContextOnThread();
            context.setPreparedMessageHook(null);
            SMailCallbackContext.clearIfNoInterface(context);
        }
    }

    protected static SMailCallbackContext getOrCreateContext() {
        if (SMailCallbackContext.isExistCallbackContextOnThread()) {
            return SMailCallbackContext.getCallbackContextOnThread();
        }
        SMailCallbackContext context = new SMailCallbackContext();
        SMailCallbackContext.setCallbackContextOnThread(context);
        return context;
    }

    protected static void clearIfNoInterface(SMailCallbackContext context) {
        if (!context.hasAnyInterface()) {
            SMailCallbackContext.clearCallbackContextOnThread();
        }
    }

    public boolean hasAnyInterface() {
        return this._preparedMessageHook != null;
    }

    public String toString() {
        String title = DfTypeUtil.toClassTitle((Object)this);
        StringBuilder sb = new StringBuilder();
        sb.append(title);
        sb.append(":{preparedMessageHook=").append(this._preparedMessageHook);
        sb.append("}");
        return sb.toString();
    }

    public SMailPreparedMessageHook getPreparedMessageHook() {
        return this._preparedMessageHook;
    }

    public void setPreparedMessageHook(SMailPreparedMessageHook preparedMessageHook) {
        this._preparedMessageHook = this._preparedMessageHook != null && preparedMessageHook != null && preparedMessageHook.inheritsExistingHook() ? this.createInheritablePreparedMessageHook(preparedMessageHook) : preparedMessageHook;
    }

    protected InheritablePreparedMessageHook createInheritablePreparedMessageHook(SMailPreparedMessageHook preparedMessageHook) {
        return new InheritablePreparedMessageHook(this._preparedMessageHook, preparedMessageHook);
    }

    static {
        _holder = _defaultHolder = new SMailCallbackContextHolder(){

            @Override
            public SMailCallbackContext provide() {
                return _defaultThreadLocal.get();
            }

            @Override
            public void save(SMailCallbackContext context) {
                _defaultThreadLocal.set(context);
            }
        };
        _locked = true;
    }

    protected static class InheritablePreparedMessageHook
    implements SMailPreparedMessageHook {
        protected final SMailPreparedMessageHook _originally;
        protected final SMailPreparedMessageHook _yourHook;

        public InheritablePreparedMessageHook(SMailPreparedMessageHook originally, SMailPreparedMessageHook yourHook) {
            this._originally = originally;
            this._yourHook = yourHook;
        }

        @Override
        public void hookPreparedMessage(CardView cardView, SMailPostingDiscloser discloser) {
            if (this._originally != null) {
                this._originally.hookPreparedMessage(cardView, discloser);
            }
            this._yourHook.hookPreparedMessage(cardView, discloser);
        }
    }

    public static interface SMailCallbackContextHolder {
        public SMailCallbackContext provide();

        public void save(SMailCallbackContext var1);
    }
}

