/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.mail.send.supplement.logging;

import org.dbflute.mail.CardView;
import org.dbflute.mail.send.supplement.SMailPostingDiscloser;
import org.dbflute.mail.send.supplement.logging.SMailLoggingStrategy;
import org.dbflute.optional.OptionalThing;
import org.dbflute.util.Srl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SMailTypicalLoggingStrategy
implements SMailLoggingStrategy {
    public static final String MESSAGE_LOGGER_NAME = "mailflute.sending";
    private static final Logger messageLogger = LoggerFactory.getLogger((String)"mailflute.sending");
    private static final Logger normalLogger = LoggerFactory.getLogger(SMailTypicalLoggingStrategy.class);

    @Override
    public void logMailBefore(CardView view, SMailPostingDiscloser discloser) {
        this.showMessage(view, discloser);
    }

    protected void showMessage(CardView view, SMailPostingDiscloser discloser) {
        boolean messageInfoEnabled = messageLogger.isInfoEnabled();
        boolean normalDebugEnabled = normalLogger.isDebugEnabled();
        if (!messageInfoEnabled && !normalDebugEnabled) {
            return;
        }
        String msg = this.buildMessageDisp(view, discloser);
        if (messageInfoEnabled) {
            messageLogger.info(msg);
        }
        if (normalDebugEnabled) {
            normalLogger.debug(msg);
        }
    }

    protected String buildMessageDisp(CardView view, SMailPostingDiscloser discloser) {
        String state = discloser.isTraining() ? "as training" : "actually";
        String hash = this.toHash(discloser);
        String disp = discloser.toDisplay();
        return "...Sending mail " + state + ": #" + hash + "\n" + disp;
    }

    @Override
    public void logMailFinally(CardView view, SMailPostingDiscloser discloser, OptionalThing<Exception> cause) {
        this.showResult(discloser, cause);
    }

    protected void showResult(SMailPostingDiscloser discloser, OptionalThing<Exception> cause) {
        boolean messageInfoEnabled = messageLogger.isInfoEnabled();
        boolean normalDebugEnabled = normalLogger.isDebugEnabled();
        if (!messageInfoEnabled && !normalDebugEnabled) {
            return;
        }
        String msg = this.buildResultDisp(discloser, cause);
        if (messageInfoEnabled) {
            messageLogger.info(msg);
        }
        if (normalDebugEnabled) {
            normalLogger.debug(msg);
        }
    }

    protected String buildResultDisp(SMailPostingDiscloser discloser, OptionalThing<Exception> cause) {
        String hash = this.toHash(discloser);
        String returnExp = this.doBuildResultDispLastReturnCode(discloser);
        String responseExp = this.doBuildResultDispLastServerResponse(discloser);
        String causeExp = this.doBuildResultDispCause(cause);
        return "Finished mail: #" + hash + returnExp + responseExp + causeExp;
    }

    protected String doBuildResultDispLastReturnCode(SMailPostingDiscloser discloser) {
        return (String)discloser.getLastReturnCode().map(code -> " return=" + code).orElse((Object)"");
    }

    protected String doBuildResultDispLastServerResponse(SMailPostingDiscloser discloser) {
        return (String)discloser.getLastServerResponse().map(res -> " response=" + res.trim()).orElse((Object)"");
    }

    protected String doBuildResultDispCause(OptionalThing<Exception> cause) {
        return (String)cause.map(exp -> " *" + exp.getClass().getSimpleName()).orElse((Object)"");
    }

    @Override
    public void logRetrySuccess(CardView view, SMailPostingDiscloser discloser, int challengeCount, Exception firstCause) {
        if (normalLogger.isInfoEnabled()) {
            normalLogger.info(this.buildRetrySuccessDisp(view, discloser, challengeCount, firstCause));
        }
    }

    protected String buildRetrySuccessDisp(CardView view, SMailPostingDiscloser discloser, int challengeCount, Exception firstCause) {
        String hash = this.toHash(discloser);
        String causeExp = this.buildCauseExp(firstCause);
        return "Successful mail by retry: #" + hash + " challengeCount=" + challengeCount + " postcard=" + view + " cause=" + causeExp;
    }

    protected String buildCauseExp(Exception firstCause) {
        String tmp = firstCause.getMessage();
        return tmp != null ? Srl.substringFirstFront((String)tmp.trim(), (String[])new String[]{"\n"}).trim() : null;
    }

    @Override
    public void logSuppressedCause(CardView view, SMailPostingDiscloser discloser, Exception suppressedCause) {
        if (normalLogger.isWarnEnabled()) {
            normalLogger.warn(this.buildSuppressedCauseDisp(view, discloser, suppressedCause), (Throwable)suppressedCause);
        }
    }

    protected String buildSuppressedCauseDisp(CardView view, SMailPostingDiscloser discloser, Exception suppressedCause) {
        return "Failed to send the mail but continued: #" + this.toHash(discloser) + " " + view;
    }

    protected String toHash(SMailPostingDiscloser discloser) {
        return discloser.toHash();
    }
}

