/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.startup.ContextConfig;
import org.apache.tomcat.JarScanFilter;
import org.apache.tomcat.JarScanType;
import org.apache.tomcat.JarScanner;
import org.apache.tomcat.util.descriptor.web.WebXml;
import org.apache.tomcat.util.descriptor.web.WebXmlParser;
import org.dbflute.tomcat.core.RhythmicalHandlingDef;

public class RhythmicalContextConfig
extends ContextConfig {
    protected final RhythmicalHandlingDef.AnnotationHandling annotationHandling;
    protected final RhythmicalHandlingDef.MetaInfoResourceHandling metaInfoResourceHandling;
    protected final RhythmicalHandlingDef.TldHandling tldHandling;
    protected final Predicate<String> tldFilesSelector;
    protected final RhythmicalHandlingDef.WebFragmentsHandling webFragmentsHandling;
    protected final Predicate<String> webFragmentsSelector;
    protected boolean alreadyFirstLifecycle;

    public RhythmicalContextConfig(RhythmicalHandlingDef.AnnotationHandling annotationHandling, RhythmicalHandlingDef.MetaInfoResourceHandling metaInfoResourceHandling, RhythmicalHandlingDef.TldHandling tldHandling, Predicate<String> tldFilesSelector, RhythmicalHandlingDef.WebFragmentsHandling webFragmentsHandling, Predicate<String> webFragmentsSelector) {
        this.annotationHandling = annotationHandling;
        this.metaInfoResourceHandling = metaInfoResourceHandling;
        this.tldHandling = tldHandling;
        this.tldFilesSelector = tldFilesSelector;
        this.webFragmentsHandling = webFragmentsHandling;
        this.webFragmentsSelector = webFragmentsSelector;
    }

    public void lifecycleEvent(LifecycleEvent event) {
        super.lifecycleEvent(event);
        if (!this.alreadyFirstLifecycle) {
            this.alreadyFirstLifecycle = true;
            if (this.isJarScannerAdjustmentEnabled()) {
                JarScanner jarScanner = this.extractJarScanner();
                JarScanFilter jarScanFilter = jarScanner.getJarScanFilter();
                jarScanner.setJarScanFilter(this.createSelectableJarScanFilter(jarScanFilter));
            }
        }
    }

    protected boolean isJarScannerAdjustmentEnabled() {
        return this.isTldFilesSelectorEnabled() || this.isWebFragmentsSelectorEnabled();
    }

    protected JarScanner extractJarScanner() {
        return this.context.getJarScanner();
    }

    protected JarScanFilter createSelectableJarScanFilter(JarScanFilter existingFilter) {
        if (existingFilter instanceof SelectableJarScanFilter) {
            return existingFilter;
        }
        return new SelectableJarScanFilter(existingFilter);
    }

    protected Map<String, WebXml> processJarsForWebFragments(WebXml application, WebXmlParser webXmlParser) {
        if (this.isWebFragmentsHandlingDetect()) {
            return super.processJarsForWebFragments(application, webXmlParser);
        }
        return new HashMap<String, WebXml>(2);
    }

    protected void processServletContainerInitializers() {
        if (this.isAvailableServletContainerInitializers()) {
            super.processServletContainerInitializers();
        }
        this.removeJettyInitializer();
    }

    protected boolean isAvailableServletContainerInitializers() {
        return this.isAnnotationHandlingDetect() || this.isTldHandlingDetect();
    }

    protected void removeJettyInitializer() {
        this.initializerClassMap.keySet().stream().filter(initializer -> initializer.getClass().getName().startsWith("org.eclipse.jetty")).collect(Collectors.toList()).forEach(initializer -> this.initializerClassMap.remove(initializer));
    }

    protected void processAnnotations(Set<WebXml> fragments, boolean handlesTypesOnly, Map<String, ContextConfig.JavaClassCacheEntry> javaClassCache) {
        if (this.isAnnotationHandlingDetect()) {
            super.processAnnotations(fragments, handlesTypesOnly, javaClassCache);
        }
    }

    protected void processResourceJARs(Set<WebXml> fragments) {
        if (this.isMetaInfoResourceHandlingDetect()) {
            super.processResourceJARs(fragments);
        }
    }

    protected boolean isAnnotationHandlingDetect() {
        return RhythmicalHandlingDef.AnnotationHandling.DETECT.equals((Object)this.annotationHandling);
    }

    protected boolean isMetaInfoResourceHandlingDetect() {
        return RhythmicalHandlingDef.MetaInfoResourceHandling.DETECT.equals((Object)this.metaInfoResourceHandling);
    }

    protected boolean isTldHandlingDetect() {
        return RhythmicalHandlingDef.TldHandling.DETECT.equals((Object)this.tldHandling);
    }

    protected boolean isTldFilesSelectorEnabled() {
        return this.isTldHandlingDetect() && this.tldFilesSelector != null;
    }

    protected boolean isWebFragmentsHandlingDetect() {
        return RhythmicalHandlingDef.WebFragmentsHandling.DETECT.equals((Object)this.webFragmentsHandling);
    }

    protected boolean isWebFragmentsSelectorEnabled() {
        return this.isWebFragmentsHandlingDetect() && this.webFragmentsSelector != null;
    }

    protected class SelectableJarScanFilter
    implements JarScanFilter {
        protected final JarScanFilter existingFilter;

        public SelectableJarScanFilter(JarScanFilter existingFilter) {
            this.existingFilter = existingFilter;
        }

        public boolean check(JarScanType jarScanType, String jarName) {
            if (JarScanType.TLD.equals((Object)jarScanType)) {
                if (RhythmicalContextConfig.this.isTldFilesSelectorEnabled()) {
                    return RhythmicalContextConfig.this.tldFilesSelector.test(jarName);
                }
            } else if (JarScanType.PLUGGABILITY.equals((Object)jarScanType) && RhythmicalContextConfig.this.isWebFragmentsSelectorEnabled()) {
                return RhythmicalContextConfig.this.webFragmentsSelector.test(jarName);
            }
            return this.existingFilter.check(jarScanType, jarName);
        }
    }
}

