/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.tomcat;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.ServletException;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.Valve;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.startup.Tomcat;
import org.dbflute.tomcat.core.RhythmicalHandlingDef;
import org.dbflute.tomcat.core.RhythmicalTomcat;
import org.dbflute.tomcat.core.accesslog.AccessLogOption;
import org.dbflute.tomcat.core.likeit.LikeItCatalinaSetupper;
import org.dbflute.tomcat.core.valve.YourValveOption;
import org.dbflute.tomcat.logging.BootLogger;
import org.dbflute.tomcat.logging.TomcatLoggingOption;
import org.dbflute.tomcat.props.BootPropsTranslator;
import org.dbflute.tomcat.util.BotmResourceUtil;

public class TomcatBoot {
    protected static final String DEFAULT_MARK_DIR = "/tmp/dbflute/tomcatboot";
    protected final int port;
    protected final String contextPath;
    protected boolean development;
    protected boolean browseOnDesktop;
    protected boolean suppressShutdownHook;
    protected boolean useAnnotationDetect;
    protected boolean useMetaInfoResourceDetect;
    protected boolean useTldDetect;
    protected Predicate<String> tldFilesSelector;
    protected boolean useWebFragmentsDetect;
    protected Predicate<String> webFragmentsSelector;
    protected String configFile;
    protected String[] extendsConfigFiles;
    protected String loggingFile;
    protected Consumer<TomcatLoggingOption> loggingOptionCall;
    protected String baseDir;
    protected YourValveOption yourValveOption;
    protected LikeItCatalinaSetupper likeitCatalinaSetupper;
    protected Properties configProps;
    protected List<String> readConfigList;
    protected BootLogger bootLogger;
    protected Tomcat server;
    protected final BootPropsTranslator propsTranslator = this.createBootPropsTranslator();

    protected BootPropsTranslator createBootPropsTranslator() {
        return new BootPropsTranslator();
    }

    public TomcatBoot(int port, String contextPath) {
        if (contextPath == null) {
            throw new IllegalArgumentException("The argument 'contextPath' should not be null.");
        }
        this.port = port;
        this.contextPath = contextPath;
    }

    public TomcatBoot asDevelopment() {
        this.development = true;
        return this;
    }

    public TomcatBoot asDevelopment(boolean development) {
        this.development = development;
        return this;
    }

    public TomcatBoot browseOnDesktop() {
        this.browseOnDesktop = true;
        return this;
    }

    public TomcatBoot suppressShutdownHook() {
        this.assertDevelopmentState();
        this.suppressShutdownHook = true;
        return this;
    }

    protected void assertDevelopmentState() {
        if (!this.development) {
            throw new IllegalStateException("The option is valid only when development: port=" + this.port);
        }
    }

    public TomcatBoot useAnnotationDetect() {
        this.useAnnotationDetect = true;
        return this;
    }

    public TomcatBoot useMetaInfoResourceDetect() {
        this.useMetaInfoResourceDetect = true;
        return this;
    }

    public TomcatBoot useTldDetect() {
        this.useTldDetect = true;
        return this;
    }

    public TomcatBoot useTldDetect(Predicate<String> oneArgLambda) {
        this.useTldDetect = true;
        this.tldFilesSelector = oneArgLambda;
        return this;
    }

    public TomcatBoot useWebFragmentsDetect() {
        this.useWebFragmentsDetect = true;
        return this;
    }

    public TomcatBoot useWebFragmentsDetect(Predicate<String> oneArgLambda) {
        this.useWebFragmentsDetect = true;
        this.webFragmentsSelector = oneArgLambda;
        return this;
    }

    public TomcatBoot configure(String configFile, String ... extendsConfigFiles) {
        if (configFile == null || configFile.trim().length() == 0) {
            throw new IllegalArgumentException("The argument 'configFile' should not be null or empty: " + configFile);
        }
        if (extendsConfigFiles == null) {
            throw new IllegalArgumentException("The argument 'extendsConfigFiles' should not be null or empty: configFile=" + configFile);
        }
        this.configFile = configFile;
        this.extendsConfigFiles = extendsConfigFiles;
        return this;
    }

    public TomcatBoot logging(String loggingFile, Consumer<TomcatLoggingOption> opLambda) {
        if (loggingFile == null || loggingFile.trim().length() == 0) {
            throw new IllegalArgumentException("The argument 'loggingFile' should not be null or empty: " + loggingFile);
        }
        if (opLambda == null) {
            throw new IllegalArgumentException("The argument 'opLambda' should not be null.");
        }
        this.loggingFile = loggingFile;
        this.loggingOptionCall = opLambda;
        return this;
    }

    public TomcatBoot atBaseDir(String baseDir) {
        this.baseDir = baseDir;
        return this;
    }

    public TomcatBoot valve(Valve yourValve) {
        if (yourValve == null) {
            throw new IllegalArgumentException("The argument 'yourValve' should not be null.");
        }
        if (this.yourValveOption == null) {
            this.yourValveOption = new YourValveOption();
        }
        this.yourValveOption.valve(yourValve);
        return this;
    }

    public TomcatBoot asYouLikeIt(LikeItCatalinaSetupper resourceLambda) {
        if (resourceLambda == null) {
            throw new IllegalArgumentException("The argument 'resourceLambda' should not be null.");
        }
        this.likeitCatalinaSetupper = resourceLambda;
        return this;
    }

    public TomcatBoot bootAwait() {
        this.ready();
        this.go();
        this.await();
        return this;
    }

    public void ready() {
        this.loadServerConfigIfNeeds();
        this.loadServerLoggingIfNeeds();
    }

    protected void loadServerConfigIfNeeds() {
        if (this.configFile == null) {
            return;
        }
        this.configProps = new Properties();
        this.readConfigList = new ArrayList<String>();
        if (this.extendsConfigFiles != null && this.extendsConfigFiles.length > 0) {
            ArrayList<String> extendsConfigFileList = new ArrayList<String>(Arrays.asList(this.extendsConfigFiles));
            Collections.reverse(extendsConfigFileList);
            for (String extendsConfigFile : extendsConfigFileList) {
                String extendsResolvedFile = this.resolveConfigEnvPath(extendsConfigFile);
                this.readConfigList.add(extendsResolvedFile);
                this.configProps.putAll((Map<?, ?>)this.readConfigProps(extendsResolvedFile));
            }
        }
        String resolvedFile = this.resolveConfigEnvPath(this.configFile);
        this.readConfigList.add(resolvedFile);
        this.configProps.putAll((Map<?, ?>)this.readConfigProps(resolvedFile));
        Collections.reverse(this.readConfigList);
    }

    protected String resolveConfigEnvPath(String envPath) {
        return this.propsTranslator.resolveConfigEnvPath(envPath);
    }

    protected Properties readConfigProps(String propFile) {
        return this.propsTranslator.readConfigProps(propFile);
    }

    protected void loadServerLoggingIfNeeds() {
        this.bootLogger = new BootLogger(this.loggingFile, this.loggingOptionCall, this.configProps);
    }

    public void go() {
        this.info("...Booting the Tomcat: port=" + this.port + " contextPath=" + this.contextPath);
        if (this.development) {
            this.registerShutdownHook();
        }
        this.prepareServer();
        URI uri = this.startServer();
        this.info("Boot successful" + (this.development ? " as development" : "") + ": url -> " + uri);
        if (this.development) {
            this.browseOnDesktop(uri);
        }
    }

    protected void prepareServer() {
        this.server = this.createTomcat();
        this.server.setPort(this.port);
        if (this.baseDir != null) {
            this.server.setBaseDir(this.baseDir);
        }
        this.adjustServer();
        this.setupWebappContext();
        this.setupServerConfigIfNeeds();
    }

    protected void adjustServer() {
        if (this.isUnpackWARsDisabled()) {
            this.disableUnpackWARsOption();
        }
    }

    protected void setupWebappContext() {
        String warPath = this.prepareWarPath();
        try {
            if (warPath.endsWith(".war")) {
                this.doSetupWebappContextWar(warPath);
            } else {
                this.doSetupWebappContextWebappDir();
            }
        }
        catch (ServletException e) {
            throw new IllegalStateException("Failed to set up web context: warPath=" + warPath, e);
        }
    }

    protected void doSetupWebappContextWar(String warPath) throws ServletException {
        this.server.addWebapp(this.contextPath, warPath);
        if (!this.isUnpackWARsDisabled()) {
            this.prepareUnpackWARsEnv();
        }
    }

    protected void doSetupWebappContextWebappDir() throws ServletException {
        String webappPath = this.prepareWebappPath();
        String docBase = new File(webappPath).getAbsolutePath();
        Context context = this.server.addWebapp(this.contextPath, docBase);
        String webXmlPath = this.prepareWebXmlPath(webappPath);
        context.getServletContext().setAttribute("org.apache.catalina.deploy.alt_dd", (Object)webXmlPath);
    }

    protected Tomcat createTomcat() {
        RhythmicalHandlingDef.AnnotationHandling annotationHandling = this.prepareAnnotationHandling();
        RhythmicalHandlingDef.MetaInfoResourceHandling metaInfoResourceHandling = this.prepareMetaInfoResourceHandling();
        RhythmicalHandlingDef.TldHandling tldHandling = this.prepareTldHandling();
        Predicate<String> tldFilesSelector = this.prepareTldFilesSelector();
        RhythmicalHandlingDef.WebFragmentsHandling webFragmentsHandling = this.prepareuseWebFragmentsHandling();
        Predicate<String> webFragmentsSelector = this.prepareWebFragmentsSelector();
        AccessLogOption accessLogOption = this.prepareAccessLogOption();
        YourValveOption yourValveOption = this.prepareYourValveOption();
        LikeItCatalinaSetupper likeitCatalinaSetupper = this.prepareLikeItCatalinaSetupper();
        return this.newRhythmicalTomcat(this.bootLogger, annotationHandling, metaInfoResourceHandling, tldHandling, tldFilesSelector, webFragmentsHandling, webFragmentsSelector, accessLogOption, yourValveOption, likeitCatalinaSetupper);
    }

    protected RhythmicalTomcat newRhythmicalTomcat(BootLogger bootLogger, RhythmicalHandlingDef.AnnotationHandling annotationHandling, RhythmicalHandlingDef.MetaInfoResourceHandling metaInfoResourceHandling, RhythmicalHandlingDef.TldHandling tldHandling, Predicate<String> tldFilesSelector, RhythmicalHandlingDef.WebFragmentsHandling webFragmentsHandling, Predicate<String> webFragmentsSelector, AccessLogOption accessLogOption, YourValveOption yourValveOption, LikeItCatalinaSetupper likeitCatalinaSetupper) {
        return new RhythmicalTomcat(bootLogger, annotationHandling, metaInfoResourceHandling, tldHandling, tldFilesSelector, webFragmentsHandling, webFragmentsSelector, accessLogOption, yourValveOption, likeitCatalinaSetupper);
    }

    protected RhythmicalHandlingDef.AnnotationHandling prepareAnnotationHandling() {
        return this.useAnnotationDetect ? RhythmicalHandlingDef.AnnotationHandling.DETECT : RhythmicalHandlingDef.AnnotationHandling.NONE;
    }

    protected RhythmicalHandlingDef.MetaInfoResourceHandling prepareMetaInfoResourceHandling() {
        return this.useMetaInfoResourceDetect ? RhythmicalHandlingDef.MetaInfoResourceHandling.DETECT : RhythmicalHandlingDef.MetaInfoResourceHandling.NONE;
    }

    protected RhythmicalHandlingDef.TldHandling prepareTldHandling() {
        return this.useTldDetect ? RhythmicalHandlingDef.TldHandling.DETECT : RhythmicalHandlingDef.TldHandling.NONE;
    }

    protected Predicate<String> prepareTldFilesSelector() {
        return this.tldFilesSelector;
    }

    protected RhythmicalHandlingDef.WebFragmentsHandling prepareuseWebFragmentsHandling() {
        return this.useWebFragmentsDetect ? RhythmicalHandlingDef.WebFragmentsHandling.DETECT : RhythmicalHandlingDef.WebFragmentsHandling.NONE;
    }

    protected Predicate<String> prepareWebFragmentsSelector() {
        return this.webFragmentsSelector;
    }

    protected AccessLogOption prepareAccessLogOption() {
        return this.propsTranslator.prepareAccessLogOption(this.bootLogger, this.configProps, this.readConfigList);
    }

    protected YourValveOption prepareYourValveOption() {
        return this.yourValveOption;
    }

    protected LikeItCatalinaSetupper prepareLikeItCatalinaSetupper() {
        return this.likeitCatalinaSetupper;
    }

    public void await() {
        if (this.server == null) {
            throw new IllegalStateException("server has not been started.");
        }
        try {
            this.server.getServer().await();
        }
        catch (Exception e) {
            throw new IllegalStateException("server join failed.", e);
        }
    }

    protected String prepareWarPath() {
        String path;
        URL location = TomcatBoot.class.getProtectionDomain().getCodeSource().getLocation();
        try {
            path = location.toURI().getPath();
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Failed to get path from the location: " + location, e);
        }
        return path;
    }

    protected String prepareWebappPath() {
        return this.deriveWebappDir().getPath();
    }

    protected String prepareWebXmlPath(String webappPath) {
        return webappPath + "/WEB-INF/web.xml";
    }

    protected File deriveWebappDir() {
        String webappRelativePath = this.getBasicWebappRelativePath();
        File webappDir = new File(webappRelativePath);
        if (webappDir.exists()) {
            return webappDir;
        }
        File projectWebappDir = this.findProjectWebappDir(webappRelativePath);
        if (projectWebappDir != null) {
            return projectWebappDir;
        }
        throw new IllegalStateException("Not found the webapp directory: " + webappDir);
    }

    protected String getBasicWebappRelativePath() {
        return "./src/main/webapp";
    }

    protected File findProjectWebappDir(String webappRelativePath) {
        String projectPath;
        Class<?> clazz;
        this.info("...Finding project webapp from stack trace: webappRelativePath=" + webappRelativePath);
        StackTraceElement[] stackTrace = new RuntimeException().getStackTrace();
        if (stackTrace == null || stackTrace.length == 0) {
            this.info("*Not found the stack trace: " + stackTrace);
            return null;
        }
        StackTraceElement rootElement = null;
        for (int i = 0; i < stackTrace.length; ++i) {
            StackTraceElement element = stackTrace[i];
            if (!"main".equals(element.getMethodName())) continue;
            rootElement = element;
            break;
        }
        if (rootElement == null) {
            this.info("*Not found the main method: " + Stream.of(stackTrace).map(el -> el.getMethodName()).collect(Collectors.joining(",")));
            return null;
        }
        String className = rootElement.getClassName();
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException continued) {
            this.info("*Not found the class: " + className + " :: " + continued.getMessage());
            return null;
        }
        File buildDir = BotmResourceUtil.getBuildDir(clazz);
        File targetDir = buildDir.getParentFile();
        if (targetDir == null) {
            this.info("*Not found the target directory: buildDir=" + buildDir);
            return null;
        }
        File projectDir = targetDir.getParentFile();
        if (projectDir == null) {
            this.info("*Not found the project directory: targetDir=" + targetDir);
            return null;
        }
        try {
            projectPath = projectDir.getCanonicalPath().replace("\\", "/");
        }
        catch (IOException continued) {
            this.info("*Cannot get canonical path from: " + projectDir + " :: " + continued.getMessage());
            return null;
        }
        String projectWebappPath = projectPath + "/" + webappRelativePath;
        File projectWebappDir = new File(projectWebappPath);
        if (projectWebappDir.exists()) {
            this.info("OK, found the project webapp: " + projectWebappPath);
            return projectWebappDir;
        }
        this.info("*Not found the project webapp by derived path: " + projectWebappPath);
        return null;
    }

    protected boolean isUnpackWARsDisabled() {
        return false;
    }

    protected void disableUnpackWARsOption() {
        Host host = this.server.getHost();
        if (host instanceof StandardHost) {
            this.info("...Disabling unpackWARs");
            ((StandardHost)host).setUnpackWARs(false);
        }
    }

    protected void prepareUnpackWARsEnv() {
        Host host = this.server.getHost();
        File appBaseFile = host.getAppBaseFile();
        if (appBaseFile.exists()) {
            this.cleanPreviousExtractedWarDir(appBaseFile);
        }
        this.info("...Making unpackWARs directory: " + appBaseFile);
        appBaseFile.mkdirs();
    }

    protected void cleanPreviousExtractedWarDir(File appBaseFile) {
        String appsPath = appBaseFile.getAbsolutePath().replace("\\", "/");
        if (!appsPath.contains("/webapps")) {
            return;
        }
        String parentPath = appsPath.substring(0, appsPath.lastIndexOf("/webapps"));
        if (!parentPath.contains("/")) {
            return;
        }
        String parentName = parentPath.substring(parentPath.lastIndexOf("/") + "/".length());
        if (!parentName.startsWith("tomcat.")) {
            return;
        }
        try {
            this.info("...Cleaning previous extracted-war directory: " + parentPath);
            Files.walkFileTree(Paths.get(parentPath, new String[0]), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    if (exc == null) {
                        Files.delete(dir);
                        return FileVisitResult.CONTINUE;
                    }
                    throw exc;
                }
            });
        }
        catch (IOException continued) {
            this.info("*Failed to delete previous directory: " + continued.getMessage());
            return;
        }
    }

    protected void setupServerConfigIfNeeds() {
        this.propsTranslator.setupServerConfigIfNeeds(this.bootLogger, this.server, this.server.getConnector(), this.configProps, this.readConfigList);
    }

    protected URI startServer() {
        try {
            this.server.start();
        }
        catch (Exception e) {
            throw new IllegalStateException("server start failed.", e);
        }
        String scheme = this.server.getConnector().getScheme();
        String uri = scheme + "://" + this.server.getHost().getName() + ":" + this.port + this.contextPath;
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Failed to create URI object: " + uri, e);
        }
    }

    protected void registerShutdownHook() {
        if (this.suppressShutdownHook) {
            return;
        }
        File markFile = this.prepareMarkFile();
        long lastModified = markFile.lastModified();
        String exp = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS").format(new Date(lastModified));
        this.info("...Registering the shutdown hook for the Tomcat: lastModified=" + exp);
        new Thread(() -> {
            while (true) {
                if (this.needsShutdown(markFile, lastModified)) break;
                this.waitForNextShuwdownHook();
            }
            this.shutdownForcedly();
        }).start();
    }

    protected File prepareMarkFile() {
        File markFile = new File(this.buildMarkFilePath());
        if (markFile.exists()) {
            markFile.setLastModified(System.currentTimeMillis());
            this.waitForExistingServerShuwdown();
        } else {
            markFile.mkdirs();
            try {
                markFile.createNewFile();
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to create new file: " + markFile, e);
            }
        }
        return markFile;
    }

    protected void waitForExistingServerShuwdown() {
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Failed to sleep the thread.", e);
        }
    }

    protected String buildMarkFilePath() {
        return this.getMarkDir() + "/boot" + this.port + ".dfmark";
    }

    protected String getMarkDir() {
        return DEFAULT_MARK_DIR;
    }

    protected boolean needsShutdown(File markFile, long lastModified) {
        return !markFile.exists() || lastModified != markFile.lastModified();
    }

    protected void shutdownForcedly() {
        this.info("...Shuting down the Tomcat forcedly: port=" + this.port);
        this.close();
    }

    protected void waitForNextShuwdownHook() {
        try {
            Thread.sleep(this.getShuwdownHookWaitMillis());
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Failed to sleep the thread.", e);
        }
    }

    protected long getShuwdownHookWaitMillis() {
        return 300L;
    }

    protected void browseOnDesktop(URI uri) {
        if (!this.browseOnDesktop) {
            return;
        }
        Desktop desktop = Desktop.getDesktop();
        try {
            desktop.browse(uri);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to browse the URI: " + uri, e);
        }
    }

    public void close() {
        if (this.server == null) {
            throw new IllegalStateException("server has not been started.");
        }
        try {
            this.server.stop();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to stop the Tomcat.", e);
        }
        try {
            this.server.destroy();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to destroy the Tomcat.", e);
        }
    }

    protected void info(String msg) {
        this.bootLogger.info(msg);
    }

    public Tomcat getServer() {
        return this.server;
    }
}

