/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.tomcat.core;

import java.lang.reflect.InvocationTargetException;
import java.util.function.Predicate;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Valve;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.startup.ContextConfig;
import org.apache.catalina.startup.RhythmicalContextConfig;
import org.apache.catalina.startup.Tomcat;
import org.apache.catalina.valves.AccessLogValve;
import org.dbflute.tomcat.core.RhythmicalHandlingDef;
import org.dbflute.tomcat.core.accesslog.AccessLogOption;
import org.dbflute.tomcat.core.likeit.LikeItCatalinaResource;
import org.dbflute.tomcat.core.likeit.LikeItCatalinaSetupper;
import org.dbflute.tomcat.core.valve.YourValveOption;
import org.dbflute.tomcat.logging.BootLogger;

public class RhythmicalTomcat
extends Tomcat {
    protected final BootLogger bootLogger;
    protected final RhythmicalHandlingDef.AnnotationHandling annotationHandling;
    protected final RhythmicalHandlingDef.MetaInfoResourceHandling metaInfoResourceHandling;
    protected final RhythmicalHandlingDef.TldHandling tldHandling;
    protected final Predicate<String> tldFilesSelector;
    protected final RhythmicalHandlingDef.WebFragmentsHandling webFragmentsHandling;
    protected final Predicate<String> webFragmentsSelector;
    protected final AccessLogOption accessLogOption;
    protected final YourValveOption yourValveOption;
    protected final LikeItCatalinaSetupper likeitCatalinaSetupper;

    public RhythmicalTomcat(BootLogger bootLogger, RhythmicalHandlingDef.AnnotationHandling annotationHandling, RhythmicalHandlingDef.MetaInfoResourceHandling metaInfoResourceHandling, RhythmicalHandlingDef.TldHandling tldHandling, Predicate<String> tldFilesSelector, RhythmicalHandlingDef.WebFragmentsHandling webFragmentsHandling, Predicate<String> webFragmentsSelector, AccessLogOption accessLogOption, YourValveOption yourValveOption, LikeItCatalinaSetupper likeitCatalinaSetupper) {
        this.bootLogger = bootLogger;
        this.annotationHandling = annotationHandling;
        this.metaInfoResourceHandling = metaInfoResourceHandling;
        this.tldHandling = tldHandling;
        this.tldFilesSelector = tldFilesSelector;
        this.webFragmentsHandling = webFragmentsHandling;
        this.webFragmentsSelector = webFragmentsSelector;
        this.accessLogOption = accessLogOption;
        this.yourValveOption = yourValveOption;
        this.likeitCatalinaSetupper = likeitCatalinaSetupper;
    }

    public Context addWebapp(Host host, String contextPath, String docBase) {
        ContextConfig contextConfig = this.createContextConfig();
        return this.addWebapp(host, contextPath, docBase, (LifecycleListener)contextConfig);
    }

    protected ContextConfig createContextConfig() {
        return this.newRhythmicalContextConfig(this.annotationHandling, this.metaInfoResourceHandling, this.tldHandling, this.tldFilesSelector, this.webFragmentsHandling, this.webFragmentsSelector);
    }

    protected RhythmicalContextConfig newRhythmicalContextConfig(RhythmicalHandlingDef.AnnotationHandling annotationHandling, RhythmicalHandlingDef.MetaInfoResourceHandling metaInfoResourceHandling, RhythmicalHandlingDef.TldHandling tldHandling, Predicate<String> tldFilesSelector, RhythmicalHandlingDef.WebFragmentsHandling webFragmentsHandling, Predicate<String> webFragmentsSelector) {
        return new RhythmicalContextConfig(annotationHandling, metaInfoResourceHandling, tldHandling, tldFilesSelector, webFragmentsHandling, webFragmentsSelector);
    }

    public Context addWebapp(Host host, String contextPath, String docBase, LifecycleListener config) {
        Context ctx = this.createContext(host, contextPath);
        ctx.setPath(contextPath);
        ctx.setDocBase(docBase);
        ctx.addLifecycleListener((LifecycleListener)this.newDefaultWebXmlListener());
        ctx.setConfigFile(this.getWebappConfigFile(docBase, contextPath));
        ctx.addLifecycleListener(config);
        if (config instanceof ContextConfig) {
            ((ContextConfig)config).setDefaultWebXml(this.noDefaultWebXmlPath());
        }
        if (host == null) {
            this.getHost().addChild((Container)ctx);
        } else {
            host.addChild((Container)ctx);
        }
        return ctx;
    }

    protected Context createContext(Host host, String url) {
        Context ctx;
        String contextClass = StandardContext.class.getName();
        if (host == null) {
            host = this.getHost();
        }
        if (host instanceof StandardHost) {
            contextClass = ((StandardHost)host).getContextClass();
        }
        try {
            ctx = (Context)Class.forName(contextClass).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            String msg = "Can't instantiate context-class " + contextClass + " for host " + host + " and url " + url;
            throw new IllegalArgumentException(msg, e);
        }
        this.setupAccessLogIfNeeds(ctx);
        this.setupYourValveIfNeeds(ctx);
        if (this.likeitCatalinaSetupper != null) {
            this.likeitCatalinaSetupper.setup(new LikeItCatalinaResource(host, ctx));
        }
        return ctx;
    }

    protected void setupAccessLogIfNeeds(Context ctx) {
        if (this.accessLogOption != null && ctx instanceof StandardContext) {
            StandardContext stdctx = (StandardContext)ctx;
            AccessLogValve valve = new AccessLogValve();
            this.accessLogOption.getLogDir().ifPresent(dir -> valve.setDirectory(dir));
            this.accessLogOption.getFilePrefix().ifPresent(prefix -> valve.setPrefix(prefix));
            this.accessLogOption.getFileSuffix().ifPresent(suffix -> valve.setSuffix(suffix));
            this.accessLogOption.getFileDateFormat().ifPresent(format -> valve.setFileDateFormat(format));
            valve.setEncoding(this.accessLogOption.getFileEncoding().orElse("UTF-8"));
            valve.setPattern(this.accessLogOption.getFormatPattern().orElse("common"));
            this.accessLogOption.getConditionIf().ifPresent(cond -> valve.setConditionIf(cond));
            this.accessLogOption.getConditionUnless().ifPresent(cond -> valve.setConditionUnless(cond));
            stdctx.addValve((Valve)valve);
        }
    }

    protected void setupYourValveIfNeeds(Context ctx) {
        if (this.yourValveOption != null && ctx instanceof StandardContext) {
            StandardContext stdctx = (StandardContext)ctx;
            for (Valve valve : this.yourValveOption.getValveList()) {
                stdctx.addValve(valve);
            }
        }
    }

    protected Tomcat.DefaultWebXmlListener newDefaultWebXmlListener() {
        return new Tomcat.DefaultWebXmlListener(){

            public void lifecycleEvent(LifecycleEvent event) {
                RhythmicalTomcat.this.doDefaultWebXmlLifecycleEvent(event);
            }
        };
    }

    protected void doDefaultWebXmlLifecycleEvent(LifecycleEvent event) {
        if ("before_start".equals(event.getType())) {
            Context ctx = (Context)event.getLifecycle();
            String msgBase = "...Initializing webapp of default web.xml ";
            if (this.existsJspServlet()) {
                this.bootLogger.info("...Initializing webapp of default web.xml with JSP (the servlet found)");
                RhythmicalTomcat.initWebappDefaults((Context)ctx);
            } else {
                this.bootLogger.info("...Initializing webapp of default web.xml without JSP");
                this.initWebappDefaultsWithoutJsp(ctx);
            }
        }
    }

    protected boolean existsJspServlet() {
        try {
            Class.forName("org.apache.jasper.servlet.JspServlet");
            return true;
        }
        catch (ClassNotFoundException ignored) {
            return false;
        }
    }

    protected void initWebappDefaultsWithoutJsp(Context ctx) {
        Wrapper servlet = RhythmicalTomcat.addServlet((Context)ctx, (String)"default", (String)"org.apache.catalina.servlets.DefaultServlet");
        servlet.setLoadOnStartup(1);
        servlet.setOverridable(true);
        ctx.addServletMappingDecoded("/", "default");
        ctx.setSessionTimeout(30);
        RhythmicalTomcat.addDefaultMimeTypeMappings((Context)ctx);
        ctx.addWelcomeFile("index.html");
        ctx.addWelcomeFile("index.htm");
    }
}

