/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.tomcat.logging;

import java.util.Properties;
import java.util.function.Consumer;
import java.util.logging.Logger;
import org.dbflute.tomcat.logging.ServerLoggingLoader;
import org.dbflute.tomcat.logging.TomcatLoggingOption;

public class BootLogger {
    protected final String loggingFile;
    protected final Consumer<TomcatLoggingOption> loggingOptionCall;
    protected final Properties configProps;
    protected final Logger logger;

    public BootLogger(String loggingFile, Consumer<TomcatLoggingOption> loggingOptionCall, Properties configProps) {
        this.loggingFile = loggingFile;
        this.loggingOptionCall = loggingOptionCall;
        this.configProps = configProps;
        if (loggingFile != null) {
            this.createServerLoggingLoader().loadServerLogging();
            this.logger = Logger.getLogger(this.getClass().getPackage().getName());
        } else {
            this.logger = null;
        }
    }

    protected ServerLoggingLoader createServerLoggingLoader() {
        return new ServerLoggingLoader(this.loggingFile, this.loggingOptionCall, this.configProps, msg -> this.println((String)msg));
    }

    public void info(String msg) {
        if (this.logger != null) {
            this.logger.info(msg);
        } else if (this.loggingFile == null) {
            this.println(msg);
        }
    }

    protected void println(String msg) {
        System.out.println(msg);
    }
}

