/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.tomcat.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class LinerLogFormatter
extends Formatter {
    protected static Date cachedDate = new Date();
    protected static SimpleDateFormat cachedFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized String format(LogRecord record) {
        cachedDate.setTime(record.getMillis());
        StringBuilder sb = new StringBuilder();
        sb.append(cachedFormat.format(cachedDate));
        sb.append(" [").append(Thread.currentThread().getName()).append("]");
        sb.append(" ").append(record.getLevel().getName());
        sb.append(" (");
        String className = record.getSourceClassName();
        if (className != null) {
            if (className.contains(".")) {
                sb.append(className.substring(className.lastIndexOf(".") + ".".length()));
            } else {
                sb.append(className);
            }
            String methodName = record.getSourceMethodName();
            if (methodName != null) {
                sb.append("@").append(methodName).append("()");
            }
        } else {
            sb.append(record.getLoggerName());
        }
        sb.append(") - ").append(this.formatMessage(record));
        Throwable thrown = record.getThrown();
        if (thrown != null) {
            StringWriter stringWriter = new StringWriter();
            try (PrintWriter printWriter = new PrintWriter(stringWriter);){
                printWriter.println();
                thrown.printStackTrace(printWriter);
            }
            sb.append(stringWriter.toString());
        }
        sb.append("\n");
        return sb.toString();
    }
}

