/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.tomcat.logging;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.logging.LogManager;
import java.util.regex.Pattern;
import org.dbflute.tomcat.logging.TomcatLoggingOption;

public class ServerLoggingLoader {
    protected final String loggingFile;
    protected final Consumer<TomcatLoggingOption> loggingOptionCall;
    protected final Properties configProps;
    protected final Consumer<String> coreLogger;

    public ServerLoggingLoader(String loggingFile, Consumer<TomcatLoggingOption> loggingOptionCall, Properties configProps, Consumer<String> coreLogger) {
        this.loggingFile = loggingFile;
        this.loggingOptionCall = loggingOptionCall;
        this.configProps = configProps;
        this.coreLogger = coreLogger;
    }

    public void loadServerLogging() {
        try (InputStream ins = this.getClass().getClassLoader().getResourceAsStream(this.loggingFile);){
            TomcatLoggingOption option = new TomcatLoggingOption();
            this.loggingOptionCall.accept(option);
            if (ins == null) {
                if (option.isIgnoreNoFile()) {
                    this.coreLogger.accept("*Not found the logging file in classpath, but continue: " + this.loggingFile);
                    return;
                }
                throw new IllegalStateException("Not found the logging file in classpath: " + this.loggingFile);
            }
            String encoding = "UTF-8";
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                String key;
                int len;
                ByteBuffer buffer = ByteBuffer.allocate(4096);
                byte[] buf = buffer.array();
                while ((len = ins.read(buf)) != -1) {
                    out.write(buf, 0, len);
                }
                String text = out.toString("UTF-8");
                Map<String, String> replaceMap = option.getReplaceMap();
                if (replaceMap != null) {
                    for (Map.Entry<String, String> entry : replaceMap.entrySet()) {
                        key = entry.getKey();
                        text = text.replaceAll(Pattern.quote("${" + key + "}"), entry.getValue());
                    }
                }
                if (this.configProps != null) {
                    for (Map.Entry<Object, Object> entry : this.configProps.entrySet()) {
                        key = (String)entry.getKey();
                        text = text.replaceAll(Pattern.quote("${" + key + "}"), (String)entry.getValue());
                    }
                }
                LogManager.getLogManager().readConfiguration(new ByteArrayInputStream(text.getBytes("UTF-8")));
            }
        }
        catch (Exception e) {
            this.handleLoggingSetupFailureException(e);
        }
    }

    protected void handleLoggingSetupFailureException(Exception e) {
        throw new IllegalStateException("Failed to load tomcat logging configuration: " + this.loggingFile, e);
    }
}

