/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.tomcat.props;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import java.util.function.Consumer;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.startup.Tomcat;
import org.apache.coyote.ProtocolHandler;
import org.apache.coyote.http11.AbstractHttp11Protocol;
import org.dbflute.tomcat.core.accesslog.AccessLogOption;
import org.dbflute.tomcat.logging.BootLogger;

public class BootPropsTranslator {
    public String resolveConfigEnvPath(String envPath) {
        if (envPath == null) {
            throw new IllegalArgumentException("The argument 'envPath' should not be null.");
        }
        String configEnv = this.getConfigEnv();
        String envMark = "_env.";
        if (configEnv != null && envPath.contains("_env.")) {
            int markIndex = envPath.indexOf("_env.");
            String front = envPath.substring(0, markIndex);
            String rear = envPath.substring(markIndex + "_env.".length());
            return front + "_env_" + configEnv + "." + rear;
        }
        return envPath;
    }

    protected String getConfigEnv() {
        return System.getProperty("lasta.env");
    }

    public Properties readConfigProps(String propFile) {
        InputStream ins = this.getClass().getClassLoader().getResourceAsStream(propFile);
        if (ins == null) {
            throw new IllegalStateException("Not found the config file in classpath: " + propFile);
        }
        Properties props = new Properties();
        try {
            props.load(ins);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to load the config resource as stream: " + propFile, e);
        }
        finally {
            try {
                ins.close();
            }
            catch (IOException iOException) {}
        }
        return props;
    }

    public AccessLogOption prepareAccessLogOption(BootLogger logger, Properties props, List<String> readConfigList) {
        if (props == null) {
            return null;
        }
        String enabled = props.getProperty("tomcat.accesslog.enabled");
        if (enabled == null || !this.isStringBooleanTrue(enabled)) {
            return null;
        }
        logger.info("...Preparing tomcat access log: enabled=" + enabled + ", config=" + readConfigList);
        AccessLogOption option = new AccessLogOption();
        this.doPrepareAccessLogOption(logger, props, "logDir", value -> option.logDir((String)value));
        this.doPrepareAccessLogOption(logger, props, "filePrefix", value -> option.filePrefix((String)value));
        this.doPrepareAccessLogOption(logger, props, "fileSuffix", value -> option.fileSuffix((String)value));
        this.doPrepareAccessLogOption(logger, props, "fileDateFormat", value -> option.fileDateFormat((String)value));
        this.doPrepareAccessLogOption(logger, props, "fileEncoding", value -> option.fileEncoding((String)value));
        this.doPrepareAccessLogOption(logger, props, "formatPattern", value -> option.formatPattern((String)value));
        this.doPrepareAccessLogOption(logger, props, "conditionIf", value -> option.conditionIf((String)value));
        this.doPrepareAccessLogOption(logger, props, "conditionUnless", value -> option.conditionUnless((String)value));
        return option;
    }

    protected void doPrepareAccessLogOption(BootLogger logger, Properties props, String keyword, Consumer<String> reflector) {
        String value = props.getProperty("tomcat.accesslog." + keyword);
        if (value != null && !value.isEmpty()) {
            logger.info(" tomcat.accesslog." + keyword + " = " + value);
            reflector.accept(value);
        }
    }

    public void setupServerConfigIfNeeds(BootLogger logger, Tomcat server, Connector connector, Properties props, List<String> readConfigList) {
        if (props == null) {
            return;
        }
        logger.info("...Reflecting configuration to server: config=" + readConfigList);
        this.doSetupServerConfig(logger, props, "URIEncoding", value -> connector.setURIEncoding(value));
        this.doSetupServerConfig(logger, props, "useBodyEncodingForURI", value -> connector.setUseBodyEncodingForURI(this.isStringBooleanTrue((String)value)));
        this.doSetupServerConfig(logger, props, "secure", value -> connector.setSecure(this.isStringBooleanTrue((String)value)));
        this.doSetupServerConfig(logger, props, "scheme", value -> connector.setScheme(value));
        this.doSetupServerConfig(logger, props, "bindAddress", value -> connector.setProperty("address", value));
        this.doSetupServerConfig(logger, props, "proxyPort", value -> connector.setProxyPort(this.toInt("proxyPort(config)", (String)value)));
        this.doSetupServerConfig(logger, props, "maxHttpHeaderSize", value -> this.reflectPropertyMaxHttpHeaderSize(logger, server, connector, (String)value));
        this.doSetupServerConfig(logger, props, "maxConnections", value -> this.reflectPropertyMaxConnections(logger, server, connector, (String)value));
        this.doSetupServerConfig(logger, props, "maxThreads", value -> this.reflectPropertyMaxThreads(logger, server, connector, (String)value));
    }

    protected void doSetupServerConfig(BootLogger logger, Properties props, String keyword, Consumer<String> reflector) {
        String value = props.getProperty("tomcat." + keyword);
        if (value != null && !value.isEmpty()) {
            logger.info(" tomcat." + keyword + " = " + value);
            reflector.accept(value);
        }
    }

    protected void reflectPropertyMaxHttpHeaderSize(BootLogger logger, Tomcat server, Connector connector, String value) {
        ProtocolHandler protocolHandler = connector.getProtocolHandler();
        if (protocolHandler instanceof AbstractHttp11Protocol) {
            AbstractHttp11Protocol protocol = (AbstractHttp11Protocol)protocolHandler;
            protocol.setMaxHttpHeaderSize(this.toInt("maxHttpHeaderSize(config)", value));
        } else {
            logger.info("Cannot set the property 'maxHttpHeaderSize' because of different protocol handler: " + protocolHandler);
        }
    }

    protected void reflectPropertyMaxConnections(BootLogger logger, Tomcat server, Connector connector, String value) {
        ProtocolHandler protocolHandler = connector.getProtocolHandler();
        if (protocolHandler instanceof AbstractHttp11Protocol) {
            AbstractHttp11Protocol protocol = (AbstractHttp11Protocol)protocolHandler;
            protocol.setMaxConnections(this.toInt("maxConnections(config)", value));
        } else {
            logger.info("Cannot set the property 'maxConnections' because of different protocol handler: " + protocolHandler);
        }
    }

    protected void reflectPropertyMaxThreads(BootLogger logger, Tomcat server, Connector connector, String value) {
        ProtocolHandler protocolHandler = connector.getProtocolHandler();
        if (protocolHandler instanceof AbstractHttp11Protocol) {
            AbstractHttp11Protocol protocol = (AbstractHttp11Protocol)protocolHandler;
            protocol.setMaxThreads(this.toInt("maxThreads(config)", value));
        } else {
            logger.info("Cannot set the property 'maxThreads' because of different protocol handler: " + protocolHandler);
        }
    }

    protected boolean isStringBooleanTrue(String value) {
        return value.equalsIgnoreCase("true");
    }

    protected int toInt(String property, String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException("Failed to parse the value as int: property=" + property + " value=" + value);
        }
    }
}

