/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.utflute.core;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.dbflute.utflute.core.PlainTestCase;
import org.dbflute.utflute.core.binding.BindingAnnotationRule;
import org.dbflute.utflute.core.binding.BindingRuleProvider;
import org.dbflute.utflute.core.binding.BoundResult;
import org.dbflute.utflute.core.binding.ComponentBinder;
import org.dbflute.utflute.core.binding.ComponentProvider;
import org.dbflute.utflute.core.transaction.TransactionFailureException;
import org.dbflute.utflute.core.transaction.TransactionResource;

public abstract class InjectionTestCase
extends PlainTestCase {
    private TransactionResource _xtestCaseTransactionResource;
    private final ComponentBinder _xtestCaseComponentBinder = this.createTestCaseComponentBinder();
    private BoundResult _xtestCaseBoundResult;
    private List<BoundResult> _xinjectedBoundResultList;
    private List<Object> _xmockInstanceList;
    private List<Class<?>> _xnonBindingTypeList;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.xsetupBeforeContainer();
        this.xsetupBeforeTestCaseContainer();
        this.xprepareTestCaseContainer();
        this.xsetupAfterTestCaseContainer();
        this.xsetupBeforeTestCaseInjection();
        this.xprepareTestCaseInjection();
        this.xsetupAfterTestCaseInjection();
        this.xsetupBeforeTestCaseTransaction();
        this.xprepareTestCaseTransaction();
        this.xsetupAfterTestCaseTransaction();
    }

    @Deprecated
    protected void xsetupBeforeContainer() {
    }

    protected void xsetupBeforeTestCaseContainer() {
    }

    protected abstract void xprepareTestCaseContainer();

    protected void xsetupAfterTestCaseContainer() {
    }

    protected boolean isUseOneTimeContainer() {
        return false;
    }

    protected void xsetupBeforeTestCaseInjection() {
    }

    protected void xprepareTestCaseInjection() {
        this._xtestCaseBoundResult = this._xtestCaseComponentBinder.bindComponent((Object)this);
    }

    protected void xsetupAfterTestCaseInjection() {
    }

    protected void xsetupBeforeTestCaseTransaction() {
    }

    protected void xprepareTestCaseTransaction() {
        if (!this.isSuppressTestCaseTransaction()) {
            this.xbeginTestCaseTransaction();
        }
    }

    protected boolean isSuppressTestCaseTransaction() {
        return false;
    }

    protected void xbeginTestCaseTransaction() {
        this._xtestCaseTransactionResource = this.beginNewTransaction();
    }

    protected void xsetupAfterTestCaseTransaction() {
    }

    @Override
    public void tearDown() throws Exception {
        if (!this.isSuppressTestCaseTransaction()) {
            this.xrollbackTestCaseTransaction();
        }
        this.xdestroyTestCaseInjection();
        this.xdestroyTestCaseContainer();
        this._xmockInstanceList = null;
        this._xnonBindingTypeList = null;
        super.tearDown();
    }

    protected void xrollbackTestCaseTransaction() {
        if (this._xtestCaseTransactionResource == null) {
            return;
        }
        if (this.isCommitTestCaseTransaction()) {
            this.commitTransaction(this._xtestCaseTransactionResource);
        } else {
            this.rollbackTransaction(this._xtestCaseTransactionResource);
        }
        this._xtestCaseTransactionResource = null;
    }

    protected boolean isCommitTestCaseTransaction() {
        return false;
    }

    @Override
    protected void commitTransaction(TransactionResource resource) {
        this.xassertTransactionResourceNotNull(resource);
        try {
            resource.commit();
        }
        catch (Exception e) {
            String msg = "Failed to commit the transaction: " + resource;
            throw new TransactionFailureException(msg, e);
        }
    }

    @Override
    protected void rollbackTransaction(TransactionResource resource) {
        this.xassertTransactionResourceNotNull(resource);
        try {
            resource.rollback();
        }
        catch (Exception e) {
            String msg = "Failed to roll-back the transaction: " + resource;
            throw new TransactionFailureException(msg, e);
        }
    }

    protected void xdestroyTestCaseInjection() {
        this._xtestCaseComponentBinder.revertBoundComponent(this._xtestCaseBoundResult);
        this._xtestCaseBoundResult = null;
        if (this._xinjectedBoundResultList != null) {
            this._xtestCaseComponentBinder.revertBoundComponent(this._xinjectedBoundResultList);
        }
        this._xinjectedBoundResultList = null;
    }

    protected void xdestroyTestCaseContainer() {
        if (this.isUseOneTimeContainer() || this.isDestroyContainerAtTearDown()) {
            this.xdestroyContainer();
            this.xclearCachedContainer();
        }
    }

    protected boolean isDestroyContainerAtTearDown() {
        return false;
    }

    protected abstract void xclearCachedContainer();

    protected ComponentBinder xcreateBasicComponentBinder() {
        return new ComponentBinder(this.xcreateComponentProvider(), this.createBindingRuleProvider());
    }

    protected ComponentProvider xcreateComponentProvider() {
        return new ComponentProvider(){

            @Override
            public <COMPONENT> COMPONENT provideComponent(Class<COMPONENT> type) {
                return InjectionTestCase.this.getComponent(type);
            }

            @Override
            public <COMPONENT> COMPONENT provideComponent(String name) {
                return InjectionTestCase.this.getComponent(name);
            }

            @Override
            public boolean existsComponent(Class<?> type) {
                return InjectionTestCase.this.hasComponent(type);
            }

            @Override
            public boolean existsComponent(String name) {
                return InjectionTestCase.this.hasComponent(name);
            }
        };
    }

    protected ComponentBinder createTestCaseComponentBinder() {
        ComponentBinder binder = this.xcreateBasicComponentBinder();
        binder.stopBindingAtSuper(InjectionTestCase.class);
        if (this.isUseTestCaseLooseBinding()) {
            binder.looseBinding();
        }
        return binder;
    }

    protected boolean isUseTestCaseLooseBinding() {
        return false;
    }

    public void registerMock(Object mock) {
        InjectionTestCase.assertNotNull((Object)mock);
        if (this._xmockInstanceList == null) {
            this._xmockInstanceList = new ArrayList<Object>();
        }
        Object filtered = mock instanceof BoundResult ? ((BoundResult)mock).getTargetBean() : mock;
        this._xmockInstanceList.add(filtered);
    }

    public void registerMockInstance(Object mock) {
        InjectionTestCase.assertNotNull((Object)mock);
        this.registerMock(mock);
    }

    public void registerMockInstanceInjecting(Object mock) {
        InjectionTestCase.assertNotNull((Object)mock);
        this.inject(mock);
        this.registerMock(mock);
    }

    public void suppressBindingOf(Class<?> nonBindingType) {
        InjectionTestCase.assertNotNull(nonBindingType);
        if (this._xnonBindingTypeList == null) {
            this._xnonBindingTypeList = new ArrayList();
        }
        this._xnonBindingTypeList.add(nonBindingType);
    }

    protected BindingRuleProvider createBindingRuleProvider() {
        return new BindingRuleProvider(){

            @Override
            public Map<Class<? extends Annotation>, BindingAnnotationRule> provideBindingAnnotationRuleMap() {
                return InjectionTestCase.this.xprovideBindingAnnotationRuleMap();
            }

            @Override
            public String filterByBindingNamingRule(String propertyName, Class<?> propertyType) {
                return InjectionTestCase.this.xfilterByBindingNamingRule(propertyName, propertyType);
            }
        };
    }

    protected abstract Map<Class<? extends Annotation>, BindingAnnotationRule> xprovideBindingAnnotationRuleMap();

    protected String xfilterByBindingNamingRule(String propertyName, Class<?> propertyType) {
        return null;
    }

    protected BoundResult inject(Object bean) {
        ComponentBinder binder = this.createOuterComponentBinder(bean);
        BoundResult boundResult = this.xdoInject(bean, binder);
        if (this._xinjectedBoundResultList == null) {
            this._xinjectedBoundResultList = new ArrayList<BoundResult>(2);
        }
        this._xinjectedBoundResultList.add(boundResult);
        return boundResult;
    }

    protected ComponentBinder createOuterComponentBinder(Object bean) {
        ComponentBinder binder = this.xcreateBasicComponentBinder();
        this.xadjustOuterComponentBinder(bean, binder);
        return binder;
    }

    protected void xadjustOuterComponentBinder(Object bean, ComponentBinder binder) {
        ArrayList mockInstanceList = this.newArrayList();
        if (this._xmockInstanceList != null) {
            mockInstanceList.addAll(this._xmockInstanceList);
        }
        for (Object mockInstance : mockInstanceList) {
            if (mockInstance == bean) continue;
            binder.addMockInstance(mockInstance);
        }
        ArrayList nonBindingTypeList = this.newArrayList();
        if (this._xnonBindingTypeList != null) {
            nonBindingTypeList.addAll(this._xnonBindingTypeList);
        }
        for (Class nonBindingType : nonBindingTypeList) {
            binder.addNonBindingType(nonBindingType);
        }
    }

    protected BoundResult xdoInject(Object bean, ComponentBinder binder) {
        return binder.bindComponent(bean);
    }

    protected abstract void xdestroyContainer();

    protected abstract <COMPONENT> COMPONENT getComponent(Class<COMPONENT> var1);

    protected abstract <COMPONENT> COMPONENT getComponent(String var1);

    protected abstract boolean hasComponent(Class<?> var1);

    protected abstract boolean hasComponent(String var1);

    protected TransactionResource xgetTestCaseTransactionResource() {
        return this._xtestCaseTransactionResource;
    }

    protected void xsetTestCaseTransactionResource(TransactionResource testCaseTransactionResource) {
        this._xtestCaseTransactionResource = testCaseTransactionResource;
    }

    protected ComponentBinder xgetTestCaseComponentBinder() {
        return this._xtestCaseComponentBinder;
    }

    protected BoundResult xgetTestCaseBoundResult() {
        return this._xtestCaseBoundResult;
    }

    protected void xsetTestCaseBoundResult(BoundResult testCaseBoundResult) {
        this._xtestCaseBoundResult = testCaseBoundResult;
    }

    protected List<BoundResult> xgetInjectedBoundResultList() {
        return this._xinjectedBoundResultList;
    }

    protected void xsetInjectedBoundResultList(List<BoundResult> injectedBoundResultList) {
        this._xinjectedBoundResultList = injectedBoundResultList;
    }

    protected List<Object> xgetMockInstanceList() {
        return this._xmockInstanceList;
    }

    protected void xsetMockInstanceList(List<Object> mockInstanceList) {
        this._xmockInstanceList = mockInstanceList;
    }

    protected List<Class<?>> xgetNonBindingTypeList() {
        return this._xnonBindingTypeList;
    }

    protected void xsetNonBindingTypeList(List<Class<?>> nonBindingTypeList) {
        this._xnonBindingTypeList = nonBindingTypeList;
    }
}

